/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HpcCacheNfsTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#cache_name HpcCacheNfsTarget#cache_name}
    */
    readonly cacheName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#id HpcCacheNfsTarget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#name HpcCacheNfsTarget#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#resource_group_name HpcCacheNfsTarget#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#target_host_name HpcCacheNfsTarget#target_host_name}
    */
    readonly targetHostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#usage_model HpcCacheNfsTarget#usage_model}
    */
    readonly usageModel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#verification_timer_in_seconds HpcCacheNfsTarget#verification_timer_in_seconds}
    */
    readonly verificationTimerInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#write_back_timer_in_seconds HpcCacheNfsTarget#write_back_timer_in_seconds}
    */
    readonly writeBackTimerInSeconds?: number;
    /**
    * namespace_junction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#namespace_junction HpcCacheNfsTarget#namespace_junction}
    */
    readonly namespaceJunction: HpcCacheNfsTargetNamespaceJunction[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#timeouts HpcCacheNfsTarget#timeouts}
    */
    readonly timeouts?: HpcCacheNfsTargetTimeouts;
}
export interface HpcCacheNfsTargetNamespaceJunction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#access_policy_name HpcCacheNfsTarget#access_policy_name}
    */
    readonly accessPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#namespace_path HpcCacheNfsTarget#namespace_path}
    */
    readonly namespacePath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#nfs_export HpcCacheNfsTarget#nfs_export}
    */
    readonly nfsExport: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#target_path HpcCacheNfsTarget#target_path}
    */
    readonly targetPath?: string;
}
export declare function hpcCacheNfsTargetNamespaceJunctionToTerraform(struct?: HpcCacheNfsTargetNamespaceJunction | cdktf.IResolvable): any;
export declare function hpcCacheNfsTargetNamespaceJunctionToHclTerraform(struct?: HpcCacheNfsTargetNamespaceJunction | cdktf.IResolvable): any;
export declare class HpcCacheNfsTargetNamespaceJunctionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HpcCacheNfsTargetNamespaceJunction | cdktf.IResolvable | undefined;
    set internalValue(value: HpcCacheNfsTargetNamespaceJunction | cdktf.IResolvable | undefined);
    private _accessPolicyName?;
    get accessPolicyName(): string;
    set accessPolicyName(value: string);
    resetAccessPolicyName(): void;
    get accessPolicyNameInput(): string | undefined;
    private _namespacePath?;
    get namespacePath(): string;
    set namespacePath(value: string);
    get namespacePathInput(): string | undefined;
    private _nfsExport?;
    get nfsExport(): string;
    set nfsExport(value: string);
    get nfsExportInput(): string | undefined;
    private _targetPath?;
    get targetPath(): string;
    set targetPath(value: string);
    resetTargetPath(): void;
    get targetPathInput(): string | undefined;
}
export declare class HpcCacheNfsTargetNamespaceJunctionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HpcCacheNfsTargetNamespaceJunction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HpcCacheNfsTargetNamespaceJunctionOutputReference;
}
export interface HpcCacheNfsTargetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#create HpcCacheNfsTarget#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#delete HpcCacheNfsTarget#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#read HpcCacheNfsTarget#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#update HpcCacheNfsTarget#update}
    */
    readonly update?: string;
}
export declare function hpcCacheNfsTargetTimeoutsToTerraform(struct?: HpcCacheNfsTargetTimeouts | cdktf.IResolvable): any;
export declare function hpcCacheNfsTargetTimeoutsToHclTerraform(struct?: HpcCacheNfsTargetTimeouts | cdktf.IResolvable): any;
export declare class HpcCacheNfsTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HpcCacheNfsTargetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HpcCacheNfsTargetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target azurerm_hpc_cache_nfs_target}
*/
export declare class HpcCacheNfsTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hpc_cache_nfs_target";
    /**
    * Generates CDKTF code for importing a HpcCacheNfsTarget resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HpcCacheNfsTarget to import
    * @param importFromId The id of the existing HpcCacheNfsTarget that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HpcCacheNfsTarget to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/hpc_cache_nfs_target azurerm_hpc_cache_nfs_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HpcCacheNfsTargetConfig
    */
    constructor(scope: Construct, id: string, config: HpcCacheNfsTargetConfig);
    private _cacheName?;
    get cacheName(): string;
    set cacheName(value: string);
    get cacheNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _targetHostName?;
    get targetHostName(): string;
    set targetHostName(value: string);
    get targetHostNameInput(): string | undefined;
    private _usageModel?;
    get usageModel(): string;
    set usageModel(value: string);
    get usageModelInput(): string | undefined;
    private _verificationTimerInSeconds?;
    get verificationTimerInSeconds(): number;
    set verificationTimerInSeconds(value: number);
    resetVerificationTimerInSeconds(): void;
    get verificationTimerInSecondsInput(): number | undefined;
    private _writeBackTimerInSeconds?;
    get writeBackTimerInSeconds(): number;
    set writeBackTimerInSeconds(value: number);
    resetWriteBackTimerInSeconds(): void;
    get writeBackTimerInSecondsInput(): number | undefined;
    private _namespaceJunction;
    get namespaceJunction(): HpcCacheNfsTargetNamespaceJunctionList;
    putNamespaceJunction(value: HpcCacheNfsTargetNamespaceJunction[] | cdktf.IResolvable): void;
    get namespaceJunctionInput(): cdktf.IResolvable | HpcCacheNfsTargetNamespaceJunction[] | undefined;
    private _timeouts;
    get timeouts(): HpcCacheNfsTargetTimeoutsOutputReference;
    putTimeouts(value: HpcCacheNfsTargetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HpcCacheNfsTargetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
