/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#api_server_authorized_ip_ranges KubernetesCluster#api_server_authorized_ip_ranges}
    */
    readonly apiServerAuthorizedIpRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#automatic_channel_upgrade KubernetesCluster#automatic_channel_upgrade}
    */
    readonly automaticChannelUpgrade?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#azure_policy_enabled KubernetesCluster#azure_policy_enabled}
    */
    readonly azurePolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#cost_analysis_enabled KubernetesCluster#cost_analysis_enabled}
    */
    readonly costAnalysisEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#custom_ca_trust_certificates_base64 KubernetesCluster#custom_ca_trust_certificates_base64}
    */
    readonly customCaTrustCertificatesBase64?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#disk_encryption_set_id KubernetesCluster#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#dns_prefix KubernetesCluster#dns_prefix}
    */
    readonly dnsPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#dns_prefix_private_cluster KubernetesCluster#dns_prefix_private_cluster}
    */
    readonly dnsPrefixPrivateCluster?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#edge_zone KubernetesCluster#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#enable_pod_security_policy KubernetesCluster#enable_pod_security_policy}
    */
    readonly enablePodSecurityPolicy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#http_application_routing_enabled KubernetesCluster#http_application_routing_enabled}
    */
    readonly httpApplicationRoutingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#id KubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#image_cleaner_enabled KubernetesCluster#image_cleaner_enabled}
    */
    readonly imageCleanerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#image_cleaner_interval_hours KubernetesCluster#image_cleaner_interval_hours}
    */
    readonly imageCleanerIntervalHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#kubernetes_version KubernetesCluster#kubernetes_version}
    */
    readonly kubernetesVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#local_account_disabled KubernetesCluster#local_account_disabled}
    */
    readonly localAccountDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#location KubernetesCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_os_channel_upgrade KubernetesCluster#node_os_channel_upgrade}
    */
    readonly nodeOsChannelUpgrade?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_resource_group KubernetesCluster#node_resource_group}
    */
    readonly nodeResourceGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#oidc_issuer_enabled KubernetesCluster#oidc_issuer_enabled}
    */
    readonly oidcIssuerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#open_service_mesh_enabled KubernetesCluster#open_service_mesh_enabled}
    */
    readonly openServiceMeshEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#private_cluster_enabled KubernetesCluster#private_cluster_enabled}
    */
    readonly privateClusterEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#private_cluster_public_fqdn_enabled KubernetesCluster#private_cluster_public_fqdn_enabled}
    */
    readonly privateClusterPublicFqdnEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#private_dns_zone_id KubernetesCluster#private_dns_zone_id}
    */
    readonly privateDnsZoneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#public_network_access_enabled KubernetesCluster#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#resource_group_name KubernetesCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#role_based_access_control_enabled KubernetesCluster#role_based_access_control_enabled}
    */
    readonly roleBasedAccessControlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#run_command_enabled KubernetesCluster#run_command_enabled}
    */
    readonly runCommandEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#sku_tier KubernetesCluster#sku_tier}
    */
    readonly skuTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#support_plan KubernetesCluster#support_plan}
    */
    readonly supportPlan?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#tags KubernetesCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#workload_identity_enabled KubernetesCluster#workload_identity_enabled}
    */
    readonly workloadIdentityEnabled?: boolean | cdktf.IResolvable;
    /**
    * aci_connector_linux block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#aci_connector_linux KubernetesCluster#aci_connector_linux}
    */
    readonly aciConnectorLinux?: KubernetesClusterAciConnectorLinux;
    /**
    * api_server_access_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#api_server_access_profile KubernetesCluster#api_server_access_profile}
    */
    readonly apiServerAccessProfile?: KubernetesClusterApiServerAccessProfile;
    /**
    * auto_scaler_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#auto_scaler_profile KubernetesCluster#auto_scaler_profile}
    */
    readonly autoScalerProfile?: KubernetesClusterAutoScalerProfile;
    /**
    * azure_active_directory_role_based_access_control block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#azure_active_directory_role_based_access_control KubernetesCluster#azure_active_directory_role_based_access_control}
    */
    readonly azureActiveDirectoryRoleBasedAccessControl?: KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl;
    /**
    * confidential_computing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#confidential_computing KubernetesCluster#confidential_computing}
    */
    readonly confidentialComputing?: KubernetesClusterConfidentialComputing;
    /**
    * default_node_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#default_node_pool KubernetesCluster#default_node_pool}
    */
    readonly defaultNodePool: KubernetesClusterDefaultNodePool;
    /**
    * http_proxy_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#http_proxy_config KubernetesCluster#http_proxy_config}
    */
    readonly httpProxyConfig?: KubernetesClusterHttpProxyConfig;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#identity KubernetesCluster#identity}
    */
    readonly identity?: KubernetesClusterIdentity;
    /**
    * ingress_application_gateway block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#ingress_application_gateway KubernetesCluster#ingress_application_gateway}
    */
    readonly ingressApplicationGateway?: KubernetesClusterIngressApplicationGateway;
    /**
    * key_management_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#key_management_service KubernetesCluster#key_management_service}
    */
    readonly keyManagementService?: KubernetesClusterKeyManagementService;
    /**
    * key_vault_secrets_provider block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#key_vault_secrets_provider KubernetesCluster#key_vault_secrets_provider}
    */
    readonly keyVaultSecretsProvider?: KubernetesClusterKeyVaultSecretsProvider;
    /**
    * kubelet_identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#kubelet_identity KubernetesCluster#kubelet_identity}
    */
    readonly kubeletIdentity?: KubernetesClusterKubeletIdentity;
    /**
    * linux_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#linux_profile KubernetesCluster#linux_profile}
    */
    readonly linuxProfile?: KubernetesClusterLinuxProfile;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#maintenance_window KubernetesCluster#maintenance_window}
    */
    readonly maintenanceWindow?: KubernetesClusterMaintenanceWindow;
    /**
    * maintenance_window_auto_upgrade block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#maintenance_window_auto_upgrade KubernetesCluster#maintenance_window_auto_upgrade}
    */
    readonly maintenanceWindowAutoUpgrade?: KubernetesClusterMaintenanceWindowAutoUpgrade;
    /**
    * maintenance_window_node_os block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#maintenance_window_node_os KubernetesCluster#maintenance_window_node_os}
    */
    readonly maintenanceWindowNodeOs?: KubernetesClusterMaintenanceWindowNodeOs;
    /**
    * microsoft_defender block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#microsoft_defender KubernetesCluster#microsoft_defender}
    */
    readonly microsoftDefender?: KubernetesClusterMicrosoftDefender;
    /**
    * monitor_metrics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#monitor_metrics KubernetesCluster#monitor_metrics}
    */
    readonly monitorMetrics?: KubernetesClusterMonitorMetrics;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#network_profile KubernetesCluster#network_profile}
    */
    readonly networkProfile?: KubernetesClusterNetworkProfile;
    /**
    * oms_agent block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#oms_agent KubernetesCluster#oms_agent}
    */
    readonly omsAgent?: KubernetesClusterOmsAgent;
    /**
    * service_mesh_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#service_mesh_profile KubernetesCluster#service_mesh_profile}
    */
    readonly serviceMeshProfile?: KubernetesClusterServiceMeshProfile;
    /**
    * service_principal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#service_principal KubernetesCluster#service_principal}
    */
    readonly servicePrincipal?: KubernetesClusterServicePrincipal;
    /**
    * storage_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#storage_profile KubernetesCluster#storage_profile}
    */
    readonly storageProfile?: KubernetesClusterStorageProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#timeouts KubernetesCluster#timeouts}
    */
    readonly timeouts?: KubernetesClusterTimeouts;
    /**
    * web_app_routing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#web_app_routing KubernetesCluster#web_app_routing}
    */
    readonly webAppRouting?: KubernetesClusterWebAppRouting;
    /**
    * windows_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#windows_profile KubernetesCluster#windows_profile}
    */
    readonly windowsProfile?: KubernetesClusterWindowsProfile;
    /**
    * workload_autoscaler_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#workload_autoscaler_profile KubernetesCluster#workload_autoscaler_profile}
    */
    readonly workloadAutoscalerProfile?: KubernetesClusterWorkloadAutoscalerProfile;
}
export interface KubernetesClusterKubeAdminConfig {
}
export declare function kubernetesClusterKubeAdminConfigToTerraform(struct?: KubernetesClusterKubeAdminConfig): any;
export declare function kubernetesClusterKubeAdminConfigToHclTerraform(struct?: KubernetesClusterKubeAdminConfig): any;
export declare class KubernetesClusterKubeAdminConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterKubeAdminConfig | undefined;
    set internalValue(value: KubernetesClusterKubeAdminConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class KubernetesClusterKubeAdminConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterKubeAdminConfigOutputReference;
}
export interface KubernetesClusterKubeConfig {
}
export declare function kubernetesClusterKubeConfigToTerraform(struct?: KubernetesClusterKubeConfig): any;
export declare function kubernetesClusterKubeConfigToHclTerraform(struct?: KubernetesClusterKubeConfig): any;
export declare class KubernetesClusterKubeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterKubeConfig | undefined;
    set internalValue(value: KubernetesClusterKubeConfig | undefined);
    get clientCertificate(): string;
    get clientKey(): string;
    get clusterCaCertificate(): string;
    get host(): string;
    get password(): string;
    get username(): string;
}
export declare class KubernetesClusterKubeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterKubeConfigOutputReference;
}
export interface KubernetesClusterAciConnectorLinuxConnectorIdentity {
}
export declare function kubernetesClusterAciConnectorLinuxConnectorIdentityToTerraform(struct?: KubernetesClusterAciConnectorLinuxConnectorIdentity): any;
export declare function kubernetesClusterAciConnectorLinuxConnectorIdentityToHclTerraform(struct?: KubernetesClusterAciConnectorLinuxConnectorIdentity): any;
export declare class KubernetesClusterAciConnectorLinuxConnectorIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterAciConnectorLinuxConnectorIdentity | undefined;
    set internalValue(value: KubernetesClusterAciConnectorLinuxConnectorIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class KubernetesClusterAciConnectorLinuxConnectorIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterAciConnectorLinuxConnectorIdentityOutputReference;
}
export interface KubernetesClusterAciConnectorLinux {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#subnet_name KubernetesCluster#subnet_name}
    */
    readonly subnetName: string;
}
export declare function kubernetesClusterAciConnectorLinuxToTerraform(struct?: KubernetesClusterAciConnectorLinuxOutputReference | KubernetesClusterAciConnectorLinux): any;
export declare function kubernetesClusterAciConnectorLinuxToHclTerraform(struct?: KubernetesClusterAciConnectorLinuxOutputReference | KubernetesClusterAciConnectorLinux): any;
export declare class KubernetesClusterAciConnectorLinuxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterAciConnectorLinux | undefined;
    set internalValue(value: KubernetesClusterAciConnectorLinux | undefined);
    private _connectorIdentity;
    get connectorIdentity(): KubernetesClusterAciConnectorLinuxConnectorIdentityList;
    private _subnetName?;
    get subnetName(): string;
    set subnetName(value: string);
    get subnetNameInput(): string | undefined;
}
export interface KubernetesClusterApiServerAccessProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#authorized_ip_ranges KubernetesCluster#authorized_ip_ranges}
    */
    readonly authorizedIpRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#subnet_id KubernetesCluster#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#vnet_integration_enabled KubernetesCluster#vnet_integration_enabled}
    */
    readonly vnetIntegrationEnabled?: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterApiServerAccessProfileToTerraform(struct?: KubernetesClusterApiServerAccessProfileOutputReference | KubernetesClusterApiServerAccessProfile): any;
export declare function kubernetesClusterApiServerAccessProfileToHclTerraform(struct?: KubernetesClusterApiServerAccessProfileOutputReference | KubernetesClusterApiServerAccessProfile): any;
export declare class KubernetesClusterApiServerAccessProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterApiServerAccessProfile | undefined;
    set internalValue(value: KubernetesClusterApiServerAccessProfile | undefined);
    private _authorizedIpRanges?;
    get authorizedIpRanges(): string[];
    set authorizedIpRanges(value: string[]);
    resetAuthorizedIpRanges(): void;
    get authorizedIpRangesInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _vnetIntegrationEnabled?;
    get vnetIntegrationEnabled(): boolean | cdktf.IResolvable;
    set vnetIntegrationEnabled(value: boolean | cdktf.IResolvable);
    resetVnetIntegrationEnabled(): void;
    get vnetIntegrationEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface KubernetesClusterAutoScalerProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#balance_similar_node_groups KubernetesCluster#balance_similar_node_groups}
    */
    readonly balanceSimilarNodeGroups?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#empty_bulk_delete_max KubernetesCluster#empty_bulk_delete_max}
    */
    readonly emptyBulkDeleteMax?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#expander KubernetesCluster#expander}
    */
    readonly expander?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#max_graceful_termination_sec KubernetesCluster#max_graceful_termination_sec}
    */
    readonly maxGracefulTerminationSec?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#max_node_provisioning_time KubernetesCluster#max_node_provisioning_time}
    */
    readonly maxNodeProvisioningTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#max_unready_nodes KubernetesCluster#max_unready_nodes}
    */
    readonly maxUnreadyNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#max_unready_percentage KubernetesCluster#max_unready_percentage}
    */
    readonly maxUnreadyPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#new_pod_scale_up_delay KubernetesCluster#new_pod_scale_up_delay}
    */
    readonly newPodScaleUpDelay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scale_down_delay_after_add KubernetesCluster#scale_down_delay_after_add}
    */
    readonly scaleDownDelayAfterAdd?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scale_down_delay_after_delete KubernetesCluster#scale_down_delay_after_delete}
    */
    readonly scaleDownDelayAfterDelete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scale_down_delay_after_failure KubernetesCluster#scale_down_delay_after_failure}
    */
    readonly scaleDownDelayAfterFailure?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scale_down_unneeded KubernetesCluster#scale_down_unneeded}
    */
    readonly scaleDownUnneeded?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scale_down_unready KubernetesCluster#scale_down_unready}
    */
    readonly scaleDownUnready?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scale_down_utilization_threshold KubernetesCluster#scale_down_utilization_threshold}
    */
    readonly scaleDownUtilizationThreshold?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scan_interval KubernetesCluster#scan_interval}
    */
    readonly scanInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#skip_nodes_with_local_storage KubernetesCluster#skip_nodes_with_local_storage}
    */
    readonly skipNodesWithLocalStorage?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#skip_nodes_with_system_pods KubernetesCluster#skip_nodes_with_system_pods}
    */
    readonly skipNodesWithSystemPods?: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterAutoScalerProfileToTerraform(struct?: KubernetesClusterAutoScalerProfileOutputReference | KubernetesClusterAutoScalerProfile): any;
export declare function kubernetesClusterAutoScalerProfileToHclTerraform(struct?: KubernetesClusterAutoScalerProfileOutputReference | KubernetesClusterAutoScalerProfile): any;
export declare class KubernetesClusterAutoScalerProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterAutoScalerProfile | undefined;
    set internalValue(value: KubernetesClusterAutoScalerProfile | undefined);
    private _balanceSimilarNodeGroups?;
    get balanceSimilarNodeGroups(): boolean | cdktf.IResolvable;
    set balanceSimilarNodeGroups(value: boolean | cdktf.IResolvable);
    resetBalanceSimilarNodeGroups(): void;
    get balanceSimilarNodeGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _emptyBulkDeleteMax?;
    get emptyBulkDeleteMax(): string;
    set emptyBulkDeleteMax(value: string);
    resetEmptyBulkDeleteMax(): void;
    get emptyBulkDeleteMaxInput(): string | undefined;
    private _expander?;
    get expander(): string;
    set expander(value: string);
    resetExpander(): void;
    get expanderInput(): string | undefined;
    private _maxGracefulTerminationSec?;
    get maxGracefulTerminationSec(): string;
    set maxGracefulTerminationSec(value: string);
    resetMaxGracefulTerminationSec(): void;
    get maxGracefulTerminationSecInput(): string | undefined;
    private _maxNodeProvisioningTime?;
    get maxNodeProvisioningTime(): string;
    set maxNodeProvisioningTime(value: string);
    resetMaxNodeProvisioningTime(): void;
    get maxNodeProvisioningTimeInput(): string | undefined;
    private _maxUnreadyNodes?;
    get maxUnreadyNodes(): number;
    set maxUnreadyNodes(value: number);
    resetMaxUnreadyNodes(): void;
    get maxUnreadyNodesInput(): number | undefined;
    private _maxUnreadyPercentage?;
    get maxUnreadyPercentage(): number;
    set maxUnreadyPercentage(value: number);
    resetMaxUnreadyPercentage(): void;
    get maxUnreadyPercentageInput(): number | undefined;
    private _newPodScaleUpDelay?;
    get newPodScaleUpDelay(): string;
    set newPodScaleUpDelay(value: string);
    resetNewPodScaleUpDelay(): void;
    get newPodScaleUpDelayInput(): string | undefined;
    private _scaleDownDelayAfterAdd?;
    get scaleDownDelayAfterAdd(): string;
    set scaleDownDelayAfterAdd(value: string);
    resetScaleDownDelayAfterAdd(): void;
    get scaleDownDelayAfterAddInput(): string | undefined;
    private _scaleDownDelayAfterDelete?;
    get scaleDownDelayAfterDelete(): string;
    set scaleDownDelayAfterDelete(value: string);
    resetScaleDownDelayAfterDelete(): void;
    get scaleDownDelayAfterDeleteInput(): string | undefined;
    private _scaleDownDelayAfterFailure?;
    get scaleDownDelayAfterFailure(): string;
    set scaleDownDelayAfterFailure(value: string);
    resetScaleDownDelayAfterFailure(): void;
    get scaleDownDelayAfterFailureInput(): string | undefined;
    private _scaleDownUnneeded?;
    get scaleDownUnneeded(): string;
    set scaleDownUnneeded(value: string);
    resetScaleDownUnneeded(): void;
    get scaleDownUnneededInput(): string | undefined;
    private _scaleDownUnready?;
    get scaleDownUnready(): string;
    set scaleDownUnready(value: string);
    resetScaleDownUnready(): void;
    get scaleDownUnreadyInput(): string | undefined;
    private _scaleDownUtilizationThreshold?;
    get scaleDownUtilizationThreshold(): string;
    set scaleDownUtilizationThreshold(value: string);
    resetScaleDownUtilizationThreshold(): void;
    get scaleDownUtilizationThresholdInput(): string | undefined;
    private _scanInterval?;
    get scanInterval(): string;
    set scanInterval(value: string);
    resetScanInterval(): void;
    get scanIntervalInput(): string | undefined;
    private _skipNodesWithLocalStorage?;
    get skipNodesWithLocalStorage(): boolean | cdktf.IResolvable;
    set skipNodesWithLocalStorage(value: boolean | cdktf.IResolvable);
    resetSkipNodesWithLocalStorage(): void;
    get skipNodesWithLocalStorageInput(): boolean | cdktf.IResolvable | undefined;
    private _skipNodesWithSystemPods?;
    get skipNodesWithSystemPods(): boolean | cdktf.IResolvable;
    set skipNodesWithSystemPods(value: boolean | cdktf.IResolvable);
    resetSkipNodesWithSystemPods(): void;
    get skipNodesWithSystemPodsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#admin_group_object_ids KubernetesCluster#admin_group_object_ids}
    */
    readonly adminGroupObjectIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#azure_rbac_enabled KubernetesCluster#azure_rbac_enabled}
    */
    readonly azureRbacEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#client_app_id KubernetesCluster#client_app_id}
    */
    readonly clientAppId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#managed KubernetesCluster#managed}
    */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#server_app_id KubernetesCluster#server_app_id}
    */
    readonly serverAppId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#server_app_secret KubernetesCluster#server_app_secret}
    */
    readonly serverAppSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#tenant_id KubernetesCluster#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function kubernetesClusterAzureActiveDirectoryRoleBasedAccessControlToTerraform(struct?: KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference | KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl): any;
export declare function kubernetesClusterAzureActiveDirectoryRoleBasedAccessControlToHclTerraform(struct?: KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference | KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl): any;
export declare class KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl | undefined;
    set internalValue(value: KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl | undefined);
    private _adminGroupObjectIds?;
    get adminGroupObjectIds(): string[];
    set adminGroupObjectIds(value: string[]);
    resetAdminGroupObjectIds(): void;
    get adminGroupObjectIdsInput(): string[] | undefined;
    private _azureRbacEnabled?;
    get azureRbacEnabled(): boolean | cdktf.IResolvable;
    set azureRbacEnabled(value: boolean | cdktf.IResolvable);
    resetAzureRbacEnabled(): void;
    get azureRbacEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientAppId?;
    get clientAppId(): string;
    set clientAppId(value: string);
    resetClientAppId(): void;
    get clientAppIdInput(): string | undefined;
    private _managed?;
    get managed(): boolean | cdktf.IResolvable;
    set managed(value: boolean | cdktf.IResolvable);
    resetManaged(): void;
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAppId?;
    get serverAppId(): string;
    set serverAppId(value: string);
    resetServerAppId(): void;
    get serverAppIdInput(): string | undefined;
    private _serverAppSecret?;
    get serverAppSecret(): string;
    set serverAppSecret(value: string);
    resetServerAppSecret(): void;
    get serverAppSecretInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export interface KubernetesClusterConfidentialComputing {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#sgx_quote_helper_enabled KubernetesCluster#sgx_quote_helper_enabled}
    */
    readonly sgxQuoteHelperEnabled: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterConfidentialComputingToTerraform(struct?: KubernetesClusterConfidentialComputingOutputReference | KubernetesClusterConfidentialComputing): any;
export declare function kubernetesClusterConfidentialComputingToHclTerraform(struct?: KubernetesClusterConfidentialComputingOutputReference | KubernetesClusterConfidentialComputing): any;
export declare class KubernetesClusterConfidentialComputingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterConfidentialComputing | undefined;
    set internalValue(value: KubernetesClusterConfidentialComputing | undefined);
    private _sgxQuoteHelperEnabled?;
    get sgxQuoteHelperEnabled(): boolean | cdktf.IResolvable;
    set sgxQuoteHelperEnabled(value: boolean | cdktf.IResolvable);
    get sgxQuoteHelperEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface KubernetesClusterDefaultNodePoolKubeletConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#allowed_unsafe_sysctls KubernetesCluster#allowed_unsafe_sysctls}
    */
    readonly allowedUnsafeSysctls?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#container_log_max_line KubernetesCluster#container_log_max_line}
    */
    readonly containerLogMaxLine?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#container_log_max_size_mb KubernetesCluster#container_log_max_size_mb}
    */
    readonly containerLogMaxSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#cpu_cfs_quota_enabled KubernetesCluster#cpu_cfs_quota_enabled}
    */
    readonly cpuCfsQuotaEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#cpu_cfs_quota_period KubernetesCluster#cpu_cfs_quota_period}
    */
    readonly cpuCfsQuotaPeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#cpu_manager_policy KubernetesCluster#cpu_manager_policy}
    */
    readonly cpuManagerPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#image_gc_high_threshold KubernetesCluster#image_gc_high_threshold}
    */
    readonly imageGcHighThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#image_gc_low_threshold KubernetesCluster#image_gc_low_threshold}
    */
    readonly imageGcLowThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#pod_max_pid KubernetesCluster#pod_max_pid}
    */
    readonly podMaxPid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#topology_manager_policy KubernetesCluster#topology_manager_policy}
    */
    readonly topologyManagerPolicy?: string;
}
export declare function kubernetesClusterDefaultNodePoolKubeletConfigToTerraform(struct?: KubernetesClusterDefaultNodePoolKubeletConfigOutputReference | KubernetesClusterDefaultNodePoolKubeletConfig): any;
export declare function kubernetesClusterDefaultNodePoolKubeletConfigToHclTerraform(struct?: KubernetesClusterDefaultNodePoolKubeletConfigOutputReference | KubernetesClusterDefaultNodePoolKubeletConfig): any;
export declare class KubernetesClusterDefaultNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterDefaultNodePoolKubeletConfig | undefined;
    set internalValue(value: KubernetesClusterDefaultNodePoolKubeletConfig | undefined);
    private _allowedUnsafeSysctls?;
    get allowedUnsafeSysctls(): string[];
    set allowedUnsafeSysctls(value: string[]);
    resetAllowedUnsafeSysctls(): void;
    get allowedUnsafeSysctlsInput(): string[] | undefined;
    private _containerLogMaxLine?;
    get containerLogMaxLine(): number;
    set containerLogMaxLine(value: number);
    resetContainerLogMaxLine(): void;
    get containerLogMaxLineInput(): number | undefined;
    private _containerLogMaxSizeMb?;
    get containerLogMaxSizeMb(): number;
    set containerLogMaxSizeMb(value: number);
    resetContainerLogMaxSizeMb(): void;
    get containerLogMaxSizeMbInput(): number | undefined;
    private _cpuCfsQuotaEnabled?;
    get cpuCfsQuotaEnabled(): boolean | cdktf.IResolvable;
    set cpuCfsQuotaEnabled(value: boolean | cdktf.IResolvable);
    resetCpuCfsQuotaEnabled(): void;
    get cpuCfsQuotaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    get cpuCfsQuotaPeriod(): string;
    set cpuCfsQuotaPeriod(value: string);
    resetCpuCfsQuotaPeriod(): void;
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    get cpuManagerPolicy(): string;
    set cpuManagerPolicy(value: string);
    resetCpuManagerPolicy(): void;
    get cpuManagerPolicyInput(): string | undefined;
    private _imageGcHighThreshold?;
    get imageGcHighThreshold(): number;
    set imageGcHighThreshold(value: number);
    resetImageGcHighThreshold(): void;
    get imageGcHighThresholdInput(): number | undefined;
    private _imageGcLowThreshold?;
    get imageGcLowThreshold(): number;
    set imageGcLowThreshold(value: number);
    resetImageGcLowThreshold(): void;
    get imageGcLowThresholdInput(): number | undefined;
    private _podMaxPid?;
    get podMaxPid(): number;
    set podMaxPid(value: number);
    resetPodMaxPid(): void;
    get podMaxPidInput(): number | undefined;
    private _topologyManagerPolicy?;
    get topologyManagerPolicy(): string;
    set topologyManagerPolicy(value: string);
    resetTopologyManagerPolicy(): void;
    get topologyManagerPolicyInput(): string | undefined;
}
export interface KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#fs_aio_max_nr KubernetesCluster#fs_aio_max_nr}
    */
    readonly fsAioMaxNr?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#fs_file_max KubernetesCluster#fs_file_max}
    */
    readonly fsFileMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#fs_inotify_max_user_watches KubernetesCluster#fs_inotify_max_user_watches}
    */
    readonly fsInotifyMaxUserWatches?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#fs_nr_open KubernetesCluster#fs_nr_open}
    */
    readonly fsNrOpen?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#kernel_threads_max KubernetesCluster#kernel_threads_max}
    */
    readonly kernelThreadsMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_core_netdev_max_backlog KubernetesCluster#net_core_netdev_max_backlog}
    */
    readonly netCoreNetdevMaxBacklog?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_core_optmem_max KubernetesCluster#net_core_optmem_max}
    */
    readonly netCoreOptmemMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_core_rmem_default KubernetesCluster#net_core_rmem_default}
    */
    readonly netCoreRmemDefault?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_core_rmem_max KubernetesCluster#net_core_rmem_max}
    */
    readonly netCoreRmemMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_core_somaxconn KubernetesCluster#net_core_somaxconn}
    */
    readonly netCoreSomaxconn?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_core_wmem_default KubernetesCluster#net_core_wmem_default}
    */
    readonly netCoreWmemDefault?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_core_wmem_max KubernetesCluster#net_core_wmem_max}
    */
    readonly netCoreWmemMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_ip_local_port_range_max KubernetesCluster#net_ipv4_ip_local_port_range_max}
    */
    readonly netIpv4IpLocalPortRangeMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_ip_local_port_range_min KubernetesCluster#net_ipv4_ip_local_port_range_min}
    */
    readonly netIpv4IpLocalPortRangeMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_neigh_default_gc_thresh1 KubernetesCluster#net_ipv4_neigh_default_gc_thresh1}
    */
    readonly netIpv4NeighDefaultGcThresh1?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_neigh_default_gc_thresh2 KubernetesCluster#net_ipv4_neigh_default_gc_thresh2}
    */
    readonly netIpv4NeighDefaultGcThresh2?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_neigh_default_gc_thresh3 KubernetesCluster#net_ipv4_neigh_default_gc_thresh3}
    */
    readonly netIpv4NeighDefaultGcThresh3?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_tcp_fin_timeout KubernetesCluster#net_ipv4_tcp_fin_timeout}
    */
    readonly netIpv4TcpFinTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_tcp_keepalive_intvl KubernetesCluster#net_ipv4_tcp_keepalive_intvl}
    */
    readonly netIpv4TcpKeepaliveIntvl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_tcp_keepalive_probes KubernetesCluster#net_ipv4_tcp_keepalive_probes}
    */
    readonly netIpv4TcpKeepaliveProbes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_tcp_keepalive_time KubernetesCluster#net_ipv4_tcp_keepalive_time}
    */
    readonly netIpv4TcpKeepaliveTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_tcp_max_syn_backlog KubernetesCluster#net_ipv4_tcp_max_syn_backlog}
    */
    readonly netIpv4TcpMaxSynBacklog?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_tcp_max_tw_buckets KubernetesCluster#net_ipv4_tcp_max_tw_buckets}
    */
    readonly netIpv4TcpMaxTwBuckets?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_ipv4_tcp_tw_reuse KubernetesCluster#net_ipv4_tcp_tw_reuse}
    */
    readonly netIpv4TcpTwReuse?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_netfilter_nf_conntrack_buckets KubernetesCluster#net_netfilter_nf_conntrack_buckets}
    */
    readonly netNetfilterNfConntrackBuckets?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#net_netfilter_nf_conntrack_max KubernetesCluster#net_netfilter_nf_conntrack_max}
    */
    readonly netNetfilterNfConntrackMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#vm_max_map_count KubernetesCluster#vm_max_map_count}
    */
    readonly vmMaxMapCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#vm_swappiness KubernetesCluster#vm_swappiness}
    */
    readonly vmSwappiness?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#vm_vfs_cache_pressure KubernetesCluster#vm_vfs_cache_pressure}
    */
    readonly vmVfsCachePressure?: number;
}
export declare function kubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigToTerraform(struct?: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigOutputReference | KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig): any;
export declare function kubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigToHclTerraform(struct?: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigOutputReference | KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig): any;
export declare class KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig | undefined;
    set internalValue(value: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig | undefined);
    private _fsAioMaxNr?;
    get fsAioMaxNr(): number;
    set fsAioMaxNr(value: number);
    resetFsAioMaxNr(): void;
    get fsAioMaxNrInput(): number | undefined;
    private _fsFileMax?;
    get fsFileMax(): number;
    set fsFileMax(value: number);
    resetFsFileMax(): void;
    get fsFileMaxInput(): number | undefined;
    private _fsInotifyMaxUserWatches?;
    get fsInotifyMaxUserWatches(): number;
    set fsInotifyMaxUserWatches(value: number);
    resetFsInotifyMaxUserWatches(): void;
    get fsInotifyMaxUserWatchesInput(): number | undefined;
    private _fsNrOpen?;
    get fsNrOpen(): number;
    set fsNrOpen(value: number);
    resetFsNrOpen(): void;
    get fsNrOpenInput(): number | undefined;
    private _kernelThreadsMax?;
    get kernelThreadsMax(): number;
    set kernelThreadsMax(value: number);
    resetKernelThreadsMax(): void;
    get kernelThreadsMaxInput(): number | undefined;
    private _netCoreNetdevMaxBacklog?;
    get netCoreNetdevMaxBacklog(): number;
    set netCoreNetdevMaxBacklog(value: number);
    resetNetCoreNetdevMaxBacklog(): void;
    get netCoreNetdevMaxBacklogInput(): number | undefined;
    private _netCoreOptmemMax?;
    get netCoreOptmemMax(): number;
    set netCoreOptmemMax(value: number);
    resetNetCoreOptmemMax(): void;
    get netCoreOptmemMaxInput(): number | undefined;
    private _netCoreRmemDefault?;
    get netCoreRmemDefault(): number;
    set netCoreRmemDefault(value: number);
    resetNetCoreRmemDefault(): void;
    get netCoreRmemDefaultInput(): number | undefined;
    private _netCoreRmemMax?;
    get netCoreRmemMax(): number;
    set netCoreRmemMax(value: number);
    resetNetCoreRmemMax(): void;
    get netCoreRmemMaxInput(): number | undefined;
    private _netCoreSomaxconn?;
    get netCoreSomaxconn(): number;
    set netCoreSomaxconn(value: number);
    resetNetCoreSomaxconn(): void;
    get netCoreSomaxconnInput(): number | undefined;
    private _netCoreWmemDefault?;
    get netCoreWmemDefault(): number;
    set netCoreWmemDefault(value: number);
    resetNetCoreWmemDefault(): void;
    get netCoreWmemDefaultInput(): number | undefined;
    private _netCoreWmemMax?;
    get netCoreWmemMax(): number;
    set netCoreWmemMax(value: number);
    resetNetCoreWmemMax(): void;
    get netCoreWmemMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMax?;
    get netIpv4IpLocalPortRangeMax(): number;
    set netIpv4IpLocalPortRangeMax(value: number);
    resetNetIpv4IpLocalPortRangeMax(): void;
    get netIpv4IpLocalPortRangeMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMin?;
    get netIpv4IpLocalPortRangeMin(): number;
    set netIpv4IpLocalPortRangeMin(value: number);
    resetNetIpv4IpLocalPortRangeMin(): void;
    get netIpv4IpLocalPortRangeMinInput(): number | undefined;
    private _netIpv4NeighDefaultGcThresh1?;
    get netIpv4NeighDefaultGcThresh1(): number;
    set netIpv4NeighDefaultGcThresh1(value: number);
    resetNetIpv4NeighDefaultGcThresh1(): void;
    get netIpv4NeighDefaultGcThresh1Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh2?;
    get netIpv4NeighDefaultGcThresh2(): number;
    set netIpv4NeighDefaultGcThresh2(value: number);
    resetNetIpv4NeighDefaultGcThresh2(): void;
    get netIpv4NeighDefaultGcThresh2Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh3?;
    get netIpv4NeighDefaultGcThresh3(): number;
    set netIpv4NeighDefaultGcThresh3(value: number);
    resetNetIpv4NeighDefaultGcThresh3(): void;
    get netIpv4NeighDefaultGcThresh3Input(): number | undefined;
    private _netIpv4TcpFinTimeout?;
    get netIpv4TcpFinTimeout(): number;
    set netIpv4TcpFinTimeout(value: number);
    resetNetIpv4TcpFinTimeout(): void;
    get netIpv4TcpFinTimeoutInput(): number | undefined;
    private _netIpv4TcpKeepaliveIntvl?;
    get netIpv4TcpKeepaliveIntvl(): number;
    set netIpv4TcpKeepaliveIntvl(value: number);
    resetNetIpv4TcpKeepaliveIntvl(): void;
    get netIpv4TcpKeepaliveIntvlInput(): number | undefined;
    private _netIpv4TcpKeepaliveProbes?;
    get netIpv4TcpKeepaliveProbes(): number;
    set netIpv4TcpKeepaliveProbes(value: number);
    resetNetIpv4TcpKeepaliveProbes(): void;
    get netIpv4TcpKeepaliveProbesInput(): number | undefined;
    private _netIpv4TcpKeepaliveTime?;
    get netIpv4TcpKeepaliveTime(): number;
    set netIpv4TcpKeepaliveTime(value: number);
    resetNetIpv4TcpKeepaliveTime(): void;
    get netIpv4TcpKeepaliveTimeInput(): number | undefined;
    private _netIpv4TcpMaxSynBacklog?;
    get netIpv4TcpMaxSynBacklog(): number;
    set netIpv4TcpMaxSynBacklog(value: number);
    resetNetIpv4TcpMaxSynBacklog(): void;
    get netIpv4TcpMaxSynBacklogInput(): number | undefined;
    private _netIpv4TcpMaxTwBuckets?;
    get netIpv4TcpMaxTwBuckets(): number;
    set netIpv4TcpMaxTwBuckets(value: number);
    resetNetIpv4TcpMaxTwBuckets(): void;
    get netIpv4TcpMaxTwBucketsInput(): number | undefined;
    private _netIpv4TcpTwReuse?;
    get netIpv4TcpTwReuse(): boolean | cdktf.IResolvable;
    set netIpv4TcpTwReuse(value: boolean | cdktf.IResolvable);
    resetNetIpv4TcpTwReuse(): void;
    get netIpv4TcpTwReuseInput(): boolean | cdktf.IResolvable | undefined;
    private _netNetfilterNfConntrackBuckets?;
    get netNetfilterNfConntrackBuckets(): number;
    set netNetfilterNfConntrackBuckets(value: number);
    resetNetNetfilterNfConntrackBuckets(): void;
    get netNetfilterNfConntrackBucketsInput(): number | undefined;
    private _netNetfilterNfConntrackMax?;
    get netNetfilterNfConntrackMax(): number;
    set netNetfilterNfConntrackMax(value: number);
    resetNetNetfilterNfConntrackMax(): void;
    get netNetfilterNfConntrackMaxInput(): number | undefined;
    private _vmMaxMapCount?;
    get vmMaxMapCount(): number;
    set vmMaxMapCount(value: number);
    resetVmMaxMapCount(): void;
    get vmMaxMapCountInput(): number | undefined;
    private _vmSwappiness?;
    get vmSwappiness(): number;
    set vmSwappiness(value: number);
    resetVmSwappiness(): void;
    get vmSwappinessInput(): number | undefined;
    private _vmVfsCachePressure?;
    get vmVfsCachePressure(): number;
    set vmVfsCachePressure(value: number);
    resetVmVfsCachePressure(): void;
    get vmVfsCachePressureInput(): number | undefined;
}
export interface KubernetesClusterDefaultNodePoolLinuxOsConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#swap_file_size_mb KubernetesCluster#swap_file_size_mb}
    */
    readonly swapFileSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#transparent_huge_page_defrag KubernetesCluster#transparent_huge_page_defrag}
    */
    readonly transparentHugePageDefrag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#transparent_huge_page_enabled KubernetesCluster#transparent_huge_page_enabled}
    */
    readonly transparentHugePageEnabled?: string;
    /**
    * sysctl_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#sysctl_config KubernetesCluster#sysctl_config}
    */
    readonly sysctlConfig?: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig;
}
export declare function kubernetesClusterDefaultNodePoolLinuxOsConfigToTerraform(struct?: KubernetesClusterDefaultNodePoolLinuxOsConfigOutputReference | KubernetesClusterDefaultNodePoolLinuxOsConfig): any;
export declare function kubernetesClusterDefaultNodePoolLinuxOsConfigToHclTerraform(struct?: KubernetesClusterDefaultNodePoolLinuxOsConfigOutputReference | KubernetesClusterDefaultNodePoolLinuxOsConfig): any;
export declare class KubernetesClusterDefaultNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterDefaultNodePoolLinuxOsConfig | undefined;
    set internalValue(value: KubernetesClusterDefaultNodePoolLinuxOsConfig | undefined);
    private _swapFileSizeMb?;
    get swapFileSizeMb(): number;
    set swapFileSizeMb(value: number);
    resetSwapFileSizeMb(): void;
    get swapFileSizeMbInput(): number | undefined;
    private _transparentHugePageDefrag?;
    get transparentHugePageDefrag(): string;
    set transparentHugePageDefrag(value: string);
    resetTransparentHugePageDefrag(): void;
    get transparentHugePageDefragInput(): string | undefined;
    private _transparentHugePageEnabled?;
    get transparentHugePageEnabled(): string;
    set transparentHugePageEnabled(value: string);
    resetTransparentHugePageEnabled(): void;
    get transparentHugePageEnabledInput(): string | undefined;
    private _sysctlConfig;
    get sysctlConfig(): KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigOutputReference;
    putSysctlConfig(value: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig): void;
    resetSysctlConfig(): void;
    get sysctlConfigInput(): KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig | undefined;
}
export interface KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#port_end KubernetesCluster#port_end}
    */
    readonly portEnd?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#port_start KubernetesCluster#port_start}
    */
    readonly portStart?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#protocol KubernetesCluster#protocol}
    */
    readonly protocol?: string;
}
export declare function kubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPortsToTerraform(struct?: KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable): any;
export declare function kubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPortsToHclTerraform(struct?: KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable): any;
export declare class KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable | undefined);
    private _portEnd?;
    get portEnd(): number;
    set portEnd(value: number);
    resetPortEnd(): void;
    get portEndInput(): number | undefined;
    private _portStart?;
    get portStart(): number;
    set portStart(value: number);
    resetPortStart(): void;
    get portStartInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPortsOutputReference;
}
export interface KubernetesClusterDefaultNodePoolNodeNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#application_security_group_ids KubernetesCluster#application_security_group_ids}
    */
    readonly applicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_public_ip_tags KubernetesCluster#node_public_ip_tags}
    */
    readonly nodePublicIpTags?: {
        [key: string]: string;
    };
    /**
    * allowed_host_ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#allowed_host_ports KubernetesCluster#allowed_host_ports}
    */
    readonly allowedHostPorts?: KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts[] | cdktf.IResolvable;
}
export declare function kubernetesClusterDefaultNodePoolNodeNetworkProfileToTerraform(struct?: KubernetesClusterDefaultNodePoolNodeNetworkProfileOutputReference | KubernetesClusterDefaultNodePoolNodeNetworkProfile): any;
export declare function kubernetesClusterDefaultNodePoolNodeNetworkProfileToHclTerraform(struct?: KubernetesClusterDefaultNodePoolNodeNetworkProfileOutputReference | KubernetesClusterDefaultNodePoolNodeNetworkProfile): any;
export declare class KubernetesClusterDefaultNodePoolNodeNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterDefaultNodePoolNodeNetworkProfile | undefined;
    set internalValue(value: KubernetesClusterDefaultNodePoolNodeNetworkProfile | undefined);
    private _applicationSecurityGroupIds?;
    get applicationSecurityGroupIds(): string[];
    set applicationSecurityGroupIds(value: string[]);
    resetApplicationSecurityGroupIds(): void;
    get applicationSecurityGroupIdsInput(): string[] | undefined;
    private _nodePublicIpTags?;
    get nodePublicIpTags(): {
        [key: string]: string;
    };
    set nodePublicIpTags(value: {
        [key: string]: string;
    });
    resetNodePublicIpTags(): void;
    get nodePublicIpTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedHostPorts;
    get allowedHostPorts(): KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPortsList;
    putAllowedHostPorts(value: KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts[] | cdktf.IResolvable): void;
    resetAllowedHostPorts(): void;
    get allowedHostPortsInput(): cdktf.IResolvable | KubernetesClusterDefaultNodePoolNodeNetworkProfileAllowedHostPorts[] | undefined;
}
export interface KubernetesClusterDefaultNodePoolUpgradeSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#drain_timeout_in_minutes KubernetesCluster#drain_timeout_in_minutes}
    */
    readonly drainTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#max_surge KubernetesCluster#max_surge}
    */
    readonly maxSurge: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_soak_duration_in_minutes KubernetesCluster#node_soak_duration_in_minutes}
    */
    readonly nodeSoakDurationInMinutes?: number;
}
export declare function kubernetesClusterDefaultNodePoolUpgradeSettingsToTerraform(struct?: KubernetesClusterDefaultNodePoolUpgradeSettingsOutputReference | KubernetesClusterDefaultNodePoolUpgradeSettings): any;
export declare function kubernetesClusterDefaultNodePoolUpgradeSettingsToHclTerraform(struct?: KubernetesClusterDefaultNodePoolUpgradeSettingsOutputReference | KubernetesClusterDefaultNodePoolUpgradeSettings): any;
export declare class KubernetesClusterDefaultNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterDefaultNodePoolUpgradeSettings | undefined;
    set internalValue(value: KubernetesClusterDefaultNodePoolUpgradeSettings | undefined);
    private _drainTimeoutInMinutes?;
    get drainTimeoutInMinutes(): number;
    set drainTimeoutInMinutes(value: number);
    resetDrainTimeoutInMinutes(): void;
    get drainTimeoutInMinutesInput(): number | undefined;
    private _maxSurge?;
    get maxSurge(): string;
    set maxSurge(value: string);
    get maxSurgeInput(): string | undefined;
    private _nodeSoakDurationInMinutes?;
    get nodeSoakDurationInMinutes(): number;
    set nodeSoakDurationInMinutes(value: number);
    resetNodeSoakDurationInMinutes(): void;
    get nodeSoakDurationInMinutesInput(): number | undefined;
}
export interface KubernetesClusterDefaultNodePool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#capacity_reservation_group_id KubernetesCluster#capacity_reservation_group_id}
    */
    readonly capacityReservationGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#custom_ca_trust_enabled KubernetesCluster#custom_ca_trust_enabled}
    */
    readonly customCaTrustEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#enable_auto_scaling KubernetesCluster#enable_auto_scaling}
    */
    readonly enableAutoScaling?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#enable_host_encryption KubernetesCluster#enable_host_encryption}
    */
    readonly enableHostEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#enable_node_public_ip KubernetesCluster#enable_node_public_ip}
    */
    readonly enableNodePublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#fips_enabled KubernetesCluster#fips_enabled}
    */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#gpu_instance KubernetesCluster#gpu_instance}
    */
    readonly gpuInstance?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#host_group_id KubernetesCluster#host_group_id}
    */
    readonly hostGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#kubelet_disk_type KubernetesCluster#kubelet_disk_type}
    */
    readonly kubeletDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#max_count KubernetesCluster#max_count}
    */
    readonly maxCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#max_pods KubernetesCluster#max_pods}
    */
    readonly maxPods?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#message_of_the_day KubernetesCluster#message_of_the_day}
    */
    readonly messageOfTheDay?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#min_count KubernetesCluster#min_count}
    */
    readonly minCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#name KubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_count KubernetesCluster#node_count}
    */
    readonly nodeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_labels KubernetesCluster#node_labels}
    */
    readonly nodeLabels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_public_ip_prefix_id KubernetesCluster#node_public_ip_prefix_id}
    */
    readonly nodePublicIpPrefixId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_taints KubernetesCluster#node_taints}
    */
    readonly nodeTaints?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#only_critical_addons_enabled KubernetesCluster#only_critical_addons_enabled}
    */
    readonly onlyCriticalAddonsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#orchestrator_version KubernetesCluster#orchestrator_version}
    */
    readonly orchestratorVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#os_disk_size_gb KubernetesCluster#os_disk_size_gb}
    */
    readonly osDiskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#os_disk_type KubernetesCluster#os_disk_type}
    */
    readonly osDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#os_sku KubernetesCluster#os_sku}
    */
    readonly osSku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#pod_subnet_id KubernetesCluster#pod_subnet_id}
    */
    readonly podSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#proximity_placement_group_id KubernetesCluster#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#scale_down_mode KubernetesCluster#scale_down_mode}
    */
    readonly scaleDownMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#snapshot_id KubernetesCluster#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#tags KubernetesCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#temporary_name_for_rotation KubernetesCluster#temporary_name_for_rotation}
    */
    readonly temporaryNameForRotation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#type KubernetesCluster#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#ultra_ssd_enabled KubernetesCluster#ultra_ssd_enabled}
    */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#vm_size KubernetesCluster#vm_size}
    */
    readonly vmSize: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#vnet_subnet_id KubernetesCluster#vnet_subnet_id}
    */
    readonly vnetSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#workload_runtime KubernetesCluster#workload_runtime}
    */
    readonly workloadRuntime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#zones KubernetesCluster#zones}
    */
    readonly zones?: string[];
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#kubelet_config KubernetesCluster#kubelet_config}
    */
    readonly kubeletConfig?: KubernetesClusterDefaultNodePoolKubeletConfig;
    /**
    * linux_os_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#linux_os_config KubernetesCluster#linux_os_config}
    */
    readonly linuxOsConfig?: KubernetesClusterDefaultNodePoolLinuxOsConfig;
    /**
    * node_network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#node_network_profile KubernetesCluster#node_network_profile}
    */
    readonly nodeNetworkProfile?: KubernetesClusterDefaultNodePoolNodeNetworkProfile;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#upgrade_settings KubernetesCluster#upgrade_settings}
    */
    readonly upgradeSettings?: KubernetesClusterDefaultNodePoolUpgradeSettings;
}
export declare function kubernetesClusterDefaultNodePoolToTerraform(struct?: KubernetesClusterDefaultNodePoolOutputReference | KubernetesClusterDefaultNodePool): any;
export declare function kubernetesClusterDefaultNodePoolToHclTerraform(struct?: KubernetesClusterDefaultNodePoolOutputReference | KubernetesClusterDefaultNodePool): any;
export declare class KubernetesClusterDefaultNodePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterDefaultNodePool | undefined;
    set internalValue(value: KubernetesClusterDefaultNodePool | undefined);
    private _capacityReservationGroupId?;
    get capacityReservationGroupId(): string;
    set capacityReservationGroupId(value: string);
    resetCapacityReservationGroupId(): void;
    get capacityReservationGroupIdInput(): string | undefined;
    private _customCaTrustEnabled?;
    get customCaTrustEnabled(): boolean | cdktf.IResolvable;
    set customCaTrustEnabled(value: boolean | cdktf.IResolvable);
    resetCustomCaTrustEnabled(): void;
    get customCaTrustEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutoScaling?;
    get enableAutoScaling(): boolean | cdktf.IResolvable;
    set enableAutoScaling(value: boolean | cdktf.IResolvable);
    resetEnableAutoScaling(): void;
    get enableAutoScalingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHostEncryption?;
    get enableHostEncryption(): boolean | cdktf.IResolvable;
    set enableHostEncryption(value: boolean | cdktf.IResolvable);
    resetEnableHostEncryption(): void;
    get enableHostEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableNodePublicIp?;
    get enableNodePublicIp(): boolean | cdktf.IResolvable;
    set enableNodePublicIp(value: boolean | cdktf.IResolvable);
    resetEnableNodePublicIp(): void;
    get enableNodePublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _fipsEnabled?;
    get fipsEnabled(): boolean | cdktf.IResolvable;
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    resetFipsEnabled(): void;
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gpuInstance?;
    get gpuInstance(): string;
    set gpuInstance(value: string);
    resetGpuInstance(): void;
    get gpuInstanceInput(): string | undefined;
    private _hostGroupId?;
    get hostGroupId(): string;
    set hostGroupId(value: string);
    resetHostGroupId(): void;
    get hostGroupIdInput(): string | undefined;
    private _kubeletDiskType?;
    get kubeletDiskType(): string;
    set kubeletDiskType(value: string);
    resetKubeletDiskType(): void;
    get kubeletDiskTypeInput(): string | undefined;
    private _maxCount?;
    get maxCount(): number;
    set maxCount(value: number);
    resetMaxCount(): void;
    get maxCountInput(): number | undefined;
    private _maxPods?;
    get maxPods(): number;
    set maxPods(value: number);
    resetMaxPods(): void;
    get maxPodsInput(): number | undefined;
    private _messageOfTheDay?;
    get messageOfTheDay(): string;
    set messageOfTheDay(value: string);
    resetMessageOfTheDay(): void;
    get messageOfTheDayInput(): string | undefined;
    private _minCount?;
    get minCount(): number;
    set minCount(value: number);
    resetMinCount(): void;
    get minCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLabels?;
    get nodeLabels(): {
        [key: string]: string;
    };
    set nodeLabels(value: {
        [key: string]: string;
    });
    resetNodeLabels(): void;
    get nodeLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodePublicIpPrefixId?;
    get nodePublicIpPrefixId(): string;
    set nodePublicIpPrefixId(value: string);
    resetNodePublicIpPrefixId(): void;
    get nodePublicIpPrefixIdInput(): string | undefined;
    private _nodeTaints?;
    get nodeTaints(): string[];
    set nodeTaints(value: string[]);
    resetNodeTaints(): void;
    get nodeTaintsInput(): string[] | undefined;
    private _onlyCriticalAddonsEnabled?;
    get onlyCriticalAddonsEnabled(): boolean | cdktf.IResolvable;
    set onlyCriticalAddonsEnabled(value: boolean | cdktf.IResolvable);
    resetOnlyCriticalAddonsEnabled(): void;
    get onlyCriticalAddonsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _orchestratorVersion?;
    get orchestratorVersion(): string;
    set orchestratorVersion(value: string);
    resetOrchestratorVersion(): void;
    get orchestratorVersionInput(): string | undefined;
    private _osDiskSizeGb?;
    get osDiskSizeGb(): number;
    set osDiskSizeGb(value: number);
    resetOsDiskSizeGb(): void;
    get osDiskSizeGbInput(): number | undefined;
    private _osDiskType?;
    get osDiskType(): string;
    set osDiskType(value: string);
    resetOsDiskType(): void;
    get osDiskTypeInput(): string | undefined;
    private _osSku?;
    get osSku(): string;
    set osSku(value: string);
    resetOsSku(): void;
    get osSkuInput(): string | undefined;
    private _podSubnetId?;
    get podSubnetId(): string;
    set podSubnetId(value: string);
    resetPodSubnetId(): void;
    get podSubnetIdInput(): string | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _scaleDownMode?;
    get scaleDownMode(): string;
    set scaleDownMode(value: string);
    resetScaleDownMode(): void;
    get scaleDownModeInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _temporaryNameForRotation?;
    get temporaryNameForRotation(): string;
    set temporaryNameForRotation(value: string);
    resetTemporaryNameForRotation(): void;
    get temporaryNameForRotationInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _ultraSsdEnabled?;
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    resetUltraSsdEnabled(): void;
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _vnetSubnetId?;
    get vnetSubnetId(): string;
    set vnetSubnetId(value: string);
    resetVnetSubnetId(): void;
    get vnetSubnetIdInput(): string | undefined;
    private _workloadRuntime?;
    get workloadRuntime(): string;
    set workloadRuntime(value: string);
    resetWorkloadRuntime(): void;
    get workloadRuntimeInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _kubeletConfig;
    get kubeletConfig(): KubernetesClusterDefaultNodePoolKubeletConfigOutputReference;
    putKubeletConfig(value: KubernetesClusterDefaultNodePoolKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): KubernetesClusterDefaultNodePoolKubeletConfig | undefined;
    private _linuxOsConfig;
    get linuxOsConfig(): KubernetesClusterDefaultNodePoolLinuxOsConfigOutputReference;
    putLinuxOsConfig(value: KubernetesClusterDefaultNodePoolLinuxOsConfig): void;
    resetLinuxOsConfig(): void;
    get linuxOsConfigInput(): KubernetesClusterDefaultNodePoolLinuxOsConfig | undefined;
    private _nodeNetworkProfile;
    get nodeNetworkProfile(): KubernetesClusterDefaultNodePoolNodeNetworkProfileOutputReference;
    putNodeNetworkProfile(value: KubernetesClusterDefaultNodePoolNodeNetworkProfile): void;
    resetNodeNetworkProfile(): void;
    get nodeNetworkProfileInput(): KubernetesClusterDefaultNodePoolNodeNetworkProfile | undefined;
    private _upgradeSettings;
    get upgradeSettings(): KubernetesClusterDefaultNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: KubernetesClusterDefaultNodePoolUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): KubernetesClusterDefaultNodePoolUpgradeSettings | undefined;
}
export interface KubernetesClusterHttpProxyConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#http_proxy KubernetesCluster#http_proxy}
    */
    readonly httpProxy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#https_proxy KubernetesCluster#https_proxy}
    */
    readonly httpsProxy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#no_proxy KubernetesCluster#no_proxy}
    */
    readonly noProxy?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#trusted_ca KubernetesCluster#trusted_ca}
    */
    readonly trustedCa?: string;
}
export declare function kubernetesClusterHttpProxyConfigToTerraform(struct?: KubernetesClusterHttpProxyConfigOutputReference | KubernetesClusterHttpProxyConfig): any;
export declare function kubernetesClusterHttpProxyConfigToHclTerraform(struct?: KubernetesClusterHttpProxyConfigOutputReference | KubernetesClusterHttpProxyConfig): any;
export declare class KubernetesClusterHttpProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterHttpProxyConfig | undefined;
    set internalValue(value: KubernetesClusterHttpProxyConfig | undefined);
    private _httpProxy?;
    get httpProxy(): string;
    set httpProxy(value: string);
    resetHttpProxy(): void;
    get httpProxyInput(): string | undefined;
    private _httpsProxy?;
    get httpsProxy(): string;
    set httpsProxy(value: string);
    resetHttpsProxy(): void;
    get httpsProxyInput(): string | undefined;
    private _noProxy?;
    get noProxy(): string[];
    set noProxy(value: string[]);
    resetNoProxy(): void;
    get noProxyInput(): string[] | undefined;
    private _trustedCa?;
    get trustedCa(): string;
    set trustedCa(value: string);
    resetTrustedCa(): void;
    get trustedCaInput(): string | undefined;
}
export interface KubernetesClusterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#identity_ids KubernetesCluster#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#type KubernetesCluster#type}
    */
    readonly type: string;
}
export declare function kubernetesClusterIdentityToTerraform(struct?: KubernetesClusterIdentityOutputReference | KubernetesClusterIdentity): any;
export declare function kubernetesClusterIdentityToHclTerraform(struct?: KubernetesClusterIdentityOutputReference | KubernetesClusterIdentity): any;
export declare class KubernetesClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterIdentity | undefined;
    set internalValue(value: KubernetesClusterIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity {
}
export declare function kubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityToTerraform(struct?: KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity): any;
export declare function kubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityToHclTerraform(struct?: KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity): any;
export declare class KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined;
    set internalValue(value: KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityOutputReference;
}
export interface KubernetesClusterIngressApplicationGateway {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#gateway_id KubernetesCluster#gateway_id}
    */
    readonly gatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#gateway_name KubernetesCluster#gateway_name}
    */
    readonly gatewayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#subnet_cidr KubernetesCluster#subnet_cidr}
    */
    readonly subnetCidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#subnet_id KubernetesCluster#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function kubernetesClusterIngressApplicationGatewayToTerraform(struct?: KubernetesClusterIngressApplicationGatewayOutputReference | KubernetesClusterIngressApplicationGateway): any;
export declare function kubernetesClusterIngressApplicationGatewayToHclTerraform(struct?: KubernetesClusterIngressApplicationGatewayOutputReference | KubernetesClusterIngressApplicationGateway): any;
export declare class KubernetesClusterIngressApplicationGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterIngressApplicationGateway | undefined;
    set internalValue(value: KubernetesClusterIngressApplicationGateway | undefined);
    get effectiveGatewayId(): string;
    private _gatewayId?;
    get gatewayId(): string;
    set gatewayId(value: string);
    resetGatewayId(): void;
    get gatewayIdInput(): string | undefined;
    private _gatewayName?;
    get gatewayName(): string;
    set gatewayName(value: string);
    resetGatewayName(): void;
    get gatewayNameInput(): string | undefined;
    private _ingressApplicationGatewayIdentity;
    get ingressApplicationGatewayIdentity(): KubernetesClusterIngressApplicationGatewayIngressApplicationGatewayIdentityList;
    private _subnetCidr?;
    get subnetCidr(): string;
    set subnetCidr(value: string);
    resetSubnetCidr(): void;
    get subnetCidrInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export interface KubernetesClusterKeyManagementService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#key_vault_key_id KubernetesCluster#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#key_vault_network_access KubernetesCluster#key_vault_network_access}
    */
    readonly keyVaultNetworkAccess?: string;
}
export declare function kubernetesClusterKeyManagementServiceToTerraform(struct?: KubernetesClusterKeyManagementServiceOutputReference | KubernetesClusterKeyManagementService): any;
export declare function kubernetesClusterKeyManagementServiceToHclTerraform(struct?: KubernetesClusterKeyManagementServiceOutputReference | KubernetesClusterKeyManagementService): any;
export declare class KubernetesClusterKeyManagementServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterKeyManagementService | undefined;
    set internalValue(value: KubernetesClusterKeyManagementService | undefined);
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
    private _keyVaultNetworkAccess?;
    get keyVaultNetworkAccess(): string;
    set keyVaultNetworkAccess(value: string);
    resetKeyVaultNetworkAccess(): void;
    get keyVaultNetworkAccessInput(): string | undefined;
}
export interface KubernetesClusterKeyVaultSecretsProviderSecretIdentity {
}
export declare function kubernetesClusterKeyVaultSecretsProviderSecretIdentityToTerraform(struct?: KubernetesClusterKeyVaultSecretsProviderSecretIdentity): any;
export declare function kubernetesClusterKeyVaultSecretsProviderSecretIdentityToHclTerraform(struct?: KubernetesClusterKeyVaultSecretsProviderSecretIdentity): any;
export declare class KubernetesClusterKeyVaultSecretsProviderSecretIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterKeyVaultSecretsProviderSecretIdentity | undefined;
    set internalValue(value: KubernetesClusterKeyVaultSecretsProviderSecretIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class KubernetesClusterKeyVaultSecretsProviderSecretIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterKeyVaultSecretsProviderSecretIdentityOutputReference;
}
export interface KubernetesClusterKeyVaultSecretsProvider {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#secret_rotation_enabled KubernetesCluster#secret_rotation_enabled}
    */
    readonly secretRotationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#secret_rotation_interval KubernetesCluster#secret_rotation_interval}
    */
    readonly secretRotationInterval?: string;
}
export declare function kubernetesClusterKeyVaultSecretsProviderToTerraform(struct?: KubernetesClusterKeyVaultSecretsProviderOutputReference | KubernetesClusterKeyVaultSecretsProvider): any;
export declare function kubernetesClusterKeyVaultSecretsProviderToHclTerraform(struct?: KubernetesClusterKeyVaultSecretsProviderOutputReference | KubernetesClusterKeyVaultSecretsProvider): any;
export declare class KubernetesClusterKeyVaultSecretsProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterKeyVaultSecretsProvider | undefined;
    set internalValue(value: KubernetesClusterKeyVaultSecretsProvider | undefined);
    private _secretIdentity;
    get secretIdentity(): KubernetesClusterKeyVaultSecretsProviderSecretIdentityList;
    private _secretRotationEnabled?;
    get secretRotationEnabled(): boolean | cdktf.IResolvable;
    set secretRotationEnabled(value: boolean | cdktf.IResolvable);
    resetSecretRotationEnabled(): void;
    get secretRotationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRotationInterval?;
    get secretRotationInterval(): string;
    set secretRotationInterval(value: string);
    resetSecretRotationInterval(): void;
    get secretRotationIntervalInput(): string | undefined;
}
export interface KubernetesClusterKubeletIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#client_id KubernetesCluster#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#object_id KubernetesCluster#object_id}
    */
    readonly objectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#user_assigned_identity_id KubernetesCluster#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function kubernetesClusterKubeletIdentityToTerraform(struct?: KubernetesClusterKubeletIdentityOutputReference | KubernetesClusterKubeletIdentity): any;
export declare function kubernetesClusterKubeletIdentityToHclTerraform(struct?: KubernetesClusterKubeletIdentityOutputReference | KubernetesClusterKubeletIdentity): any;
export declare class KubernetesClusterKubeletIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterKubeletIdentity | undefined;
    set internalValue(value: KubernetesClusterKubeletIdentity | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export interface KubernetesClusterLinuxProfileSshKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#key_data KubernetesCluster#key_data}
    */
    readonly keyData: string;
}
export declare function kubernetesClusterLinuxProfileSshKeyToTerraform(struct?: KubernetesClusterLinuxProfileSshKeyOutputReference | KubernetesClusterLinuxProfileSshKey): any;
export declare function kubernetesClusterLinuxProfileSshKeyToHclTerraform(struct?: KubernetesClusterLinuxProfileSshKeyOutputReference | KubernetesClusterLinuxProfileSshKey): any;
export declare class KubernetesClusterLinuxProfileSshKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterLinuxProfileSshKey | undefined;
    set internalValue(value: KubernetesClusterLinuxProfileSshKey | undefined);
    private _keyData?;
    get keyData(): string;
    set keyData(value: string);
    get keyDataInput(): string | undefined;
}
export interface KubernetesClusterLinuxProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#admin_username KubernetesCluster#admin_username}
    */
    readonly adminUsername: string;
    /**
    * ssh_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#ssh_key KubernetesCluster#ssh_key}
    */
    readonly sshKey: KubernetesClusterLinuxProfileSshKey;
}
export declare function kubernetesClusterLinuxProfileToTerraform(struct?: KubernetesClusterLinuxProfileOutputReference | KubernetesClusterLinuxProfile): any;
export declare function kubernetesClusterLinuxProfileToHclTerraform(struct?: KubernetesClusterLinuxProfileOutputReference | KubernetesClusterLinuxProfile): any;
export declare class KubernetesClusterLinuxProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterLinuxProfile | undefined;
    set internalValue(value: KubernetesClusterLinuxProfile | undefined);
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _sshKey;
    get sshKey(): KubernetesClusterLinuxProfileSshKeyOutputReference;
    putSshKey(value: KubernetesClusterLinuxProfileSshKey): void;
    get sshKeyInput(): KubernetesClusterLinuxProfileSshKey | undefined;
}
export interface KubernetesClusterMaintenanceWindowAllowed {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#day KubernetesCluster#day}
    */
    readonly day: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#hours KubernetesCluster#hours}
    */
    readonly hours: number[];
}
export declare function kubernetesClusterMaintenanceWindowAllowedToTerraform(struct?: KubernetesClusterMaintenanceWindowAllowed | cdktf.IResolvable): any;
export declare function kubernetesClusterMaintenanceWindowAllowedToHclTerraform(struct?: KubernetesClusterMaintenanceWindowAllowed | cdktf.IResolvable): any;
export declare class KubernetesClusterMaintenanceWindowAllowedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterMaintenanceWindowAllowed | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterMaintenanceWindowAllowed | cdktf.IResolvable | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    private _hours?;
    get hours(): number[];
    set hours(value: number[]);
    get hoursInput(): number[] | undefined;
}
export declare class KubernetesClusterMaintenanceWindowAllowedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterMaintenanceWindowAllowed[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterMaintenanceWindowAllowedOutputReference;
}
export interface KubernetesClusterMaintenanceWindowNotAllowed {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#end KubernetesCluster#end}
    */
    readonly end: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#start KubernetesCluster#start}
    */
    readonly start: string;
}
export declare function kubernetesClusterMaintenanceWindowNotAllowedToTerraform(struct?: KubernetesClusterMaintenanceWindowNotAllowed | cdktf.IResolvable): any;
export declare function kubernetesClusterMaintenanceWindowNotAllowedToHclTerraform(struct?: KubernetesClusterMaintenanceWindowNotAllowed | cdktf.IResolvable): any;
export declare class KubernetesClusterMaintenanceWindowNotAllowedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterMaintenanceWindowNotAllowed | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterMaintenanceWindowNotAllowed | cdktf.IResolvable | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
}
export declare class KubernetesClusterMaintenanceWindowNotAllowedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterMaintenanceWindowNotAllowed[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterMaintenanceWindowNotAllowedOutputReference;
}
export interface KubernetesClusterMaintenanceWindow {
    /**
    * allowed block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#allowed KubernetesCluster#allowed}
    */
    readonly allowed?: KubernetesClusterMaintenanceWindowAllowed[] | cdktf.IResolvable;
    /**
    * not_allowed block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#not_allowed KubernetesCluster#not_allowed}
    */
    readonly notAllowed?: KubernetesClusterMaintenanceWindowNotAllowed[] | cdktf.IResolvable;
}
export declare function kubernetesClusterMaintenanceWindowToTerraform(struct?: KubernetesClusterMaintenanceWindowOutputReference | KubernetesClusterMaintenanceWindow): any;
export declare function kubernetesClusterMaintenanceWindowToHclTerraform(struct?: KubernetesClusterMaintenanceWindowOutputReference | KubernetesClusterMaintenanceWindow): any;
export declare class KubernetesClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterMaintenanceWindow | undefined;
    set internalValue(value: KubernetesClusterMaintenanceWindow | undefined);
    private _allowed;
    get allowed(): KubernetesClusterMaintenanceWindowAllowedList;
    putAllowed(value: KubernetesClusterMaintenanceWindowAllowed[] | cdktf.IResolvable): void;
    resetAllowed(): void;
    get allowedInput(): cdktf.IResolvable | KubernetesClusterMaintenanceWindowAllowed[] | undefined;
    private _notAllowed;
    get notAllowed(): KubernetesClusterMaintenanceWindowNotAllowedList;
    putNotAllowed(value: KubernetesClusterMaintenanceWindowNotAllowed[] | cdktf.IResolvable): void;
    resetNotAllowed(): void;
    get notAllowedInput(): cdktf.IResolvable | KubernetesClusterMaintenanceWindowNotAllowed[] | undefined;
}
export interface KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#end KubernetesCluster#end}
    */
    readonly end: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#start KubernetesCluster#start}
    */
    readonly start: string;
}
export declare function kubernetesClusterMaintenanceWindowAutoUpgradeNotAllowedToTerraform(struct?: KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed | cdktf.IResolvable): any;
export declare function kubernetesClusterMaintenanceWindowAutoUpgradeNotAllowedToHclTerraform(struct?: KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed | cdktf.IResolvable): any;
export declare class KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed | cdktf.IResolvable | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
}
export declare class KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowedOutputReference;
}
export interface KubernetesClusterMaintenanceWindowAutoUpgrade {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#day_of_month KubernetesCluster#day_of_month}
    */
    readonly dayOfMonth?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#day_of_week KubernetesCluster#day_of_week}
    */
    readonly dayOfWeek?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#duration KubernetesCluster#duration}
    */
    readonly duration: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#frequency KubernetesCluster#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#interval KubernetesCluster#interval}
    */
    readonly interval: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#start_date KubernetesCluster#start_date}
    */
    readonly startDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#start_time KubernetesCluster#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#utc_offset KubernetesCluster#utc_offset}
    */
    readonly utcOffset?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#week_index KubernetesCluster#week_index}
    */
    readonly weekIndex?: string;
    /**
    * not_allowed block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#not_allowed KubernetesCluster#not_allowed}
    */
    readonly notAllowed?: KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed[] | cdktf.IResolvable;
}
export declare function kubernetesClusterMaintenanceWindowAutoUpgradeToTerraform(struct?: KubernetesClusterMaintenanceWindowAutoUpgradeOutputReference | KubernetesClusterMaintenanceWindowAutoUpgrade): any;
export declare function kubernetesClusterMaintenanceWindowAutoUpgradeToHclTerraform(struct?: KubernetesClusterMaintenanceWindowAutoUpgradeOutputReference | KubernetesClusterMaintenanceWindowAutoUpgrade): any;
export declare class KubernetesClusterMaintenanceWindowAutoUpgradeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterMaintenanceWindowAutoUpgrade | undefined;
    set internalValue(value: KubernetesClusterMaintenanceWindowAutoUpgrade | undefined);
    private _dayOfMonth?;
    get dayOfMonth(): number;
    set dayOfMonth(value: number);
    resetDayOfMonth(): void;
    get dayOfMonthInput(): number | undefined;
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    resetDayOfWeek(): void;
    get dayOfWeekInput(): string | undefined;
    private _duration?;
    get duration(): number;
    set duration(value: number);
    get durationInput(): number | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    resetStartDate(): void;
    get startDateInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _utcOffset?;
    get utcOffset(): string;
    set utcOffset(value: string);
    resetUtcOffset(): void;
    get utcOffsetInput(): string | undefined;
    private _weekIndex?;
    get weekIndex(): string;
    set weekIndex(value: string);
    resetWeekIndex(): void;
    get weekIndexInput(): string | undefined;
    private _notAllowed;
    get notAllowed(): KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowedList;
    putNotAllowed(value: KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed[] | cdktf.IResolvable): void;
    resetNotAllowed(): void;
    get notAllowedInput(): cdktf.IResolvable | KubernetesClusterMaintenanceWindowAutoUpgradeNotAllowed[] | undefined;
}
export interface KubernetesClusterMaintenanceWindowNodeOsNotAllowed {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#end KubernetesCluster#end}
    */
    readonly end: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#start KubernetesCluster#start}
    */
    readonly start: string;
}
export declare function kubernetesClusterMaintenanceWindowNodeOsNotAllowedToTerraform(struct?: KubernetesClusterMaintenanceWindowNodeOsNotAllowed | cdktf.IResolvable): any;
export declare function kubernetesClusterMaintenanceWindowNodeOsNotAllowedToHclTerraform(struct?: KubernetesClusterMaintenanceWindowNodeOsNotAllowed | cdktf.IResolvable): any;
export declare class KubernetesClusterMaintenanceWindowNodeOsNotAllowedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterMaintenanceWindowNodeOsNotAllowed | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterMaintenanceWindowNodeOsNotAllowed | cdktf.IResolvable | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
}
export declare class KubernetesClusterMaintenanceWindowNodeOsNotAllowedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterMaintenanceWindowNodeOsNotAllowed[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterMaintenanceWindowNodeOsNotAllowedOutputReference;
}
export interface KubernetesClusterMaintenanceWindowNodeOs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#day_of_month KubernetesCluster#day_of_month}
    */
    readonly dayOfMonth?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#day_of_week KubernetesCluster#day_of_week}
    */
    readonly dayOfWeek?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#duration KubernetesCluster#duration}
    */
    readonly duration: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#frequency KubernetesCluster#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#interval KubernetesCluster#interval}
    */
    readonly interval: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#start_date KubernetesCluster#start_date}
    */
    readonly startDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#start_time KubernetesCluster#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#utc_offset KubernetesCluster#utc_offset}
    */
    readonly utcOffset?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#week_index KubernetesCluster#week_index}
    */
    readonly weekIndex?: string;
    /**
    * not_allowed block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#not_allowed KubernetesCluster#not_allowed}
    */
    readonly notAllowed?: KubernetesClusterMaintenanceWindowNodeOsNotAllowed[] | cdktf.IResolvable;
}
export declare function kubernetesClusterMaintenanceWindowNodeOsToTerraform(struct?: KubernetesClusterMaintenanceWindowNodeOsOutputReference | KubernetesClusterMaintenanceWindowNodeOs): any;
export declare function kubernetesClusterMaintenanceWindowNodeOsToHclTerraform(struct?: KubernetesClusterMaintenanceWindowNodeOsOutputReference | KubernetesClusterMaintenanceWindowNodeOs): any;
export declare class KubernetesClusterMaintenanceWindowNodeOsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterMaintenanceWindowNodeOs | undefined;
    set internalValue(value: KubernetesClusterMaintenanceWindowNodeOs | undefined);
    private _dayOfMonth?;
    get dayOfMonth(): number;
    set dayOfMonth(value: number);
    resetDayOfMonth(): void;
    get dayOfMonthInput(): number | undefined;
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    resetDayOfWeek(): void;
    get dayOfWeekInput(): string | undefined;
    private _duration?;
    get duration(): number;
    set duration(value: number);
    get durationInput(): number | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    get intervalInput(): number | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    resetStartDate(): void;
    get startDateInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _utcOffset?;
    get utcOffset(): string;
    set utcOffset(value: string);
    resetUtcOffset(): void;
    get utcOffsetInput(): string | undefined;
    private _weekIndex?;
    get weekIndex(): string;
    set weekIndex(value: string);
    resetWeekIndex(): void;
    get weekIndexInput(): string | undefined;
    private _notAllowed;
    get notAllowed(): KubernetesClusterMaintenanceWindowNodeOsNotAllowedList;
    putNotAllowed(value: KubernetesClusterMaintenanceWindowNodeOsNotAllowed[] | cdktf.IResolvable): void;
    resetNotAllowed(): void;
    get notAllowedInput(): cdktf.IResolvable | KubernetesClusterMaintenanceWindowNodeOsNotAllowed[] | undefined;
}
export interface KubernetesClusterMicrosoftDefender {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#log_analytics_workspace_id KubernetesCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
}
export declare function kubernetesClusterMicrosoftDefenderToTerraform(struct?: KubernetesClusterMicrosoftDefenderOutputReference | KubernetesClusterMicrosoftDefender): any;
export declare function kubernetesClusterMicrosoftDefenderToHclTerraform(struct?: KubernetesClusterMicrosoftDefenderOutputReference | KubernetesClusterMicrosoftDefender): any;
export declare class KubernetesClusterMicrosoftDefenderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterMicrosoftDefender | undefined;
    set internalValue(value: KubernetesClusterMicrosoftDefender | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
}
export interface KubernetesClusterMonitorMetrics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#annotations_allowed KubernetesCluster#annotations_allowed}
    */
    readonly annotationsAllowed?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#labels_allowed KubernetesCluster#labels_allowed}
    */
    readonly labelsAllowed?: string;
}
export declare function kubernetesClusterMonitorMetricsToTerraform(struct?: KubernetesClusterMonitorMetricsOutputReference | KubernetesClusterMonitorMetrics): any;
export declare function kubernetesClusterMonitorMetricsToHclTerraform(struct?: KubernetesClusterMonitorMetricsOutputReference | KubernetesClusterMonitorMetrics): any;
export declare class KubernetesClusterMonitorMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterMonitorMetrics | undefined;
    set internalValue(value: KubernetesClusterMonitorMetrics | undefined);
    private _annotationsAllowed?;
    get annotationsAllowed(): string;
    set annotationsAllowed(value: string);
    resetAnnotationsAllowed(): void;
    get annotationsAllowedInput(): string | undefined;
    private _labelsAllowed?;
    get labelsAllowed(): string;
    set labelsAllowed(value: string);
    resetLabelsAllowed(): void;
    get labelsAllowedInput(): string | undefined;
}
export interface KubernetesClusterNetworkProfileLoadBalancerProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#idle_timeout_in_minutes KubernetesCluster#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#managed_outbound_ip_count KubernetesCluster#managed_outbound_ip_count}
    */
    readonly managedOutboundIpCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#managed_outbound_ipv6_count KubernetesCluster#managed_outbound_ipv6_count}
    */
    readonly managedOutboundIpv6Count?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#outbound_ip_address_ids KubernetesCluster#outbound_ip_address_ids}
    */
    readonly outboundIpAddressIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#outbound_ip_prefix_ids KubernetesCluster#outbound_ip_prefix_ids}
    */
    readonly outboundIpPrefixIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#outbound_ports_allocated KubernetesCluster#outbound_ports_allocated}
    */
    readonly outboundPortsAllocated?: number;
}
export declare function kubernetesClusterNetworkProfileLoadBalancerProfileToTerraform(struct?: KubernetesClusterNetworkProfileLoadBalancerProfileOutputReference | KubernetesClusterNetworkProfileLoadBalancerProfile): any;
export declare function kubernetesClusterNetworkProfileLoadBalancerProfileToHclTerraform(struct?: KubernetesClusterNetworkProfileLoadBalancerProfileOutputReference | KubernetesClusterNetworkProfileLoadBalancerProfile): any;
export declare class KubernetesClusterNetworkProfileLoadBalancerProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNetworkProfileLoadBalancerProfile | undefined;
    set internalValue(value: KubernetesClusterNetworkProfileLoadBalancerProfile | undefined);
    get effectiveOutboundIps(): string[];
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _managedOutboundIpCount?;
    get managedOutboundIpCount(): number;
    set managedOutboundIpCount(value: number);
    resetManagedOutboundIpCount(): void;
    get managedOutboundIpCountInput(): number | undefined;
    private _managedOutboundIpv6Count?;
    get managedOutboundIpv6Count(): number;
    set managedOutboundIpv6Count(value: number);
    resetManagedOutboundIpv6Count(): void;
    get managedOutboundIpv6CountInput(): number | undefined;
    private _outboundIpAddressIds?;
    get outboundIpAddressIds(): string[];
    set outboundIpAddressIds(value: string[]);
    resetOutboundIpAddressIds(): void;
    get outboundIpAddressIdsInput(): string[] | undefined;
    private _outboundIpPrefixIds?;
    get outboundIpPrefixIds(): string[];
    set outboundIpPrefixIds(value: string[]);
    resetOutboundIpPrefixIds(): void;
    get outboundIpPrefixIdsInput(): string[] | undefined;
    private _outboundPortsAllocated?;
    get outboundPortsAllocated(): number;
    set outboundPortsAllocated(value: number);
    resetOutboundPortsAllocated(): void;
    get outboundPortsAllocatedInput(): number | undefined;
}
export interface KubernetesClusterNetworkProfileNatGatewayProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#idle_timeout_in_minutes KubernetesCluster#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#managed_outbound_ip_count KubernetesCluster#managed_outbound_ip_count}
    */
    readonly managedOutboundIpCount?: number;
}
export declare function kubernetesClusterNetworkProfileNatGatewayProfileToTerraform(struct?: KubernetesClusterNetworkProfileNatGatewayProfileOutputReference | KubernetesClusterNetworkProfileNatGatewayProfile): any;
export declare function kubernetesClusterNetworkProfileNatGatewayProfileToHclTerraform(struct?: KubernetesClusterNetworkProfileNatGatewayProfileOutputReference | KubernetesClusterNetworkProfileNatGatewayProfile): any;
export declare class KubernetesClusterNetworkProfileNatGatewayProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNetworkProfileNatGatewayProfile | undefined;
    set internalValue(value: KubernetesClusterNetworkProfileNatGatewayProfile | undefined);
    get effectiveOutboundIps(): string[];
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _managedOutboundIpCount?;
    get managedOutboundIpCount(): number;
    set managedOutboundIpCount(value: number);
    resetManagedOutboundIpCount(): void;
    get managedOutboundIpCountInput(): number | undefined;
}
export interface KubernetesClusterNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#dns_service_ip KubernetesCluster#dns_service_ip}
    */
    readonly dnsServiceIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#docker_bridge_cidr KubernetesCluster#docker_bridge_cidr}
    */
    readonly dockerBridgeCidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#ebpf_data_plane KubernetesCluster#ebpf_data_plane}
    */
    readonly ebpfDataPlane?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#ip_versions KubernetesCluster#ip_versions}
    */
    readonly ipVersions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#load_balancer_sku KubernetesCluster#load_balancer_sku}
    */
    readonly loadBalancerSku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#network_data_plane KubernetesCluster#network_data_plane}
    */
    readonly networkDataPlane?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#network_mode KubernetesCluster#network_mode}
    */
    readonly networkMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#network_plugin KubernetesCluster#network_plugin}
    */
    readonly networkPlugin: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#network_plugin_mode KubernetesCluster#network_plugin_mode}
    */
    readonly networkPluginMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#network_policy KubernetesCluster#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#outbound_ip_address_ids KubernetesCluster#outbound_ip_address_ids}
    */
    readonly outboundIpAddressIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#outbound_ip_prefix_ids KubernetesCluster#outbound_ip_prefix_ids}
    */
    readonly outboundIpPrefixIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#outbound_type KubernetesCluster#outbound_type}
    */
    readonly outboundType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#pod_cidr KubernetesCluster#pod_cidr}
    */
    readonly podCidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#pod_cidrs KubernetesCluster#pod_cidrs}
    */
    readonly podCidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#service_cidr KubernetesCluster#service_cidr}
    */
    readonly serviceCidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#service_cidrs KubernetesCluster#service_cidrs}
    */
    readonly serviceCidrs?: string[];
    /**
    * load_balancer_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#load_balancer_profile KubernetesCluster#load_balancer_profile}
    */
    readonly loadBalancerProfile?: KubernetesClusterNetworkProfileLoadBalancerProfile;
    /**
    * nat_gateway_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#nat_gateway_profile KubernetesCluster#nat_gateway_profile}
    */
    readonly natGatewayProfile?: KubernetesClusterNetworkProfileNatGatewayProfile;
}
export declare function kubernetesClusterNetworkProfileToTerraform(struct?: KubernetesClusterNetworkProfileOutputReference | KubernetesClusterNetworkProfile): any;
export declare function kubernetesClusterNetworkProfileToHclTerraform(struct?: KubernetesClusterNetworkProfileOutputReference | KubernetesClusterNetworkProfile): any;
export declare class KubernetesClusterNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNetworkProfile | undefined;
    set internalValue(value: KubernetesClusterNetworkProfile | undefined);
    private _dnsServiceIp?;
    get dnsServiceIp(): string;
    set dnsServiceIp(value: string);
    resetDnsServiceIp(): void;
    get dnsServiceIpInput(): string | undefined;
    private _dockerBridgeCidr?;
    get dockerBridgeCidr(): string;
    set dockerBridgeCidr(value: string);
    resetDockerBridgeCidr(): void;
    get dockerBridgeCidrInput(): string | undefined;
    private _ebpfDataPlane?;
    get ebpfDataPlane(): string;
    set ebpfDataPlane(value: string);
    resetEbpfDataPlane(): void;
    get ebpfDataPlaneInput(): string | undefined;
    private _ipVersions?;
    get ipVersions(): string[];
    set ipVersions(value: string[]);
    resetIpVersions(): void;
    get ipVersionsInput(): string[] | undefined;
    private _loadBalancerSku?;
    get loadBalancerSku(): string;
    set loadBalancerSku(value: string);
    resetLoadBalancerSku(): void;
    get loadBalancerSkuInput(): string | undefined;
    private _networkDataPlane?;
    get networkDataPlane(): string;
    set networkDataPlane(value: string);
    resetNetworkDataPlane(): void;
    get networkDataPlaneInput(): string | undefined;
    private _networkMode?;
    get networkMode(): string;
    set networkMode(value: string);
    resetNetworkMode(): void;
    get networkModeInput(): string | undefined;
    private _networkPlugin?;
    get networkPlugin(): string;
    set networkPlugin(value: string);
    get networkPluginInput(): string | undefined;
    private _networkPluginMode?;
    get networkPluginMode(): string;
    set networkPluginMode(value: string);
    resetNetworkPluginMode(): void;
    get networkPluginModeInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _outboundIpAddressIds?;
    get outboundIpAddressIds(): string[];
    set outboundIpAddressIds(value: string[]);
    resetOutboundIpAddressIds(): void;
    get outboundIpAddressIdsInput(): string[] | undefined;
    private _outboundIpPrefixIds?;
    get outboundIpPrefixIds(): string[];
    set outboundIpPrefixIds(value: string[]);
    resetOutboundIpPrefixIds(): void;
    get outboundIpPrefixIdsInput(): string[] | undefined;
    private _outboundType?;
    get outboundType(): string;
    set outboundType(value: string);
    resetOutboundType(): void;
    get outboundTypeInput(): string | undefined;
    private _podCidr?;
    get podCidr(): string;
    set podCidr(value: string);
    resetPodCidr(): void;
    get podCidrInput(): string | undefined;
    private _podCidrs?;
    get podCidrs(): string[];
    set podCidrs(value: string[]);
    resetPodCidrs(): void;
    get podCidrsInput(): string[] | undefined;
    private _serviceCidr?;
    get serviceCidr(): string;
    set serviceCidr(value: string);
    resetServiceCidr(): void;
    get serviceCidrInput(): string | undefined;
    private _serviceCidrs?;
    get serviceCidrs(): string[];
    set serviceCidrs(value: string[]);
    resetServiceCidrs(): void;
    get serviceCidrsInput(): string[] | undefined;
    private _loadBalancerProfile;
    get loadBalancerProfile(): KubernetesClusterNetworkProfileLoadBalancerProfileOutputReference;
    putLoadBalancerProfile(value: KubernetesClusterNetworkProfileLoadBalancerProfile): void;
    resetLoadBalancerProfile(): void;
    get loadBalancerProfileInput(): KubernetesClusterNetworkProfileLoadBalancerProfile | undefined;
    private _natGatewayProfile;
    get natGatewayProfile(): KubernetesClusterNetworkProfileNatGatewayProfileOutputReference;
    putNatGatewayProfile(value: KubernetesClusterNetworkProfileNatGatewayProfile): void;
    resetNatGatewayProfile(): void;
    get natGatewayProfileInput(): KubernetesClusterNetworkProfileNatGatewayProfile | undefined;
}
export interface KubernetesClusterOmsAgentOmsAgentIdentity {
}
export declare function kubernetesClusterOmsAgentOmsAgentIdentityToTerraform(struct?: KubernetesClusterOmsAgentOmsAgentIdentity): any;
export declare function kubernetesClusterOmsAgentOmsAgentIdentityToHclTerraform(struct?: KubernetesClusterOmsAgentOmsAgentIdentity): any;
export declare class KubernetesClusterOmsAgentOmsAgentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterOmsAgentOmsAgentIdentity | undefined;
    set internalValue(value: KubernetesClusterOmsAgentOmsAgentIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class KubernetesClusterOmsAgentOmsAgentIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterOmsAgentOmsAgentIdentityOutputReference;
}
export interface KubernetesClusterOmsAgent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#log_analytics_workspace_id KubernetesCluster#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#msi_auth_for_monitoring_enabled KubernetesCluster#msi_auth_for_monitoring_enabled}
    */
    readonly msiAuthForMonitoringEnabled?: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterOmsAgentToTerraform(struct?: KubernetesClusterOmsAgentOutputReference | KubernetesClusterOmsAgent): any;
export declare function kubernetesClusterOmsAgentToHclTerraform(struct?: KubernetesClusterOmsAgentOutputReference | KubernetesClusterOmsAgent): any;
export declare class KubernetesClusterOmsAgentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterOmsAgent | undefined;
    set internalValue(value: KubernetesClusterOmsAgent | undefined);
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _msiAuthForMonitoringEnabled?;
    get msiAuthForMonitoringEnabled(): boolean | cdktf.IResolvable;
    set msiAuthForMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetMsiAuthForMonitoringEnabled(): void;
    get msiAuthForMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _omsAgentIdentity;
    get omsAgentIdentity(): KubernetesClusterOmsAgentOmsAgentIdentityList;
}
export interface KubernetesClusterServiceMeshProfileCertificateAuthority {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#cert_chain_object_name KubernetesCluster#cert_chain_object_name}
    */
    readonly certChainObjectName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#cert_object_name KubernetesCluster#cert_object_name}
    */
    readonly certObjectName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#key_object_name KubernetesCluster#key_object_name}
    */
    readonly keyObjectName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#key_vault_id KubernetesCluster#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#root_cert_object_name KubernetesCluster#root_cert_object_name}
    */
    readonly rootCertObjectName: string;
}
export declare function kubernetesClusterServiceMeshProfileCertificateAuthorityToTerraform(struct?: KubernetesClusterServiceMeshProfileCertificateAuthorityOutputReference | KubernetesClusterServiceMeshProfileCertificateAuthority): any;
export declare function kubernetesClusterServiceMeshProfileCertificateAuthorityToHclTerraform(struct?: KubernetesClusterServiceMeshProfileCertificateAuthorityOutputReference | KubernetesClusterServiceMeshProfileCertificateAuthority): any;
export declare class KubernetesClusterServiceMeshProfileCertificateAuthorityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterServiceMeshProfileCertificateAuthority | undefined;
    set internalValue(value: KubernetesClusterServiceMeshProfileCertificateAuthority | undefined);
    private _certChainObjectName?;
    get certChainObjectName(): string;
    set certChainObjectName(value: string);
    get certChainObjectNameInput(): string | undefined;
    private _certObjectName?;
    get certObjectName(): string;
    set certObjectName(value: string);
    get certObjectNameInput(): string | undefined;
    private _keyObjectName?;
    get keyObjectName(): string;
    set keyObjectName(value: string);
    get keyObjectNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _rootCertObjectName?;
    get rootCertObjectName(): string;
    set rootCertObjectName(value: string);
    get rootCertObjectNameInput(): string | undefined;
}
export interface KubernetesClusterServiceMeshProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#external_ingress_gateway_enabled KubernetesCluster#external_ingress_gateway_enabled}
    */
    readonly externalIngressGatewayEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#internal_ingress_gateway_enabled KubernetesCluster#internal_ingress_gateway_enabled}
    */
    readonly internalIngressGatewayEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#mode KubernetesCluster#mode}
    */
    readonly mode: string;
    /**
    * certificate_authority block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#certificate_authority KubernetesCluster#certificate_authority}
    */
    readonly certificateAuthority?: KubernetesClusterServiceMeshProfileCertificateAuthority;
}
export declare function kubernetesClusterServiceMeshProfileToTerraform(struct?: KubernetesClusterServiceMeshProfileOutputReference | KubernetesClusterServiceMeshProfile): any;
export declare function kubernetesClusterServiceMeshProfileToHclTerraform(struct?: KubernetesClusterServiceMeshProfileOutputReference | KubernetesClusterServiceMeshProfile): any;
export declare class KubernetesClusterServiceMeshProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterServiceMeshProfile | undefined;
    set internalValue(value: KubernetesClusterServiceMeshProfile | undefined);
    private _externalIngressGatewayEnabled?;
    get externalIngressGatewayEnabled(): boolean | cdktf.IResolvable;
    set externalIngressGatewayEnabled(value: boolean | cdktf.IResolvable);
    resetExternalIngressGatewayEnabled(): void;
    get externalIngressGatewayEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _internalIngressGatewayEnabled?;
    get internalIngressGatewayEnabled(): boolean | cdktf.IResolvable;
    set internalIngressGatewayEnabled(value: boolean | cdktf.IResolvable);
    resetInternalIngressGatewayEnabled(): void;
    get internalIngressGatewayEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _certificateAuthority;
    get certificateAuthority(): KubernetesClusterServiceMeshProfileCertificateAuthorityOutputReference;
    putCertificateAuthority(value: KubernetesClusterServiceMeshProfileCertificateAuthority): void;
    resetCertificateAuthority(): void;
    get certificateAuthorityInput(): KubernetesClusterServiceMeshProfileCertificateAuthority | undefined;
}
export interface KubernetesClusterServicePrincipal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#client_id KubernetesCluster#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#client_secret KubernetesCluster#client_secret}
    */
    readonly clientSecret: string;
}
export declare function kubernetesClusterServicePrincipalToTerraform(struct?: KubernetesClusterServicePrincipalOutputReference | KubernetesClusterServicePrincipal): any;
export declare function kubernetesClusterServicePrincipalToHclTerraform(struct?: KubernetesClusterServicePrincipalOutputReference | KubernetesClusterServicePrincipal): any;
export declare class KubernetesClusterServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterServicePrincipal | undefined;
    set internalValue(value: KubernetesClusterServicePrincipal | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
}
export interface KubernetesClusterStorageProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#blob_driver_enabled KubernetesCluster#blob_driver_enabled}
    */
    readonly blobDriverEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#disk_driver_enabled KubernetesCluster#disk_driver_enabled}
    */
    readonly diskDriverEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#disk_driver_version KubernetesCluster#disk_driver_version}
    */
    readonly diskDriverVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#file_driver_enabled KubernetesCluster#file_driver_enabled}
    */
    readonly fileDriverEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#snapshot_controller_enabled KubernetesCluster#snapshot_controller_enabled}
    */
    readonly snapshotControllerEnabled?: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterStorageProfileToTerraform(struct?: KubernetesClusterStorageProfileOutputReference | KubernetesClusterStorageProfile): any;
export declare function kubernetesClusterStorageProfileToHclTerraform(struct?: KubernetesClusterStorageProfileOutputReference | KubernetesClusterStorageProfile): any;
export declare class KubernetesClusterStorageProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterStorageProfile | undefined;
    set internalValue(value: KubernetesClusterStorageProfile | undefined);
    private _blobDriverEnabled?;
    get blobDriverEnabled(): boolean | cdktf.IResolvable;
    set blobDriverEnabled(value: boolean | cdktf.IResolvable);
    resetBlobDriverEnabled(): void;
    get blobDriverEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskDriverEnabled?;
    get diskDriverEnabled(): boolean | cdktf.IResolvable;
    set diskDriverEnabled(value: boolean | cdktf.IResolvable);
    resetDiskDriverEnabled(): void;
    get diskDriverEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskDriverVersion?;
    get diskDriverVersion(): string;
    set diskDriverVersion(value: string);
    resetDiskDriverVersion(): void;
    get diskDriverVersionInput(): string | undefined;
    private _fileDriverEnabled?;
    get fileDriverEnabled(): boolean | cdktf.IResolvable;
    set fileDriverEnabled(value: boolean | cdktf.IResolvable);
    resetFileDriverEnabled(): void;
    get fileDriverEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshotControllerEnabled?;
    get snapshotControllerEnabled(): boolean | cdktf.IResolvable;
    set snapshotControllerEnabled(value: boolean | cdktf.IResolvable);
    resetSnapshotControllerEnabled(): void;
    get snapshotControllerEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface KubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#create KubernetesCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#delete KubernetesCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#read KubernetesCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#update KubernetesCluster#update}
    */
    readonly update?: string;
}
export declare function kubernetesClusterTimeoutsToTerraform(struct?: KubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare function kubernetesClusterTimeoutsToHclTerraform(struct?: KubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class KubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface KubernetesClusterWebAppRoutingWebAppRoutingIdentity {
}
export declare function kubernetesClusterWebAppRoutingWebAppRoutingIdentityToTerraform(struct?: KubernetesClusterWebAppRoutingWebAppRoutingIdentity): any;
export declare function kubernetesClusterWebAppRoutingWebAppRoutingIdentityToHclTerraform(struct?: KubernetesClusterWebAppRoutingWebAppRoutingIdentity): any;
export declare class KubernetesClusterWebAppRoutingWebAppRoutingIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterWebAppRoutingWebAppRoutingIdentity | undefined;
    set internalValue(value: KubernetesClusterWebAppRoutingWebAppRoutingIdentity | undefined);
    get clientId(): string;
    get objectId(): string;
    get userAssignedIdentityId(): string;
}
export declare class KubernetesClusterWebAppRoutingWebAppRoutingIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterWebAppRoutingWebAppRoutingIdentityOutputReference;
}
export interface KubernetesClusterWebAppRouting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#dns_zone_id KubernetesCluster#dns_zone_id}
    */
    readonly dnsZoneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#dns_zone_ids KubernetesCluster#dns_zone_ids}
    */
    readonly dnsZoneIds?: string[];
}
export declare function kubernetesClusterWebAppRoutingToTerraform(struct?: KubernetesClusterWebAppRoutingOutputReference | KubernetesClusterWebAppRouting): any;
export declare function kubernetesClusterWebAppRoutingToHclTerraform(struct?: KubernetesClusterWebAppRoutingOutputReference | KubernetesClusterWebAppRouting): any;
export declare class KubernetesClusterWebAppRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterWebAppRouting | undefined;
    set internalValue(value: KubernetesClusterWebAppRouting | undefined);
    private _dnsZoneId?;
    get dnsZoneId(): string;
    set dnsZoneId(value: string);
    resetDnsZoneId(): void;
    get dnsZoneIdInput(): string | undefined;
    private _dnsZoneIds?;
    get dnsZoneIds(): string[];
    set dnsZoneIds(value: string[]);
    resetDnsZoneIds(): void;
    get dnsZoneIdsInput(): string[] | undefined;
    private _webAppRoutingIdentity;
    get webAppRoutingIdentity(): KubernetesClusterWebAppRoutingWebAppRoutingIdentityList;
}
export interface KubernetesClusterWindowsProfileGmsa {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#dns_server KubernetesCluster#dns_server}
    */
    readonly dnsServer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#root_domain KubernetesCluster#root_domain}
    */
    readonly rootDomain: string;
}
export declare function kubernetesClusterWindowsProfileGmsaToTerraform(struct?: KubernetesClusterWindowsProfileGmsaOutputReference | KubernetesClusterWindowsProfileGmsa): any;
export declare function kubernetesClusterWindowsProfileGmsaToHclTerraform(struct?: KubernetesClusterWindowsProfileGmsaOutputReference | KubernetesClusterWindowsProfileGmsa): any;
export declare class KubernetesClusterWindowsProfileGmsaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterWindowsProfileGmsa | undefined;
    set internalValue(value: KubernetesClusterWindowsProfileGmsa | undefined);
    private _dnsServer?;
    get dnsServer(): string;
    set dnsServer(value: string);
    get dnsServerInput(): string | undefined;
    private _rootDomain?;
    get rootDomain(): string;
    set rootDomain(value: string);
    get rootDomainInput(): string | undefined;
}
export interface KubernetesClusterWindowsProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#admin_password KubernetesCluster#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#admin_username KubernetesCluster#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#license KubernetesCluster#license}
    */
    readonly license?: string;
    /**
    * gmsa block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#gmsa KubernetesCluster#gmsa}
    */
    readonly gmsa?: KubernetesClusterWindowsProfileGmsa;
}
export declare function kubernetesClusterWindowsProfileToTerraform(struct?: KubernetesClusterWindowsProfileOutputReference | KubernetesClusterWindowsProfile): any;
export declare function kubernetesClusterWindowsProfileToHclTerraform(struct?: KubernetesClusterWindowsProfileOutputReference | KubernetesClusterWindowsProfile): any;
export declare class KubernetesClusterWindowsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterWindowsProfile | undefined;
    set internalValue(value: KubernetesClusterWindowsProfile | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _license?;
    get license(): string;
    set license(value: string);
    resetLicense(): void;
    get licenseInput(): string | undefined;
    private _gmsa;
    get gmsa(): KubernetesClusterWindowsProfileGmsaOutputReference;
    putGmsa(value: KubernetesClusterWindowsProfileGmsa): void;
    resetGmsa(): void;
    get gmsaInput(): KubernetesClusterWindowsProfileGmsa | undefined;
}
export interface KubernetesClusterWorkloadAutoscalerProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#keda_enabled KubernetesCluster#keda_enabled}
    */
    readonly kedaEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#vertical_pod_autoscaler_enabled KubernetesCluster#vertical_pod_autoscaler_enabled}
    */
    readonly verticalPodAutoscalerEnabled?: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterWorkloadAutoscalerProfileToTerraform(struct?: KubernetesClusterWorkloadAutoscalerProfileOutputReference | KubernetesClusterWorkloadAutoscalerProfile): any;
export declare function kubernetesClusterWorkloadAutoscalerProfileToHclTerraform(struct?: KubernetesClusterWorkloadAutoscalerProfileOutputReference | KubernetesClusterWorkloadAutoscalerProfile): any;
export declare class KubernetesClusterWorkloadAutoscalerProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterWorkloadAutoscalerProfile | undefined;
    set internalValue(value: KubernetesClusterWorkloadAutoscalerProfile | undefined);
    private _kedaEnabled?;
    get kedaEnabled(): boolean | cdktf.IResolvable;
    set kedaEnabled(value: boolean | cdktf.IResolvable);
    resetKedaEnabled(): void;
    get kedaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get verticalPodAutoscalerControlledValues(): string;
    private _verticalPodAutoscalerEnabled?;
    get verticalPodAutoscalerEnabled(): boolean | cdktf.IResolvable;
    set verticalPodAutoscalerEnabled(value: boolean | cdktf.IResolvable);
    resetVerticalPodAutoscalerEnabled(): void;
    get verticalPodAutoscalerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get verticalPodAutoscalerUpdateMode(): string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster azurerm_kubernetes_cluster}
*/
export declare class KubernetesCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_cluster";
    /**
    * Generates CDKTF code for importing a KubernetesCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesCluster to import
    * @param importFromId The id of the existing KubernetesCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/kubernetes_cluster azurerm_kubernetes_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesClusterConfig);
    private _apiServerAuthorizedIpRanges?;
    get apiServerAuthorizedIpRanges(): string[];
    set apiServerAuthorizedIpRanges(value: string[]);
    resetApiServerAuthorizedIpRanges(): void;
    get apiServerAuthorizedIpRangesInput(): string[] | undefined;
    private _automaticChannelUpgrade?;
    get automaticChannelUpgrade(): string;
    set automaticChannelUpgrade(value: string);
    resetAutomaticChannelUpgrade(): void;
    get automaticChannelUpgradeInput(): string | undefined;
    private _azurePolicyEnabled?;
    get azurePolicyEnabled(): boolean | cdktf.IResolvable;
    set azurePolicyEnabled(value: boolean | cdktf.IResolvable);
    resetAzurePolicyEnabled(): void;
    get azurePolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _costAnalysisEnabled?;
    get costAnalysisEnabled(): boolean | cdktf.IResolvable;
    set costAnalysisEnabled(value: boolean | cdktf.IResolvable);
    resetCostAnalysisEnabled(): void;
    get costAnalysisEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get currentKubernetesVersion(): string;
    private _customCaTrustCertificatesBase64?;
    get customCaTrustCertificatesBase64(): string[];
    set customCaTrustCertificatesBase64(value: string[]);
    resetCustomCaTrustCertificatesBase64(): void;
    get customCaTrustCertificatesBase64Input(): string[] | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _dnsPrefix?;
    get dnsPrefix(): string;
    set dnsPrefix(value: string);
    resetDnsPrefix(): void;
    get dnsPrefixInput(): string | undefined;
    private _dnsPrefixPrivateCluster?;
    get dnsPrefixPrivateCluster(): string;
    set dnsPrefixPrivateCluster(value: string);
    resetDnsPrefixPrivateCluster(): void;
    get dnsPrefixPrivateClusterInput(): string | undefined;
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _enablePodSecurityPolicy?;
    get enablePodSecurityPolicy(): boolean | cdktf.IResolvable;
    set enablePodSecurityPolicy(value: boolean | cdktf.IResolvable);
    resetEnablePodSecurityPolicy(): void;
    get enablePodSecurityPolicyInput(): boolean | cdktf.IResolvable | undefined;
    get fqdn(): string;
    private _httpApplicationRoutingEnabled?;
    get httpApplicationRoutingEnabled(): boolean | cdktf.IResolvable;
    set httpApplicationRoutingEnabled(value: boolean | cdktf.IResolvable);
    resetHttpApplicationRoutingEnabled(): void;
    get httpApplicationRoutingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get httpApplicationRoutingZoneName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageCleanerEnabled?;
    get imageCleanerEnabled(): boolean | cdktf.IResolvable;
    set imageCleanerEnabled(value: boolean | cdktf.IResolvable);
    resetImageCleanerEnabled(): void;
    get imageCleanerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _imageCleanerIntervalHours?;
    get imageCleanerIntervalHours(): number;
    set imageCleanerIntervalHours(value: number);
    resetImageCleanerIntervalHours(): void;
    get imageCleanerIntervalHoursInput(): number | undefined;
    private _kubeAdminConfig;
    get kubeAdminConfig(): KubernetesClusterKubeAdminConfigList;
    get kubeAdminConfigRaw(): string;
    private _kubeConfig;
    get kubeConfig(): KubernetesClusterKubeConfigList;
    get kubeConfigRaw(): string;
    private _kubernetesVersion?;
    get kubernetesVersion(): string;
    set kubernetesVersion(value: string);
    resetKubernetesVersion(): void;
    get kubernetesVersionInput(): string | undefined;
    private _localAccountDisabled?;
    get localAccountDisabled(): boolean | cdktf.IResolvable;
    set localAccountDisabled(value: boolean | cdktf.IResolvable);
    resetLocalAccountDisabled(): void;
    get localAccountDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeOsChannelUpgrade?;
    get nodeOsChannelUpgrade(): string;
    set nodeOsChannelUpgrade(value: string);
    resetNodeOsChannelUpgrade(): void;
    get nodeOsChannelUpgradeInput(): string | undefined;
    private _nodeResourceGroup?;
    get nodeResourceGroup(): string;
    set nodeResourceGroup(value: string);
    resetNodeResourceGroup(): void;
    get nodeResourceGroupInput(): string | undefined;
    get nodeResourceGroupId(): string;
    private _oidcIssuerEnabled?;
    get oidcIssuerEnabled(): boolean | cdktf.IResolvable;
    set oidcIssuerEnabled(value: boolean | cdktf.IResolvable);
    resetOidcIssuerEnabled(): void;
    get oidcIssuerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get oidcIssuerUrl(): string;
    private _openServiceMeshEnabled?;
    get openServiceMeshEnabled(): boolean | cdktf.IResolvable;
    set openServiceMeshEnabled(value: boolean | cdktf.IResolvable);
    resetOpenServiceMeshEnabled(): void;
    get openServiceMeshEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get portalFqdn(): string;
    private _privateClusterEnabled?;
    get privateClusterEnabled(): boolean | cdktf.IResolvable;
    set privateClusterEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateClusterEnabled(): void;
    get privateClusterEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateClusterPublicFqdnEnabled?;
    get privateClusterPublicFqdnEnabled(): boolean | cdktf.IResolvable;
    set privateClusterPublicFqdnEnabled(value: boolean | cdktf.IResolvable);
    resetPrivateClusterPublicFqdnEnabled(): void;
    get privateClusterPublicFqdnEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateDnsZoneId?;
    get privateDnsZoneId(): string;
    set privateDnsZoneId(value: string);
    resetPrivateDnsZoneId(): void;
    get privateDnsZoneIdInput(): string | undefined;
    get privateFqdn(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _roleBasedAccessControlEnabled?;
    get roleBasedAccessControlEnabled(): boolean | cdktf.IResolvable;
    set roleBasedAccessControlEnabled(value: boolean | cdktf.IResolvable);
    resetRoleBasedAccessControlEnabled(): void;
    get roleBasedAccessControlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _runCommandEnabled?;
    get runCommandEnabled(): boolean | cdktf.IResolvable;
    set runCommandEnabled(value: boolean | cdktf.IResolvable);
    resetRunCommandEnabled(): void;
    get runCommandEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _skuTier?;
    get skuTier(): string;
    set skuTier(value: string);
    resetSkuTier(): void;
    get skuTierInput(): string | undefined;
    private _supportPlan?;
    get supportPlan(): string;
    set supportPlan(value: string);
    resetSupportPlan(): void;
    get supportPlanInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workloadIdentityEnabled?;
    get workloadIdentityEnabled(): boolean | cdktf.IResolvable;
    set workloadIdentityEnabled(value: boolean | cdktf.IResolvable);
    resetWorkloadIdentityEnabled(): void;
    get workloadIdentityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _aciConnectorLinux;
    get aciConnectorLinux(): KubernetesClusterAciConnectorLinuxOutputReference;
    putAciConnectorLinux(value: KubernetesClusterAciConnectorLinux): void;
    resetAciConnectorLinux(): void;
    get aciConnectorLinuxInput(): KubernetesClusterAciConnectorLinux | undefined;
    private _apiServerAccessProfile;
    get apiServerAccessProfile(): KubernetesClusterApiServerAccessProfileOutputReference;
    putApiServerAccessProfile(value: KubernetesClusterApiServerAccessProfile): void;
    resetApiServerAccessProfile(): void;
    get apiServerAccessProfileInput(): KubernetesClusterApiServerAccessProfile | undefined;
    private _autoScalerProfile;
    get autoScalerProfile(): KubernetesClusterAutoScalerProfileOutputReference;
    putAutoScalerProfile(value: KubernetesClusterAutoScalerProfile): void;
    resetAutoScalerProfile(): void;
    get autoScalerProfileInput(): KubernetesClusterAutoScalerProfile | undefined;
    private _azureActiveDirectoryRoleBasedAccessControl;
    get azureActiveDirectoryRoleBasedAccessControl(): KubernetesClusterAzureActiveDirectoryRoleBasedAccessControlOutputReference;
    putAzureActiveDirectoryRoleBasedAccessControl(value: KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl): void;
    resetAzureActiveDirectoryRoleBasedAccessControl(): void;
    get azureActiveDirectoryRoleBasedAccessControlInput(): KubernetesClusterAzureActiveDirectoryRoleBasedAccessControl | undefined;
    private _confidentialComputing;
    get confidentialComputing(): KubernetesClusterConfidentialComputingOutputReference;
    putConfidentialComputing(value: KubernetesClusterConfidentialComputing): void;
    resetConfidentialComputing(): void;
    get confidentialComputingInput(): KubernetesClusterConfidentialComputing | undefined;
    private _defaultNodePool;
    get defaultNodePool(): KubernetesClusterDefaultNodePoolOutputReference;
    putDefaultNodePool(value: KubernetesClusterDefaultNodePool): void;
    get defaultNodePoolInput(): KubernetesClusterDefaultNodePool | undefined;
    private _httpProxyConfig;
    get httpProxyConfig(): KubernetesClusterHttpProxyConfigOutputReference;
    putHttpProxyConfig(value: KubernetesClusterHttpProxyConfig): void;
    resetHttpProxyConfig(): void;
    get httpProxyConfigInput(): KubernetesClusterHttpProxyConfig | undefined;
    private _identity;
    get identity(): KubernetesClusterIdentityOutputReference;
    putIdentity(value: KubernetesClusterIdentity): void;
    resetIdentity(): void;
    get identityInput(): KubernetesClusterIdentity | undefined;
    private _ingressApplicationGateway;
    get ingressApplicationGateway(): KubernetesClusterIngressApplicationGatewayOutputReference;
    putIngressApplicationGateway(value: KubernetesClusterIngressApplicationGateway): void;
    resetIngressApplicationGateway(): void;
    get ingressApplicationGatewayInput(): KubernetesClusterIngressApplicationGateway | undefined;
    private _keyManagementService;
    get keyManagementService(): KubernetesClusterKeyManagementServiceOutputReference;
    putKeyManagementService(value: KubernetesClusterKeyManagementService): void;
    resetKeyManagementService(): void;
    get keyManagementServiceInput(): KubernetesClusterKeyManagementService | undefined;
    private _keyVaultSecretsProvider;
    get keyVaultSecretsProvider(): KubernetesClusterKeyVaultSecretsProviderOutputReference;
    putKeyVaultSecretsProvider(value: KubernetesClusterKeyVaultSecretsProvider): void;
    resetKeyVaultSecretsProvider(): void;
    get keyVaultSecretsProviderInput(): KubernetesClusterKeyVaultSecretsProvider | undefined;
    private _kubeletIdentity;
    get kubeletIdentity(): KubernetesClusterKubeletIdentityOutputReference;
    putKubeletIdentity(value: KubernetesClusterKubeletIdentity): void;
    resetKubeletIdentity(): void;
    get kubeletIdentityInput(): KubernetesClusterKubeletIdentity | undefined;
    private _linuxProfile;
    get linuxProfile(): KubernetesClusterLinuxProfileOutputReference;
    putLinuxProfile(value: KubernetesClusterLinuxProfile): void;
    resetLinuxProfile(): void;
    get linuxProfileInput(): KubernetesClusterLinuxProfile | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): KubernetesClusterMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: KubernetesClusterMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): KubernetesClusterMaintenanceWindow | undefined;
    private _maintenanceWindowAutoUpgrade;
    get maintenanceWindowAutoUpgrade(): KubernetesClusterMaintenanceWindowAutoUpgradeOutputReference;
    putMaintenanceWindowAutoUpgrade(value: KubernetesClusterMaintenanceWindowAutoUpgrade): void;
    resetMaintenanceWindowAutoUpgrade(): void;
    get maintenanceWindowAutoUpgradeInput(): KubernetesClusterMaintenanceWindowAutoUpgrade | undefined;
    private _maintenanceWindowNodeOs;
    get maintenanceWindowNodeOs(): KubernetesClusterMaintenanceWindowNodeOsOutputReference;
    putMaintenanceWindowNodeOs(value: KubernetesClusterMaintenanceWindowNodeOs): void;
    resetMaintenanceWindowNodeOs(): void;
    get maintenanceWindowNodeOsInput(): KubernetesClusterMaintenanceWindowNodeOs | undefined;
    private _microsoftDefender;
    get microsoftDefender(): KubernetesClusterMicrosoftDefenderOutputReference;
    putMicrosoftDefender(value: KubernetesClusterMicrosoftDefender): void;
    resetMicrosoftDefender(): void;
    get microsoftDefenderInput(): KubernetesClusterMicrosoftDefender | undefined;
    private _monitorMetrics;
    get monitorMetrics(): KubernetesClusterMonitorMetricsOutputReference;
    putMonitorMetrics(value: KubernetesClusterMonitorMetrics): void;
    resetMonitorMetrics(): void;
    get monitorMetricsInput(): KubernetesClusterMonitorMetrics | undefined;
    private _networkProfile;
    get networkProfile(): KubernetesClusterNetworkProfileOutputReference;
    putNetworkProfile(value: KubernetesClusterNetworkProfile): void;
    resetNetworkProfile(): void;
    get networkProfileInput(): KubernetesClusterNetworkProfile | undefined;
    private _omsAgent;
    get omsAgent(): KubernetesClusterOmsAgentOutputReference;
    putOmsAgent(value: KubernetesClusterOmsAgent): void;
    resetOmsAgent(): void;
    get omsAgentInput(): KubernetesClusterOmsAgent | undefined;
    private _serviceMeshProfile;
    get serviceMeshProfile(): KubernetesClusterServiceMeshProfileOutputReference;
    putServiceMeshProfile(value: KubernetesClusterServiceMeshProfile): void;
    resetServiceMeshProfile(): void;
    get serviceMeshProfileInput(): KubernetesClusterServiceMeshProfile | undefined;
    private _servicePrincipal;
    get servicePrincipal(): KubernetesClusterServicePrincipalOutputReference;
    putServicePrincipal(value: KubernetesClusterServicePrincipal): void;
    resetServicePrincipal(): void;
    get servicePrincipalInput(): KubernetesClusterServicePrincipal | undefined;
    private _storageProfile;
    get storageProfile(): KubernetesClusterStorageProfileOutputReference;
    putStorageProfile(value: KubernetesClusterStorageProfile): void;
    resetStorageProfile(): void;
    get storageProfileInput(): KubernetesClusterStorageProfile | undefined;
    private _timeouts;
    get timeouts(): KubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: KubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesClusterTimeouts | undefined;
    private _webAppRouting;
    get webAppRouting(): KubernetesClusterWebAppRoutingOutputReference;
    putWebAppRouting(value: KubernetesClusterWebAppRouting): void;
    resetWebAppRouting(): void;
    get webAppRoutingInput(): KubernetesClusterWebAppRouting | undefined;
    private _windowsProfile;
    get windowsProfile(): KubernetesClusterWindowsProfileOutputReference;
    putWindowsProfile(value: KubernetesClusterWindowsProfile): void;
    resetWindowsProfile(): void;
    get windowsProfileInput(): KubernetesClusterWindowsProfile | undefined;
    private _workloadAutoscalerProfile;
    get workloadAutoscalerProfile(): KubernetesClusterWorkloadAutoscalerProfileOutputReference;
    putWorkloadAutoscalerProfile(value: KubernetesClusterWorkloadAutoscalerProfile): void;
    resetWorkloadAutoscalerProfile(): void;
    get workloadAutoscalerProfileInput(): KubernetesClusterWorkloadAutoscalerProfile | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
