/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppTriggerCustomConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#body LogicAppTriggerCustom#body}
    */
    readonly body: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#id LogicAppTriggerCustom#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#logic_app_id LogicAppTriggerCustom#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#name LogicAppTriggerCustom#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#timeouts LogicAppTriggerCustom#timeouts}
    */
    readonly timeouts?: LogicAppTriggerCustomTimeouts;
}
export interface LogicAppTriggerCustomTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#create LogicAppTriggerCustom#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#delete LogicAppTriggerCustom#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#read LogicAppTriggerCustom#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#update LogicAppTriggerCustom#update}
    */
    readonly update?: string;
}
export declare function logicAppTriggerCustomTimeoutsToTerraform(struct?: LogicAppTriggerCustomTimeouts | cdktf.IResolvable): any;
export declare function logicAppTriggerCustomTimeoutsToHclTerraform(struct?: LogicAppTriggerCustomTimeouts | cdktf.IResolvable): any;
export declare class LogicAppTriggerCustomTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppTriggerCustomTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppTriggerCustomTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom azurerm_logic_app_trigger_custom}
*/
export declare class LogicAppTriggerCustom extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_trigger_custom";
    /**
    * Generates CDKTF code for importing a LogicAppTriggerCustom resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LogicAppTriggerCustom to import
    * @param importFromId The id of the existing LogicAppTriggerCustom that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LogicAppTriggerCustom to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/logic_app_trigger_custom azurerm_logic_app_trigger_custom} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppTriggerCustomConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppTriggerCustomConfig);
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    get callbackUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logicAppId?;
    get logicAppId(): string;
    set logicAppId(value: string);
    get logicAppIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): LogicAppTriggerCustomTimeoutsOutputReference;
    putTimeouts(value: LogicAppTriggerCustomTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogicAppTriggerCustomTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
