/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MachineLearningInferenceClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#cluster_purpose MachineLearningInferenceCluster#cluster_purpose}
    */
    readonly clusterPurpose?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#description MachineLearningInferenceCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#id MachineLearningInferenceCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#kubernetes_cluster_id MachineLearningInferenceCluster#kubernetes_cluster_id}
    */
    readonly kubernetesClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#location MachineLearningInferenceCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#machine_learning_workspace_id MachineLearningInferenceCluster#machine_learning_workspace_id}
    */
    readonly machineLearningWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#name MachineLearningInferenceCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#tags MachineLearningInferenceCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#identity MachineLearningInferenceCluster#identity}
    */
    readonly identity?: MachineLearningInferenceClusterIdentity;
    /**
    * ssl block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#ssl MachineLearningInferenceCluster#ssl}
    */
    readonly ssl?: MachineLearningInferenceClusterSsl;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#timeouts MachineLearningInferenceCluster#timeouts}
    */
    readonly timeouts?: MachineLearningInferenceClusterTimeouts;
}
export interface MachineLearningInferenceClusterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#identity_ids MachineLearningInferenceCluster#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#type MachineLearningInferenceCluster#type}
    */
    readonly type: string;
}
export declare function machineLearningInferenceClusterIdentityToTerraform(struct?: MachineLearningInferenceClusterIdentityOutputReference | MachineLearningInferenceClusterIdentity): any;
export declare function machineLearningInferenceClusterIdentityToHclTerraform(struct?: MachineLearningInferenceClusterIdentityOutputReference | MachineLearningInferenceClusterIdentity): any;
export declare class MachineLearningInferenceClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningInferenceClusterIdentity | undefined;
    set internalValue(value: MachineLearningInferenceClusterIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MachineLearningInferenceClusterSsl {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#cert MachineLearningInferenceCluster#cert}
    */
    readonly cert?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#cname MachineLearningInferenceCluster#cname}
    */
    readonly cname?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#key MachineLearningInferenceCluster#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#leaf_domain_label MachineLearningInferenceCluster#leaf_domain_label}
    */
    readonly leafDomainLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#overwrite_existing_domain MachineLearningInferenceCluster#overwrite_existing_domain}
    */
    readonly overwriteExistingDomain?: boolean | cdktf.IResolvable;
}
export declare function machineLearningInferenceClusterSslToTerraform(struct?: MachineLearningInferenceClusterSslOutputReference | MachineLearningInferenceClusterSsl): any;
export declare function machineLearningInferenceClusterSslToHclTerraform(struct?: MachineLearningInferenceClusterSslOutputReference | MachineLearningInferenceClusterSsl): any;
export declare class MachineLearningInferenceClusterSslOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningInferenceClusterSsl | undefined;
    set internalValue(value: MachineLearningInferenceClusterSsl | undefined);
    private _cert?;
    get cert(): string;
    set cert(value: string);
    resetCert(): void;
    get certInput(): string | undefined;
    private _cname?;
    get cname(): string;
    set cname(value: string);
    resetCname(): void;
    get cnameInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _leafDomainLabel?;
    get leafDomainLabel(): string;
    set leafDomainLabel(value: string);
    resetLeafDomainLabel(): void;
    get leafDomainLabelInput(): string | undefined;
    private _overwriteExistingDomain?;
    get overwriteExistingDomain(): boolean | cdktf.IResolvable;
    set overwriteExistingDomain(value: boolean | cdktf.IResolvable);
    resetOverwriteExistingDomain(): void;
    get overwriteExistingDomainInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MachineLearningInferenceClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#create MachineLearningInferenceCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#delete MachineLearningInferenceCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#read MachineLearningInferenceCluster#read}
    */
    readonly read?: string;
}
export declare function machineLearningInferenceClusterTimeoutsToTerraform(struct?: MachineLearningInferenceClusterTimeouts | cdktf.IResolvable): any;
export declare function machineLearningInferenceClusterTimeoutsToHclTerraform(struct?: MachineLearningInferenceClusterTimeouts | cdktf.IResolvable): any;
export declare class MachineLearningInferenceClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningInferenceClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MachineLearningInferenceClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster azurerm_machine_learning_inference_cluster}
*/
export declare class MachineLearningInferenceCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_machine_learning_inference_cluster";
    /**
    * Generates CDKTF code for importing a MachineLearningInferenceCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MachineLearningInferenceCluster to import
    * @param importFromId The id of the existing MachineLearningInferenceCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MachineLearningInferenceCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/machine_learning_inference_cluster azurerm_machine_learning_inference_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MachineLearningInferenceClusterConfig
    */
    constructor(scope: Construct, id: string, config: MachineLearningInferenceClusterConfig);
    private _clusterPurpose?;
    get clusterPurpose(): string;
    set clusterPurpose(value: string);
    resetClusterPurpose(): void;
    get clusterPurposeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesClusterId?;
    get kubernetesClusterId(): string;
    set kubernetesClusterId(value: string);
    get kubernetesClusterIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    get machineLearningWorkspaceId(): string;
    set machineLearningWorkspaceId(value: string);
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): MachineLearningInferenceClusterIdentityOutputReference;
    putIdentity(value: MachineLearningInferenceClusterIdentity): void;
    resetIdentity(): void;
    get identityInput(): MachineLearningInferenceClusterIdentity | undefined;
    private _ssl;
    get ssl(): MachineLearningInferenceClusterSslOutputReference;
    putSsl(value: MachineLearningInferenceClusterSsl): void;
    resetSsl(): void;
    get sslInput(): MachineLearningInferenceClusterSsl | undefined;
    private _timeouts;
    get timeouts(): MachineLearningInferenceClusterTimeoutsOutputReference;
    putTimeouts(value: MachineLearningInferenceClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MachineLearningInferenceClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
