/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#display_name ManagementGroup#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#id ManagementGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#name ManagementGroup#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#parent_management_group_id ManagementGroup#parent_management_group_id}
    */
    readonly parentManagementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#subscription_ids ManagementGroup#subscription_ids}
    */
    readonly subscriptionIds?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#timeouts ManagementGroup#timeouts}
    */
    readonly timeouts?: ManagementGroupTimeouts;
}
export interface ManagementGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#create ManagementGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#delete ManagementGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#read ManagementGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#update ManagementGroup#update}
    */
    readonly update?: string;
}
export declare function managementGroupTimeoutsToTerraform(struct?: ManagementGroupTimeouts | cdktf.IResolvable): any;
export declare function managementGroupTimeoutsToHclTerraform(struct?: ManagementGroupTimeouts | cdktf.IResolvable): any;
export declare class ManagementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ManagementGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ManagementGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group azurerm_management_group}
*/
export declare class ManagementGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_management_group";
    /**
    * Generates CDKTF code for importing a ManagementGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ManagementGroup to import
    * @param importFromId The id of the existing ManagementGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ManagementGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/management_group azurerm_management_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagementGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ManagementGroupConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _parentManagementGroupId?;
    get parentManagementGroupId(): string;
    set parentManagementGroupId(value: string);
    resetParentManagementGroupId(): void;
    get parentManagementGroupIdInput(): string | undefined;
    private _subscriptionIds?;
    get subscriptionIds(): string[];
    set subscriptionIds(value: string[]);
    resetSubscriptionIds(): void;
    get subscriptionIdsInput(): string[] | undefined;
    get tenantScopedId(): string;
    private _timeouts;
    get timeouts(): ManagementGroupTimeoutsOutputReference;
    putTimeouts(value: ManagementGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ManagementGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
