/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaAssetFilterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#asset_id MediaAssetFilter#asset_id}
    */
    readonly assetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#first_quality_bitrate MediaAssetFilter#first_quality_bitrate}
    */
    readonly firstQualityBitrate?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#id MediaAssetFilter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#name MediaAssetFilter#name}
    */
    readonly name: string;
    /**
    * presentation_time_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#presentation_time_range MediaAssetFilter#presentation_time_range}
    */
    readonly presentationTimeRange?: MediaAssetFilterPresentationTimeRange;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#timeouts MediaAssetFilter#timeouts}
    */
    readonly timeouts?: MediaAssetFilterTimeouts;
    /**
    * track_selection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#track_selection MediaAssetFilter#track_selection}
    */
    readonly trackSelection?: MediaAssetFilterTrackSelection[] | cdktf.IResolvable;
}
export interface MediaAssetFilterPresentationTimeRange {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#end_in_units MediaAssetFilter#end_in_units}
    */
    readonly endInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#force_end MediaAssetFilter#force_end}
    */
    readonly forceEnd?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#live_backoff_in_units MediaAssetFilter#live_backoff_in_units}
    */
    readonly liveBackoffInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#presentation_window_in_units MediaAssetFilter#presentation_window_in_units}
    */
    readonly presentationWindowInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#start_in_units MediaAssetFilter#start_in_units}
    */
    readonly startInUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#unit_timescale_in_miliseconds MediaAssetFilter#unit_timescale_in_miliseconds}
    */
    readonly unitTimescaleInMiliseconds?: number;
}
export declare function mediaAssetFilterPresentationTimeRangeToTerraform(struct?: MediaAssetFilterPresentationTimeRangeOutputReference | MediaAssetFilterPresentationTimeRange): any;
export declare function mediaAssetFilterPresentationTimeRangeToHclTerraform(struct?: MediaAssetFilterPresentationTimeRangeOutputReference | MediaAssetFilterPresentationTimeRange): any;
export declare class MediaAssetFilterPresentationTimeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaAssetFilterPresentationTimeRange | undefined;
    set internalValue(value: MediaAssetFilterPresentationTimeRange | undefined);
    private _endInUnits?;
    get endInUnits(): number;
    set endInUnits(value: number);
    resetEndInUnits(): void;
    get endInUnitsInput(): number | undefined;
    private _forceEnd?;
    get forceEnd(): boolean | cdktf.IResolvable;
    set forceEnd(value: boolean | cdktf.IResolvable);
    resetForceEnd(): void;
    get forceEndInput(): boolean | cdktf.IResolvable | undefined;
    private _liveBackoffInUnits?;
    get liveBackoffInUnits(): number;
    set liveBackoffInUnits(value: number);
    resetLiveBackoffInUnits(): void;
    get liveBackoffInUnitsInput(): number | undefined;
    private _presentationWindowInUnits?;
    get presentationWindowInUnits(): number;
    set presentationWindowInUnits(value: number);
    resetPresentationWindowInUnits(): void;
    get presentationWindowInUnitsInput(): number | undefined;
    private _startInUnits?;
    get startInUnits(): number;
    set startInUnits(value: number);
    resetStartInUnits(): void;
    get startInUnitsInput(): number | undefined;
    private _unitTimescaleInMiliseconds?;
    get unitTimescaleInMiliseconds(): number;
    set unitTimescaleInMiliseconds(value: number);
    resetUnitTimescaleInMiliseconds(): void;
    get unitTimescaleInMilisecondsInput(): number | undefined;
}
export interface MediaAssetFilterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#create MediaAssetFilter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#delete MediaAssetFilter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#read MediaAssetFilter#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#update MediaAssetFilter#update}
    */
    readonly update?: string;
}
export declare function mediaAssetFilterTimeoutsToTerraform(struct?: MediaAssetFilterTimeouts | cdktf.IResolvable): any;
export declare function mediaAssetFilterTimeoutsToHclTerraform(struct?: MediaAssetFilterTimeouts | cdktf.IResolvable): any;
export declare class MediaAssetFilterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaAssetFilterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaAssetFilterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MediaAssetFilterTrackSelectionCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#operation MediaAssetFilter#operation}
    */
    readonly operation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#property MediaAssetFilter#property}
    */
    readonly property?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#value MediaAssetFilter#value}
    */
    readonly value?: string;
}
export declare function mediaAssetFilterTrackSelectionConditionToTerraform(struct?: MediaAssetFilterTrackSelectionCondition | cdktf.IResolvable): any;
export declare function mediaAssetFilterTrackSelectionConditionToHclTerraform(struct?: MediaAssetFilterTrackSelectionCondition | cdktf.IResolvable): any;
export declare class MediaAssetFilterTrackSelectionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaAssetFilterTrackSelectionCondition | cdktf.IResolvable | undefined;
    set internalValue(value: MediaAssetFilterTrackSelectionCondition | cdktf.IResolvable | undefined);
    private _operation?;
    get operation(): string;
    set operation(value: string);
    resetOperation(): void;
    get operationInput(): string | undefined;
    private _property?;
    get property(): string;
    set property(value: string);
    resetProperty(): void;
    get propertyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class MediaAssetFilterTrackSelectionConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaAssetFilterTrackSelectionCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaAssetFilterTrackSelectionConditionOutputReference;
}
export interface MediaAssetFilterTrackSelection {
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#condition MediaAssetFilter#condition}
    */
    readonly condition: MediaAssetFilterTrackSelectionCondition[] | cdktf.IResolvable;
}
export declare function mediaAssetFilterTrackSelectionToTerraform(struct?: MediaAssetFilterTrackSelection | cdktf.IResolvable): any;
export declare function mediaAssetFilterTrackSelectionToHclTerraform(struct?: MediaAssetFilterTrackSelection | cdktf.IResolvable): any;
export declare class MediaAssetFilterTrackSelectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaAssetFilterTrackSelection | cdktf.IResolvable | undefined;
    set internalValue(value: MediaAssetFilterTrackSelection | cdktf.IResolvable | undefined);
    private _condition;
    get condition(): MediaAssetFilterTrackSelectionConditionList;
    putCondition(value: MediaAssetFilterTrackSelectionCondition[] | cdktf.IResolvable): void;
    get conditionInput(): cdktf.IResolvable | MediaAssetFilterTrackSelectionCondition[] | undefined;
}
export declare class MediaAssetFilterTrackSelectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaAssetFilterTrackSelection[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaAssetFilterTrackSelectionOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter azurerm_media_asset_filter}
*/
export declare class MediaAssetFilter extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_asset_filter";
    /**
    * Generates CDKTF code for importing a MediaAssetFilter resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaAssetFilter to import
    * @param importFromId The id of the existing MediaAssetFilter that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaAssetFilter to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_asset_filter azurerm_media_asset_filter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaAssetFilterConfig
    */
    constructor(scope: Construct, id: string, config: MediaAssetFilterConfig);
    private _assetId?;
    get assetId(): string;
    set assetId(value: string);
    get assetIdInput(): string | undefined;
    private _firstQualityBitrate?;
    get firstQualityBitrate(): number;
    set firstQualityBitrate(value: number);
    resetFirstQualityBitrate(): void;
    get firstQualityBitrateInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _presentationTimeRange;
    get presentationTimeRange(): MediaAssetFilterPresentationTimeRangeOutputReference;
    putPresentationTimeRange(value: MediaAssetFilterPresentationTimeRange): void;
    resetPresentationTimeRange(): void;
    get presentationTimeRangeInput(): MediaAssetFilterPresentationTimeRange | undefined;
    private _timeouts;
    get timeouts(): MediaAssetFilterTimeoutsOutputReference;
    putTimeouts(value: MediaAssetFilterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaAssetFilterTimeouts | undefined;
    private _trackSelection;
    get trackSelection(): MediaAssetFilterTrackSelectionList;
    putTrackSelection(value: MediaAssetFilterTrackSelection[] | cdktf.IResolvable): void;
    resetTrackSelection(): void;
    get trackSelectionInput(): cdktf.IResolvable | MediaAssetFilterTrackSelection[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
