/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaLiveEventConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#auto_start_enabled MediaLiveEvent#auto_start_enabled}
    */
    readonly autoStartEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#description MediaLiveEvent#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#hostname_prefix MediaLiveEvent#hostname_prefix}
    */
    readonly hostnamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#id MediaLiveEvent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#location MediaLiveEvent#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#media_services_account_name MediaLiveEvent#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#name MediaLiveEvent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#resource_group_name MediaLiveEvent#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#stream_options MediaLiveEvent#stream_options}
    */
    readonly streamOptions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#tags MediaLiveEvent#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#transcription_languages MediaLiveEvent#transcription_languages}
    */
    readonly transcriptionLanguages?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#use_static_hostname MediaLiveEvent#use_static_hostname}
    */
    readonly useStaticHostname?: boolean | cdktf.IResolvable;
    /**
    * cross_site_access_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#cross_site_access_policy MediaLiveEvent#cross_site_access_policy}
    */
    readonly crossSiteAccessPolicy?: MediaLiveEventCrossSiteAccessPolicy;
    /**
    * encoding block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#encoding MediaLiveEvent#encoding}
    */
    readonly encoding?: MediaLiveEventEncoding;
    /**
    * input block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#input MediaLiveEvent#input}
    */
    readonly input: MediaLiveEventInput;
    /**
    * preview block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#preview MediaLiveEvent#preview}
    */
    readonly preview?: MediaLiveEventPreview;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#timeouts MediaLiveEvent#timeouts}
    */
    readonly timeouts?: MediaLiveEventTimeouts;
}
export interface MediaLiveEventCrossSiteAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#client_access_policy MediaLiveEvent#client_access_policy}
    */
    readonly clientAccessPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#cross_domain_policy MediaLiveEvent#cross_domain_policy}
    */
    readonly crossDomainPolicy?: string;
}
export declare function mediaLiveEventCrossSiteAccessPolicyToTerraform(struct?: MediaLiveEventCrossSiteAccessPolicyOutputReference | MediaLiveEventCrossSiteAccessPolicy): any;
export declare function mediaLiveEventCrossSiteAccessPolicyToHclTerraform(struct?: MediaLiveEventCrossSiteAccessPolicyOutputReference | MediaLiveEventCrossSiteAccessPolicy): any;
export declare class MediaLiveEventCrossSiteAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaLiveEventCrossSiteAccessPolicy | undefined;
    set internalValue(value: MediaLiveEventCrossSiteAccessPolicy | undefined);
    private _clientAccessPolicy?;
    get clientAccessPolicy(): string;
    set clientAccessPolicy(value: string);
    resetClientAccessPolicy(): void;
    get clientAccessPolicyInput(): string | undefined;
    private _crossDomainPolicy?;
    get crossDomainPolicy(): string;
    set crossDomainPolicy(value: string);
    resetCrossDomainPolicy(): void;
    get crossDomainPolicyInput(): string | undefined;
}
export interface MediaLiveEventEncoding {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#key_frame_interval MediaLiveEvent#key_frame_interval}
    */
    readonly keyFrameInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#preset_name MediaLiveEvent#preset_name}
    */
    readonly presetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#stretch_mode MediaLiveEvent#stretch_mode}
    */
    readonly stretchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#type MediaLiveEvent#type}
    */
    readonly type?: string;
}
export declare function mediaLiveEventEncodingToTerraform(struct?: MediaLiveEventEncodingOutputReference | MediaLiveEventEncoding): any;
export declare function mediaLiveEventEncodingToHclTerraform(struct?: MediaLiveEventEncodingOutputReference | MediaLiveEventEncoding): any;
export declare class MediaLiveEventEncodingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaLiveEventEncoding | undefined;
    set internalValue(value: MediaLiveEventEncoding | undefined);
    private _keyFrameInterval?;
    get keyFrameInterval(): string;
    set keyFrameInterval(value: string);
    resetKeyFrameInterval(): void;
    get keyFrameIntervalInput(): string | undefined;
    private _presetName?;
    get presetName(): string;
    set presetName(value: string);
    resetPresetName(): void;
    get presetNameInput(): string | undefined;
    private _stretchMode?;
    get stretchMode(): string;
    set stretchMode(value: string);
    resetStretchMode(): void;
    get stretchModeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface MediaLiveEventInputEndpoint {
}
export declare function mediaLiveEventInputEndpointToTerraform(struct?: MediaLiveEventInputEndpoint): any;
export declare function mediaLiveEventInputEndpointToHclTerraform(struct?: MediaLiveEventInputEndpoint): any;
export declare class MediaLiveEventInputEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaLiveEventInputEndpoint | undefined;
    set internalValue(value: MediaLiveEventInputEndpoint | undefined);
    get protocol(): string;
    get url(): string;
}
export declare class MediaLiveEventInputEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaLiveEventInputEndpointOutputReference;
}
export interface MediaLiveEventInputIpAccessControlAllow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#address MediaLiveEvent#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#name MediaLiveEvent#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#subnet_prefix_length MediaLiveEvent#subnet_prefix_length}
    */
    readonly subnetPrefixLength?: number;
}
export declare function mediaLiveEventInputIpAccessControlAllowToTerraform(struct?: MediaLiveEventInputIpAccessControlAllow | cdktf.IResolvable): any;
export declare function mediaLiveEventInputIpAccessControlAllowToHclTerraform(struct?: MediaLiveEventInputIpAccessControlAllow | cdktf.IResolvable): any;
export declare class MediaLiveEventInputIpAccessControlAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaLiveEventInputIpAccessControlAllow | cdktf.IResolvable | undefined;
    set internalValue(value: MediaLiveEventInputIpAccessControlAllow | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _subnetPrefixLength?;
    get subnetPrefixLength(): number;
    set subnetPrefixLength(value: number);
    resetSubnetPrefixLength(): void;
    get subnetPrefixLengthInput(): number | undefined;
}
export declare class MediaLiveEventInputIpAccessControlAllowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaLiveEventInputIpAccessControlAllow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaLiveEventInputIpAccessControlAllowOutputReference;
}
export interface MediaLiveEventInput {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#access_token MediaLiveEvent#access_token}
    */
    readonly accessToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#key_frame_interval_duration MediaLiveEvent#key_frame_interval_duration}
    */
    readonly keyFrameIntervalDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#streaming_protocol MediaLiveEvent#streaming_protocol}
    */
    readonly streamingProtocol?: string;
    /**
    * ip_access_control_allow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#ip_access_control_allow MediaLiveEvent#ip_access_control_allow}
    */
    readonly ipAccessControlAllow?: MediaLiveEventInputIpAccessControlAllow[] | cdktf.IResolvable;
}
export declare function mediaLiveEventInputToTerraform(struct?: MediaLiveEventInputOutputReference | MediaLiveEventInput): any;
export declare function mediaLiveEventInputToHclTerraform(struct?: MediaLiveEventInputOutputReference | MediaLiveEventInput): any;
export declare class MediaLiveEventInputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaLiveEventInput | undefined;
    set internalValue(value: MediaLiveEventInput | undefined);
    private _accessToken?;
    get accessToken(): string;
    set accessToken(value: string);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _endpoint;
    get endpoint(): MediaLiveEventInputEndpointList;
    private _keyFrameIntervalDuration?;
    get keyFrameIntervalDuration(): string;
    set keyFrameIntervalDuration(value: string);
    resetKeyFrameIntervalDuration(): void;
    get keyFrameIntervalDurationInput(): string | undefined;
    private _streamingProtocol?;
    get streamingProtocol(): string;
    set streamingProtocol(value: string);
    resetStreamingProtocol(): void;
    get streamingProtocolInput(): string | undefined;
    private _ipAccessControlAllow;
    get ipAccessControlAllow(): MediaLiveEventInputIpAccessControlAllowList;
    putIpAccessControlAllow(value: MediaLiveEventInputIpAccessControlAllow[] | cdktf.IResolvable): void;
    resetIpAccessControlAllow(): void;
    get ipAccessControlAllowInput(): cdktf.IResolvable | MediaLiveEventInputIpAccessControlAllow[] | undefined;
}
export interface MediaLiveEventPreviewEndpoint {
}
export declare function mediaLiveEventPreviewEndpointToTerraform(struct?: MediaLiveEventPreviewEndpoint): any;
export declare function mediaLiveEventPreviewEndpointToHclTerraform(struct?: MediaLiveEventPreviewEndpoint): any;
export declare class MediaLiveEventPreviewEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaLiveEventPreviewEndpoint | undefined;
    set internalValue(value: MediaLiveEventPreviewEndpoint | undefined);
    get protocol(): string;
    get url(): string;
}
export declare class MediaLiveEventPreviewEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaLiveEventPreviewEndpointOutputReference;
}
export interface MediaLiveEventPreviewIpAccessControlAllow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#address MediaLiveEvent#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#name MediaLiveEvent#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#subnet_prefix_length MediaLiveEvent#subnet_prefix_length}
    */
    readonly subnetPrefixLength?: number;
}
export declare function mediaLiveEventPreviewIpAccessControlAllowToTerraform(struct?: MediaLiveEventPreviewIpAccessControlAllow | cdktf.IResolvable): any;
export declare function mediaLiveEventPreviewIpAccessControlAllowToHclTerraform(struct?: MediaLiveEventPreviewIpAccessControlAllow | cdktf.IResolvable): any;
export declare class MediaLiveEventPreviewIpAccessControlAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaLiveEventPreviewIpAccessControlAllow | cdktf.IResolvable | undefined;
    set internalValue(value: MediaLiveEventPreviewIpAccessControlAllow | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _subnetPrefixLength?;
    get subnetPrefixLength(): number;
    set subnetPrefixLength(value: number);
    resetSubnetPrefixLength(): void;
    get subnetPrefixLengthInput(): number | undefined;
}
export declare class MediaLiveEventPreviewIpAccessControlAllowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaLiveEventPreviewIpAccessControlAllow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaLiveEventPreviewIpAccessControlAllowOutputReference;
}
export interface MediaLiveEventPreview {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#alternative_media_id MediaLiveEvent#alternative_media_id}
    */
    readonly alternativeMediaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#preview_locator MediaLiveEvent#preview_locator}
    */
    readonly previewLocator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#streaming_policy_name MediaLiveEvent#streaming_policy_name}
    */
    readonly streamingPolicyName?: string;
    /**
    * ip_access_control_allow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#ip_access_control_allow MediaLiveEvent#ip_access_control_allow}
    */
    readonly ipAccessControlAllow?: MediaLiveEventPreviewIpAccessControlAllow[] | cdktf.IResolvable;
}
export declare function mediaLiveEventPreviewToTerraform(struct?: MediaLiveEventPreviewOutputReference | MediaLiveEventPreview): any;
export declare function mediaLiveEventPreviewToHclTerraform(struct?: MediaLiveEventPreviewOutputReference | MediaLiveEventPreview): any;
export declare class MediaLiveEventPreviewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaLiveEventPreview | undefined;
    set internalValue(value: MediaLiveEventPreview | undefined);
    private _alternativeMediaId?;
    get alternativeMediaId(): string;
    set alternativeMediaId(value: string);
    resetAlternativeMediaId(): void;
    get alternativeMediaIdInput(): string | undefined;
    private _endpoint;
    get endpoint(): MediaLiveEventPreviewEndpointList;
    private _previewLocator?;
    get previewLocator(): string;
    set previewLocator(value: string);
    resetPreviewLocator(): void;
    get previewLocatorInput(): string | undefined;
    private _streamingPolicyName?;
    get streamingPolicyName(): string;
    set streamingPolicyName(value: string);
    resetStreamingPolicyName(): void;
    get streamingPolicyNameInput(): string | undefined;
    private _ipAccessControlAllow;
    get ipAccessControlAllow(): MediaLiveEventPreviewIpAccessControlAllowList;
    putIpAccessControlAllow(value: MediaLiveEventPreviewIpAccessControlAllow[] | cdktf.IResolvable): void;
    resetIpAccessControlAllow(): void;
    get ipAccessControlAllowInput(): cdktf.IResolvable | MediaLiveEventPreviewIpAccessControlAllow[] | undefined;
}
export interface MediaLiveEventTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#create MediaLiveEvent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#delete MediaLiveEvent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#read MediaLiveEvent#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#update MediaLiveEvent#update}
    */
    readonly update?: string;
}
export declare function mediaLiveEventTimeoutsToTerraform(struct?: MediaLiveEventTimeouts | cdktf.IResolvable): any;
export declare function mediaLiveEventTimeoutsToHclTerraform(struct?: MediaLiveEventTimeouts | cdktf.IResolvable): any;
export declare class MediaLiveEventTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaLiveEventTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaLiveEventTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event azurerm_media_live_event}
*/
export declare class MediaLiveEvent extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_live_event";
    /**
    * Generates CDKTF code for importing a MediaLiveEvent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaLiveEvent to import
    * @param importFromId The id of the existing MediaLiveEvent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaLiveEvent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_live_event azurerm_media_live_event} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaLiveEventConfig
    */
    constructor(scope: Construct, id: string, config: MediaLiveEventConfig);
    private _autoStartEnabled?;
    get autoStartEnabled(): boolean | cdktf.IResolvable;
    set autoStartEnabled(value: boolean | cdktf.IResolvable);
    resetAutoStartEnabled(): void;
    get autoStartEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hostnamePrefix?;
    get hostnamePrefix(): string;
    set hostnamePrefix(value: string);
    resetHostnamePrefix(): void;
    get hostnamePrefixInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _streamOptions?;
    get streamOptions(): string[];
    set streamOptions(value: string[]);
    resetStreamOptions(): void;
    get streamOptionsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _transcriptionLanguages?;
    get transcriptionLanguages(): string[];
    set transcriptionLanguages(value: string[]);
    resetTranscriptionLanguages(): void;
    get transcriptionLanguagesInput(): string[] | undefined;
    private _useStaticHostname?;
    get useStaticHostname(): boolean | cdktf.IResolvable;
    set useStaticHostname(value: boolean | cdktf.IResolvable);
    resetUseStaticHostname(): void;
    get useStaticHostnameInput(): boolean | cdktf.IResolvable | undefined;
    private _crossSiteAccessPolicy;
    get crossSiteAccessPolicy(): MediaLiveEventCrossSiteAccessPolicyOutputReference;
    putCrossSiteAccessPolicy(value: MediaLiveEventCrossSiteAccessPolicy): void;
    resetCrossSiteAccessPolicy(): void;
    get crossSiteAccessPolicyInput(): MediaLiveEventCrossSiteAccessPolicy | undefined;
    private _encoding;
    get encoding(): MediaLiveEventEncodingOutputReference;
    putEncoding(value: MediaLiveEventEncoding): void;
    resetEncoding(): void;
    get encodingInput(): MediaLiveEventEncoding | undefined;
    private _input;
    get input(): MediaLiveEventInputOutputReference;
    putInput(value: MediaLiveEventInput): void;
    get inputInput(): MediaLiveEventInput | undefined;
    private _preview;
    get preview(): MediaLiveEventPreviewOutputReference;
    putPreview(value: MediaLiveEventPreview): void;
    resetPreview(): void;
    get previewInput(): MediaLiveEventPreview | undefined;
    private _timeouts;
    get timeouts(): MediaLiveEventTimeoutsOutputReference;
    putTimeouts(value: MediaLiveEventTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaLiveEventTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
