/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaTransformConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#description MediaTransform#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#id MediaTransform#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#media_services_account_name MediaTransform#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#name MediaTransform#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#resource_group_name MediaTransform#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * output block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#output MediaTransform#output}
    */
    readonly output?: MediaTransformOutput[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#timeouts MediaTransform#timeouts}
    */
    readonly timeouts?: MediaTransformTimeouts;
}
export interface MediaTransformOutputAudioAnalyzerPreset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio_analysis_mode MediaTransform#audio_analysis_mode}
    */
    readonly audioAnalysisMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio_language MediaTransform#audio_language}
    */
    readonly audioLanguage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#experimental_options MediaTransform#experimental_options}
    */
    readonly experimentalOptions?: {
        [key: string]: string;
    };
}
export declare function mediaTransformOutputAudioAnalyzerPresetToTerraform(struct?: MediaTransformOutputAudioAnalyzerPresetOutputReference | MediaTransformOutputAudioAnalyzerPreset): any;
export declare function mediaTransformOutputAudioAnalyzerPresetToHclTerraform(struct?: MediaTransformOutputAudioAnalyzerPresetOutputReference | MediaTransformOutputAudioAnalyzerPreset): any;
export declare class MediaTransformOutputAudioAnalyzerPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputAudioAnalyzerPreset | undefined;
    set internalValue(value: MediaTransformOutputAudioAnalyzerPreset | undefined);
    private _audioAnalysisMode?;
    get audioAnalysisMode(): string;
    set audioAnalysisMode(value: string);
    resetAudioAnalysisMode(): void;
    get audioAnalysisModeInput(): string | undefined;
    private _audioLanguage?;
    get audioLanguage(): string;
    set audioLanguage(value: string);
    resetAudioLanguage(): void;
    get audioLanguageInput(): string | undefined;
    private _experimentalOptions?;
    get experimentalOptions(): {
        [key: string]: string;
    };
    set experimentalOptions(value: {
        [key: string]: string;
    });
    resetExperimentalOptions(): void;
    get experimentalOptionsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface MediaTransformOutputBuiltinPresetPresetConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#complexity MediaTransform#complexity}
    */
    readonly complexity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#interleave_output MediaTransform#interleave_output}
    */
    readonly interleaveOutput?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#key_frame_interval_in_seconds MediaTransform#key_frame_interval_in_seconds}
    */
    readonly keyFrameIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#max_bitrate_bps MediaTransform#max_bitrate_bps}
    */
    readonly maxBitrateBps?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#max_height MediaTransform#max_height}
    */
    readonly maxHeight?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#max_layers MediaTransform#max_layers}
    */
    readonly maxLayers?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#min_bitrate_bps MediaTransform#min_bitrate_bps}
    */
    readonly minBitrateBps?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#min_height MediaTransform#min_height}
    */
    readonly minHeight?: number;
}
export declare function mediaTransformOutputBuiltinPresetPresetConfigurationToTerraform(struct?: MediaTransformOutputBuiltinPresetPresetConfigurationOutputReference | MediaTransformOutputBuiltinPresetPresetConfiguration): any;
export declare function mediaTransformOutputBuiltinPresetPresetConfigurationToHclTerraform(struct?: MediaTransformOutputBuiltinPresetPresetConfigurationOutputReference | MediaTransformOutputBuiltinPresetPresetConfiguration): any;
export declare class MediaTransformOutputBuiltinPresetPresetConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputBuiltinPresetPresetConfiguration | undefined;
    set internalValue(value: MediaTransformOutputBuiltinPresetPresetConfiguration | undefined);
    private _complexity?;
    get complexity(): string;
    set complexity(value: string);
    resetComplexity(): void;
    get complexityInput(): string | undefined;
    private _interleaveOutput?;
    get interleaveOutput(): string;
    set interleaveOutput(value: string);
    resetInterleaveOutput(): void;
    get interleaveOutputInput(): string | undefined;
    private _keyFrameIntervalInSeconds?;
    get keyFrameIntervalInSeconds(): number;
    set keyFrameIntervalInSeconds(value: number);
    resetKeyFrameIntervalInSeconds(): void;
    get keyFrameIntervalInSecondsInput(): number | undefined;
    private _maxBitrateBps?;
    get maxBitrateBps(): number;
    set maxBitrateBps(value: number);
    resetMaxBitrateBps(): void;
    get maxBitrateBpsInput(): number | undefined;
    private _maxHeight?;
    get maxHeight(): number;
    set maxHeight(value: number);
    resetMaxHeight(): void;
    get maxHeightInput(): number | undefined;
    private _maxLayers?;
    get maxLayers(): number;
    set maxLayers(value: number);
    resetMaxLayers(): void;
    get maxLayersInput(): number | undefined;
    private _minBitrateBps?;
    get minBitrateBps(): number;
    set minBitrateBps(value: number);
    resetMinBitrateBps(): void;
    get minBitrateBpsInput(): number | undefined;
    private _minHeight?;
    get minHeight(): number;
    set minHeight(value: number);
    resetMinHeight(): void;
    get minHeightInput(): number | undefined;
}
export interface MediaTransformOutputBuiltinPreset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#preset_name MediaTransform#preset_name}
    */
    readonly presetName: string;
    /**
    * preset_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#preset_configuration MediaTransform#preset_configuration}
    */
    readonly presetConfiguration?: MediaTransformOutputBuiltinPresetPresetConfiguration;
}
export declare function mediaTransformOutputBuiltinPresetToTerraform(struct?: MediaTransformOutputBuiltinPresetOutputReference | MediaTransformOutputBuiltinPreset): any;
export declare function mediaTransformOutputBuiltinPresetToHclTerraform(struct?: MediaTransformOutputBuiltinPresetOutputReference | MediaTransformOutputBuiltinPreset): any;
export declare class MediaTransformOutputBuiltinPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputBuiltinPreset | undefined;
    set internalValue(value: MediaTransformOutputBuiltinPreset | undefined);
    private _presetName?;
    get presetName(): string;
    set presetName(value: string);
    get presetNameInput(): string | undefined;
    private _presetConfiguration;
    get presetConfiguration(): MediaTransformOutputBuiltinPresetPresetConfigurationOutputReference;
    putPresetConfiguration(value: MediaTransformOutputBuiltinPresetPresetConfiguration): void;
    resetPresetConfiguration(): void;
    get presetConfigurationInput(): MediaTransformOutputBuiltinPresetPresetConfiguration | undefined;
}
export interface MediaTransformOutputCustomPresetCodecAacAudio {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#bitrate MediaTransform#bitrate}
    */
    readonly bitrate?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#channels MediaTransform#channels}
    */
    readonly channels?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#profile MediaTransform#profile}
    */
    readonly profile?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#sampling_rate MediaTransform#sampling_rate}
    */
    readonly samplingRate?: number;
}
export declare function mediaTransformOutputCustomPresetCodecAacAudioToTerraform(struct?: MediaTransformOutputCustomPresetCodecAacAudioOutputReference | MediaTransformOutputCustomPresetCodecAacAudio): any;
export declare function mediaTransformOutputCustomPresetCodecAacAudioToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecAacAudioOutputReference | MediaTransformOutputCustomPresetCodecAacAudio): any;
export declare class MediaTransformOutputCustomPresetCodecAacAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecAacAudio | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecAacAudio | undefined);
    private _bitrate?;
    get bitrate(): number;
    set bitrate(value: number);
    resetBitrate(): void;
    get bitrateInput(): number | undefined;
    private _channels?;
    get channels(): number;
    set channels(value: number);
    resetChannels(): void;
    get channelsInput(): number | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _samplingRate?;
    get samplingRate(): number;
    set samplingRate(value: number);
    resetSamplingRate(): void;
    get samplingRateInput(): number | undefined;
}
export interface MediaTransformOutputCustomPresetCodecCopyAudio {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
}
export declare function mediaTransformOutputCustomPresetCodecCopyAudioToTerraform(struct?: MediaTransformOutputCustomPresetCodecCopyAudioOutputReference | MediaTransformOutputCustomPresetCodecCopyAudio): any;
export declare function mediaTransformOutputCustomPresetCodecCopyAudioToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecCopyAudioOutputReference | MediaTransformOutputCustomPresetCodecCopyAudio): any;
export declare class MediaTransformOutputCustomPresetCodecCopyAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecCopyAudio | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecCopyAudio | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetCodecCopyVideo {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
}
export declare function mediaTransformOutputCustomPresetCodecCopyVideoToTerraform(struct?: MediaTransformOutputCustomPresetCodecCopyVideoOutputReference | MediaTransformOutputCustomPresetCodecCopyVideo): any;
export declare function mediaTransformOutputCustomPresetCodecCopyVideoToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecCopyVideoOutputReference | MediaTransformOutputCustomPresetCodecCopyVideo): any;
export declare class MediaTransformOutputCustomPresetCodecCopyVideoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecCopyVideo | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecCopyVideo | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetCodecDdAudio {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#bitrate MediaTransform#bitrate}
    */
    readonly bitrate?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#channels MediaTransform#channels}
    */
    readonly channels?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#sampling_rate MediaTransform#sampling_rate}
    */
    readonly samplingRate?: number;
}
export declare function mediaTransformOutputCustomPresetCodecDdAudioToTerraform(struct?: MediaTransformOutputCustomPresetCodecDdAudioOutputReference | MediaTransformOutputCustomPresetCodecDdAudio): any;
export declare function mediaTransformOutputCustomPresetCodecDdAudioToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecDdAudioOutputReference | MediaTransformOutputCustomPresetCodecDdAudio): any;
export declare class MediaTransformOutputCustomPresetCodecDdAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecDdAudio | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecDdAudio | undefined);
    private _bitrate?;
    get bitrate(): number;
    set bitrate(value: number);
    resetBitrate(): void;
    get bitrateInput(): number | undefined;
    private _channels?;
    get channels(): number;
    set channels(value: number);
    resetChannels(): void;
    get channelsInput(): number | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _samplingRate?;
    get samplingRate(): number;
    set samplingRate(value: number);
    resetSamplingRate(): void;
    get samplingRateInput(): number | undefined;
}
export interface MediaTransformOutputCustomPresetCodecH264VideoLayer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#adaptive_b_frame_enabled MediaTransform#adaptive_b_frame_enabled}
    */
    readonly adaptiveBFrameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#b_frames MediaTransform#b_frames}
    */
    readonly bFrames?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#bitrate MediaTransform#bitrate}
    */
    readonly bitrate: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#buffer_window MediaTransform#buffer_window}
    */
    readonly bufferWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#crf MediaTransform#crf}
    */
    readonly crf?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#entropy_mode MediaTransform#entropy_mode}
    */
    readonly entropyMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#frame_rate MediaTransform#frame_rate}
    */
    readonly frameRate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#height MediaTransform#height}
    */
    readonly height?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#level MediaTransform#level}
    */
    readonly level?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#max_bitrate MediaTransform#max_bitrate}
    */
    readonly maxBitrate?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#profile MediaTransform#profile}
    */
    readonly profile?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#reference_frames MediaTransform#reference_frames}
    */
    readonly referenceFrames?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#slices MediaTransform#slices}
    */
    readonly slices?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#width MediaTransform#width}
    */
    readonly width?: string;
}
export declare function mediaTransformOutputCustomPresetCodecH264VideoLayerToTerraform(struct?: MediaTransformOutputCustomPresetCodecH264VideoLayer | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetCodecH264VideoLayerToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecH264VideoLayer | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetCodecH264VideoLayerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetCodecH264VideoLayer | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecH264VideoLayer | cdktf.IResolvable | undefined);
    private _adaptiveBFrameEnabled?;
    get adaptiveBFrameEnabled(): boolean | cdktf.IResolvable;
    set adaptiveBFrameEnabled(value: boolean | cdktf.IResolvable);
    resetAdaptiveBFrameEnabled(): void;
    get adaptiveBFrameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _bFrames?;
    get bFrames(): number;
    set bFrames(value: number);
    resetBFrames(): void;
    get bFramesInput(): number | undefined;
    private _bitrate?;
    get bitrate(): number;
    set bitrate(value: number);
    get bitrateInput(): number | undefined;
    private _bufferWindow?;
    get bufferWindow(): string;
    set bufferWindow(value: string);
    resetBufferWindow(): void;
    get bufferWindowInput(): string | undefined;
    private _crf?;
    get crf(): number;
    set crf(value: number);
    resetCrf(): void;
    get crfInput(): number | undefined;
    private _entropyMode?;
    get entropyMode(): string;
    set entropyMode(value: string);
    resetEntropyMode(): void;
    get entropyModeInput(): string | undefined;
    private _frameRate?;
    get frameRate(): string;
    set frameRate(value: string);
    resetFrameRate(): void;
    get frameRateInput(): string | undefined;
    private _height?;
    get height(): string;
    set height(value: string);
    resetHeight(): void;
    get heightInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _maxBitrate?;
    get maxBitrate(): number;
    set maxBitrate(value: number);
    resetMaxBitrate(): void;
    get maxBitrateInput(): number | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _referenceFrames?;
    get referenceFrames(): number;
    set referenceFrames(value: number);
    resetReferenceFrames(): void;
    get referenceFramesInput(): number | undefined;
    private _slices?;
    get slices(): number;
    set slices(value: number);
    resetSlices(): void;
    get slicesInput(): number | undefined;
    private _width?;
    get width(): string;
    set width(value: string);
    resetWidth(): void;
    get widthInput(): string | undefined;
}
export declare class MediaTransformOutputCustomPresetCodecH264VideoLayerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetCodecH264VideoLayer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetCodecH264VideoLayerOutputReference;
}
export interface MediaTransformOutputCustomPresetCodecH264Video {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#complexity MediaTransform#complexity}
    */
    readonly complexity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#key_frame_interval MediaTransform#key_frame_interval}
    */
    readonly keyFrameInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#rate_control_mode MediaTransform#rate_control_mode}
    */
    readonly rateControlMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#scene_change_detection_enabled MediaTransform#scene_change_detection_enabled}
    */
    readonly sceneChangeDetectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#stretch_mode MediaTransform#stretch_mode}
    */
    readonly stretchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#sync_mode MediaTransform#sync_mode}
    */
    readonly syncMode?: string;
    /**
    * layer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#layer MediaTransform#layer}
    */
    readonly layer?: MediaTransformOutputCustomPresetCodecH264VideoLayer[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetCodecH264VideoToTerraform(struct?: MediaTransformOutputCustomPresetCodecH264VideoOutputReference | MediaTransformOutputCustomPresetCodecH264Video): any;
export declare function mediaTransformOutputCustomPresetCodecH264VideoToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecH264VideoOutputReference | MediaTransformOutputCustomPresetCodecH264Video): any;
export declare class MediaTransformOutputCustomPresetCodecH264VideoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecH264Video | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecH264Video | undefined);
    private _complexity?;
    get complexity(): string;
    set complexity(value: string);
    resetComplexity(): void;
    get complexityInput(): string | undefined;
    private _keyFrameInterval?;
    get keyFrameInterval(): string;
    set keyFrameInterval(value: string);
    resetKeyFrameInterval(): void;
    get keyFrameIntervalInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _rateControlMode?;
    get rateControlMode(): string;
    set rateControlMode(value: string);
    resetRateControlMode(): void;
    get rateControlModeInput(): string | undefined;
    private _sceneChangeDetectionEnabled?;
    get sceneChangeDetectionEnabled(): boolean | cdktf.IResolvable;
    set sceneChangeDetectionEnabled(value: boolean | cdktf.IResolvable);
    resetSceneChangeDetectionEnabled(): void;
    get sceneChangeDetectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _stretchMode?;
    get stretchMode(): string;
    set stretchMode(value: string);
    resetStretchMode(): void;
    get stretchModeInput(): string | undefined;
    private _syncMode?;
    get syncMode(): string;
    set syncMode(value: string);
    resetSyncMode(): void;
    get syncModeInput(): string | undefined;
    private _layer;
    get layer(): MediaTransformOutputCustomPresetCodecH264VideoLayerList;
    putLayer(value: MediaTransformOutputCustomPresetCodecH264VideoLayer[] | cdktf.IResolvable): void;
    resetLayer(): void;
    get layerInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetCodecH264VideoLayer[] | undefined;
}
export interface MediaTransformOutputCustomPresetCodecH265VideoLayer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#adaptive_b_frame_enabled MediaTransform#adaptive_b_frame_enabled}
    */
    readonly adaptiveBFrameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#b_frames MediaTransform#b_frames}
    */
    readonly bFrames?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#bitrate MediaTransform#bitrate}
    */
    readonly bitrate: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#buffer_window MediaTransform#buffer_window}
    */
    readonly bufferWindow?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#crf MediaTransform#crf}
    */
    readonly crf?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#frame_rate MediaTransform#frame_rate}
    */
    readonly frameRate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#height MediaTransform#height}
    */
    readonly height?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#level MediaTransform#level}
    */
    readonly level?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#max_bitrate MediaTransform#max_bitrate}
    */
    readonly maxBitrate?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#profile MediaTransform#profile}
    */
    readonly profile?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#reference_frames MediaTransform#reference_frames}
    */
    readonly referenceFrames?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#slices MediaTransform#slices}
    */
    readonly slices?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#width MediaTransform#width}
    */
    readonly width?: string;
}
export declare function mediaTransformOutputCustomPresetCodecH265VideoLayerToTerraform(struct?: MediaTransformOutputCustomPresetCodecH265VideoLayer | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetCodecH265VideoLayerToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecH265VideoLayer | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetCodecH265VideoLayerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetCodecH265VideoLayer | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecH265VideoLayer | cdktf.IResolvable | undefined);
    private _adaptiveBFrameEnabled?;
    get adaptiveBFrameEnabled(): boolean | cdktf.IResolvable;
    set adaptiveBFrameEnabled(value: boolean | cdktf.IResolvable);
    resetAdaptiveBFrameEnabled(): void;
    get adaptiveBFrameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _bFrames?;
    get bFrames(): number;
    set bFrames(value: number);
    resetBFrames(): void;
    get bFramesInput(): number | undefined;
    private _bitrate?;
    get bitrate(): number;
    set bitrate(value: number);
    get bitrateInput(): number | undefined;
    private _bufferWindow?;
    get bufferWindow(): string;
    set bufferWindow(value: string);
    resetBufferWindow(): void;
    get bufferWindowInput(): string | undefined;
    private _crf?;
    get crf(): number;
    set crf(value: number);
    resetCrf(): void;
    get crfInput(): number | undefined;
    private _frameRate?;
    get frameRate(): string;
    set frameRate(value: string);
    resetFrameRate(): void;
    get frameRateInput(): string | undefined;
    private _height?;
    get height(): string;
    set height(value: string);
    resetHeight(): void;
    get heightInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _maxBitrate?;
    get maxBitrate(): number;
    set maxBitrate(value: number);
    resetMaxBitrate(): void;
    get maxBitrateInput(): number | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _referenceFrames?;
    get referenceFrames(): number;
    set referenceFrames(value: number);
    resetReferenceFrames(): void;
    get referenceFramesInput(): number | undefined;
    private _slices?;
    get slices(): number;
    set slices(value: number);
    resetSlices(): void;
    get slicesInput(): number | undefined;
    private _width?;
    get width(): string;
    set width(value: string);
    resetWidth(): void;
    get widthInput(): string | undefined;
}
export declare class MediaTransformOutputCustomPresetCodecH265VideoLayerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetCodecH265VideoLayer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetCodecH265VideoLayerOutputReference;
}
export interface MediaTransformOutputCustomPresetCodecH265Video {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#complexity MediaTransform#complexity}
    */
    readonly complexity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#key_frame_interval MediaTransform#key_frame_interval}
    */
    readonly keyFrameInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#scene_change_detection_enabled MediaTransform#scene_change_detection_enabled}
    */
    readonly sceneChangeDetectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#stretch_mode MediaTransform#stretch_mode}
    */
    readonly stretchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#sync_mode MediaTransform#sync_mode}
    */
    readonly syncMode?: string;
    /**
    * layer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#layer MediaTransform#layer}
    */
    readonly layer?: MediaTransformOutputCustomPresetCodecH265VideoLayer[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetCodecH265VideoToTerraform(struct?: MediaTransformOutputCustomPresetCodecH265VideoOutputReference | MediaTransformOutputCustomPresetCodecH265Video): any;
export declare function mediaTransformOutputCustomPresetCodecH265VideoToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecH265VideoOutputReference | MediaTransformOutputCustomPresetCodecH265Video): any;
export declare class MediaTransformOutputCustomPresetCodecH265VideoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecH265Video | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecH265Video | undefined);
    private _complexity?;
    get complexity(): string;
    set complexity(value: string);
    resetComplexity(): void;
    get complexityInput(): string | undefined;
    private _keyFrameInterval?;
    get keyFrameInterval(): string;
    set keyFrameInterval(value: string);
    resetKeyFrameInterval(): void;
    get keyFrameIntervalInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _sceneChangeDetectionEnabled?;
    get sceneChangeDetectionEnabled(): boolean | cdktf.IResolvable;
    set sceneChangeDetectionEnabled(value: boolean | cdktf.IResolvable);
    resetSceneChangeDetectionEnabled(): void;
    get sceneChangeDetectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _stretchMode?;
    get stretchMode(): string;
    set stretchMode(value: string);
    resetStretchMode(): void;
    get stretchModeInput(): string | undefined;
    private _syncMode?;
    get syncMode(): string;
    set syncMode(value: string);
    resetSyncMode(): void;
    get syncModeInput(): string | undefined;
    private _layer;
    get layer(): MediaTransformOutputCustomPresetCodecH265VideoLayerList;
    putLayer(value: MediaTransformOutputCustomPresetCodecH265VideoLayer[] | cdktf.IResolvable): void;
    resetLayer(): void;
    get layerInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetCodecH265VideoLayer[] | undefined;
}
export interface MediaTransformOutputCustomPresetCodecJpgImageLayer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#height MediaTransform#height}
    */
    readonly height?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#quality MediaTransform#quality}
    */
    readonly quality?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#width MediaTransform#width}
    */
    readonly width?: string;
}
export declare function mediaTransformOutputCustomPresetCodecJpgImageLayerToTerraform(struct?: MediaTransformOutputCustomPresetCodecJpgImageLayer | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetCodecJpgImageLayerToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecJpgImageLayer | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetCodecJpgImageLayerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetCodecJpgImageLayer | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecJpgImageLayer | cdktf.IResolvable | undefined);
    private _height?;
    get height(): string;
    set height(value: string);
    resetHeight(): void;
    get heightInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _quality?;
    get quality(): number;
    set quality(value: number);
    resetQuality(): void;
    get qualityInput(): number | undefined;
    private _width?;
    get width(): string;
    set width(value: string);
    resetWidth(): void;
    get widthInput(): string | undefined;
}
export declare class MediaTransformOutputCustomPresetCodecJpgImageLayerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetCodecJpgImageLayer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetCodecJpgImageLayerOutputReference;
}
export interface MediaTransformOutputCustomPresetCodecJpgImage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#key_frame_interval MediaTransform#key_frame_interval}
    */
    readonly keyFrameInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#range MediaTransform#range}
    */
    readonly range?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#sprite_column MediaTransform#sprite_column}
    */
    readonly spriteColumn?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#start MediaTransform#start}
    */
    readonly start: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#step MediaTransform#step}
    */
    readonly step?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#stretch_mode MediaTransform#stretch_mode}
    */
    readonly stretchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#sync_mode MediaTransform#sync_mode}
    */
    readonly syncMode?: string;
    /**
    * layer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#layer MediaTransform#layer}
    */
    readonly layer?: MediaTransformOutputCustomPresetCodecJpgImageLayer[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetCodecJpgImageToTerraform(struct?: MediaTransformOutputCustomPresetCodecJpgImageOutputReference | MediaTransformOutputCustomPresetCodecJpgImage): any;
export declare function mediaTransformOutputCustomPresetCodecJpgImageToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecJpgImageOutputReference | MediaTransformOutputCustomPresetCodecJpgImage): any;
export declare class MediaTransformOutputCustomPresetCodecJpgImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecJpgImage | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecJpgImage | undefined);
    private _keyFrameInterval?;
    get keyFrameInterval(): string;
    set keyFrameInterval(value: string);
    resetKeyFrameInterval(): void;
    get keyFrameIntervalInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _range?;
    get range(): string;
    set range(value: string);
    resetRange(): void;
    get rangeInput(): string | undefined;
    private _spriteColumn?;
    get spriteColumn(): number;
    set spriteColumn(value: number);
    resetSpriteColumn(): void;
    get spriteColumnInput(): number | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
    private _step?;
    get step(): string;
    set step(value: string);
    resetStep(): void;
    get stepInput(): string | undefined;
    private _stretchMode?;
    get stretchMode(): string;
    set stretchMode(value: string);
    resetStretchMode(): void;
    get stretchModeInput(): string | undefined;
    private _syncMode?;
    get syncMode(): string;
    set syncMode(value: string);
    resetSyncMode(): void;
    get syncModeInput(): string | undefined;
    private _layer;
    get layer(): MediaTransformOutputCustomPresetCodecJpgImageLayerList;
    putLayer(value: MediaTransformOutputCustomPresetCodecJpgImageLayer[] | cdktf.IResolvable): void;
    resetLayer(): void;
    get layerInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetCodecJpgImageLayer[] | undefined;
}
export interface MediaTransformOutputCustomPresetCodecPngImageLayer {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#height MediaTransform#height}
    */
    readonly height?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#width MediaTransform#width}
    */
    readonly width?: string;
}
export declare function mediaTransformOutputCustomPresetCodecPngImageLayerToTerraform(struct?: MediaTransformOutputCustomPresetCodecPngImageLayer | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetCodecPngImageLayerToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecPngImageLayer | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetCodecPngImageLayerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetCodecPngImageLayer | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecPngImageLayer | cdktf.IResolvable | undefined);
    private _height?;
    get height(): string;
    set height(value: string);
    resetHeight(): void;
    get heightInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _width?;
    get width(): string;
    set width(value: string);
    resetWidth(): void;
    get widthInput(): string | undefined;
}
export declare class MediaTransformOutputCustomPresetCodecPngImageLayerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetCodecPngImageLayer[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetCodecPngImageLayerOutputReference;
}
export interface MediaTransformOutputCustomPresetCodecPngImage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#key_frame_interval MediaTransform#key_frame_interval}
    */
    readonly keyFrameInterval?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#label MediaTransform#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#range MediaTransform#range}
    */
    readonly range?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#start MediaTransform#start}
    */
    readonly start: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#step MediaTransform#step}
    */
    readonly step?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#stretch_mode MediaTransform#stretch_mode}
    */
    readonly stretchMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#sync_mode MediaTransform#sync_mode}
    */
    readonly syncMode?: string;
    /**
    * layer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#layer MediaTransform#layer}
    */
    readonly layer?: MediaTransformOutputCustomPresetCodecPngImageLayer[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetCodecPngImageToTerraform(struct?: MediaTransformOutputCustomPresetCodecPngImageOutputReference | MediaTransformOutputCustomPresetCodecPngImage): any;
export declare function mediaTransformOutputCustomPresetCodecPngImageToHclTerraform(struct?: MediaTransformOutputCustomPresetCodecPngImageOutputReference | MediaTransformOutputCustomPresetCodecPngImage): any;
export declare class MediaTransformOutputCustomPresetCodecPngImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetCodecPngImage | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodecPngImage | undefined);
    private _keyFrameInterval?;
    get keyFrameInterval(): string;
    set keyFrameInterval(value: string);
    resetKeyFrameInterval(): void;
    get keyFrameIntervalInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _range?;
    get range(): string;
    set range(value: string);
    resetRange(): void;
    get rangeInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
    private _step?;
    get step(): string;
    set step(value: string);
    resetStep(): void;
    get stepInput(): string | undefined;
    private _stretchMode?;
    get stretchMode(): string;
    set stretchMode(value: string);
    resetStretchMode(): void;
    get stretchModeInput(): string | undefined;
    private _syncMode?;
    get syncMode(): string;
    set syncMode(value: string);
    resetSyncMode(): void;
    get syncModeInput(): string | undefined;
    private _layer;
    get layer(): MediaTransformOutputCustomPresetCodecPngImageLayerList;
    putLayer(value: MediaTransformOutputCustomPresetCodecPngImageLayer[] | cdktf.IResolvable): void;
    resetLayer(): void;
    get layerInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetCodecPngImageLayer[] | undefined;
}
export interface MediaTransformOutputCustomPresetCodec {
    /**
    * aac_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#aac_audio MediaTransform#aac_audio}
    */
    readonly aacAudio?: MediaTransformOutputCustomPresetCodecAacAudio;
    /**
    * copy_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#copy_audio MediaTransform#copy_audio}
    */
    readonly copyAudio?: MediaTransformOutputCustomPresetCodecCopyAudio;
    /**
    * copy_video block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#copy_video MediaTransform#copy_video}
    */
    readonly copyVideo?: MediaTransformOutputCustomPresetCodecCopyVideo;
    /**
    * dd_audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#dd_audio MediaTransform#dd_audio}
    */
    readonly ddAudio?: MediaTransformOutputCustomPresetCodecDdAudio;
    /**
    * h264_video block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#h264_video MediaTransform#h264_video}
    */
    readonly h264Video?: MediaTransformOutputCustomPresetCodecH264Video;
    /**
    * h265_video block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#h265_video MediaTransform#h265_video}
    */
    readonly h265Video?: MediaTransformOutputCustomPresetCodecH265Video;
    /**
    * jpg_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#jpg_image MediaTransform#jpg_image}
    */
    readonly jpgImage?: MediaTransformOutputCustomPresetCodecJpgImage;
    /**
    * png_image block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#png_image MediaTransform#png_image}
    */
    readonly pngImage?: MediaTransformOutputCustomPresetCodecPngImage;
}
export declare function mediaTransformOutputCustomPresetCodecToTerraform(struct?: MediaTransformOutputCustomPresetCodec | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetCodecToHclTerraform(struct?: MediaTransformOutputCustomPresetCodec | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetCodecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetCodec | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetCodec | cdktf.IResolvable | undefined);
    private _aacAudio;
    get aacAudio(): MediaTransformOutputCustomPresetCodecAacAudioOutputReference;
    putAacAudio(value: MediaTransformOutputCustomPresetCodecAacAudio): void;
    resetAacAudio(): void;
    get aacAudioInput(): MediaTransformOutputCustomPresetCodecAacAudio | undefined;
    private _copyAudio;
    get copyAudio(): MediaTransformOutputCustomPresetCodecCopyAudioOutputReference;
    putCopyAudio(value: MediaTransformOutputCustomPresetCodecCopyAudio): void;
    resetCopyAudio(): void;
    get copyAudioInput(): MediaTransformOutputCustomPresetCodecCopyAudio | undefined;
    private _copyVideo;
    get copyVideo(): MediaTransformOutputCustomPresetCodecCopyVideoOutputReference;
    putCopyVideo(value: MediaTransformOutputCustomPresetCodecCopyVideo): void;
    resetCopyVideo(): void;
    get copyVideoInput(): MediaTransformOutputCustomPresetCodecCopyVideo | undefined;
    private _ddAudio;
    get ddAudio(): MediaTransformOutputCustomPresetCodecDdAudioOutputReference;
    putDdAudio(value: MediaTransformOutputCustomPresetCodecDdAudio): void;
    resetDdAudio(): void;
    get ddAudioInput(): MediaTransformOutputCustomPresetCodecDdAudio | undefined;
    private _h264Video;
    get h264Video(): MediaTransformOutputCustomPresetCodecH264VideoOutputReference;
    putH264Video(value: MediaTransformOutputCustomPresetCodecH264Video): void;
    resetH264Video(): void;
    get h264VideoInput(): MediaTransformOutputCustomPresetCodecH264Video | undefined;
    private _h265Video;
    get h265Video(): MediaTransformOutputCustomPresetCodecH265VideoOutputReference;
    putH265Video(value: MediaTransformOutputCustomPresetCodecH265Video): void;
    resetH265Video(): void;
    get h265VideoInput(): MediaTransformOutputCustomPresetCodecH265Video | undefined;
    private _jpgImage;
    get jpgImage(): MediaTransformOutputCustomPresetCodecJpgImageOutputReference;
    putJpgImage(value: MediaTransformOutputCustomPresetCodecJpgImage): void;
    resetJpgImage(): void;
    get jpgImageInput(): MediaTransformOutputCustomPresetCodecJpgImage | undefined;
    private _pngImage;
    get pngImage(): MediaTransformOutputCustomPresetCodecPngImageOutputReference;
    putPngImage(value: MediaTransformOutputCustomPresetCodecPngImage): void;
    resetPngImage(): void;
    get pngImageInput(): MediaTransformOutputCustomPresetCodecPngImage | undefined;
}
export declare class MediaTransformOutputCustomPresetCodecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetCodec[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetCodecOutputReference;
}
export interface MediaTransformOutputCustomPresetFilterCropRectangle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#height MediaTransform#height}
    */
    readonly height?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#left MediaTransform#left}
    */
    readonly left?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#top MediaTransform#top}
    */
    readonly top?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#width MediaTransform#width}
    */
    readonly width?: string;
}
export declare function mediaTransformOutputCustomPresetFilterCropRectangleToTerraform(struct?: MediaTransformOutputCustomPresetFilterCropRectangleOutputReference | MediaTransformOutputCustomPresetFilterCropRectangle): any;
export declare function mediaTransformOutputCustomPresetFilterCropRectangleToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterCropRectangleOutputReference | MediaTransformOutputCustomPresetFilterCropRectangle): any;
export declare class MediaTransformOutputCustomPresetFilterCropRectangleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterCropRectangle | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterCropRectangle | undefined);
    private _height?;
    get height(): string;
    set height(value: string);
    resetHeight(): void;
    get heightInput(): string | undefined;
    private _left?;
    get left(): string;
    set left(value: string);
    resetLeft(): void;
    get leftInput(): string | undefined;
    private _top?;
    get top(): string;
    set top(value: string);
    resetTop(): void;
    get topInput(): string | undefined;
    private _width?;
    get width(): string;
    set width(value: string);
    resetWidth(): void;
    get widthInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFilterDeinterlace {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#mode MediaTransform#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#parity MediaTransform#parity}
    */
    readonly parity?: string;
}
export declare function mediaTransformOutputCustomPresetFilterDeinterlaceToTerraform(struct?: MediaTransformOutputCustomPresetFilterDeinterlaceOutputReference | MediaTransformOutputCustomPresetFilterDeinterlace): any;
export declare function mediaTransformOutputCustomPresetFilterDeinterlaceToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterDeinterlaceOutputReference | MediaTransformOutputCustomPresetFilterDeinterlace): any;
export declare class MediaTransformOutputCustomPresetFilterDeinterlaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterDeinterlace | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterDeinterlace | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _parity?;
    get parity(): string;
    set parity(value: string);
    resetParity(): void;
    get parityInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFilterFadeIn {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#duration MediaTransform#duration}
    */
    readonly duration: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_color MediaTransform#fade_color}
    */
    readonly fadeColor: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#start MediaTransform#start}
    */
    readonly start?: string;
}
export declare function mediaTransformOutputCustomPresetFilterFadeInToTerraform(struct?: MediaTransformOutputCustomPresetFilterFadeInOutputReference | MediaTransformOutputCustomPresetFilterFadeIn): any;
export declare function mediaTransformOutputCustomPresetFilterFadeInToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterFadeInOutputReference | MediaTransformOutputCustomPresetFilterFadeIn): any;
export declare class MediaTransformOutputCustomPresetFilterFadeInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterFadeIn | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterFadeIn | undefined);
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _fadeColor?;
    get fadeColor(): string;
    set fadeColor(value: string);
    get fadeColorInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFilterFadeOut {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#duration MediaTransform#duration}
    */
    readonly duration: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_color MediaTransform#fade_color}
    */
    readonly fadeColor: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#start MediaTransform#start}
    */
    readonly start?: string;
}
export declare function mediaTransformOutputCustomPresetFilterFadeOutToTerraform(struct?: MediaTransformOutputCustomPresetFilterFadeOutOutputReference | MediaTransformOutputCustomPresetFilterFadeOut): any;
export declare function mediaTransformOutputCustomPresetFilterFadeOutToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterFadeOutOutputReference | MediaTransformOutputCustomPresetFilterFadeOut): any;
export declare class MediaTransformOutputCustomPresetFilterFadeOutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterFadeOut | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterFadeOut | undefined);
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _fadeColor?;
    get fadeColor(): string;
    set fadeColor(value: string);
    get fadeColorInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFilterOverlayAudio {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio_gain_level MediaTransform#audio_gain_level}
    */
    readonly audioGainLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#end MediaTransform#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_in_duration MediaTransform#fade_in_duration}
    */
    readonly fadeInDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_out_duration MediaTransform#fade_out_duration}
    */
    readonly fadeOutDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#input_label MediaTransform#input_label}
    */
    readonly inputLabel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#start MediaTransform#start}
    */
    readonly start?: string;
}
export declare function mediaTransformOutputCustomPresetFilterOverlayAudioToTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayAudioOutputReference | MediaTransformOutputCustomPresetFilterOverlayAudio): any;
export declare function mediaTransformOutputCustomPresetFilterOverlayAudioToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayAudioOutputReference | MediaTransformOutputCustomPresetFilterOverlayAudio): any;
export declare class MediaTransformOutputCustomPresetFilterOverlayAudioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterOverlayAudio | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterOverlayAudio | undefined);
    private _audioGainLevel?;
    get audioGainLevel(): number;
    set audioGainLevel(value: number);
    resetAudioGainLevel(): void;
    get audioGainLevelInput(): number | undefined;
    private _end?;
    get end(): string;
    set end(value: string);
    resetEnd(): void;
    get endInput(): string | undefined;
    private _fadeInDuration?;
    get fadeInDuration(): string;
    set fadeInDuration(value: string);
    resetFadeInDuration(): void;
    get fadeInDurationInput(): string | undefined;
    private _fadeOutDuration?;
    get fadeOutDuration(): string;
    set fadeOutDuration(value: string);
    resetFadeOutDuration(): void;
    get fadeOutDurationInput(): string | undefined;
    private _inputLabel?;
    get inputLabel(): string;
    set inputLabel(value: string);
    get inputLabelInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#height MediaTransform#height}
    */
    readonly height?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#left MediaTransform#left}
    */
    readonly left?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#top MediaTransform#top}
    */
    readonly top?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#width MediaTransform#width}
    */
    readonly width?: string;
}
export declare function mediaTransformOutputCustomPresetFilterOverlayVideoCropRectangleToTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangleOutputReference | MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle): any;
export declare function mediaTransformOutputCustomPresetFilterOverlayVideoCropRectangleToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangleOutputReference | MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle): any;
export declare class MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle | undefined);
    private _height?;
    get height(): string;
    set height(value: string);
    resetHeight(): void;
    get heightInput(): string | undefined;
    private _left?;
    get left(): string;
    set left(value: string);
    resetLeft(): void;
    get leftInput(): string | undefined;
    private _top?;
    get top(): string;
    set top(value: string);
    resetTop(): void;
    get topInput(): string | undefined;
    private _width?;
    get width(): string;
    set width(value: string);
    resetWidth(): void;
    get widthInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFilterOverlayVideoPosition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#height MediaTransform#height}
    */
    readonly height?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#left MediaTransform#left}
    */
    readonly left?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#top MediaTransform#top}
    */
    readonly top?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#width MediaTransform#width}
    */
    readonly width?: string;
}
export declare function mediaTransformOutputCustomPresetFilterOverlayVideoPositionToTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayVideoPositionOutputReference | MediaTransformOutputCustomPresetFilterOverlayVideoPosition): any;
export declare function mediaTransformOutputCustomPresetFilterOverlayVideoPositionToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayVideoPositionOutputReference | MediaTransformOutputCustomPresetFilterOverlayVideoPosition): any;
export declare class MediaTransformOutputCustomPresetFilterOverlayVideoPositionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterOverlayVideoPosition | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterOverlayVideoPosition | undefined);
    private _height?;
    get height(): string;
    set height(value: string);
    resetHeight(): void;
    get heightInput(): string | undefined;
    private _left?;
    get left(): string;
    set left(value: string);
    resetLeft(): void;
    get leftInput(): string | undefined;
    private _top?;
    get top(): string;
    set top(value: string);
    resetTop(): void;
    get topInput(): string | undefined;
    private _width?;
    get width(): string;
    set width(value: string);
    resetWidth(): void;
    get widthInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFilterOverlayVideo {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio_gain_level MediaTransform#audio_gain_level}
    */
    readonly audioGainLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#end MediaTransform#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_in_duration MediaTransform#fade_in_duration}
    */
    readonly fadeInDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_out_duration MediaTransform#fade_out_duration}
    */
    readonly fadeOutDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#input_label MediaTransform#input_label}
    */
    readonly inputLabel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#opacity MediaTransform#opacity}
    */
    readonly opacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#start MediaTransform#start}
    */
    readonly start?: string;
    /**
    * crop_rectangle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#crop_rectangle MediaTransform#crop_rectangle}
    */
    readonly cropRectangle?: MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle;
    /**
    * position block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#position MediaTransform#position}
    */
    readonly position?: MediaTransformOutputCustomPresetFilterOverlayVideoPosition;
}
export declare function mediaTransformOutputCustomPresetFilterOverlayVideoToTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayVideoOutputReference | MediaTransformOutputCustomPresetFilterOverlayVideo): any;
export declare function mediaTransformOutputCustomPresetFilterOverlayVideoToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlayVideoOutputReference | MediaTransformOutputCustomPresetFilterOverlayVideo): any;
export declare class MediaTransformOutputCustomPresetFilterOverlayVideoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilterOverlayVideo | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterOverlayVideo | undefined);
    private _audioGainLevel?;
    get audioGainLevel(): number;
    set audioGainLevel(value: number);
    resetAudioGainLevel(): void;
    get audioGainLevelInput(): number | undefined;
    private _end?;
    get end(): string;
    set end(value: string);
    resetEnd(): void;
    get endInput(): string | undefined;
    private _fadeInDuration?;
    get fadeInDuration(): string;
    set fadeInDuration(value: string);
    resetFadeInDuration(): void;
    get fadeInDurationInput(): string | undefined;
    private _fadeOutDuration?;
    get fadeOutDuration(): string;
    set fadeOutDuration(value: string);
    resetFadeOutDuration(): void;
    get fadeOutDurationInput(): string | undefined;
    private _inputLabel?;
    get inputLabel(): string;
    set inputLabel(value: string);
    get inputLabelInput(): string | undefined;
    private _opacity?;
    get opacity(): number;
    set opacity(value: number);
    resetOpacity(): void;
    get opacityInput(): number | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
    private _cropRectangle;
    get cropRectangle(): MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangleOutputReference;
    putCropRectangle(value: MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle): void;
    resetCropRectangle(): void;
    get cropRectangleInput(): MediaTransformOutputCustomPresetFilterOverlayVideoCropRectangle | undefined;
    private _position;
    get position(): MediaTransformOutputCustomPresetFilterOverlayVideoPositionOutputReference;
    putPosition(value: MediaTransformOutputCustomPresetFilterOverlayVideoPosition): void;
    resetPosition(): void;
    get positionInput(): MediaTransformOutputCustomPresetFilterOverlayVideoPosition | undefined;
}
export interface MediaTransformOutputCustomPresetFilterOverlay {
    /**
    * audio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio MediaTransform#audio}
    */
    readonly audio?: MediaTransformOutputCustomPresetFilterOverlayAudio;
    /**
    * video block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#video MediaTransform#video}
    */
    readonly video?: MediaTransformOutputCustomPresetFilterOverlayVideo;
}
export declare function mediaTransformOutputCustomPresetFilterOverlayToTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlay | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetFilterOverlayToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterOverlay | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetFilterOverlayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetFilterOverlay | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilterOverlay | cdktf.IResolvable | undefined);
    private _audio;
    get audio(): MediaTransformOutputCustomPresetFilterOverlayAudioOutputReference;
    putAudio(value: MediaTransformOutputCustomPresetFilterOverlayAudio): void;
    resetAudio(): void;
    get audioInput(): MediaTransformOutputCustomPresetFilterOverlayAudio | undefined;
    private _video;
    get video(): MediaTransformOutputCustomPresetFilterOverlayVideoOutputReference;
    putVideo(value: MediaTransformOutputCustomPresetFilterOverlayVideo): void;
    resetVideo(): void;
    get videoInput(): MediaTransformOutputCustomPresetFilterOverlayVideo | undefined;
}
export declare class MediaTransformOutputCustomPresetFilterOverlayList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetFilterOverlay[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetFilterOverlayOutputReference;
}
export interface MediaTransformOutputCustomPresetFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#rotation MediaTransform#rotation}
    */
    readonly rotation?: string;
    /**
    * crop_rectangle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#crop_rectangle MediaTransform#crop_rectangle}
    */
    readonly cropRectangle?: MediaTransformOutputCustomPresetFilterCropRectangle;
    /**
    * deinterlace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#deinterlace MediaTransform#deinterlace}
    */
    readonly deinterlace?: MediaTransformOutputCustomPresetFilterDeinterlace;
    /**
    * fade_in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_in MediaTransform#fade_in}
    */
    readonly fadeIn?: MediaTransformOutputCustomPresetFilterFadeIn;
    /**
    * fade_out block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#fade_out MediaTransform#fade_out}
    */
    readonly fadeOut?: MediaTransformOutputCustomPresetFilterFadeOut;
    /**
    * overlay block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#overlay MediaTransform#overlay}
    */
    readonly overlay?: MediaTransformOutputCustomPresetFilterOverlay[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetFilterToTerraform(struct?: MediaTransformOutputCustomPresetFilterOutputReference | MediaTransformOutputCustomPresetFilter): any;
export declare function mediaTransformOutputCustomPresetFilterToHclTerraform(struct?: MediaTransformOutputCustomPresetFilterOutputReference | MediaTransformOutputCustomPresetFilter): any;
export declare class MediaTransformOutputCustomPresetFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFilter | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFilter | undefined);
    private _rotation?;
    get rotation(): string;
    set rotation(value: string);
    resetRotation(): void;
    get rotationInput(): string | undefined;
    private _cropRectangle;
    get cropRectangle(): MediaTransformOutputCustomPresetFilterCropRectangleOutputReference;
    putCropRectangle(value: MediaTransformOutputCustomPresetFilterCropRectangle): void;
    resetCropRectangle(): void;
    get cropRectangleInput(): MediaTransformOutputCustomPresetFilterCropRectangle | undefined;
    private _deinterlace;
    get deinterlace(): MediaTransformOutputCustomPresetFilterDeinterlaceOutputReference;
    putDeinterlace(value: MediaTransformOutputCustomPresetFilterDeinterlace): void;
    resetDeinterlace(): void;
    get deinterlaceInput(): MediaTransformOutputCustomPresetFilterDeinterlace | undefined;
    private _fadeIn;
    get fadeIn(): MediaTransformOutputCustomPresetFilterFadeInOutputReference;
    putFadeIn(value: MediaTransformOutputCustomPresetFilterFadeIn): void;
    resetFadeIn(): void;
    get fadeInInput(): MediaTransformOutputCustomPresetFilterFadeIn | undefined;
    private _fadeOut;
    get fadeOut(): MediaTransformOutputCustomPresetFilterFadeOutOutputReference;
    putFadeOut(value: MediaTransformOutputCustomPresetFilterFadeOut): void;
    resetFadeOut(): void;
    get fadeOutInput(): MediaTransformOutputCustomPresetFilterFadeOut | undefined;
    private _overlay;
    get overlay(): MediaTransformOutputCustomPresetFilterOverlayList;
    putOverlay(value: MediaTransformOutputCustomPresetFilterOverlay[] | cdktf.IResolvable): void;
    resetOverlay(): void;
    get overlayInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetFilterOverlay[] | undefined;
}
export interface MediaTransformOutputCustomPresetFormatJpg {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#filename_pattern MediaTransform#filename_pattern}
    */
    readonly filenamePattern: string;
}
export declare function mediaTransformOutputCustomPresetFormatJpgToTerraform(struct?: MediaTransformOutputCustomPresetFormatJpgOutputReference | MediaTransformOutputCustomPresetFormatJpg): any;
export declare function mediaTransformOutputCustomPresetFormatJpgToHclTerraform(struct?: MediaTransformOutputCustomPresetFormatJpgOutputReference | MediaTransformOutputCustomPresetFormatJpg): any;
export declare class MediaTransformOutputCustomPresetFormatJpgOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFormatJpg | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFormatJpg | undefined);
    private _filenamePattern?;
    get filenamePattern(): string;
    set filenamePattern(value: string);
    get filenamePatternInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFormatMp4OutputFile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#labels MediaTransform#labels}
    */
    readonly labels: string[];
}
export declare function mediaTransformOutputCustomPresetFormatMp4OutputFileToTerraform(struct?: MediaTransformOutputCustomPresetFormatMp4OutputFile | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetFormatMp4OutputFileToHclTerraform(struct?: MediaTransformOutputCustomPresetFormatMp4OutputFile | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetFormatMp4OutputFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetFormatMp4OutputFile | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFormatMp4OutputFile | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    get labelsInput(): string[] | undefined;
}
export declare class MediaTransformOutputCustomPresetFormatMp4OutputFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetFormatMp4OutputFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetFormatMp4OutputFileOutputReference;
}
export interface MediaTransformOutputCustomPresetFormatMp4 {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#filename_pattern MediaTransform#filename_pattern}
    */
    readonly filenamePattern: string;
    /**
    * output_file block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#output_file MediaTransform#output_file}
    */
    readonly outputFile?: MediaTransformOutputCustomPresetFormatMp4OutputFile[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetFormatMp4ToTerraform(struct?: MediaTransformOutputCustomPresetFormatMp4OutputReference | MediaTransformOutputCustomPresetFormatMp4): any;
export declare function mediaTransformOutputCustomPresetFormatMp4ToHclTerraform(struct?: MediaTransformOutputCustomPresetFormatMp4OutputReference | MediaTransformOutputCustomPresetFormatMp4): any;
export declare class MediaTransformOutputCustomPresetFormatMp4OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFormatMp4 | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFormatMp4 | undefined);
    private _filenamePattern?;
    get filenamePattern(): string;
    set filenamePattern(value: string);
    get filenamePatternInput(): string | undefined;
    private _outputFile;
    get outputFile(): MediaTransformOutputCustomPresetFormatMp4OutputFileList;
    putOutputFile(value: MediaTransformOutputCustomPresetFormatMp4OutputFile[] | cdktf.IResolvable): void;
    resetOutputFile(): void;
    get outputFileInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetFormatMp4OutputFile[] | undefined;
}
export interface MediaTransformOutputCustomPresetFormatPng {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#filename_pattern MediaTransform#filename_pattern}
    */
    readonly filenamePattern: string;
}
export declare function mediaTransformOutputCustomPresetFormatPngToTerraform(struct?: MediaTransformOutputCustomPresetFormatPngOutputReference | MediaTransformOutputCustomPresetFormatPng): any;
export declare function mediaTransformOutputCustomPresetFormatPngToHclTerraform(struct?: MediaTransformOutputCustomPresetFormatPngOutputReference | MediaTransformOutputCustomPresetFormatPng): any;
export declare class MediaTransformOutputCustomPresetFormatPngOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFormatPng | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFormatPng | undefined);
    private _filenamePattern?;
    get filenamePattern(): string;
    set filenamePattern(value: string);
    get filenamePatternInput(): string | undefined;
}
export interface MediaTransformOutputCustomPresetFormatTransportStreamOutputFile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#labels MediaTransform#labels}
    */
    readonly labels: string[];
}
export declare function mediaTransformOutputCustomPresetFormatTransportStreamOutputFileToTerraform(struct?: MediaTransformOutputCustomPresetFormatTransportStreamOutputFile | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetFormatTransportStreamOutputFileToHclTerraform(struct?: MediaTransformOutputCustomPresetFormatTransportStreamOutputFile | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetFormatTransportStreamOutputFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetFormatTransportStreamOutputFile | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFormatTransportStreamOutputFile | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    get labelsInput(): string[] | undefined;
}
export declare class MediaTransformOutputCustomPresetFormatTransportStreamOutputFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetFormatTransportStreamOutputFile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetFormatTransportStreamOutputFileOutputReference;
}
export interface MediaTransformOutputCustomPresetFormatTransportStream {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#filename_pattern MediaTransform#filename_pattern}
    */
    readonly filenamePattern: string;
    /**
    * output_file block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#output_file MediaTransform#output_file}
    */
    readonly outputFile?: MediaTransformOutputCustomPresetFormatTransportStreamOutputFile[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetFormatTransportStreamToTerraform(struct?: MediaTransformOutputCustomPresetFormatTransportStreamOutputReference | MediaTransformOutputCustomPresetFormatTransportStream): any;
export declare function mediaTransformOutputCustomPresetFormatTransportStreamToHclTerraform(struct?: MediaTransformOutputCustomPresetFormatTransportStreamOutputReference | MediaTransformOutputCustomPresetFormatTransportStream): any;
export declare class MediaTransformOutputCustomPresetFormatTransportStreamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPresetFormatTransportStream | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFormatTransportStream | undefined);
    private _filenamePattern?;
    get filenamePattern(): string;
    set filenamePattern(value: string);
    get filenamePatternInput(): string | undefined;
    private _outputFile;
    get outputFile(): MediaTransformOutputCustomPresetFormatTransportStreamOutputFileList;
    putOutputFile(value: MediaTransformOutputCustomPresetFormatTransportStreamOutputFile[] | cdktf.IResolvable): void;
    resetOutputFile(): void;
    get outputFileInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetFormatTransportStreamOutputFile[] | undefined;
}
export interface MediaTransformOutputCustomPresetFormat {
    /**
    * jpg block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#jpg MediaTransform#jpg}
    */
    readonly jpg?: MediaTransformOutputCustomPresetFormatJpg;
    /**
    * mp4 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#mp4 MediaTransform#mp4}
    */
    readonly mp4?: MediaTransformOutputCustomPresetFormatMp4;
    /**
    * png block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#png MediaTransform#png}
    */
    readonly png?: MediaTransformOutputCustomPresetFormatPng;
    /**
    * transport_stream block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#transport_stream MediaTransform#transport_stream}
    */
    readonly transportStream?: MediaTransformOutputCustomPresetFormatTransportStream;
}
export declare function mediaTransformOutputCustomPresetFormatToTerraform(struct?: MediaTransformOutputCustomPresetFormat | cdktf.IResolvable): any;
export declare function mediaTransformOutputCustomPresetFormatToHclTerraform(struct?: MediaTransformOutputCustomPresetFormat | cdktf.IResolvable): any;
export declare class MediaTransformOutputCustomPresetFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutputCustomPresetFormat | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutputCustomPresetFormat | cdktf.IResolvable | undefined);
    private _jpg;
    get jpg(): MediaTransformOutputCustomPresetFormatJpgOutputReference;
    putJpg(value: MediaTransformOutputCustomPresetFormatJpg): void;
    resetJpg(): void;
    get jpgInput(): MediaTransformOutputCustomPresetFormatJpg | undefined;
    private _mp4;
    get mp4(): MediaTransformOutputCustomPresetFormatMp4OutputReference;
    putMp4(value: MediaTransformOutputCustomPresetFormatMp4): void;
    resetMp4(): void;
    get mp4Input(): MediaTransformOutputCustomPresetFormatMp4 | undefined;
    private _png;
    get png(): MediaTransformOutputCustomPresetFormatPngOutputReference;
    putPng(value: MediaTransformOutputCustomPresetFormatPng): void;
    resetPng(): void;
    get pngInput(): MediaTransformOutputCustomPresetFormatPng | undefined;
    private _transportStream;
    get transportStream(): MediaTransformOutputCustomPresetFormatTransportStreamOutputReference;
    putTransportStream(value: MediaTransformOutputCustomPresetFormatTransportStream): void;
    resetTransportStream(): void;
    get transportStreamInput(): MediaTransformOutputCustomPresetFormatTransportStream | undefined;
}
export declare class MediaTransformOutputCustomPresetFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutputCustomPresetFormat[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputCustomPresetFormatOutputReference;
}
export interface MediaTransformOutputCustomPreset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#experimental_options MediaTransform#experimental_options}
    */
    readonly experimentalOptions?: {
        [key: string]: string;
    };
    /**
    * codec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#codec MediaTransform#codec}
    */
    readonly codec: MediaTransformOutputCustomPresetCodec[] | cdktf.IResolvable;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#filter MediaTransform#filter}
    */
    readonly filter?: MediaTransformOutputCustomPresetFilter;
    /**
    * format block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#format MediaTransform#format}
    */
    readonly format: MediaTransformOutputCustomPresetFormat[] | cdktf.IResolvable;
}
export declare function mediaTransformOutputCustomPresetToTerraform(struct?: MediaTransformOutputCustomPresetOutputReference | MediaTransformOutputCustomPreset): any;
export declare function mediaTransformOutputCustomPresetToHclTerraform(struct?: MediaTransformOutputCustomPresetOutputReference | MediaTransformOutputCustomPreset): any;
export declare class MediaTransformOutputCustomPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputCustomPreset | undefined;
    set internalValue(value: MediaTransformOutputCustomPreset | undefined);
    private _experimentalOptions?;
    get experimentalOptions(): {
        [key: string]: string;
    };
    set experimentalOptions(value: {
        [key: string]: string;
    });
    resetExperimentalOptions(): void;
    get experimentalOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _codec;
    get codec(): MediaTransformOutputCustomPresetCodecList;
    putCodec(value: MediaTransformOutputCustomPresetCodec[] | cdktf.IResolvable): void;
    get codecInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetCodec[] | undefined;
    private _filter;
    get filter(): MediaTransformOutputCustomPresetFilterOutputReference;
    putFilter(value: MediaTransformOutputCustomPresetFilter): void;
    resetFilter(): void;
    get filterInput(): MediaTransformOutputCustomPresetFilter | undefined;
    private _format;
    get format(): MediaTransformOutputCustomPresetFormatList;
    putFormat(value: MediaTransformOutputCustomPresetFormat[] | cdktf.IResolvable): void;
    get formatInput(): cdktf.IResolvable | MediaTransformOutputCustomPresetFormat[] | undefined;
}
export interface MediaTransformOutputFaceDetectorPreset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#analysis_resolution MediaTransform#analysis_resolution}
    */
    readonly analysisResolution?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#blur_type MediaTransform#blur_type}
    */
    readonly blurType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#experimental_options MediaTransform#experimental_options}
    */
    readonly experimentalOptions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#face_redactor_mode MediaTransform#face_redactor_mode}
    */
    readonly faceRedactorMode?: string;
}
export declare function mediaTransformOutputFaceDetectorPresetToTerraform(struct?: MediaTransformOutputFaceDetectorPresetOutputReference | MediaTransformOutputFaceDetectorPreset): any;
export declare function mediaTransformOutputFaceDetectorPresetToHclTerraform(struct?: MediaTransformOutputFaceDetectorPresetOutputReference | MediaTransformOutputFaceDetectorPreset): any;
export declare class MediaTransformOutputFaceDetectorPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputFaceDetectorPreset | undefined;
    set internalValue(value: MediaTransformOutputFaceDetectorPreset | undefined);
    private _analysisResolution?;
    get analysisResolution(): string;
    set analysisResolution(value: string);
    resetAnalysisResolution(): void;
    get analysisResolutionInput(): string | undefined;
    private _blurType?;
    get blurType(): string;
    set blurType(value: string);
    resetBlurType(): void;
    get blurTypeInput(): string | undefined;
    private _experimentalOptions?;
    get experimentalOptions(): {
        [key: string]: string;
    };
    set experimentalOptions(value: {
        [key: string]: string;
    });
    resetExperimentalOptions(): void;
    get experimentalOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _faceRedactorMode?;
    get faceRedactorMode(): string;
    set faceRedactorMode(value: string);
    resetFaceRedactorMode(): void;
    get faceRedactorModeInput(): string | undefined;
}
export interface MediaTransformOutputVideoAnalyzerPreset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio_analysis_mode MediaTransform#audio_analysis_mode}
    */
    readonly audioAnalysisMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio_language MediaTransform#audio_language}
    */
    readonly audioLanguage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#experimental_options MediaTransform#experimental_options}
    */
    readonly experimentalOptions?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#insights_type MediaTransform#insights_type}
    */
    readonly insightsType?: string;
}
export declare function mediaTransformOutputVideoAnalyzerPresetToTerraform(struct?: MediaTransformOutputVideoAnalyzerPresetOutputReference | MediaTransformOutputVideoAnalyzerPreset): any;
export declare function mediaTransformOutputVideoAnalyzerPresetToHclTerraform(struct?: MediaTransformOutputVideoAnalyzerPresetOutputReference | MediaTransformOutputVideoAnalyzerPreset): any;
export declare class MediaTransformOutputVideoAnalyzerPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputVideoAnalyzerPreset | undefined;
    set internalValue(value: MediaTransformOutputVideoAnalyzerPreset | undefined);
    private _audioAnalysisMode?;
    get audioAnalysisMode(): string;
    set audioAnalysisMode(value: string);
    resetAudioAnalysisMode(): void;
    get audioAnalysisModeInput(): string | undefined;
    private _audioLanguage?;
    get audioLanguage(): string;
    set audioLanguage(value: string);
    resetAudioLanguage(): void;
    get audioLanguageInput(): string | undefined;
    private _experimentalOptions?;
    get experimentalOptions(): {
        [key: string]: string;
    };
    set experimentalOptions(value: {
        [key: string]: string;
    });
    resetExperimentalOptions(): void;
    get experimentalOptionsInput(): {
        [key: string]: string;
    } | undefined;
    private _insightsType?;
    get insightsType(): string;
    set insightsType(value: string);
    resetInsightsType(): void;
    get insightsTypeInput(): string | undefined;
}
export interface MediaTransformOutput {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#on_error_action MediaTransform#on_error_action}
    */
    readonly onErrorAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#relative_priority MediaTransform#relative_priority}
    */
    readonly relativePriority?: string;
    /**
    * audio_analyzer_preset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#audio_analyzer_preset MediaTransform#audio_analyzer_preset}
    */
    readonly audioAnalyzerPreset?: MediaTransformOutputAudioAnalyzerPreset;
    /**
    * builtin_preset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#builtin_preset MediaTransform#builtin_preset}
    */
    readonly builtinPreset?: MediaTransformOutputBuiltinPreset;
    /**
    * custom_preset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#custom_preset MediaTransform#custom_preset}
    */
    readonly customPreset?: MediaTransformOutputCustomPreset;
    /**
    * face_detector_preset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#face_detector_preset MediaTransform#face_detector_preset}
    */
    readonly faceDetectorPreset?: MediaTransformOutputFaceDetectorPreset;
    /**
    * video_analyzer_preset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#video_analyzer_preset MediaTransform#video_analyzer_preset}
    */
    readonly videoAnalyzerPreset?: MediaTransformOutputVideoAnalyzerPreset;
}
export declare function mediaTransformOutputToTerraform(struct?: MediaTransformOutput | cdktf.IResolvable): any;
export declare function mediaTransformOutputToHclTerraform(struct?: MediaTransformOutput | cdktf.IResolvable): any;
export declare class MediaTransformOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutput | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutput | cdktf.IResolvable | undefined);
    private _onErrorAction?;
    get onErrorAction(): string;
    set onErrorAction(value: string);
    resetOnErrorAction(): void;
    get onErrorActionInput(): string | undefined;
    private _relativePriority?;
    get relativePriority(): string;
    set relativePriority(value: string);
    resetRelativePriority(): void;
    get relativePriorityInput(): string | undefined;
    private _audioAnalyzerPreset;
    get audioAnalyzerPreset(): MediaTransformOutputAudioAnalyzerPresetOutputReference;
    putAudioAnalyzerPreset(value: MediaTransformOutputAudioAnalyzerPreset): void;
    resetAudioAnalyzerPreset(): void;
    get audioAnalyzerPresetInput(): MediaTransformOutputAudioAnalyzerPreset | undefined;
    private _builtinPreset;
    get builtinPreset(): MediaTransformOutputBuiltinPresetOutputReference;
    putBuiltinPreset(value: MediaTransformOutputBuiltinPreset): void;
    resetBuiltinPreset(): void;
    get builtinPresetInput(): MediaTransformOutputBuiltinPreset | undefined;
    private _customPreset;
    get customPreset(): MediaTransformOutputCustomPresetOutputReference;
    putCustomPreset(value: MediaTransformOutputCustomPreset): void;
    resetCustomPreset(): void;
    get customPresetInput(): MediaTransformOutputCustomPreset | undefined;
    private _faceDetectorPreset;
    get faceDetectorPreset(): MediaTransformOutputFaceDetectorPresetOutputReference;
    putFaceDetectorPreset(value: MediaTransformOutputFaceDetectorPreset): void;
    resetFaceDetectorPreset(): void;
    get faceDetectorPresetInput(): MediaTransformOutputFaceDetectorPreset | undefined;
    private _videoAnalyzerPreset;
    get videoAnalyzerPreset(): MediaTransformOutputVideoAnalyzerPresetOutputReference;
    putVideoAnalyzerPreset(value: MediaTransformOutputVideoAnalyzerPreset): void;
    resetVideoAnalyzerPreset(): void;
    get videoAnalyzerPresetInput(): MediaTransformOutputVideoAnalyzerPreset | undefined;
}
export declare class MediaTransformOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutput[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputOutputReference;
}
export interface MediaTransformTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#create MediaTransform#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#delete MediaTransform#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#read MediaTransform#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#update MediaTransform#update}
    */
    readonly update?: string;
}
export declare function mediaTransformTimeoutsToTerraform(struct?: MediaTransformTimeouts | cdktf.IResolvable): any;
export declare function mediaTransformTimeoutsToHclTerraform(struct?: MediaTransformTimeouts | cdktf.IResolvable): any;
export declare class MediaTransformTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform azurerm_media_transform}
*/
export declare class MediaTransform extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_transform";
    /**
    * Generates CDKTF code for importing a MediaTransform resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaTransform to import
    * @param importFromId The id of the existing MediaTransform that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaTransform to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/media_transform azurerm_media_transform} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaTransformConfig
    */
    constructor(scope: Construct, id: string, config: MediaTransformConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _output;
    get output(): MediaTransformOutputList;
    putOutput(value: MediaTransformOutput[] | cdktf.IResolvable): void;
    resetOutput(): void;
    get outputInput(): cdktf.IResolvable | MediaTransformOutput[] | undefined;
    private _timeouts;
    get timeouts(): MediaTransformTimeoutsOutputReference;
    putTimeouts(value: MediaTransformTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaTransformTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
