"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobileNetworkAttachedDataNetwork = exports.MobileNetworkAttachedDataNetworkTimeoutsOutputReference = exports.mobileNetworkAttachedDataNetworkTimeoutsToHclTerraform = exports.mobileNetworkAttachedDataNetworkTimeoutsToTerraform = exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference = exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToHclTerraform = exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform = exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference = exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToHclTerraform = exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        maximum: cdktf.numberToTerraform(struct.maximum),
        minimum: cdktf.numberToTerraform(struct.minimum),
    };
}
exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform = mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform;
function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        maximum: {
            value: cdktf.numberToHclTerraform(struct.maximum),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        minimum: {
            value: cdktf.numberToHclTerraform(struct.minimum),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToHclTerraform = mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToHclTerraform;
class MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maximum !== undefined) {
            hasAnyValues = true;
            internalValueResult.maximum = this._maximum;
        }
        if (this._minimum !== undefined) {
            hasAnyValues = true;
            internalValueResult.minimum = this._minimum;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maximum = undefined;
            this._minimum = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maximum = value.maximum;
            this._minimum = value.minimum;
        }
    }
    get maximum() {
        return this.getNumberAttribute('maximum');
    }
    set maximum(value) {
        this._maximum = value;
    }
    resetMaximum() {
        this._maximum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maximumInput() {
        return this._maximum;
    }
    get minimum() {
        return this.getNumberAttribute('minimum');
    }
    set minimum(value) {
        this._minimum = value;
    }
    resetMinimum() {
        this._minimum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minimumInput() {
        return this._minimum;
    }
}
exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference = MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference", version: "12.26.1" };
function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        icmp_pinhole_timeout_in_seconds: cdktf.numberToTerraform(struct.icmpPinholeTimeoutInSeconds),
        pinhole_maximum_number: cdktf.numberToTerraform(struct.pinholeMaximumNumber),
        tcp_pinhole_timeout_in_seconds: cdktf.numberToTerraform(struct.tcpPinholeTimeoutInSeconds),
        tcp_port_reuse_minimum_hold_time_in_seconds: cdktf.numberToTerraform(struct.tcpPortReuseMinimumHoldTimeInSeconds),
        udp_pinhole_timeout_in_seconds: cdktf.numberToTerraform(struct.udpPinholeTimeoutInSeconds),
        udp_port_reuse_minimum_hold_time_in_seconds: cdktf.numberToTerraform(struct.udpPortReuseMinimumHoldTimeInSeconds),
        port_range: mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform(struct.portRange),
    };
}
exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform = mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform;
function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        icmp_pinhole_timeout_in_seconds: {
            value: cdktf.numberToHclTerraform(struct.icmpPinholeTimeoutInSeconds),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        pinhole_maximum_number: {
            value: cdktf.numberToHclTerraform(struct.pinholeMaximumNumber),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        tcp_pinhole_timeout_in_seconds: {
            value: cdktf.numberToHclTerraform(struct.tcpPinholeTimeoutInSeconds),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        tcp_port_reuse_minimum_hold_time_in_seconds: {
            value: cdktf.numberToHclTerraform(struct.tcpPortReuseMinimumHoldTimeInSeconds),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        udp_pinhole_timeout_in_seconds: {
            value: cdktf.numberToHclTerraform(struct.udpPinholeTimeoutInSeconds),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        udp_port_reuse_minimum_hold_time_in_seconds: {
            value: cdktf.numberToHclTerraform(struct.udpPortReuseMinimumHoldTimeInSeconds),
            isBlock: false,
            type: "simple",
            storageClassType: "number",
        },
        port_range: {
            value: mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToHclTerraform(struct.portRange),
            isBlock: true,
            type: "list",
            storageClassType: "MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeList",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToHclTerraform = mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToHclTerraform;
class MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // port_range - computed: false, optional: true, required: false
        this._portRange = new MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference(this, "port_range");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._icmpPinholeTimeoutInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.icmpPinholeTimeoutInSeconds = this._icmpPinholeTimeoutInSeconds;
        }
        if (this._pinholeMaximumNumber !== undefined) {
            hasAnyValues = true;
            internalValueResult.pinholeMaximumNumber = this._pinholeMaximumNumber;
        }
        if (this._tcpPinholeTimeoutInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.tcpPinholeTimeoutInSeconds = this._tcpPinholeTimeoutInSeconds;
        }
        if (this._tcpPortReuseMinimumHoldTimeInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.tcpPortReuseMinimumHoldTimeInSeconds = this._tcpPortReuseMinimumHoldTimeInSeconds;
        }
        if (this._udpPinholeTimeoutInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.udpPinholeTimeoutInSeconds = this._udpPinholeTimeoutInSeconds;
        }
        if (this._udpPortReuseMinimumHoldTimeInSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.udpPortReuseMinimumHoldTimeInSeconds = this._udpPortReuseMinimumHoldTimeInSeconds;
        }
        if (this._portRange?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.portRange = this._portRange?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._icmpPinholeTimeoutInSeconds = undefined;
            this._pinholeMaximumNumber = undefined;
            this._tcpPinholeTimeoutInSeconds = undefined;
            this._tcpPortReuseMinimumHoldTimeInSeconds = undefined;
            this._udpPinholeTimeoutInSeconds = undefined;
            this._udpPortReuseMinimumHoldTimeInSeconds = undefined;
            this._portRange.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._icmpPinholeTimeoutInSeconds = value.icmpPinholeTimeoutInSeconds;
            this._pinholeMaximumNumber = value.pinholeMaximumNumber;
            this._tcpPinholeTimeoutInSeconds = value.tcpPinholeTimeoutInSeconds;
            this._tcpPortReuseMinimumHoldTimeInSeconds = value.tcpPortReuseMinimumHoldTimeInSeconds;
            this._udpPinholeTimeoutInSeconds = value.udpPinholeTimeoutInSeconds;
            this._udpPortReuseMinimumHoldTimeInSeconds = value.udpPortReuseMinimumHoldTimeInSeconds;
            this._portRange.internalValue = value.portRange;
        }
    }
    get icmpPinholeTimeoutInSeconds() {
        return this.getNumberAttribute('icmp_pinhole_timeout_in_seconds');
    }
    set icmpPinholeTimeoutInSeconds(value) {
        this._icmpPinholeTimeoutInSeconds = value;
    }
    resetIcmpPinholeTimeoutInSeconds() {
        this._icmpPinholeTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get icmpPinholeTimeoutInSecondsInput() {
        return this._icmpPinholeTimeoutInSeconds;
    }
    get pinholeMaximumNumber() {
        return this.getNumberAttribute('pinhole_maximum_number');
    }
    set pinholeMaximumNumber(value) {
        this._pinholeMaximumNumber = value;
    }
    resetPinholeMaximumNumber() {
        this._pinholeMaximumNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pinholeMaximumNumberInput() {
        return this._pinholeMaximumNumber;
    }
    get tcpPinholeTimeoutInSeconds() {
        return this.getNumberAttribute('tcp_pinhole_timeout_in_seconds');
    }
    set tcpPinholeTimeoutInSeconds(value) {
        this._tcpPinholeTimeoutInSeconds = value;
    }
    resetTcpPinholeTimeoutInSeconds() {
        this._tcpPinholeTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tcpPinholeTimeoutInSecondsInput() {
        return this._tcpPinholeTimeoutInSeconds;
    }
    get tcpPortReuseMinimumHoldTimeInSeconds() {
        return this.getNumberAttribute('tcp_port_reuse_minimum_hold_time_in_seconds');
    }
    set tcpPortReuseMinimumHoldTimeInSeconds(value) {
        this._tcpPortReuseMinimumHoldTimeInSeconds = value;
    }
    resetTcpPortReuseMinimumHoldTimeInSeconds() {
        this._tcpPortReuseMinimumHoldTimeInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tcpPortReuseMinimumHoldTimeInSecondsInput() {
        return this._tcpPortReuseMinimumHoldTimeInSeconds;
    }
    get udpPinholeTimeoutInSeconds() {
        return this.getNumberAttribute('udp_pinhole_timeout_in_seconds');
    }
    set udpPinholeTimeoutInSeconds(value) {
        this._udpPinholeTimeoutInSeconds = value;
    }
    resetUdpPinholeTimeoutInSeconds() {
        this._udpPinholeTimeoutInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get udpPinholeTimeoutInSecondsInput() {
        return this._udpPinholeTimeoutInSeconds;
    }
    get udpPortReuseMinimumHoldTimeInSeconds() {
        return this.getNumberAttribute('udp_port_reuse_minimum_hold_time_in_seconds');
    }
    set udpPortReuseMinimumHoldTimeInSeconds(value) {
        this._udpPortReuseMinimumHoldTimeInSeconds = value;
    }
    resetUdpPortReuseMinimumHoldTimeInSeconds() {
        this._udpPortReuseMinimumHoldTimeInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get udpPortReuseMinimumHoldTimeInSecondsInput() {
        return this._udpPortReuseMinimumHoldTimeInSeconds;
    }
    get portRange() {
        return this._portRange;
    }
    putPortRange(value) {
        this._portRange.internalValue = value;
    }
    resetPortRange() {
        this._portRange.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portRangeInput() {
        return this._portRange.internalValue;
    }
}
exports.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference = MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference", version: "12.26.1" };
function mobileNetworkAttachedDataNetworkTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mobileNetworkAttachedDataNetworkTimeoutsToTerraform = mobileNetworkAttachedDataNetworkTimeoutsToTerraform;
function mobileNetworkAttachedDataNetworkTimeoutsToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        create: {
            value: cdktf.stringToHclTerraform(struct.create),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        delete: {
            value: cdktf.stringToHclTerraform(struct.delete),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        read: {
            value: cdktf.stringToHclTerraform(struct.read),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        update: {
            value: cdktf.stringToHclTerraform(struct.update),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
exports.mobileNetworkAttachedDataNetworkTimeoutsToHclTerraform = mobileNetworkAttachedDataNetworkTimeoutsToHclTerraform;
class MobileNetworkAttachedDataNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MobileNetworkAttachedDataNetworkTimeoutsOutputReference = MobileNetworkAttachedDataNetworkTimeoutsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetworkTimeoutsOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetworkTimeoutsOutputReference", version: "12.26.1" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network}
*/
class MobileNetworkAttachedDataNetwork extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a MobileNetworkAttachedDataNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkAttachedDataNetwork to import
    * @param importFromId The id of the existing MobileNetworkAttachedDataNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/mobile_network_attached_data_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkAttachedDataNetwork to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "azurerm_mobile_network_attached_data_network", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkAttachedDataNetworkConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_mobile_network_attached_data_network',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.115.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // network_address_port_translation - computed: false, optional: true, required: false
        this._networkAddressPortTranslation = new MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference(this, "network_address_port_translation");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MobileNetworkAttachedDataNetworkTimeoutsOutputReference(this, "timeouts");
        this._dnsAddresses = config.dnsAddresses;
        this._id = config.id;
        this._location = config.location;
        this._mobileNetworkDataNetworkName = config.mobileNetworkDataNetworkName;
        this._mobileNetworkPacketCoreDataPlaneId = config.mobileNetworkPacketCoreDataPlaneId;
        this._tags = config.tags;
        this._userEquipmentAddressPoolPrefixes = config.userEquipmentAddressPoolPrefixes;
        this._userEquipmentStaticAddressPoolPrefixes = config.userEquipmentStaticAddressPoolPrefixes;
        this._userPlaneAccessIpv4Address = config.userPlaneAccessIpv4Address;
        this._userPlaneAccessIpv4Gateway = config.userPlaneAccessIpv4Gateway;
        this._userPlaneAccessIpv4Subnet = config.userPlaneAccessIpv4Subnet;
        this._userPlaneAccessName = config.userPlaneAccessName;
        this._networkAddressPortTranslation.internalValue = config.networkAddressPortTranslation;
        this._timeouts.internalValue = config.timeouts;
    }
    get dnsAddresses() {
        return this.getListAttribute('dns_addresses');
    }
    set dnsAddresses(value) {
        this._dnsAddresses = value;
    }
    // Temporarily expose input value. Use with caution.
    get dnsAddressesInput() {
        return this._dnsAddresses;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get mobileNetworkDataNetworkName() {
        return this.getStringAttribute('mobile_network_data_network_name');
    }
    set mobileNetworkDataNetworkName(value) {
        this._mobileNetworkDataNetworkName = value;
    }
    // Temporarily expose input value. Use with caution.
    get mobileNetworkDataNetworkNameInput() {
        return this._mobileNetworkDataNetworkName;
    }
    get mobileNetworkPacketCoreDataPlaneId() {
        return this.getStringAttribute('mobile_network_packet_core_data_plane_id');
    }
    set mobileNetworkPacketCoreDataPlaneId(value) {
        this._mobileNetworkPacketCoreDataPlaneId = value;
    }
    // Temporarily expose input value. Use with caution.
    get mobileNetworkPacketCoreDataPlaneIdInput() {
        return this._mobileNetworkPacketCoreDataPlaneId;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get userEquipmentAddressPoolPrefixes() {
        return this.getListAttribute('user_equipment_address_pool_prefixes');
    }
    set userEquipmentAddressPoolPrefixes(value) {
        this._userEquipmentAddressPoolPrefixes = value;
    }
    resetUserEquipmentAddressPoolPrefixes() {
        this._userEquipmentAddressPoolPrefixes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userEquipmentAddressPoolPrefixesInput() {
        return this._userEquipmentAddressPoolPrefixes;
    }
    get userEquipmentStaticAddressPoolPrefixes() {
        return this.getListAttribute('user_equipment_static_address_pool_prefixes');
    }
    set userEquipmentStaticAddressPoolPrefixes(value) {
        this._userEquipmentStaticAddressPoolPrefixes = value;
    }
    resetUserEquipmentStaticAddressPoolPrefixes() {
        this._userEquipmentStaticAddressPoolPrefixes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userEquipmentStaticAddressPoolPrefixesInput() {
        return this._userEquipmentStaticAddressPoolPrefixes;
    }
    get userPlaneAccessIpv4Address() {
        return this.getStringAttribute('user_plane_access_ipv4_address');
    }
    set userPlaneAccessIpv4Address(value) {
        this._userPlaneAccessIpv4Address = value;
    }
    resetUserPlaneAccessIpv4Address() {
        this._userPlaneAccessIpv4Address = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessIpv4AddressInput() {
        return this._userPlaneAccessIpv4Address;
    }
    get userPlaneAccessIpv4Gateway() {
        return this.getStringAttribute('user_plane_access_ipv4_gateway');
    }
    set userPlaneAccessIpv4Gateway(value) {
        this._userPlaneAccessIpv4Gateway = value;
    }
    resetUserPlaneAccessIpv4Gateway() {
        this._userPlaneAccessIpv4Gateway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessIpv4GatewayInput() {
        return this._userPlaneAccessIpv4Gateway;
    }
    get userPlaneAccessIpv4Subnet() {
        return this.getStringAttribute('user_plane_access_ipv4_subnet');
    }
    set userPlaneAccessIpv4Subnet(value) {
        this._userPlaneAccessIpv4Subnet = value;
    }
    resetUserPlaneAccessIpv4Subnet() {
        this._userPlaneAccessIpv4Subnet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessIpv4SubnetInput() {
        return this._userPlaneAccessIpv4Subnet;
    }
    get userPlaneAccessName() {
        return this.getStringAttribute('user_plane_access_name');
    }
    set userPlaneAccessName(value) {
        this._userPlaneAccessName = value;
    }
    resetUserPlaneAccessName() {
        this._userPlaneAccessName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userPlaneAccessNameInput() {
        return this._userPlaneAccessName;
    }
    get networkAddressPortTranslation() {
        return this._networkAddressPortTranslation;
    }
    putNetworkAddressPortTranslation(value) {
        this._networkAddressPortTranslation.internalValue = value;
    }
    resetNetworkAddressPortTranslation() {
        this._networkAddressPortTranslation.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkAddressPortTranslationInput() {
        return this._networkAddressPortTranslation.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dns_addresses: cdktf.listMapper(cdktf.stringToTerraform, false)(this._dnsAddresses),
            id: cdktf.stringToTerraform(this._id),
            location: cdktf.stringToTerraform(this._location),
            mobile_network_data_network_name: cdktf.stringToTerraform(this._mobileNetworkDataNetworkName),
            mobile_network_packet_core_data_plane_id: cdktf.stringToTerraform(this._mobileNetworkPacketCoreDataPlaneId),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            user_equipment_address_pool_prefixes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._userEquipmentAddressPoolPrefixes),
            user_equipment_static_address_pool_prefixes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._userEquipmentStaticAddressPoolPrefixes),
            user_plane_access_ipv4_address: cdktf.stringToTerraform(this._userPlaneAccessIpv4Address),
            user_plane_access_ipv4_gateway: cdktf.stringToTerraform(this._userPlaneAccessIpv4Gateway),
            user_plane_access_ipv4_subnet: cdktf.stringToTerraform(this._userPlaneAccessIpv4Subnet),
            user_plane_access_name: cdktf.stringToTerraform(this._userPlaneAccessName),
            network_address_port_translation: mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform(this._networkAddressPortTranslation.internalValue),
            timeouts: mobileNetworkAttachedDataNetworkTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            dns_addresses: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._dnsAddresses),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            location: {
                value: cdktf.stringToHclTerraform(this._location),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mobile_network_data_network_name: {
                value: cdktf.stringToHclTerraform(this._mobileNetworkDataNetworkName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mobile_network_packet_core_data_plane_id: {
                value: cdktf.stringToHclTerraform(this._mobileNetworkPacketCoreDataPlaneId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            tags: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._tags),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            user_equipment_address_pool_prefixes: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._userEquipmentAddressPoolPrefixes),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            user_equipment_static_address_pool_prefixes: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._userEquipmentStaticAddressPoolPrefixes),
                isBlock: false,
                type: "list",
                storageClassType: "stringList",
            },
            user_plane_access_ipv4_address: {
                value: cdktf.stringToHclTerraform(this._userPlaneAccessIpv4Address),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_plane_access_ipv4_gateway: {
                value: cdktf.stringToHclTerraform(this._userPlaneAccessIpv4Gateway),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_plane_access_ipv4_subnet: {
                value: cdktf.stringToHclTerraform(this._userPlaneAccessIpv4Subnet),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_plane_access_name: {
                value: cdktf.stringToHclTerraform(this._userPlaneAccessName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            network_address_port_translation: {
                value: mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToHclTerraform(this._networkAddressPortTranslation.internalValue),
                isBlock: true,
                type: "list",
                storageClassType: "MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationList",
            },
            timeouts: {
                value: mobileNetworkAttachedDataNetworkTimeoutsToHclTerraform(this._timeouts.internalValue),
                isBlock: true,
                type: "struct",
                storageClassType: "MobileNetworkAttachedDataNetworkTimeouts",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.MobileNetworkAttachedDataNetwork = MobileNetworkAttachedDataNetwork;
_d = JSII_RTTI_SYMBOL_1;
MobileNetworkAttachedDataNetwork[_d] = { fqn: "@cdktf/provider-azurerm.mobileNetworkAttachedDataNetwork.MobileNetworkAttachedDataNetwork", version: "12.26.1" };
// =================
// STATIC PROPERTIES
// =================
MobileNetworkAttachedDataNetwork.tfResourceType = "azurerm_mobile_network_attached_data_network";
//# sourceMappingURL=data:application/json;base64,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