/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetappSnapshotPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#account_name NetappSnapshotPolicy#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#enabled NetappSnapshotPolicy#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#id NetappSnapshotPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#location NetappSnapshotPolicy#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#name NetappSnapshotPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#resource_group_name NetappSnapshotPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#tags NetappSnapshotPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * daily_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#daily_schedule NetappSnapshotPolicy#daily_schedule}
    */
    readonly dailySchedule?: NetappSnapshotPolicyDailySchedule;
    /**
    * hourly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#hourly_schedule NetappSnapshotPolicy#hourly_schedule}
    */
    readonly hourlySchedule?: NetappSnapshotPolicyHourlySchedule;
    /**
    * monthly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#monthly_schedule NetappSnapshotPolicy#monthly_schedule}
    */
    readonly monthlySchedule?: NetappSnapshotPolicyMonthlySchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#timeouts NetappSnapshotPolicy#timeouts}
    */
    readonly timeouts?: NetappSnapshotPolicyTimeouts;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#weekly_schedule NetappSnapshotPolicy#weekly_schedule}
    */
    readonly weeklySchedule?: NetappSnapshotPolicyWeeklySchedule;
}
export interface NetappSnapshotPolicyDailySchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#hour NetappSnapshotPolicy#hour}
    */
    readonly hour: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}
    */
    readonly minute: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyDailyScheduleToTerraform(struct?: NetappSnapshotPolicyDailyScheduleOutputReference | NetappSnapshotPolicyDailySchedule): any;
export declare function netappSnapshotPolicyDailyScheduleToHclTerraform(struct?: NetappSnapshotPolicyDailyScheduleOutputReference | NetappSnapshotPolicyDailySchedule): any;
export declare class NetappSnapshotPolicyDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappSnapshotPolicyDailySchedule | undefined;
    set internalValue(value: NetappSnapshotPolicyDailySchedule | undefined);
    private _hour?;
    get hour(): number;
    set hour(value: number);
    get hourInput(): number | undefined;
    private _minute?;
    get minute(): number;
    set minute(value: number);
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
export interface NetappSnapshotPolicyHourlySchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}
    */
    readonly minute: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyHourlyScheduleToTerraform(struct?: NetappSnapshotPolicyHourlyScheduleOutputReference | NetappSnapshotPolicyHourlySchedule): any;
export declare function netappSnapshotPolicyHourlyScheduleToHclTerraform(struct?: NetappSnapshotPolicyHourlyScheduleOutputReference | NetappSnapshotPolicyHourlySchedule): any;
export declare class NetappSnapshotPolicyHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappSnapshotPolicyHourlySchedule | undefined;
    set internalValue(value: NetappSnapshotPolicyHourlySchedule | undefined);
    private _minute?;
    get minute(): number;
    set minute(value: number);
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
export interface NetappSnapshotPolicyMonthlySchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#days_of_month NetappSnapshotPolicy#days_of_month}
    */
    readonly daysOfMonth: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#hour NetappSnapshotPolicy#hour}
    */
    readonly hour: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}
    */
    readonly minute: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyMonthlyScheduleToTerraform(struct?: NetappSnapshotPolicyMonthlyScheduleOutputReference | NetappSnapshotPolicyMonthlySchedule): any;
export declare function netappSnapshotPolicyMonthlyScheduleToHclTerraform(struct?: NetappSnapshotPolicyMonthlyScheduleOutputReference | NetappSnapshotPolicyMonthlySchedule): any;
export declare class NetappSnapshotPolicyMonthlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappSnapshotPolicyMonthlySchedule | undefined;
    set internalValue(value: NetappSnapshotPolicyMonthlySchedule | undefined);
    private _daysOfMonth?;
    get daysOfMonth(): number[];
    set daysOfMonth(value: number[]);
    get daysOfMonthInput(): number[] | undefined;
    private _hour?;
    get hour(): number;
    set hour(value: number);
    get hourInput(): number | undefined;
    private _minute?;
    get minute(): number;
    set minute(value: number);
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
export interface NetappSnapshotPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#create NetappSnapshotPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#delete NetappSnapshotPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#read NetappSnapshotPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#update NetappSnapshotPolicy#update}
    */
    readonly update?: string;
}
export declare function netappSnapshotPolicyTimeoutsToTerraform(struct?: NetappSnapshotPolicyTimeouts | cdktf.IResolvable): any;
export declare function netappSnapshotPolicyTimeoutsToHclTerraform(struct?: NetappSnapshotPolicyTimeouts | cdktf.IResolvable): any;
export declare class NetappSnapshotPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappSnapshotPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetappSnapshotPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NetappSnapshotPolicyWeeklySchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#days_of_week NetappSnapshotPolicy#days_of_week}
    */
    readonly daysOfWeek: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#hour NetappSnapshotPolicy#hour}
    */
    readonly hour: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#minute NetappSnapshotPolicy#minute}
    */
    readonly minute: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#snapshots_to_keep NetappSnapshotPolicy#snapshots_to_keep}
    */
    readonly snapshotsToKeep: number;
}
export declare function netappSnapshotPolicyWeeklyScheduleToTerraform(struct?: NetappSnapshotPolicyWeeklyScheduleOutputReference | NetappSnapshotPolicyWeeklySchedule): any;
export declare function netappSnapshotPolicyWeeklyScheduleToHclTerraform(struct?: NetappSnapshotPolicyWeeklyScheduleOutputReference | NetappSnapshotPolicyWeeklySchedule): any;
export declare class NetappSnapshotPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappSnapshotPolicyWeeklySchedule | undefined;
    set internalValue(value: NetappSnapshotPolicyWeeklySchedule | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    get daysOfWeekInput(): string[] | undefined;
    private _hour?;
    get hour(): number;
    set hour(value: number);
    get hourInput(): number | undefined;
    private _minute?;
    get minute(): number;
    set minute(value: number);
    get minuteInput(): number | undefined;
    private _snapshotsToKeep?;
    get snapshotsToKeep(): number;
    set snapshotsToKeep(value: number);
    get snapshotsToKeepInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy azurerm_netapp_snapshot_policy}
*/
export declare class NetappSnapshotPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_netapp_snapshot_policy";
    /**
    * Generates CDKTF code for importing a NetappSnapshotPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetappSnapshotPolicy to import
    * @param importFromId The id of the existing NetappSnapshotPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetappSnapshotPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/netapp_snapshot_policy azurerm_netapp_snapshot_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetappSnapshotPolicyConfig
    */
    constructor(scope: Construct, id: string, config: NetappSnapshotPolicyConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dailySchedule;
    get dailySchedule(): NetappSnapshotPolicyDailyScheduleOutputReference;
    putDailySchedule(value: NetappSnapshotPolicyDailySchedule): void;
    resetDailySchedule(): void;
    get dailyScheduleInput(): NetappSnapshotPolicyDailySchedule | undefined;
    private _hourlySchedule;
    get hourlySchedule(): NetappSnapshotPolicyHourlyScheduleOutputReference;
    putHourlySchedule(value: NetappSnapshotPolicyHourlySchedule): void;
    resetHourlySchedule(): void;
    get hourlyScheduleInput(): NetappSnapshotPolicyHourlySchedule | undefined;
    private _monthlySchedule;
    get monthlySchedule(): NetappSnapshotPolicyMonthlyScheduleOutputReference;
    putMonthlySchedule(value: NetappSnapshotPolicyMonthlySchedule): void;
    resetMonthlySchedule(): void;
    get monthlyScheduleInput(): NetappSnapshotPolicyMonthlySchedule | undefined;
    private _timeouts;
    get timeouts(): NetappSnapshotPolicyTimeoutsOutputReference;
    putTimeouts(value: NetappSnapshotPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetappSnapshotPolicyTimeouts | undefined;
    private _weeklySchedule;
    get weeklySchedule(): NetappSnapshotPolicyWeeklyScheduleOutputReference;
    putWeeklySchedule(value: NetappSnapshotPolicyWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): NetappSnapshotPolicyWeeklySchedule | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
