/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NewRelicTagRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#activity_log_enabled NewRelicTagRule#activity_log_enabled}
    */
    readonly activityLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#azure_active_directory_log_enabled NewRelicTagRule#azure_active_directory_log_enabled}
    */
    readonly azureActiveDirectoryLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#id NewRelicTagRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#metric_enabled NewRelicTagRule#metric_enabled}
    */
    readonly metricEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#monitor_id NewRelicTagRule#monitor_id}
    */
    readonly monitorId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#subscription_log_enabled NewRelicTagRule#subscription_log_enabled}
    */
    readonly subscriptionLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * log_tag_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#log_tag_filter NewRelicTagRule#log_tag_filter}
    */
    readonly logTagFilter?: NewRelicTagRuleLogTagFilter[] | cdktf.IResolvable;
    /**
    * metric_tag_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#metric_tag_filter NewRelicTagRule#metric_tag_filter}
    */
    readonly metricTagFilter?: NewRelicTagRuleMetricTagFilter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#timeouts NewRelicTagRule#timeouts}
    */
    readonly timeouts?: NewRelicTagRuleTimeouts;
}
export interface NewRelicTagRuleLogTagFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#action NewRelicTagRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#name NewRelicTagRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#value NewRelicTagRule#value}
    */
    readonly value: string;
}
export declare function newRelicTagRuleLogTagFilterToTerraform(struct?: NewRelicTagRuleLogTagFilter | cdktf.IResolvable): any;
export declare function newRelicTagRuleLogTagFilterToHclTerraform(struct?: NewRelicTagRuleLogTagFilter | cdktf.IResolvable): any;
export declare class NewRelicTagRuleLogTagFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NewRelicTagRuleLogTagFilter | cdktf.IResolvable | undefined;
    set internalValue(value: NewRelicTagRuleLogTagFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class NewRelicTagRuleLogTagFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NewRelicTagRuleLogTagFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NewRelicTagRuleLogTagFilterOutputReference;
}
export interface NewRelicTagRuleMetricTagFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#action NewRelicTagRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#name NewRelicTagRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#value NewRelicTagRule#value}
    */
    readonly value: string;
}
export declare function newRelicTagRuleMetricTagFilterToTerraform(struct?: NewRelicTagRuleMetricTagFilter | cdktf.IResolvable): any;
export declare function newRelicTagRuleMetricTagFilterToHclTerraform(struct?: NewRelicTagRuleMetricTagFilter | cdktf.IResolvable): any;
export declare class NewRelicTagRuleMetricTagFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NewRelicTagRuleMetricTagFilter | cdktf.IResolvable | undefined;
    set internalValue(value: NewRelicTagRuleMetricTagFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class NewRelicTagRuleMetricTagFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NewRelicTagRuleMetricTagFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NewRelicTagRuleMetricTagFilterOutputReference;
}
export interface NewRelicTagRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#create NewRelicTagRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#delete NewRelicTagRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#read NewRelicTagRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#update NewRelicTagRule#update}
    */
    readonly update?: string;
}
export declare function newRelicTagRuleTimeoutsToTerraform(struct?: NewRelicTagRuleTimeouts | cdktf.IResolvable): any;
export declare function newRelicTagRuleTimeoutsToHclTerraform(struct?: NewRelicTagRuleTimeouts | cdktf.IResolvable): any;
export declare class NewRelicTagRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NewRelicTagRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NewRelicTagRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule azurerm_new_relic_tag_rule}
*/
export declare class NewRelicTagRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_new_relic_tag_rule";
    /**
    * Generates CDKTF code for importing a NewRelicTagRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NewRelicTagRule to import
    * @param importFromId The id of the existing NewRelicTagRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NewRelicTagRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/new_relic_tag_rule azurerm_new_relic_tag_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NewRelicTagRuleConfig
    */
    constructor(scope: Construct, id: string, config: NewRelicTagRuleConfig);
    private _activityLogEnabled?;
    get activityLogEnabled(): boolean | cdktf.IResolvable;
    set activityLogEnabled(value: boolean | cdktf.IResolvable);
    resetActivityLogEnabled(): void;
    get activityLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _azureActiveDirectoryLogEnabled?;
    get azureActiveDirectoryLogEnabled(): boolean | cdktf.IResolvable;
    set azureActiveDirectoryLogEnabled(value: boolean | cdktf.IResolvable);
    resetAzureActiveDirectoryLogEnabled(): void;
    get azureActiveDirectoryLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metricEnabled?;
    get metricEnabled(): boolean | cdktf.IResolvable;
    set metricEnabled(value: boolean | cdktf.IResolvable);
    resetMetricEnabled(): void;
    get metricEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _monitorId?;
    get monitorId(): string;
    set monitorId(value: string);
    get monitorIdInput(): string | undefined;
    private _subscriptionLogEnabled?;
    get subscriptionLogEnabled(): boolean | cdktf.IResolvable;
    set subscriptionLogEnabled(value: boolean | cdktf.IResolvable);
    resetSubscriptionLogEnabled(): void;
    get subscriptionLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _logTagFilter;
    get logTagFilter(): NewRelicTagRuleLogTagFilterList;
    putLogTagFilter(value: NewRelicTagRuleLogTagFilter[] | cdktf.IResolvable): void;
    resetLogTagFilter(): void;
    get logTagFilterInput(): cdktf.IResolvable | NewRelicTagRuleLogTagFilter[] | undefined;
    private _metricTagFilter;
    get metricTagFilter(): NewRelicTagRuleMetricTagFilterList;
    putMetricTagFilter(value: NewRelicTagRuleMetricTagFilter[] | cdktf.IResolvable): void;
    resetMetricTagFilter(): void;
    get metricTagFilterInput(): cdktf.IResolvable | NewRelicTagRuleMetricTagFilter[] | undefined;
    private _timeouts;
    get timeouts(): NewRelicTagRuleTimeoutsOutputReference;
    putTimeouts(value: NewRelicTagRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NewRelicTagRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
