/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceGroupPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#description ResourceGroupPolicyAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#display_name ResourceGroupPolicyAssignment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#enforce ResourceGroupPolicyAssignment#enforce}
    */
    readonly enforce?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#id ResourceGroupPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#location ResourceGroupPolicyAssignment#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#metadata ResourceGroupPolicyAssignment#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#name ResourceGroupPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#not_scopes ResourceGroupPolicyAssignment#not_scopes}
    */
    readonly notScopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#parameters ResourceGroupPolicyAssignment#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#policy_definition_id ResourceGroupPolicyAssignment#policy_definition_id}
    */
    readonly policyDefinitionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#resource_group_id ResourceGroupPolicyAssignment#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#identity ResourceGroupPolicyAssignment#identity}
    */
    readonly identity?: ResourceGroupPolicyAssignmentIdentity;
    /**
    * non_compliance_message block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#non_compliance_message ResourceGroupPolicyAssignment#non_compliance_message}
    */
    readonly nonComplianceMessage?: ResourceGroupPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#overrides ResourceGroupPolicyAssignment#overrides}
    */
    readonly overrides?: ResourceGroupPolicyAssignmentOverrides[] | cdktf.IResolvable;
    /**
    * resource_selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#resource_selectors ResourceGroupPolicyAssignment#resource_selectors}
    */
    readonly resourceSelectors?: ResourceGroupPolicyAssignmentResourceSelectors[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#timeouts ResourceGroupPolicyAssignment#timeouts}
    */
    readonly timeouts?: ResourceGroupPolicyAssignmentTimeouts;
}
export interface ResourceGroupPolicyAssignmentIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#identity_ids ResourceGroupPolicyAssignment#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#type ResourceGroupPolicyAssignment#type}
    */
    readonly type: string;
}
export declare function resourceGroupPolicyAssignmentIdentityToTerraform(struct?: ResourceGroupPolicyAssignmentIdentityOutputReference | ResourceGroupPolicyAssignmentIdentity): any;
export declare function resourceGroupPolicyAssignmentIdentityToHclTerraform(struct?: ResourceGroupPolicyAssignmentIdentityOutputReference | ResourceGroupPolicyAssignmentIdentity): any;
export declare class ResourceGroupPolicyAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupPolicyAssignmentIdentity | undefined;
    set internalValue(value: ResourceGroupPolicyAssignmentIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ResourceGroupPolicyAssignmentNonComplianceMessage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#content ResourceGroupPolicyAssignment#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#policy_definition_reference_id ResourceGroupPolicyAssignment#policy_definition_reference_id}
    */
    readonly policyDefinitionReferenceId?: string;
}
export declare function resourceGroupPolicyAssignmentNonComplianceMessageToTerraform(struct?: ResourceGroupPolicyAssignmentNonComplianceMessage | cdktf.IResolvable): any;
export declare function resourceGroupPolicyAssignmentNonComplianceMessageToHclTerraform(struct?: ResourceGroupPolicyAssignmentNonComplianceMessage | cdktf.IResolvable): any;
export declare class ResourceGroupPolicyAssignmentNonComplianceMessageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupPolicyAssignmentNonComplianceMessage | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupPolicyAssignmentNonComplianceMessage | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _policyDefinitionReferenceId?;
    get policyDefinitionReferenceId(): string;
    set policyDefinitionReferenceId(value: string);
    resetPolicyDefinitionReferenceId(): void;
    get policyDefinitionReferenceIdInput(): string | undefined;
}
export declare class ResourceGroupPolicyAssignmentNonComplianceMessageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupPolicyAssignmentNonComplianceMessageOutputReference;
}
export interface ResourceGroupPolicyAssignmentOverridesSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#in ResourceGroupPolicyAssignment#in}
    */
    readonly in?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#not_in ResourceGroupPolicyAssignment#not_in}
    */
    readonly notIn?: string[];
}
export declare function resourceGroupPolicyAssignmentOverridesSelectorsToTerraform(struct?: ResourceGroupPolicyAssignmentOverridesSelectors | cdktf.IResolvable): any;
export declare function resourceGroupPolicyAssignmentOverridesSelectorsToHclTerraform(struct?: ResourceGroupPolicyAssignmentOverridesSelectors | cdktf.IResolvable): any;
export declare class ResourceGroupPolicyAssignmentOverridesSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupPolicyAssignmentOverridesSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupPolicyAssignmentOverridesSelectors | cdktf.IResolvable | undefined);
    private _in?;
    get in(): string[];
    set in(value: string[]);
    resetIn(): void;
    get inInput(): string[] | undefined;
    get kind(): string;
    private _notIn?;
    get notIn(): string[];
    set notIn(value: string[]);
    resetNotIn(): void;
    get notInInput(): string[] | undefined;
}
export declare class ResourceGroupPolicyAssignmentOverridesSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupPolicyAssignmentOverridesSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupPolicyAssignmentOverridesSelectorsOutputReference;
}
export interface ResourceGroupPolicyAssignmentOverrides {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#value ResourceGroupPolicyAssignment#value}
    */
    readonly value: string;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#selectors ResourceGroupPolicyAssignment#selectors}
    */
    readonly selectors?: ResourceGroupPolicyAssignmentOverridesSelectors[] | cdktf.IResolvable;
}
export declare function resourceGroupPolicyAssignmentOverridesToTerraform(struct?: ResourceGroupPolicyAssignmentOverrides | cdktf.IResolvable): any;
export declare function resourceGroupPolicyAssignmentOverridesToHclTerraform(struct?: ResourceGroupPolicyAssignmentOverrides | cdktf.IResolvable): any;
export declare class ResourceGroupPolicyAssignmentOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupPolicyAssignmentOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupPolicyAssignmentOverrides | cdktf.IResolvable | undefined);
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _selectors;
    get selectors(): ResourceGroupPolicyAssignmentOverridesSelectorsList;
    putSelectors(value: ResourceGroupPolicyAssignmentOverridesSelectors[] | cdktf.IResolvable): void;
    resetSelectors(): void;
    get selectorsInput(): cdktf.IResolvable | ResourceGroupPolicyAssignmentOverridesSelectors[] | undefined;
}
export declare class ResourceGroupPolicyAssignmentOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupPolicyAssignmentOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupPolicyAssignmentOverridesOutputReference;
}
export interface ResourceGroupPolicyAssignmentResourceSelectorsSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#in ResourceGroupPolicyAssignment#in}
    */
    readonly in?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#kind ResourceGroupPolicyAssignment#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#not_in ResourceGroupPolicyAssignment#not_in}
    */
    readonly notIn?: string[];
}
export declare function resourceGroupPolicyAssignmentResourceSelectorsSelectorsToTerraform(struct?: ResourceGroupPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable): any;
export declare function resourceGroupPolicyAssignmentResourceSelectorsSelectorsToHclTerraform(struct?: ResourceGroupPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable): any;
export declare class ResourceGroupPolicyAssignmentResourceSelectorsSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupPolicyAssignmentResourceSelectorsSelectors | cdktf.IResolvable | undefined);
    private _in?;
    get in(): string[];
    set in(value: string[]);
    resetIn(): void;
    get inInput(): string[] | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _notIn?;
    get notIn(): string[];
    set notIn(value: string[]);
    resetNotIn(): void;
    get notInInput(): string[] | undefined;
}
export declare class ResourceGroupPolicyAssignmentResourceSelectorsSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupPolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupPolicyAssignmentResourceSelectorsSelectorsOutputReference;
}
export interface ResourceGroupPolicyAssignmentResourceSelectors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#name ResourceGroupPolicyAssignment#name}
    */
    readonly name?: string;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#selectors ResourceGroupPolicyAssignment#selectors}
    */
    readonly selectors: ResourceGroupPolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable;
}
export declare function resourceGroupPolicyAssignmentResourceSelectorsToTerraform(struct?: ResourceGroupPolicyAssignmentResourceSelectors | cdktf.IResolvable): any;
export declare function resourceGroupPolicyAssignmentResourceSelectorsToHclTerraform(struct?: ResourceGroupPolicyAssignmentResourceSelectors | cdktf.IResolvable): any;
export declare class ResourceGroupPolicyAssignmentResourceSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceGroupPolicyAssignmentResourceSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupPolicyAssignmentResourceSelectors | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _selectors;
    get selectors(): ResourceGroupPolicyAssignmentResourceSelectorsSelectorsList;
    putSelectors(value: ResourceGroupPolicyAssignmentResourceSelectorsSelectors[] | cdktf.IResolvable): void;
    get selectorsInput(): cdktf.IResolvable | ResourceGroupPolicyAssignmentResourceSelectorsSelectors[] | undefined;
}
export declare class ResourceGroupPolicyAssignmentResourceSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ResourceGroupPolicyAssignmentResourceSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceGroupPolicyAssignmentResourceSelectorsOutputReference;
}
export interface ResourceGroupPolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#create ResourceGroupPolicyAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#delete ResourceGroupPolicyAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#read ResourceGroupPolicyAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#update ResourceGroupPolicyAssignment#update}
    */
    readonly update?: string;
}
export declare function resourceGroupPolicyAssignmentTimeoutsToTerraform(struct?: ResourceGroupPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare function resourceGroupPolicyAssignmentTimeoutsToHclTerraform(struct?: ResourceGroupPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class ResourceGroupPolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupPolicyAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupPolicyAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment azurerm_resource_group_policy_assignment}
*/
export declare class ResourceGroupPolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_group_policy_assignment";
    /**
    * Generates CDKTF code for importing a ResourceGroupPolicyAssignment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceGroupPolicyAssignment to import
    * @param importFromId The id of the existing ResourceGroupPolicyAssignment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceGroupPolicyAssignment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/resource_group_policy_assignment azurerm_resource_group_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceGroupPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: ResourceGroupPolicyAssignmentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enforce?;
    get enforce(): boolean | cdktf.IResolvable;
    set enforce(value: boolean | cdktf.IResolvable);
    resetEnforce(): void;
    get enforceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notScopes?;
    get notScopes(): string[];
    set notScopes(value: string[]);
    resetNotScopes(): void;
    get notScopesInput(): string[] | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
    private _policyDefinitionId?;
    get policyDefinitionId(): string;
    set policyDefinitionId(value: string);
    get policyDefinitionIdInput(): string | undefined;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _identity;
    get identity(): ResourceGroupPolicyAssignmentIdentityOutputReference;
    putIdentity(value: ResourceGroupPolicyAssignmentIdentity): void;
    resetIdentity(): void;
    get identityInput(): ResourceGroupPolicyAssignmentIdentity | undefined;
    private _nonComplianceMessage;
    get nonComplianceMessage(): ResourceGroupPolicyAssignmentNonComplianceMessageList;
    putNonComplianceMessage(value: ResourceGroupPolicyAssignmentNonComplianceMessage[] | cdktf.IResolvable): void;
    resetNonComplianceMessage(): void;
    get nonComplianceMessageInput(): cdktf.IResolvable | ResourceGroupPolicyAssignmentNonComplianceMessage[] | undefined;
    private _overrides;
    get overrides(): ResourceGroupPolicyAssignmentOverridesList;
    putOverrides(value: ResourceGroupPolicyAssignmentOverrides[] | cdktf.IResolvable): void;
    resetOverrides(): void;
    get overridesInput(): cdktf.IResolvable | ResourceGroupPolicyAssignmentOverrides[] | undefined;
    private _resourceSelectors;
    get resourceSelectors(): ResourceGroupPolicyAssignmentResourceSelectorsList;
    putResourceSelectors(value: ResourceGroupPolicyAssignmentResourceSelectors[] | cdktf.IResolvable): void;
    resetResourceSelectors(): void;
    get resourceSelectorsInput(): cdktf.IResolvable | ResourceGroupPolicyAssignmentResourceSelectors[] | undefined;
    private _timeouts;
    get timeouts(): ResourceGroupPolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: ResourceGroupPolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceGroupPolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
