/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterAssessmentPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#categories SecurityCenterAssessmentPolicy#categories}
    */
    readonly categories?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#description SecurityCenterAssessmentPolicy#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#display_name SecurityCenterAssessmentPolicy#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#id SecurityCenterAssessmentPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#implementation_effort SecurityCenterAssessmentPolicy#implementation_effort}
    */
    readonly implementationEffort?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#remediation_description SecurityCenterAssessmentPolicy#remediation_description}
    */
    readonly remediationDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#severity SecurityCenterAssessmentPolicy#severity}
    */
    readonly severity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#threats SecurityCenterAssessmentPolicy#threats}
    */
    readonly threats?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#user_impact SecurityCenterAssessmentPolicy#user_impact}
    */
    readonly userImpact?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#timeouts SecurityCenterAssessmentPolicy#timeouts}
    */
    readonly timeouts?: SecurityCenterAssessmentPolicyTimeouts;
}
export interface SecurityCenterAssessmentPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#create SecurityCenterAssessmentPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#delete SecurityCenterAssessmentPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#read SecurityCenterAssessmentPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#update SecurityCenterAssessmentPolicy#update}
    */
    readonly update?: string;
}
export declare function securityCenterAssessmentPolicyTimeoutsToTerraform(struct?: SecurityCenterAssessmentPolicyTimeouts | cdktf.IResolvable): any;
export declare function securityCenterAssessmentPolicyTimeoutsToHclTerraform(struct?: SecurityCenterAssessmentPolicyTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterAssessmentPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterAssessmentPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterAssessmentPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy azurerm_security_center_assessment_policy}
*/
export declare class SecurityCenterAssessmentPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_assessment_policy";
    /**
    * Generates CDKTF code for importing a SecurityCenterAssessmentPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterAssessmentPolicy to import
    * @param importFromId The id of the existing SecurityCenterAssessmentPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterAssessmentPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_assessment_policy azurerm_security_center_assessment_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterAssessmentPolicyConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterAssessmentPolicyConfig);
    private _categories?;
    get categories(): string[];
    set categories(value: string[]);
    resetCategories(): void;
    get categoriesInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _implementationEffort?;
    get implementationEffort(): string;
    set implementationEffort(value: string);
    resetImplementationEffort(): void;
    get implementationEffortInput(): string | undefined;
    get name(): string;
    private _remediationDescription?;
    get remediationDescription(): string;
    set remediationDescription(value: string);
    resetRemediationDescription(): void;
    get remediationDescriptionInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    resetSeverity(): void;
    get severityInput(): string | undefined;
    private _threats?;
    get threats(): string[];
    set threats(value: string[]);
    resetThreats(): void;
    get threatsInput(): string[] | undefined;
    private _userImpact?;
    get userImpact(): string;
    set userImpact(value: string);
    resetUserImpact(): void;
    get userImpactInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterAssessmentPolicyTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterAssessmentPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterAssessmentPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
