/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterStorageDefenderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#id SecurityCenterStorageDefender#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#malware_scanning_on_upload_cap_gb_per_month SecurityCenterStorageDefender#malware_scanning_on_upload_cap_gb_per_month}
    */
    readonly malwareScanningOnUploadCapGbPerMonth?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#malware_scanning_on_upload_enabled SecurityCenterStorageDefender#malware_scanning_on_upload_enabled}
    */
    readonly malwareScanningOnUploadEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#override_subscription_settings_enabled SecurityCenterStorageDefender#override_subscription_settings_enabled}
    */
    readonly overrideSubscriptionSettingsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#scan_results_event_grid_topic_id SecurityCenterStorageDefender#scan_results_event_grid_topic_id}
    */
    readonly scanResultsEventGridTopicId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#sensitive_data_discovery_enabled SecurityCenterStorageDefender#sensitive_data_discovery_enabled}
    */
    readonly sensitiveDataDiscoveryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#storage_account_id SecurityCenterStorageDefender#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#timeouts SecurityCenterStorageDefender#timeouts}
    */
    readonly timeouts?: SecurityCenterStorageDefenderTimeouts;
}
export interface SecurityCenterStorageDefenderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#create SecurityCenterStorageDefender#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#delete SecurityCenterStorageDefender#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#read SecurityCenterStorageDefender#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#update SecurityCenterStorageDefender#update}
    */
    readonly update?: string;
}
export declare function securityCenterStorageDefenderTimeoutsToTerraform(struct?: SecurityCenterStorageDefenderTimeouts | cdktf.IResolvable): any;
export declare function securityCenterStorageDefenderTimeoutsToHclTerraform(struct?: SecurityCenterStorageDefenderTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterStorageDefenderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterStorageDefenderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterStorageDefenderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender azurerm_security_center_storage_defender}
*/
export declare class SecurityCenterStorageDefender extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_storage_defender";
    /**
    * Generates CDKTF code for importing a SecurityCenterStorageDefender resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterStorageDefender to import
    * @param importFromId The id of the existing SecurityCenterStorageDefender that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterStorageDefender to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/security_center_storage_defender azurerm_security_center_storage_defender} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterStorageDefenderConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterStorageDefenderConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _malwareScanningOnUploadCapGbPerMonth?;
    get malwareScanningOnUploadCapGbPerMonth(): number;
    set malwareScanningOnUploadCapGbPerMonth(value: number);
    resetMalwareScanningOnUploadCapGbPerMonth(): void;
    get malwareScanningOnUploadCapGbPerMonthInput(): number | undefined;
    private _malwareScanningOnUploadEnabled?;
    get malwareScanningOnUploadEnabled(): boolean | cdktf.IResolvable;
    set malwareScanningOnUploadEnabled(value: boolean | cdktf.IResolvable);
    resetMalwareScanningOnUploadEnabled(): void;
    get malwareScanningOnUploadEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _overrideSubscriptionSettingsEnabled?;
    get overrideSubscriptionSettingsEnabled(): boolean | cdktf.IResolvable;
    set overrideSubscriptionSettingsEnabled(value: boolean | cdktf.IResolvable);
    resetOverrideSubscriptionSettingsEnabled(): void;
    get overrideSubscriptionSettingsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scanResultsEventGridTopicId?;
    get scanResultsEventGridTopicId(): string;
    set scanResultsEventGridTopicId(value: string);
    resetScanResultsEventGridTopicId(): void;
    get scanResultsEventGridTopicIdInput(): string | undefined;
    private _sensitiveDataDiscoveryEnabled?;
    get sensitiveDataDiscoveryEnabled(): boolean | cdktf.IResolvable;
    set sensitiveDataDiscoveryEnabled(value: boolean | cdktf.IResolvable);
    resetSensitiveDataDiscoveryEnabled(): void;
    get sensitiveDataDiscoveryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterStorageDefenderTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterStorageDefenderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterStorageDefenderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
