/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SignalrSharedPrivateLinkResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#id SignalrSharedPrivateLinkResource#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#name SignalrSharedPrivateLinkResource#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#request_message SignalrSharedPrivateLinkResource#request_message}
    */
    readonly requestMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#signalr_service_id SignalrSharedPrivateLinkResource#signalr_service_id}
    */
    readonly signalrServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#sub_resource_name SignalrSharedPrivateLinkResource#sub_resource_name}
    */
    readonly subResourceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#target_resource_id SignalrSharedPrivateLinkResource#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#timeouts SignalrSharedPrivateLinkResource#timeouts}
    */
    readonly timeouts?: SignalrSharedPrivateLinkResourceTimeouts;
}
export interface SignalrSharedPrivateLinkResourceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#create SignalrSharedPrivateLinkResource#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#delete SignalrSharedPrivateLinkResource#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#read SignalrSharedPrivateLinkResource#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#update SignalrSharedPrivateLinkResource#update}
    */
    readonly update?: string;
}
export declare function signalrSharedPrivateLinkResourceTimeoutsToTerraform(struct?: SignalrSharedPrivateLinkResourceTimeouts | cdktf.IResolvable): any;
export declare function signalrSharedPrivateLinkResourceTimeoutsToHclTerraform(struct?: SignalrSharedPrivateLinkResourceTimeouts | cdktf.IResolvable): any;
export declare class SignalrSharedPrivateLinkResourceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrSharedPrivateLinkResourceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SignalrSharedPrivateLinkResourceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource azurerm_signalr_shared_private_link_resource}
*/
export declare class SignalrSharedPrivateLinkResource extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_signalr_shared_private_link_resource";
    /**
    * Generates CDKTF code for importing a SignalrSharedPrivateLinkResource resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SignalrSharedPrivateLinkResource to import
    * @param importFromId The id of the existing SignalrSharedPrivateLinkResource that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SignalrSharedPrivateLinkResource to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/signalr_shared_private_link_resource azurerm_signalr_shared_private_link_resource} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SignalrSharedPrivateLinkResourceConfig
    */
    constructor(scope: Construct, id: string, config: SignalrSharedPrivateLinkResourceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _requestMessage?;
    get requestMessage(): string;
    set requestMessage(value: string);
    resetRequestMessage(): void;
    get requestMessageInput(): string | undefined;
    private _signalrServiceId?;
    get signalrServiceId(): string;
    set signalrServiceId(value: string);
    get signalrServiceIdInput(): string | undefined;
    get status(): string;
    private _subResourceName?;
    get subResourceName(): string;
    set subResourceName(value: string);
    get subResourceNameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SignalrSharedPrivateLinkResourceTimeoutsOutputReference;
    putTimeouts(value: SignalrSharedPrivateLinkResourceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SignalrSharedPrivateLinkResourceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
