/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudBuildPackBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#binding_type SpringCloudBuildPackBinding#binding_type}
    */
    readonly bindingType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#id SpringCloudBuildPackBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#name SpringCloudBuildPackBinding#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#spring_cloud_builder_id SpringCloudBuildPackBinding#spring_cloud_builder_id}
    */
    readonly springCloudBuilderId: string;
    /**
    * launch block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#launch SpringCloudBuildPackBinding#launch}
    */
    readonly launch?: SpringCloudBuildPackBindingLaunch;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#timeouts SpringCloudBuildPackBinding#timeouts}
    */
    readonly timeouts?: SpringCloudBuildPackBindingTimeouts;
}
export interface SpringCloudBuildPackBindingLaunch {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#properties SpringCloudBuildPackBinding#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#secrets SpringCloudBuildPackBinding#secrets}
    */
    readonly secrets?: {
        [key: string]: string;
    };
}
export declare function springCloudBuildPackBindingLaunchToTerraform(struct?: SpringCloudBuildPackBindingLaunchOutputReference | SpringCloudBuildPackBindingLaunch): any;
export declare function springCloudBuildPackBindingLaunchToHclTerraform(struct?: SpringCloudBuildPackBindingLaunchOutputReference | SpringCloudBuildPackBindingLaunch): any;
export declare class SpringCloudBuildPackBindingLaunchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudBuildPackBindingLaunch | undefined;
    set internalValue(value: SpringCloudBuildPackBindingLaunch | undefined);
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _secrets?;
    get secrets(): {
        [key: string]: string;
    };
    set secrets(value: {
        [key: string]: string;
    });
    resetSecrets(): void;
    get secretsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface SpringCloudBuildPackBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#create SpringCloudBuildPackBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#delete SpringCloudBuildPackBinding#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#read SpringCloudBuildPackBinding#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#update SpringCloudBuildPackBinding#update}
    */
    readonly update?: string;
}
export declare function springCloudBuildPackBindingTimeoutsToTerraform(struct?: SpringCloudBuildPackBindingTimeouts | cdktf.IResolvable): any;
export declare function springCloudBuildPackBindingTimeoutsToHclTerraform(struct?: SpringCloudBuildPackBindingTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudBuildPackBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudBuildPackBindingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudBuildPackBindingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding azurerm_spring_cloud_build_pack_binding}
*/
export declare class SpringCloudBuildPackBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_build_pack_binding";
    /**
    * Generates CDKTF code for importing a SpringCloudBuildPackBinding resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudBuildPackBinding to import
    * @param importFromId The id of the existing SpringCloudBuildPackBinding that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudBuildPackBinding to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/spring_cloud_build_pack_binding azurerm_spring_cloud_build_pack_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudBuildPackBindingConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudBuildPackBindingConfig);
    private _bindingType?;
    get bindingType(): string;
    set bindingType(value: string);
    resetBindingType(): void;
    get bindingTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _springCloudBuilderId?;
    get springCloudBuilderId(): string;
    set springCloudBuilderId(value: string);
    get springCloudBuilderIdInput(): string | undefined;
    private _launch;
    get launch(): SpringCloudBuildPackBindingLaunchOutputReference;
    putLaunch(value: SpringCloudBuildPackBindingLaunch): void;
    resetLaunch(): void;
    get launchInput(): SpringCloudBuildPackBindingLaunch | undefined;
    private _timeouts;
    get timeouts(): SpringCloudBuildPackBindingTimeoutsOutputReference;
    putTimeouts(value: SpringCloudBuildPackBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudBuildPackBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
