/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TenantTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#debug_level TenantTemplateDeployment#debug_level}
    */
    readonly debugLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#id TenantTemplateDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#location TenantTemplateDeployment#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#name TenantTemplateDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#parameters_content TenantTemplateDeployment#parameters_content}
    */
    readonly parametersContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#tags TenantTemplateDeployment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#template_content TenantTemplateDeployment#template_content}
    */
    readonly templateContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#template_spec_version_id TenantTemplateDeployment#template_spec_version_id}
    */
    readonly templateSpecVersionId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#timeouts TenantTemplateDeployment#timeouts}
    */
    readonly timeouts?: TenantTemplateDeploymentTimeouts;
}
export interface TenantTemplateDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#create TenantTemplateDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#delete TenantTemplateDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#read TenantTemplateDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#update TenantTemplateDeployment#update}
    */
    readonly update?: string;
}
export declare function tenantTemplateDeploymentTimeoutsToTerraform(struct?: TenantTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare function tenantTemplateDeploymentTimeoutsToHclTerraform(struct?: TenantTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare class TenantTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TenantTemplateDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TenantTemplateDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment azurerm_tenant_template_deployment}
*/
export declare class TenantTemplateDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_tenant_template_deployment";
    /**
    * Generates CDKTF code for importing a TenantTemplateDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TenantTemplateDeployment to import
    * @param importFromId The id of the existing TenantTemplateDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TenantTemplateDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/tenant_template_deployment azurerm_tenant_template_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TenantTemplateDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: TenantTemplateDeploymentConfig);
    private _debugLevel?;
    get debugLevel(): string;
    set debugLevel(value: string);
    resetDebugLevel(): void;
    get debugLevelInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputContent(): string;
    private _parametersContent?;
    get parametersContent(): string;
    set parametersContent(value: string);
    resetParametersContent(): void;
    get parametersContentInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _templateContent?;
    get templateContent(): string;
    set templateContent(value: string);
    resetTemplateContent(): void;
    get templateContentInput(): string | undefined;
    private _templateSpecVersionId?;
    get templateSpecVersionId(): string;
    set templateSpecVersionId(value: string);
    resetTemplateSpecVersionId(): void;
    get templateSpecVersionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): TenantTemplateDeploymentTimeoutsOutputReference;
    putTimeouts(value: TenantTemplateDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TenantTemplateDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
