/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualDesktopHostPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#custom_rdp_properties VirtualDesktopHostPool#custom_rdp_properties}
    */
    readonly customRdpProperties?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#description VirtualDesktopHostPool#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#friendly_name VirtualDesktopHostPool#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#id VirtualDesktopHostPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#load_balancer_type VirtualDesktopHostPool#load_balancer_type}
    */
    readonly loadBalancerType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#location VirtualDesktopHostPool#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#maximum_sessions_allowed VirtualDesktopHostPool#maximum_sessions_allowed}
    */
    readonly maximumSessionsAllowed?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#name VirtualDesktopHostPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#personal_desktop_assignment_type VirtualDesktopHostPool#personal_desktop_assignment_type}
    */
    readonly personalDesktopAssignmentType?: string;
    /**
    * Preferred App Group type to display
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#preferred_app_group_type VirtualDesktopHostPool#preferred_app_group_type}
    */
    readonly preferredAppGroupType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#public_network_access VirtualDesktopHostPool#public_network_access}
    */
    readonly publicNetworkAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#resource_group_name VirtualDesktopHostPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#start_vm_on_connect VirtualDesktopHostPool#start_vm_on_connect}
    */
    readonly startVmOnConnect?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#tags VirtualDesktopHostPool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#type VirtualDesktopHostPool#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#validate_environment VirtualDesktopHostPool#validate_environment}
    */
    readonly validateEnvironment?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#vm_template VirtualDesktopHostPool#vm_template}
    */
    readonly vmTemplate?: string;
    /**
    * scheduled_agent_updates block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#scheduled_agent_updates VirtualDesktopHostPool#scheduled_agent_updates}
    */
    readonly scheduledAgentUpdates?: VirtualDesktopHostPoolScheduledAgentUpdates;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#timeouts VirtualDesktopHostPool#timeouts}
    */
    readonly timeouts?: VirtualDesktopHostPoolTimeouts;
}
export interface VirtualDesktopHostPoolScheduledAgentUpdatesSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#day_of_week VirtualDesktopHostPool#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#hour_of_day VirtualDesktopHostPool#hour_of_day}
    */
    readonly hourOfDay: number;
}
export declare function virtualDesktopHostPoolScheduledAgentUpdatesScheduleToTerraform(struct?: VirtualDesktopHostPoolScheduledAgentUpdatesSchedule | cdktf.IResolvable): any;
export declare function virtualDesktopHostPoolScheduledAgentUpdatesScheduleToHclTerraform(struct?: VirtualDesktopHostPoolScheduledAgentUpdatesSchedule | cdktf.IResolvable): any;
export declare class VirtualDesktopHostPoolScheduledAgentUpdatesScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualDesktopHostPoolScheduledAgentUpdatesSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualDesktopHostPoolScheduledAgentUpdatesSchedule | cdktf.IResolvable | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _hourOfDay?;
    get hourOfDay(): number;
    set hourOfDay(value: number);
    get hourOfDayInput(): number | undefined;
}
export declare class VirtualDesktopHostPoolScheduledAgentUpdatesScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualDesktopHostPoolScheduledAgentUpdatesSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualDesktopHostPoolScheduledAgentUpdatesScheduleOutputReference;
}
export interface VirtualDesktopHostPoolScheduledAgentUpdates {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#enabled VirtualDesktopHostPool#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#timezone VirtualDesktopHostPool#timezone}
    */
    readonly timezone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#use_session_host_timezone VirtualDesktopHostPool#use_session_host_timezone}
    */
    readonly useSessionHostTimezone?: boolean | cdktf.IResolvable;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#schedule VirtualDesktopHostPool#schedule}
    */
    readonly schedule?: VirtualDesktopHostPoolScheduledAgentUpdatesSchedule[] | cdktf.IResolvable;
}
export declare function virtualDesktopHostPoolScheduledAgentUpdatesToTerraform(struct?: VirtualDesktopHostPoolScheduledAgentUpdatesOutputReference | VirtualDesktopHostPoolScheduledAgentUpdates): any;
export declare function virtualDesktopHostPoolScheduledAgentUpdatesToHclTerraform(struct?: VirtualDesktopHostPoolScheduledAgentUpdatesOutputReference | VirtualDesktopHostPoolScheduledAgentUpdates): any;
export declare class VirtualDesktopHostPoolScheduledAgentUpdatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualDesktopHostPoolScheduledAgentUpdates | undefined;
    set internalValue(value: VirtualDesktopHostPoolScheduledAgentUpdates | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _useSessionHostTimezone?;
    get useSessionHostTimezone(): boolean | cdktf.IResolvable;
    set useSessionHostTimezone(value: boolean | cdktf.IResolvable);
    resetUseSessionHostTimezone(): void;
    get useSessionHostTimezoneInput(): boolean | cdktf.IResolvable | undefined;
    private _schedule;
    get schedule(): VirtualDesktopHostPoolScheduledAgentUpdatesScheduleList;
    putSchedule(value: VirtualDesktopHostPoolScheduledAgentUpdatesSchedule[] | cdktf.IResolvable): void;
    resetSchedule(): void;
    get scheduleInput(): cdktf.IResolvable | VirtualDesktopHostPoolScheduledAgentUpdatesSchedule[] | undefined;
}
export interface VirtualDesktopHostPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#create VirtualDesktopHostPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#delete VirtualDesktopHostPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#read VirtualDesktopHostPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#update VirtualDesktopHostPool#update}
    */
    readonly update?: string;
}
export declare function virtualDesktopHostPoolTimeoutsToTerraform(struct?: VirtualDesktopHostPoolTimeouts | cdktf.IResolvable): any;
export declare function virtualDesktopHostPoolTimeoutsToHclTerraform(struct?: VirtualDesktopHostPoolTimeouts | cdktf.IResolvable): any;
export declare class VirtualDesktopHostPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualDesktopHostPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualDesktopHostPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool azurerm_virtual_desktop_host_pool}
*/
export declare class VirtualDesktopHostPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_desktop_host_pool";
    /**
    * Generates CDKTF code for importing a VirtualDesktopHostPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualDesktopHostPool to import
    * @param importFromId The id of the existing VirtualDesktopHostPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualDesktopHostPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_desktop_host_pool azurerm_virtual_desktop_host_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualDesktopHostPoolConfig
    */
    constructor(scope: Construct, id: string, config: VirtualDesktopHostPoolConfig);
    private _customRdpProperties?;
    get customRdpProperties(): string;
    set customRdpProperties(value: string);
    resetCustomRdpProperties(): void;
    get customRdpPropertiesInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    get loadBalancerTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maximumSessionsAllowed?;
    get maximumSessionsAllowed(): number;
    set maximumSessionsAllowed(value: number);
    resetMaximumSessionsAllowed(): void;
    get maximumSessionsAllowedInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _personalDesktopAssignmentType?;
    get personalDesktopAssignmentType(): string;
    set personalDesktopAssignmentType(value: string);
    resetPersonalDesktopAssignmentType(): void;
    get personalDesktopAssignmentTypeInput(): string | undefined;
    private _preferredAppGroupType?;
    get preferredAppGroupType(): string;
    set preferredAppGroupType(value: string);
    resetPreferredAppGroupType(): void;
    get preferredAppGroupTypeInput(): string | undefined;
    private _publicNetworkAccess?;
    get publicNetworkAccess(): string;
    set publicNetworkAccess(value: string);
    resetPublicNetworkAccess(): void;
    get publicNetworkAccessInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _startVmOnConnect?;
    get startVmOnConnect(): boolean | cdktf.IResolvable;
    set startVmOnConnect(value: boolean | cdktf.IResolvable);
    resetStartVmOnConnect(): void;
    get startVmOnConnectInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _validateEnvironment?;
    get validateEnvironment(): boolean | cdktf.IResolvable;
    set validateEnvironment(value: boolean | cdktf.IResolvable);
    resetValidateEnvironment(): void;
    get validateEnvironmentInput(): boolean | cdktf.IResolvable | undefined;
    private _vmTemplate?;
    get vmTemplate(): string;
    set vmTemplate(value: string);
    resetVmTemplate(): void;
    get vmTemplateInput(): string | undefined;
    private _scheduledAgentUpdates;
    get scheduledAgentUpdates(): VirtualDesktopHostPoolScheduledAgentUpdatesOutputReference;
    putScheduledAgentUpdates(value: VirtualDesktopHostPoolScheduledAgentUpdates): void;
    resetScheduledAgentUpdates(): void;
    get scheduledAgentUpdatesInput(): VirtualDesktopHostPoolScheduledAgentUpdates | undefined;
    private _timeouts;
    get timeouts(): VirtualDesktopHostPoolTimeoutsOutputReference;
    putTimeouts(value: VirtualDesktopHostPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualDesktopHostPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
