/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualHubRoutingIntentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#id VirtualHubRoutingIntent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#name VirtualHubRoutingIntent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#virtual_hub_id VirtualHubRoutingIntent#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * routing_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#routing_policy VirtualHubRoutingIntent#routing_policy}
    */
    readonly routingPolicy: VirtualHubRoutingIntentRoutingPolicy[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#timeouts VirtualHubRoutingIntent#timeouts}
    */
    readonly timeouts?: VirtualHubRoutingIntentTimeouts;
}
export interface VirtualHubRoutingIntentRoutingPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#destinations VirtualHubRoutingIntent#destinations}
    */
    readonly destinations: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#name VirtualHubRoutingIntent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#next_hop VirtualHubRoutingIntent#next_hop}
    */
    readonly nextHop: string;
}
export declare function virtualHubRoutingIntentRoutingPolicyToTerraform(struct?: VirtualHubRoutingIntentRoutingPolicy | cdktf.IResolvable): any;
export declare function virtualHubRoutingIntentRoutingPolicyToHclTerraform(struct?: VirtualHubRoutingIntentRoutingPolicy | cdktf.IResolvable): any;
export declare class VirtualHubRoutingIntentRoutingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualHubRoutingIntentRoutingPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubRoutingIntentRoutingPolicy | cdktf.IResolvable | undefined);
    private _destinations?;
    get destinations(): string[];
    set destinations(value: string[]);
    get destinationsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nextHop?;
    get nextHop(): string;
    set nextHop(value: string);
    get nextHopInput(): string | undefined;
}
export declare class VirtualHubRoutingIntentRoutingPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualHubRoutingIntentRoutingPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualHubRoutingIntentRoutingPolicyOutputReference;
}
export interface VirtualHubRoutingIntentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#create VirtualHubRoutingIntent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#delete VirtualHubRoutingIntent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#read VirtualHubRoutingIntent#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#update VirtualHubRoutingIntent#update}
    */
    readonly update?: string;
}
export declare function virtualHubRoutingIntentTimeoutsToTerraform(struct?: VirtualHubRoutingIntentTimeouts | cdktf.IResolvable): any;
export declare function virtualHubRoutingIntentTimeoutsToHclTerraform(struct?: VirtualHubRoutingIntentTimeouts | cdktf.IResolvable): any;
export declare class VirtualHubRoutingIntentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubRoutingIntentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubRoutingIntentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent azurerm_virtual_hub_routing_intent}
*/
export declare class VirtualHubRoutingIntent extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_hub_routing_intent";
    /**
    * Generates CDKTF code for importing a VirtualHubRoutingIntent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualHubRoutingIntent to import
    * @param importFromId The id of the existing VirtualHubRoutingIntent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualHubRoutingIntent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/virtual_hub_routing_intent azurerm_virtual_hub_routing_intent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualHubRoutingIntentConfig
    */
    constructor(scope: Construct, id: string, config: VirtualHubRoutingIntentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _routingPolicy;
    get routingPolicy(): VirtualHubRoutingIntentRoutingPolicyList;
    putRoutingPolicy(value: VirtualHubRoutingIntentRoutingPolicy[] | cdktf.IResolvable): void;
    get routingPolicyInput(): cdktf.IResolvable | VirtualHubRoutingIntentRoutingPolicy[] | undefined;
    private _timeouts;
    get timeouts(): VirtualHubRoutingIntentTimeoutsOutputReference;
    putTimeouts(value: VirtualHubRoutingIntentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualHubRoutingIntentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
