/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WindowsFunctionAppSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * A map of key-value pairs for [App Settings](https://docs.microsoft.com/en-us/azure/azure-functions/functions-app-settings) and custom values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_settings WindowsFunctionAppSlot#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Should built in logging be enabled. Configures `AzureWebJobsDashboard` app setting based on the configured storage setting.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#builtin_logging_enabled WindowsFunctionAppSlot#builtin_logging_enabled}
    */
    readonly builtinLoggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Should the Function App Slot use Client Certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_certificate_enabled WindowsFunctionAppSlot#client_certificate_enabled}
    */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Paths to exclude when using client certificates, separated by ;
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_certificate_exclusion_paths WindowsFunctionAppSlot#client_certificate_exclusion_paths}
    */
    readonly clientCertificateExclusionPaths?: string;
    /**
    * The mode of the Function App Slot's client certificates requirement for incoming requests. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_certificate_mode WindowsFunctionAppSlot#client_certificate_mode}
    */
    readonly clientCertificateMode?: string;
    /**
    * Force disable the content share settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#content_share_force_disabled WindowsFunctionAppSlot#content_share_force_disabled}
    */
    readonly contentShareForceDisabled?: boolean | cdktf.IResolvable;
    /**
    * The amount of memory in gigabyte-seconds that your application is allowed to consume per day. Setting this value only affects function apps in Consumption Plans.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#daily_memory_time_quota WindowsFunctionAppSlot#daily_memory_time_quota}
    */
    readonly dailyMemoryTimeQuota?: number;
    /**
    * Is the Windows Function App Slot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#enabled WindowsFunctionAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#ftp_publish_basic_authentication_enabled WindowsFunctionAppSlot#ftp_publish_basic_authentication_enabled}
    */
    readonly ftpPublishBasicAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * The ID of the Windows Function App this Slot is a member of.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#function_app_id WindowsFunctionAppSlot#function_app_id}
    */
    readonly functionAppId: string;
    /**
    * The runtime version associated with the Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#functions_extension_version WindowsFunctionAppSlot#functions_extension_version}
    */
    readonly functionsExtensionVersion?: string;
    /**
    * Can the Function App Slot only be accessed via HTTPS?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#https_only WindowsFunctionAppSlot#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#id WindowsFunctionAppSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The User Assigned Identity to use for Key Vault access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#key_vault_reference_identity_id WindowsFunctionAppSlot#key_vault_reference_identity_id}
    */
    readonly keyVaultReferenceIdentityId?: string;
    /**
    * Specifies the name of the Windows Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name WindowsFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#public_network_access_enabled WindowsFunctionAppSlot#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#service_plan_id WindowsFunctionAppSlot#service_plan_id}
    */
    readonly servicePlanId?: string;
    /**
    * The access key which will be used to access the storage account for the Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#storage_account_access_key WindowsFunctionAppSlot#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * The backend storage account name which will be used by this Function App Slot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#storage_account_name WindowsFunctionAppSlot#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * The Key Vault Secret ID, including version, that contains the Connection String to connect to the storage account for this Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#storage_key_vault_secret_id WindowsFunctionAppSlot#storage_key_vault_secret_id}
    */
    readonly storageKeyVaultSecretId?: string;
    /**
    * Should the Function App Slot use its Managed Identity to access storage?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#storage_uses_managed_identity WindowsFunctionAppSlot#storage_uses_managed_identity}
    */
    readonly storageUsesManagedIdentity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#tags WindowsFunctionAppSlot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#virtual_network_subnet_id WindowsFunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#webdeploy_publish_basic_authentication_enabled WindowsFunctionAppSlot#webdeploy_publish_basic_authentication_enabled}
    */
    readonly webdeployPublishBasicAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#auth_settings WindowsFunctionAppSlot#auth_settings}
    */
    readonly authSettings?: WindowsFunctionAppSlotAuthSettings;
    /**
    * auth_settings_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#auth_settings_v2 WindowsFunctionAppSlot#auth_settings_v2}
    */
    readonly authSettingsV2?: WindowsFunctionAppSlotAuthSettingsV2;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#backup WindowsFunctionAppSlot#backup}
    */
    readonly backup?: WindowsFunctionAppSlotBackup;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#connection_string WindowsFunctionAppSlot#connection_string}
    */
    readonly connectionString?: WindowsFunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#identity WindowsFunctionAppSlot#identity}
    */
    readonly identity?: WindowsFunctionAppSlotIdentity;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#site_config WindowsFunctionAppSlot#site_config}
    */
    readonly siteConfig: WindowsFunctionAppSlotSiteConfig;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#storage_account WindowsFunctionAppSlot#storage_account}
    */
    readonly storageAccount?: WindowsFunctionAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#timeouts WindowsFunctionAppSlot#timeouts}
    */
    readonly timeouts?: WindowsFunctionAppSlotTimeouts;
}
export interface WindowsFunctionAppSlotSiteCredential {
}
export declare function windowsFunctionAppSlotSiteCredentialToTerraform(struct?: WindowsFunctionAppSlotSiteCredential): any;
export declare function windowsFunctionAppSlotSiteCredentialToHclTerraform(struct?: WindowsFunctionAppSlotSiteCredential): any;
export declare class WindowsFunctionAppSlotSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotSiteCredential | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class WindowsFunctionAppSlotSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotSiteCredentialOutputReference;
}
export interface WindowsFunctionAppSlotAuthSettingsActiveDirectory {
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_audiences WindowsFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret for the Client ID. Cannot be used with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret WindowsFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The App Setting name that contains the client secret of the Client. Cannot be used with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
}
export declare function windowsFunctionAppSlotAuthSettingsActiveDirectoryToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsActiveDirectoryOutputReference | WindowsFunctionAppSlotAuthSettingsActiveDirectory): any;
export declare function windowsFunctionAppSlotAuthSettingsActiveDirectoryToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsActiveDirectoryOutputReference | WindowsFunctionAppSlotAuthSettingsActiveDirectory): any;
export declare class WindowsFunctionAppSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsActiveDirectory | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsFacebook {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_id WindowsFunctionAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The App Secret of the Facebook app used for Facebook Login. Cannot be specified with `app_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_secret WindowsFunctionAppSlot#app_secret}
    */
    readonly appSecret?: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login. Cannot be specified with `app_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_secret_setting_name WindowsFunctionAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#oauth_scopes WindowsFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsFacebookToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsFacebookOutputReference | WindowsFunctionAppSlotAuthSettingsFacebook): any;
export declare function windowsFunctionAppSlotAuthSettingsFacebookToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsFacebookOutputReference | WindowsFunctionAppSlotAuthSettingsFacebook): any;
export declare class WindowsFunctionAppSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsFacebook | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    resetAppSecret(): void;
    get appSecretInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    resetAppSecretSettingName(): void;
    get appSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsGithub {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret of the GitHub app used for GitHub Login. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret WindowsFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#oauth_scopes WindowsFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsGithubToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsGithubOutputReference | WindowsFunctionAppSlotAuthSettingsGithub): any;
export declare function windowsFunctionAppSlotAuthSettingsGithubToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsGithubOutputReference | WindowsFunctionAppSlotAuthSettingsGithub): any;
export declare class WindowsFunctionAppSlotAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsGithub | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsGithub | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsGoogle {
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret associated with the Google web application.  Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret WindowsFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. If not specified, "openid", "profile", and "email" are used as default scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#oauth_scopes WindowsFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsGoogleToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsGoogleOutputReference | WindowsFunctionAppSlotAuthSettingsGoogle): any;
export declare function windowsFunctionAppSlotAuthSettingsGoogleToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsGoogleOutputReference | WindowsFunctionAppSlotAuthSettingsGoogle): any;
export declare class WindowsFunctionAppSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsGoogle | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsMicrosoft {
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret WindowsFunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * The list of OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. If not specified, `wl.basic` is used as the default scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#oauth_scopes WindowsFunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsMicrosoftToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsMicrosoftOutputReference | WindowsFunctionAppSlotAuthSettingsMicrosoft): any;
export declare function windowsFunctionAppSlotAuthSettingsMicrosoftToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsMicrosoftOutputReference | WindowsFunctionAppSlotAuthSettingsMicrosoft): any;
export declare class WindowsFunctionAppSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsMicrosoft | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsTwitter {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#consumer_key WindowsFunctionAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#consumer_secret WindowsFunctionAppSlot#consumer_secret}
    */
    readonly consumerSecret?: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#consumer_secret_setting_name WindowsFunctionAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName?: string;
}
export declare function windowsFunctionAppSlotAuthSettingsTwitterToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsTwitterOutputReference | WindowsFunctionAppSlotAuthSettingsTwitter): any;
export declare function windowsFunctionAppSlotAuthSettingsTwitterToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsTwitterOutputReference | WindowsFunctionAppSlotAuthSettingsTwitter): any;
export declare class WindowsFunctionAppSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsTwitter | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    resetConsumerSecret(): void;
    get consumerSecretInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    resetConsumerSecretSettingName(): void;
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface WindowsFunctionAppSlotAuthSettings {
    /**
    * Specifies a map of Login Parameters to send to the OpenID Connect authorization endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#additional_login_parameters WindowsFunctionAppSlot#additional_login_parameters}
    */
    readonly additionalLoginParameters?: {
        [key: string]: string;
    };
    /**
    * Specifies a list of External URLs that can be redirected to as part of logging in or logging out of the Windows Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_external_redirect_urls WindowsFunctionAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The default authentication provider to use when multiple providers are configured. Possible values include: `AzureActiveDirectory`, `Facebook`, `Google`, `MicrosoftAccount`, `Twitter`, `Github`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#default_provider WindowsFunctionAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Should the Authentication / Authorization feature be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#enabled WindowsFunctionAppSlot#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The OpenID Connect Issuer URI that represents the entity which issues access tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#issuer WindowsFunctionAppSlot#issuer}
    */
    readonly issuer?: string;
    /**
    * The RuntimeVersion of the Authentication / Authorization feature in use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#runtime_version WindowsFunctionAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#token_refresh_extension_hours WindowsFunctionAppSlot#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Should the Windows Web App durably store platform-specific security tokens that are obtained during login flows? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#token_store_enabled WindowsFunctionAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The action to take when an unauthenticated client attempts to access the app. Possible values include: `RedirectToLoginPage`, `AllowAnonymous`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#unauthenticated_client_action WindowsFunctionAppSlot#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#active_directory WindowsFunctionAppSlot#active_directory}
    */
    readonly activeDirectory?: WindowsFunctionAppSlotAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#facebook WindowsFunctionAppSlot#facebook}
    */
    readonly facebook?: WindowsFunctionAppSlotAuthSettingsFacebook;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#github WindowsFunctionAppSlot#github}
    */
    readonly github?: WindowsFunctionAppSlotAuthSettingsGithub;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#google WindowsFunctionAppSlot#google}
    */
    readonly google?: WindowsFunctionAppSlotAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#microsoft WindowsFunctionAppSlot#microsoft}
    */
    readonly microsoft?: WindowsFunctionAppSlotAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#twitter WindowsFunctionAppSlot#twitter}
    */
    readonly twitter?: WindowsFunctionAppSlotAuthSettingsTwitter;
}
export declare function windowsFunctionAppSlotAuthSettingsToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsOutputReference | WindowsFunctionAppSlotAuthSettings): any;
export declare function windowsFunctionAppSlotAuthSettingsToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsOutputReference | WindowsFunctionAppSlotAuthSettings): any;
export declare class WindowsFunctionAppSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettings | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettings | undefined);
    private _additionalLoginParameters?;
    get additionalLoginParameters(): {
        [key: string]: string;
    };
    set additionalLoginParameters(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParameters(): void;
    get additionalLoginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): WindowsFunctionAppSlotAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: WindowsFunctionAppSlotAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): WindowsFunctionAppSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): WindowsFunctionAppSlotAuthSettingsFacebookOutputReference;
    putFacebook(value: WindowsFunctionAppSlotAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): WindowsFunctionAppSlotAuthSettingsFacebook | undefined;
    private _github;
    get github(): WindowsFunctionAppSlotAuthSettingsGithubOutputReference;
    putGithub(value: WindowsFunctionAppSlotAuthSettingsGithub): void;
    resetGithub(): void;
    get githubInput(): WindowsFunctionAppSlotAuthSettingsGithub | undefined;
    private _google;
    get google(): WindowsFunctionAppSlotAuthSettingsGoogleOutputReference;
    putGoogle(value: WindowsFunctionAppSlotAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): WindowsFunctionAppSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): WindowsFunctionAppSlotAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: WindowsFunctionAppSlotAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): WindowsFunctionAppSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): WindowsFunctionAppSlotAuthSettingsTwitterOutputReference;
    putTwitter(value: WindowsFunctionAppSlotAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): WindowsFunctionAppSlotAuthSettingsTwitter | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 {
    /**
    * The list of allowed Applications for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_applications WindowsFunctionAppSlot#allowed_applications}
    */
    readonly allowedApplications?: string[];
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_audiences WindowsFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The list of allowed Group Names for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_groups WindowsFunctionAppSlot#allowed_groups}
    */
    readonly allowedGroups?: string[];
    /**
    * The list of allowed Identities for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_identities WindowsFunctionAppSlot#allowed_identities}
    */
    readonly allowedIdentities?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The thumbprint of the certificate used for signing purposes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_certificate_thumbprint WindowsFunctionAppSlot#client_secret_certificate_thumbprint}
    */
    readonly clientSecretCertificateThumbprint?: string;
    /**
    * The App Setting name that contains the client secret of the Client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * A list of Allowed Client Applications in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#jwt_allowed_client_applications WindowsFunctionAppSlot#jwt_allowed_client_applications}
    */
    readonly jwtAllowedClientApplications?: string[];
    /**
    * A list of Allowed Groups in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#jwt_allowed_groups WindowsFunctionAppSlot#jwt_allowed_groups}
    */
    readonly jwtAllowedGroups?: string[];
    /**
    * A map of key-value pairs to send to the Authorisation Endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#login_parameters WindowsFunctionAppSlot#login_parameters}
    */
    readonly loginParameters?: {
        [key: string]: string;
    };
    /**
    * The Azure Tenant Endpoint for the Authenticating Tenant. e.g. `https://login.microsoftonline.com/v2.0/{tenant-guid}/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#tenant_auth_endpoint WindowsFunctionAppSlot#tenant_auth_endpoint}
    */
    readonly tenantAuthEndpoint: string;
    /**
    * Should the www-authenticate provider should be omitted from the request? Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#www_authentication_disabled WindowsFunctionAppSlot#www_authentication_disabled}
    */
    readonly wwwAuthenticationDisabled?: boolean | cdktf.IResolvable;
}
export declare function windowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined);
    private _allowedApplications?;
    get allowedApplications(): string[];
    set allowedApplications(value: string[]);
    resetAllowedApplications(): void;
    get allowedApplicationsInput(): string[] | undefined;
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _allowedGroups?;
    get allowedGroups(): string[];
    set allowedGroups(value: string[]);
    resetAllowedGroups(): void;
    get allowedGroupsInput(): string[] | undefined;
    private _allowedIdentities?;
    get allowedIdentities(): string[];
    set allowedIdentities(value: string[]);
    resetAllowedIdentities(): void;
    get allowedIdentitiesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretCertificateThumbprint?;
    get clientSecretCertificateThumbprint(): string;
    set clientSecretCertificateThumbprint(value: string);
    resetClientSecretCertificateThumbprint(): void;
    get clientSecretCertificateThumbprintInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _jwtAllowedClientApplications?;
    get jwtAllowedClientApplications(): string[];
    set jwtAllowedClientApplications(value: string[]);
    resetJwtAllowedClientApplications(): void;
    get jwtAllowedClientApplicationsInput(): string[] | undefined;
    private _jwtAllowedGroups?;
    get jwtAllowedGroups(): string[];
    set jwtAllowedGroups(value: string[]);
    resetJwtAllowedGroups(): void;
    get jwtAllowedGroupsInput(): string[] | undefined;
    private _loginParameters?;
    get loginParameters(): {
        [key: string]: string;
    };
    set loginParameters(value: {
        [key: string]: string;
    });
    resetLoginParameters(): void;
    get loginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantAuthEndpoint?;
    get tenantAuthEndpoint(): string;
    set tenantAuthEndpoint(value: string);
    get tenantAuthEndpointInput(): string | undefined;
    private _wwwAuthenticationDisabled?;
    get wwwAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set wwwAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetWwwAuthenticationDisabled(): void;
    get wwwAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2AppleV2 {
    /**
    * The OpenID Connect Client ID for the Apple web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Apple Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
}
export declare function windowsFunctionAppSlotAuthSettingsV2AppleV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2AppleV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2AppleV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2AppleV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2AppleV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2AppleV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2AppleV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    get loginScopes(): string[];
}
export interface WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 {
    /**
    * The ID of the Client to use to authenticate with Azure Static Web App Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
}
export declare function windowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2 {
    /**
    * The ID of the Client to use to authenticate with this Custom OIDC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The name of the Custom OIDC Authentication Provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name WindowsFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * The name of the claim that contains the users name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name_claim_type WindowsFunctionAppSlot#name_claim_type}
    */
    readonly nameClaimType?: string;
    /**
    * The endpoint that contains all the configuration endpoints for this Custom OIDC provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#openid_configuration_endpoint WindowsFunctionAppSlot#openid_configuration_endpoint}
    */
    readonly openidConfigurationEndpoint: string;
    /**
    * The list of the scopes that should be requested while authenticating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#scopes WindowsFunctionAppSlot#scopes}
    */
    readonly scopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsV2CustomOidcV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotAuthSettingsV2CustomOidcV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameClaimType?;
    get nameClaimType(): string;
    set nameClaimType(value: string);
    resetNameClaimType(): void;
    get nameClaimTypeInput(): string | undefined;
    private _openidConfigurationEndpoint?;
    get openidConfigurationEndpoint(): string;
    set openidConfigurationEndpoint(value: string);
    get openidConfigurationEndpointInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    get tokenEndpoint(): string;
}
export declare class WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2OutputReference;
}
export interface WindowsFunctionAppSlotAuthSettingsV2FacebookV2 {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_id WindowsFunctionAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_secret_setting_name WindowsFunctionAppSlot#app_secret_setting_name}
    */
    readonly appSecretSettingName: string;
    /**
    * The version of the Facebook API to be used while logging in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#graph_api_version WindowsFunctionAppSlot#graph_api_version}
    */
    readonly graphApiVersion?: string;
    /**
    * Specifies a list of scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#login_scopes WindowsFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsV2FacebookV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2FacebookV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2FacebookV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2FacebookV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2FacebookV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2FacebookV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2FacebookV2 | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    get appSecretSettingNameInput(): string | undefined;
    private _graphApiVersion?;
    get graphApiVersion(): string;
    set graphApiVersion(value: string);
    resetGraphApiVersion(): void;
    get graphApiVersionInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2GithubV2 {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#login_scopes WindowsFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsV2GithubV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2GithubV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2GithubV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2GithubV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2GithubV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2GithubV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2GithubV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2GoogleV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_audiences WindowsFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of Login scopes that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#login_scopes WindowsFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsV2GoogleV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2GoogleV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2GoogleV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2GoogleV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2GoogleV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2GoogleV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2GoogleV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2Login {
    /**
    * External URLs that can be redirected to as part of logging in or logging out of the app. This is an advanced setting typically only needed by Windows Store application backends. **Note:** URLs within the current domain are always implicitly allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_external_redirect_urls WindowsFunctionAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The method by which cookies expire. Possible values include: `FixedTime`, and `IdentityProviderDerived`. Defaults to `FixedTime`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#cookie_expiration_convention WindowsFunctionAppSlot#cookie_expiration_convention}
    */
    readonly cookieExpirationConvention?: string;
    /**
    * The time after the request is made when the session cookie should expire. Defaults to `08:00:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#cookie_expiration_time WindowsFunctionAppSlot#cookie_expiration_time}
    */
    readonly cookieExpirationTime?: string;
    /**
    * The endpoint to which logout requests should be made.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#logout_endpoint WindowsFunctionAppSlot#logout_endpoint}
    */
    readonly logoutEndpoint?: string;
    /**
    * The time after the request is made when the nonce should expire. Defaults to `00:05:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#nonce_expiration_time WindowsFunctionAppSlot#nonce_expiration_time}
    */
    readonly nonceExpirationTime?: string;
    /**
    * Should the fragments from the request be preserved after the login request is made. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#preserve_url_fragments_for_logins WindowsFunctionAppSlot#preserve_url_fragments_for_logins}
    */
    readonly preserveUrlFragmentsForLogins?: boolean | cdktf.IResolvable;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#token_refresh_extension_time WindowsFunctionAppSlot#token_refresh_extension_time}
    */
    readonly tokenRefreshExtensionTime?: number;
    /**
    * Should the Token Store configuration Enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#token_store_enabled WindowsFunctionAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The directory path in the App Filesystem in which the tokens will be stored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#token_store_path WindowsFunctionAppSlot#token_store_path}
    */
    readonly tokenStorePath?: string;
    /**
    * The name of the app setting which contains the SAS URL of the blob storage containing the tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#token_store_sas_setting_name WindowsFunctionAppSlot#token_store_sas_setting_name}
    */
    readonly tokenStoreSasSettingName?: string;
    /**
    * Should the nonce be validated while completing the login flow. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#validate_nonce WindowsFunctionAppSlot#validate_nonce}
    */
    readonly validateNonce?: boolean | cdktf.IResolvable;
}
export declare function windowsFunctionAppSlotAuthSettingsV2LoginToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2LoginOutputReference | WindowsFunctionAppSlotAuthSettingsV2Login): any;
export declare function windowsFunctionAppSlotAuthSettingsV2LoginToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2LoginOutputReference | WindowsFunctionAppSlotAuthSettingsV2Login): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2Login | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2Login | undefined);
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _cookieExpirationConvention?;
    get cookieExpirationConvention(): string;
    set cookieExpirationConvention(value: string);
    resetCookieExpirationConvention(): void;
    get cookieExpirationConventionInput(): string | undefined;
    private _cookieExpirationTime?;
    get cookieExpirationTime(): string;
    set cookieExpirationTime(value: string);
    resetCookieExpirationTime(): void;
    get cookieExpirationTimeInput(): string | undefined;
    private _logoutEndpoint?;
    get logoutEndpoint(): string;
    set logoutEndpoint(value: string);
    resetLogoutEndpoint(): void;
    get logoutEndpointInput(): string | undefined;
    private _nonceExpirationTime?;
    get nonceExpirationTime(): string;
    set nonceExpirationTime(value: string);
    resetNonceExpirationTime(): void;
    get nonceExpirationTimeInput(): string | undefined;
    private _preserveUrlFragmentsForLogins?;
    get preserveUrlFragmentsForLogins(): boolean | cdktf.IResolvable;
    set preserveUrlFragmentsForLogins(value: boolean | cdktf.IResolvable);
    resetPreserveUrlFragmentsForLogins(): void;
    get preserveUrlFragmentsForLoginsInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenRefreshExtensionTime?;
    get tokenRefreshExtensionTime(): number;
    set tokenRefreshExtensionTime(value: number);
    resetTokenRefreshExtensionTime(): void;
    get tokenRefreshExtensionTimeInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenStorePath?;
    get tokenStorePath(): string;
    set tokenStorePath(value: string);
    resetTokenStorePath(): void;
    get tokenStorePathInput(): string | undefined;
    private _tokenStoreSasSettingName?;
    get tokenStoreSasSettingName(): string;
    set tokenStoreSasSettingName(value: string);
    resetTokenStoreSasSettingName(): void;
    get tokenStoreSasSettingNameInput(): string | undefined;
    private _validateNonce?;
    get validateNonce(): boolean | cdktf.IResolvable;
    set validateNonce(value: boolean | cdktf.IResolvable);
    resetValidateNonce(): void;
    get validateNonceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Microsoft Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_audiences WindowsFunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_id WindowsFunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#client_secret_setting_name WindowsFunctionAppSlot#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * The list of Login scopes that will be requested as part of Microsoft Account authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#login_scopes WindowsFunctionAppSlot#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsFunctionAppSlotAuthSettingsV2MicrosoftV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2MicrosoftV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2TwitterV2 {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#consumer_key WindowsFunctionAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#consumer_secret_setting_name WindowsFunctionAppSlot#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName: string;
}
export declare function windowsFunctionAppSlotAuthSettingsV2TwitterV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2TwitterV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2TwitterV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2TwitterV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2TwitterV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2TwitterV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2TwitterV2 | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface WindowsFunctionAppSlotAuthSettingsV2 {
    /**
    * Should the AuthV2 Settings be enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#auth_enabled WindowsFunctionAppSlot#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The path to the App Auth settings. **Note:** Relative Paths are evaluated from the Site Root directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#config_file_path WindowsFunctionAppSlot#config_file_path}
    */
    readonly configFilePath?: string;
    /**
    * The Default Authentication Provider to use when the `unauthenticated_action` is set to `RedirectToLoginPage`. Possible values include: `apple`, `azureactivedirectory`, `facebook`, `github`, `google`, `twitter` and the `name` of your `custom_oidc_v2` provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#default_provider WindowsFunctionAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * The paths which should be excluded from the `unauthenticated_action` when it is set to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#excluded_paths WindowsFunctionAppSlot#excluded_paths}
    */
    readonly excludedPaths?: string[];
    /**
    * The convention used to determine the url of the request made. Possible values include `ForwardProxyConventionNoProxy`, `ForwardProxyConventionStandard`, `ForwardProxyConventionCustom`. Defaults to `ForwardProxyConventionNoProxy`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#forward_proxy_convention WindowsFunctionAppSlot#forward_proxy_convention}
    */
    readonly forwardProxyConvention?: string;
    /**
    * The name of the header containing the host of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#forward_proxy_custom_host_header_name WindowsFunctionAppSlot#forward_proxy_custom_host_header_name}
    */
    readonly forwardProxyCustomHostHeaderName?: string;
    /**
    * The name of the header containing the scheme of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#forward_proxy_custom_scheme_header_name WindowsFunctionAppSlot#forward_proxy_custom_scheme_header_name}
    */
    readonly forwardProxyCustomSchemeHeaderName?: string;
    /**
    * The prefix that should precede all the authentication and authorisation paths. Defaults to `/.auth`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#http_route_api_prefix WindowsFunctionAppSlot#http_route_api_prefix}
    */
    readonly httpRouteApiPrefix?: string;
    /**
    * Should the authentication flow be used for all requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#require_authentication WindowsFunctionAppSlot#require_authentication}
    */
    readonly requireAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Should HTTPS be required on connections? Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#require_https WindowsFunctionAppSlot#require_https}
    */
    readonly requireHttps?: boolean | cdktf.IResolvable;
    /**
    * The Runtime Version of the Authentication and Authorisation feature of this App. Defaults to `~1`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#runtime_version WindowsFunctionAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The action to take for requests made without authentication. Possible values include `RedirectToLoginPage`, `AllowAnonymous`, `Return401`, and `Return403`. Defaults to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#unauthenticated_action WindowsFunctionAppSlot#unauthenticated_action}
    */
    readonly unauthenticatedAction?: string;
    /**
    * active_directory_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#active_directory_v2 WindowsFunctionAppSlot#active_directory_v2}
    */
    readonly activeDirectoryV2?: WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2;
    /**
    * apple_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#apple_v2 WindowsFunctionAppSlot#apple_v2}
    */
    readonly appleV2?: WindowsFunctionAppSlotAuthSettingsV2AppleV2;
    /**
    * azure_static_web_app_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#azure_static_web_app_v2 WindowsFunctionAppSlot#azure_static_web_app_v2}
    */
    readonly azureStaticWebAppV2?: WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2;
    /**
    * custom_oidc_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#custom_oidc_v2 WindowsFunctionAppSlot#custom_oidc_v2}
    */
    readonly customOidcV2?: WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * facebook_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#facebook_v2 WindowsFunctionAppSlot#facebook_v2}
    */
    readonly facebookV2?: WindowsFunctionAppSlotAuthSettingsV2FacebookV2;
    /**
    * github_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#github_v2 WindowsFunctionAppSlot#github_v2}
    */
    readonly githubV2?: WindowsFunctionAppSlotAuthSettingsV2GithubV2;
    /**
    * google_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#google_v2 WindowsFunctionAppSlot#google_v2}
    */
    readonly googleV2?: WindowsFunctionAppSlotAuthSettingsV2GoogleV2;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#login WindowsFunctionAppSlot#login}
    */
    readonly login: WindowsFunctionAppSlotAuthSettingsV2Login;
    /**
    * microsoft_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#microsoft_v2 WindowsFunctionAppSlot#microsoft_v2}
    */
    readonly microsoftV2?: WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2;
    /**
    * twitter_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#twitter_v2 WindowsFunctionAppSlot#twitter_v2}
    */
    readonly twitterV2?: WindowsFunctionAppSlotAuthSettingsV2TwitterV2;
}
export declare function windowsFunctionAppSlotAuthSettingsV2ToTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2): any;
export declare function windowsFunctionAppSlotAuthSettingsV2ToHclTerraform(struct?: WindowsFunctionAppSlotAuthSettingsV2OutputReference | WindowsFunctionAppSlotAuthSettingsV2): any;
export declare class WindowsFunctionAppSlotAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotAuthSettingsV2 | undefined;
    set internalValue(value: WindowsFunctionAppSlotAuthSettingsV2 | undefined);
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _configFilePath?;
    get configFilePath(): string;
    set configFilePath(value: string);
    resetConfigFilePath(): void;
    get configFilePathInput(): string | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _excludedPaths?;
    get excludedPaths(): string[];
    set excludedPaths(value: string[]);
    resetExcludedPaths(): void;
    get excludedPathsInput(): string[] | undefined;
    private _forwardProxyConvention?;
    get forwardProxyConvention(): string;
    set forwardProxyConvention(value: string);
    resetForwardProxyConvention(): void;
    get forwardProxyConventionInput(): string | undefined;
    private _forwardProxyCustomHostHeaderName?;
    get forwardProxyCustomHostHeaderName(): string;
    set forwardProxyCustomHostHeaderName(value: string);
    resetForwardProxyCustomHostHeaderName(): void;
    get forwardProxyCustomHostHeaderNameInput(): string | undefined;
    private _forwardProxyCustomSchemeHeaderName?;
    get forwardProxyCustomSchemeHeaderName(): string;
    set forwardProxyCustomSchemeHeaderName(value: string);
    resetForwardProxyCustomSchemeHeaderName(): void;
    get forwardProxyCustomSchemeHeaderNameInput(): string | undefined;
    private _httpRouteApiPrefix?;
    get httpRouteApiPrefix(): string;
    set httpRouteApiPrefix(value: string);
    resetHttpRouteApiPrefix(): void;
    get httpRouteApiPrefixInput(): string | undefined;
    private _requireAuthentication?;
    get requireAuthentication(): boolean | cdktf.IResolvable;
    set requireAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireAuthentication(): void;
    get requireAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireHttps?;
    get requireHttps(): boolean | cdktf.IResolvable;
    set requireHttps(value: boolean | cdktf.IResolvable);
    resetRequireHttps(): void;
    get requireHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _unauthenticatedAction?;
    get unauthenticatedAction(): string;
    set unauthenticatedAction(value: string);
    resetUnauthenticatedAction(): void;
    get unauthenticatedActionInput(): string | undefined;
    private _activeDirectoryV2;
    get activeDirectoryV2(): WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2OutputReference;
    putActiveDirectoryV2(value: WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2): void;
    resetActiveDirectoryV2(): void;
    get activeDirectoryV2Input(): WindowsFunctionAppSlotAuthSettingsV2ActiveDirectoryV2 | undefined;
    private _appleV2;
    get appleV2(): WindowsFunctionAppSlotAuthSettingsV2AppleV2OutputReference;
    putAppleV2(value: WindowsFunctionAppSlotAuthSettingsV2AppleV2): void;
    resetAppleV2(): void;
    get appleV2Input(): WindowsFunctionAppSlotAuthSettingsV2AppleV2 | undefined;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2OutputReference;
    putAzureStaticWebAppV2(value: WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2): void;
    resetAzureStaticWebAppV2(): void;
    get azureStaticWebAppV2Input(): WindowsFunctionAppSlotAuthSettingsV2AzureStaticWebAppV2 | undefined;
    private _customOidcV2;
    get customOidcV2(): WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2List;
    putCustomOidcV2(value: WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable): void;
    resetCustomOidcV2(): void;
    get customOidcV2Input(): cdktf.IResolvable | WindowsFunctionAppSlotAuthSettingsV2CustomOidcV2[] | undefined;
    private _facebookV2;
    get facebookV2(): WindowsFunctionAppSlotAuthSettingsV2FacebookV2OutputReference;
    putFacebookV2(value: WindowsFunctionAppSlotAuthSettingsV2FacebookV2): void;
    resetFacebookV2(): void;
    get facebookV2Input(): WindowsFunctionAppSlotAuthSettingsV2FacebookV2 | undefined;
    private _githubV2;
    get githubV2(): WindowsFunctionAppSlotAuthSettingsV2GithubV2OutputReference;
    putGithubV2(value: WindowsFunctionAppSlotAuthSettingsV2GithubV2): void;
    resetGithubV2(): void;
    get githubV2Input(): WindowsFunctionAppSlotAuthSettingsV2GithubV2 | undefined;
    private _googleV2;
    get googleV2(): WindowsFunctionAppSlotAuthSettingsV2GoogleV2OutputReference;
    putGoogleV2(value: WindowsFunctionAppSlotAuthSettingsV2GoogleV2): void;
    resetGoogleV2(): void;
    get googleV2Input(): WindowsFunctionAppSlotAuthSettingsV2GoogleV2 | undefined;
    private _login;
    get login(): WindowsFunctionAppSlotAuthSettingsV2LoginOutputReference;
    putLogin(value: WindowsFunctionAppSlotAuthSettingsV2Login): void;
    get loginInput(): WindowsFunctionAppSlotAuthSettingsV2Login | undefined;
    private _microsoftV2;
    get microsoftV2(): WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2OutputReference;
    putMicrosoftV2(value: WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2): void;
    resetMicrosoftV2(): void;
    get microsoftV2Input(): WindowsFunctionAppSlotAuthSettingsV2MicrosoftV2 | undefined;
    private _twitterV2;
    get twitterV2(): WindowsFunctionAppSlotAuthSettingsV2TwitterV2OutputReference;
    putTwitterV2(value: WindowsFunctionAppSlotAuthSettingsV2TwitterV2): void;
    resetTwitterV2(): void;
    get twitterV2Input(): WindowsFunctionAppSlotAuthSettingsV2TwitterV2 | undefined;
}
export interface WindowsFunctionAppSlotBackupSchedule {
    /**
    * How often the backup should be executed (e.g. for weekly backup, this should be set to `7` and `frequency_unit` should be set to `Day`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#frequency_interval WindowsFunctionAppSlot#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * The unit of time for how often the backup should take place. Possible values include: `Day` and `Hour`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#frequency_unit WindowsFunctionAppSlot#frequency_unit}
    */
    readonly frequencyUnit: string;
    /**
    * Should the service keep at least one backup, regardless of age of backup. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#keep_at_least_one_backup WindowsFunctionAppSlot#keep_at_least_one_backup}
    */
    readonly keepAtLeastOneBackup?: boolean | cdktf.IResolvable;
    /**
    * After how many days backups should be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#retention_period_days WindowsFunctionAppSlot#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
    /**
    * When the schedule should start working in RFC-3339 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#start_time WindowsFunctionAppSlot#start_time}
    */
    readonly startTime?: string;
}
export declare function windowsFunctionAppSlotBackupScheduleToTerraform(struct?: WindowsFunctionAppSlotBackupScheduleOutputReference | WindowsFunctionAppSlotBackupSchedule): any;
export declare function windowsFunctionAppSlotBackupScheduleToHclTerraform(struct?: WindowsFunctionAppSlotBackupScheduleOutputReference | WindowsFunctionAppSlotBackupSchedule): any;
export declare class WindowsFunctionAppSlotBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotBackupSchedule | undefined;
    set internalValue(value: WindowsFunctionAppSlotBackupSchedule | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    private _frequencyUnit?;
    get frequencyUnit(): string;
    set frequencyUnit(value: string);
    get frequencyUnitInput(): string | undefined;
    private _keepAtLeastOneBackup?;
    get keepAtLeastOneBackup(): boolean | cdktf.IResolvable;
    set keepAtLeastOneBackup(value: boolean | cdktf.IResolvable);
    resetKeepAtLeastOneBackup(): void;
    get keepAtLeastOneBackupInput(): boolean | cdktf.IResolvable | undefined;
    get lastExecutionTime(): string;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface WindowsFunctionAppSlotBackup {
    /**
    * Should this backup job be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#enabled WindowsFunctionAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name which should be used for this Backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name WindowsFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * The SAS URL to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#storage_account_url WindowsFunctionAppSlot#storage_account_url}
    */
    readonly storageAccountUrl: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#schedule WindowsFunctionAppSlot#schedule}
    */
    readonly schedule: WindowsFunctionAppSlotBackupSchedule;
}
export declare function windowsFunctionAppSlotBackupToTerraform(struct?: WindowsFunctionAppSlotBackupOutputReference | WindowsFunctionAppSlotBackup): any;
export declare function windowsFunctionAppSlotBackupToHclTerraform(struct?: WindowsFunctionAppSlotBackupOutputReference | WindowsFunctionAppSlotBackup): any;
export declare class WindowsFunctionAppSlotBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotBackup | undefined;
    set internalValue(value: WindowsFunctionAppSlotBackup | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountUrl?;
    get storageAccountUrl(): string;
    set storageAccountUrl(value: string);
    get storageAccountUrlInput(): string | undefined;
    private _schedule;
    get schedule(): WindowsFunctionAppSlotBackupScheduleOutputReference;
    putSchedule(value: WindowsFunctionAppSlotBackupSchedule): void;
    get scheduleInput(): WindowsFunctionAppSlotBackupSchedule | undefined;
}
export interface WindowsFunctionAppSlotConnectionString {
    /**
    * The name which should be used for this Connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name WindowsFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Type of database. Possible values include: `MySQL`, `SQLServer`, `SQLAzure`, `Custom`, `NotificationHub`, `ServiceBus`, `EventHub`, `APIHub`, `DocDb`, `RedisCache`, and `PostgreSQL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#type WindowsFunctionAppSlot#type}
    */
    readonly type: string;
    /**
    * The connection string value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#value WindowsFunctionAppSlot#value}
    */
    readonly value: string;
}
export declare function windowsFunctionAppSlotConnectionStringToTerraform(struct?: WindowsFunctionAppSlotConnectionString | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotConnectionStringToHclTerraform(struct?: WindowsFunctionAppSlotConnectionString | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class WindowsFunctionAppSlotConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsFunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotConnectionStringOutputReference;
}
export interface WindowsFunctionAppSlotIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#identity_ids WindowsFunctionAppSlot#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#type WindowsFunctionAppSlot#type}
    */
    readonly type: string;
}
export declare function windowsFunctionAppSlotIdentityToTerraform(struct?: WindowsFunctionAppSlotIdentityOutputReference | WindowsFunctionAppSlotIdentity): any;
export declare function windowsFunctionAppSlotIdentityToHclTerraform(struct?: WindowsFunctionAppSlotIdentityOutputReference | WindowsFunctionAppSlotIdentity): any;
export declare class WindowsFunctionAppSlotIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotIdentity | undefined;
    set internalValue(value: WindowsFunctionAppSlotIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface WindowsFunctionAppSlotSiteConfigAppServiceLogs {
    /**
    * The amount of disk space to use for logs. Valid values are between `25` and `100`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#disk_quota_mb WindowsFunctionAppSlot#disk_quota_mb}
    */
    readonly diskQuotaMb?: number;
    /**
    * The retention period for logs in days. Valid values are between `0` and `99999`. Defaults to `0` (never delete).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#retention_period_days WindowsFunctionAppSlot#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
}
export declare function windowsFunctionAppSlotSiteConfigAppServiceLogsToTerraform(struct?: WindowsFunctionAppSlotSiteConfigAppServiceLogsOutputReference | WindowsFunctionAppSlotSiteConfigAppServiceLogs): any;
export declare function windowsFunctionAppSlotSiteConfigAppServiceLogsToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigAppServiceLogsOutputReference | WindowsFunctionAppSlotSiteConfigAppServiceLogs): any;
export declare class WindowsFunctionAppSlotSiteConfigAppServiceLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotSiteConfigAppServiceLogs | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfigAppServiceLogs | undefined);
    private _diskQuotaMb?;
    get diskQuotaMb(): number;
    set diskQuotaMb(value: number);
    resetDiskQuotaMb(): void;
    get diskQuotaMbInput(): number | undefined;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
}
export interface WindowsFunctionAppSlotSiteConfigApplicationStack {
    /**
    * The version of .Net. Possible values are `v3.0`, `v4.0`, `v6.0` and `v7.0`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#dotnet_version WindowsFunctionAppSlot#dotnet_version}
    */
    readonly dotnetVersion?: string;
    /**
    * The version of Java to use. Possible values are `1.8`, `11` and `17`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#java_version WindowsFunctionAppSlot#java_version}
    */
    readonly javaVersion?: string;
    /**
    * The version of Node to use. Possible values include `12`, `14`, `16` and `18`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#node_version WindowsFunctionAppSlot#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * The PowerShell Core version to use. Possible values are `7`, `7.2`, and `7.4`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#powershell_core_version WindowsFunctionAppSlot#powershell_core_version}
    */
    readonly powershellCoreVersion?: string;
    /**
    * Does the Function App use a custom Application Stack?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#use_custom_runtime WindowsFunctionAppSlot#use_custom_runtime}
    */
    readonly useCustomRuntime?: boolean | cdktf.IResolvable;
    /**
    * Should the DotNet process use an isolated runtime. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#use_dotnet_isolated_runtime WindowsFunctionAppSlot#use_dotnet_isolated_runtime}
    */
    readonly useDotnetIsolatedRuntime?: boolean | cdktf.IResolvable;
}
export declare function windowsFunctionAppSlotSiteConfigApplicationStackToTerraform(struct?: WindowsFunctionAppSlotSiteConfigApplicationStackOutputReference | WindowsFunctionAppSlotSiteConfigApplicationStack): any;
export declare function windowsFunctionAppSlotSiteConfigApplicationStackToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigApplicationStackOutputReference | WindowsFunctionAppSlotSiteConfigApplicationStack): any;
export declare class WindowsFunctionAppSlotSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotSiteConfigApplicationStack | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfigApplicationStack | undefined);
    private _dotnetVersion?;
    get dotnetVersion(): string;
    set dotnetVersion(value: string);
    resetDotnetVersion(): void;
    get dotnetVersionInput(): string | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    private _powershellCoreVersion?;
    get powershellCoreVersion(): string;
    set powershellCoreVersion(value: string);
    resetPowershellCoreVersion(): void;
    get powershellCoreVersionInput(): string | undefined;
    private _useCustomRuntime?;
    get useCustomRuntime(): boolean | cdktf.IResolvable;
    set useCustomRuntime(value: boolean | cdktf.IResolvable);
    resetUseCustomRuntime(): void;
    get useCustomRuntimeInput(): boolean | cdktf.IResolvable | undefined;
    private _useDotnetIsolatedRuntime?;
    get useDotnetIsolatedRuntime(): boolean | cdktf.IResolvable;
    set useDotnetIsolatedRuntime(value: boolean | cdktf.IResolvable);
    resetUseDotnetIsolatedRuntime(): void;
    get useDotnetIsolatedRuntimeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsFunctionAppSlotSiteConfigCors {
    /**
    * Specifies a list of origins that should be allowed to make cross-origin calls.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#allowed_origins WindowsFunctionAppSlot#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Are credentials allowed in CORS requests? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#support_credentials WindowsFunctionAppSlot#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function windowsFunctionAppSlotSiteConfigCorsToTerraform(struct?: WindowsFunctionAppSlotSiteConfigCorsOutputReference | WindowsFunctionAppSlotSiteConfigCors): any;
export declare function windowsFunctionAppSlotSiteConfigCorsToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigCorsOutputReference | WindowsFunctionAppSlotSiteConfigCors): any;
export declare class WindowsFunctionAppSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotSiteConfigCors | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_azure_fdid WindowsFunctionAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_fd_health_probe WindowsFunctionAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_forwarded_for WindowsFunctionAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_forwarded_host WindowsFunctionAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function windowsFunctionAppSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotSiteConfigIpRestrictionHeadersToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class WindowsFunctionAppSlotSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotSiteConfigIpRestrictionHeadersOutputReference;
}
export interface WindowsFunctionAppSlotSiteConfigIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#action WindowsFunctionAppSlot#action}
    */
    readonly action?: string;
    /**
    * The description of the IP restriction rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#description WindowsFunctionAppSlot#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#headers WindowsFunctionAppSlot#headers}
    */
    readonly headers?: WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#ip_address WindowsFunctionAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name WindowsFunctionAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#priority WindowsFunctionAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#service_tag WindowsFunctionAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#virtual_network_subnet_id WindowsFunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function windowsFunctionAppSlotSiteConfigIpRestrictionToTerraform(struct?: WindowsFunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotSiteConfigIpRestrictionToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _headers;
    get headers(): WindowsFunctionAppSlotSiteConfigIpRestrictionHeadersList;
    putHeaders(value: WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | WindowsFunctionAppSlotSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class WindowsFunctionAppSlotSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsFunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotSiteConfigIpRestrictionOutputReference;
}
export interface WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_azure_fdid WindowsFunctionAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_fd_health_probe WindowsFunctionAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_forwarded_for WindowsFunctionAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#x_forwarded_host WindowsFunctionAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function windowsFunctionAppSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface WindowsFunctionAppSlotSiteConfigScmIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#action WindowsFunctionAppSlot#action}
    */
    readonly action?: string;
    /**
    * The description of the IP restriction rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#description WindowsFunctionAppSlot#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#headers WindowsFunctionAppSlot#headers}
    */
    readonly headers?: WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#ip_address WindowsFunctionAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name WindowsFunctionAppSlot#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#priority WindowsFunctionAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#service_tag WindowsFunctionAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#virtual_network_subnet_id WindowsFunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function windowsFunctionAppSlotSiteConfigScmIpRestrictionToTerraform(struct?: WindowsFunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotSiteConfigScmIpRestrictionToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _headers;
    get headers(): WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | WindowsFunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class WindowsFunctionAppSlotSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsFunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotSiteConfigScmIpRestrictionOutputReference;
}
export interface WindowsFunctionAppSlotSiteConfig {
    /**
    * If this Windows Web App is Always On enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#always_on WindowsFunctionAppSlot#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * The URL of the API definition that describes this Windows Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#api_definition_url WindowsFunctionAppSlot#api_definition_url}
    */
    readonly apiDefinitionUrl?: string;
    /**
    * The ID of the API Management API for this Windows Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#api_management_api_id WindowsFunctionAppSlot#api_management_api_id}
    */
    readonly apiManagementApiId?: string;
    /**
    * The program and any arguments used to launch this app via the command line. (Example `node myapp.js`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_command_line WindowsFunctionAppSlot#app_command_line}
    */
    readonly appCommandLine?: string;
    /**
    * The number of workers this function app can scale out to. Only applicable to apps on the Consumption and Premium plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_scale_limit WindowsFunctionAppSlot#app_scale_limit}
    */
    readonly appScaleLimit?: number;
    /**
    * The Connection String for linking the Windows Function App to Application Insights.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#application_insights_connection_string WindowsFunctionAppSlot#application_insights_connection_string}
    */
    readonly applicationInsightsConnectionString?: string;
    /**
    * The Instrumentation Key for connecting the Windows Function App to Application Insights.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#application_insights_key WindowsFunctionAppSlot#application_insights_key}
    */
    readonly applicationInsightsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#auto_swap_slot_name WindowsFunctionAppSlot#auto_swap_slot_name}
    */
    readonly autoSwapSlotName?: string;
    /**
    * Specifies a list of Default Documents for the Windows Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#default_documents WindowsFunctionAppSlot#default_documents}
    */
    readonly defaultDocuments?: string[];
    /**
    * The number of minimum instances for this Windows Function App. Only affects apps on Elastic Premium plans.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#elastic_instance_minimum WindowsFunctionAppSlot#elastic_instance_minimum}
    */
    readonly elasticInstanceMinimum?: number;
    /**
    * State of FTP / FTPS service for this function app. Possible values include: `AllAllowed`, `FtpsOnly` and `Disabled`. Defaults to `Disabled`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#ftps_state WindowsFunctionAppSlot#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * The amount of time in minutes that a node is unhealthy before being removed from the load balancer. Possible values are between `2` and `10`. Defaults to `10`. Only valid in conjunction with `health_check_path`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#health_check_eviction_time_in_min WindowsFunctionAppSlot#health_check_eviction_time_in_min}
    */
    readonly healthCheckEvictionTimeInMin?: number;
    /**
    * The path to be checked for this function app health.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#health_check_path WindowsFunctionAppSlot#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Specifies if the http2 protocol should be enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#http2_enabled WindowsFunctionAppSlot#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#ip_restriction_default_action WindowsFunctionAppSlot#ip_restriction_default_action}
    */
    readonly ipRestrictionDefaultAction?: string;
    /**
    * The Site load balancing mode. Possible values include: `WeightedRoundRobin`, `LeastRequests`, `LeastResponseTime`, `WeightedTotalTraffic`, `RequestHash`, `PerSiteRoundRobin`. Defaults to `LeastRequests` if omitted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#load_balancing_mode WindowsFunctionAppSlot#load_balancing_mode}
    */
    readonly loadBalancingMode?: string;
    /**
    * The Managed Pipeline mode. Possible values include: `Integrated`, `Classic`. Defaults to `Integrated`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#managed_pipeline_mode WindowsFunctionAppSlot#managed_pipeline_mode}
    */
    readonly managedPipelineMode?: string;
    /**
    * The configures the minimum version of TLS required for SSL requests. Possible values include: `1.0`, `1.1`, and  `1.2`. Defaults to `1.2`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#minimum_tls_version WindowsFunctionAppSlot#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * The number of pre-warmed instances for this function app. Only affects apps on an Elastic Premium plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#pre_warmed_instance_count WindowsFunctionAppSlot#pre_warmed_instance_count}
    */
    readonly preWarmedInstanceCount?: number;
    /**
    * Should Remote Debugging be enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#remote_debugging_enabled WindowsFunctionAppSlot#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The Remote Debugging Version. Possible values include `VS2017`, `VS2019`, and `VS2022`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#remote_debugging_version WindowsFunctionAppSlot#remote_debugging_version}
    */
    readonly remoteDebuggingVersion?: string;
    /**
    * Should Functions Runtime Scale Monitoring be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#runtime_scale_monitoring_enabled WindowsFunctionAppSlot#runtime_scale_monitoring_enabled}
    */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#scm_ip_restriction_default_action WindowsFunctionAppSlot#scm_ip_restriction_default_action}
    */
    readonly scmIpRestrictionDefaultAction?: string;
    /**
    * Configures the minimum version of TLS required for SSL requests to the SCM site Possible values include: `1.0`, `1.1`, and  `1.2`. Defaults to `1.2`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#scm_minimum_tls_version WindowsFunctionAppSlot#scm_minimum_tls_version}
    */
    readonly scmMinimumTlsVersion?: string;
    /**
    * Should the Windows Function App `ip_restriction` configuration be used for the SCM also.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#scm_use_main_ip_restriction WindowsFunctionAppSlot#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Should the Windows Function App use a 32-bit worker.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#use_32_bit_worker WindowsFunctionAppSlot#use_32_bit_worker}
    */
    readonly use32BitWorker?: boolean | cdktf.IResolvable;
    /**
    * Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#vnet_route_all_enabled WindowsFunctionAppSlot#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Should Web Sockets be enabled. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#websockets_enabled WindowsFunctionAppSlot#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * The number of Workers for this Windows Function App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#worker_count WindowsFunctionAppSlot#worker_count}
    */
    readonly workerCount?: number;
    /**
    * app_service_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#app_service_logs WindowsFunctionAppSlot#app_service_logs}
    */
    readonly appServiceLogs?: WindowsFunctionAppSlotSiteConfigAppServiceLogs;
    /**
    * application_stack block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#application_stack WindowsFunctionAppSlot#application_stack}
    */
    readonly applicationStack?: WindowsFunctionAppSlotSiteConfigApplicationStack;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#cors WindowsFunctionAppSlot#cors}
    */
    readonly cors?: WindowsFunctionAppSlotSiteConfigCors;
    /**
    * ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#ip_restriction WindowsFunctionAppSlot#ip_restriction}
    */
    readonly ipRestriction?: WindowsFunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * scm_ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#scm_ip_restriction WindowsFunctionAppSlot#scm_ip_restriction}
    */
    readonly scmIpRestriction?: WindowsFunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
}
export declare function windowsFunctionAppSlotSiteConfigToTerraform(struct?: WindowsFunctionAppSlotSiteConfigOutputReference | WindowsFunctionAppSlotSiteConfig): any;
export declare function windowsFunctionAppSlotSiteConfigToHclTerraform(struct?: WindowsFunctionAppSlotSiteConfigOutputReference | WindowsFunctionAppSlotSiteConfig): any;
export declare class WindowsFunctionAppSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotSiteConfig | undefined;
    set internalValue(value: WindowsFunctionAppSlotSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _apiDefinitionUrl?;
    get apiDefinitionUrl(): string;
    set apiDefinitionUrl(value: string);
    resetApiDefinitionUrl(): void;
    get apiDefinitionUrlInput(): string | undefined;
    private _apiManagementApiId?;
    get apiManagementApiId(): string;
    set apiManagementApiId(value: string);
    resetApiManagementApiId(): void;
    get apiManagementApiIdInput(): string | undefined;
    private _appCommandLine?;
    get appCommandLine(): string;
    set appCommandLine(value: string);
    resetAppCommandLine(): void;
    get appCommandLineInput(): string | undefined;
    private _appScaleLimit?;
    get appScaleLimit(): number;
    set appScaleLimit(value: number);
    resetAppScaleLimit(): void;
    get appScaleLimitInput(): number | undefined;
    private _applicationInsightsConnectionString?;
    get applicationInsightsConnectionString(): string;
    set applicationInsightsConnectionString(value: string);
    resetApplicationInsightsConnectionString(): void;
    get applicationInsightsConnectionStringInput(): string | undefined;
    private _applicationInsightsKey?;
    get applicationInsightsKey(): string;
    set applicationInsightsKey(value: string);
    resetApplicationInsightsKey(): void;
    get applicationInsightsKeyInput(): string | undefined;
    private _autoSwapSlotName?;
    get autoSwapSlotName(): string;
    set autoSwapSlotName(value: string);
    resetAutoSwapSlotName(): void;
    get autoSwapSlotNameInput(): string | undefined;
    private _defaultDocuments?;
    get defaultDocuments(): string[];
    set defaultDocuments(value: string[]);
    resetDefaultDocuments(): void;
    get defaultDocumentsInput(): string[] | undefined;
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    private _elasticInstanceMinimum?;
    get elasticInstanceMinimum(): number;
    set elasticInstanceMinimum(value: number);
    resetElasticInstanceMinimum(): void;
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckEvictionTimeInMin?;
    get healthCheckEvictionTimeInMin(): number;
    set healthCheckEvictionTimeInMin(value: number);
    resetHealthCheckEvictionTimeInMin(): void;
    get healthCheckEvictionTimeInMinInput(): number | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestrictionDefaultAction?;
    get ipRestrictionDefaultAction(): string;
    set ipRestrictionDefaultAction(value: string);
    resetIpRestrictionDefaultAction(): void;
    get ipRestrictionDefaultActionInput(): string | undefined;
    private _loadBalancingMode?;
    get loadBalancingMode(): string;
    set loadBalancingMode(value: string);
    resetLoadBalancingMode(): void;
    get loadBalancingModeInput(): string | undefined;
    private _managedPipelineMode?;
    get managedPipelineMode(): string;
    set managedPipelineMode(value: string);
    resetManagedPipelineMode(): void;
    get managedPipelineModeInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    get preWarmedInstanceCount(): number;
    set preWarmedInstanceCount(value: number);
    resetPreWarmedInstanceCount(): void;
    get preWarmedInstanceCountInput(): number | undefined;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    get remoteDebuggingVersion(): string;
    set remoteDebuggingVersion(value: string);
    resetRemoteDebuggingVersion(): void;
    get remoteDebuggingVersionInput(): string | undefined;
    private _runtimeScaleMonitoringEnabled?;
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetRuntimeScaleMonitoringEnabled(): void;
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scmIpRestrictionDefaultAction?;
    get scmIpRestrictionDefaultAction(): string;
    set scmIpRestrictionDefaultAction(value: string);
    resetScmIpRestrictionDefaultAction(): void;
    get scmIpRestrictionDefaultActionInput(): string | undefined;
    private _scmMinimumTlsVersion?;
    get scmMinimumTlsVersion(): string;
    set scmMinimumTlsVersion(value: string);
    resetScmMinimumTlsVersion(): void;
    get scmMinimumTlsVersionInput(): string | undefined;
    get scmType(): string;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorker?;
    get use32BitWorker(): boolean | cdktf.IResolvable;
    set use32BitWorker(value: boolean | cdktf.IResolvable);
    resetUse32BitWorker(): void;
    get use32BitWorkerInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get windowsFxVersion(): string;
    private _workerCount?;
    get workerCount(): number;
    set workerCount(value: number);
    resetWorkerCount(): void;
    get workerCountInput(): number | undefined;
    private _appServiceLogs;
    get appServiceLogs(): WindowsFunctionAppSlotSiteConfigAppServiceLogsOutputReference;
    putAppServiceLogs(value: WindowsFunctionAppSlotSiteConfigAppServiceLogs): void;
    resetAppServiceLogs(): void;
    get appServiceLogsInput(): WindowsFunctionAppSlotSiteConfigAppServiceLogs | undefined;
    private _applicationStack;
    get applicationStack(): WindowsFunctionAppSlotSiteConfigApplicationStackOutputReference;
    putApplicationStack(value: WindowsFunctionAppSlotSiteConfigApplicationStack): void;
    resetApplicationStack(): void;
    get applicationStackInput(): WindowsFunctionAppSlotSiteConfigApplicationStack | undefined;
    private _cors;
    get cors(): WindowsFunctionAppSlotSiteConfigCorsOutputReference;
    putCors(value: WindowsFunctionAppSlotSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): WindowsFunctionAppSlotSiteConfigCors | undefined;
    private _ipRestriction;
    get ipRestriction(): WindowsFunctionAppSlotSiteConfigIpRestrictionList;
    putIpRestriction(value: WindowsFunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | WindowsFunctionAppSlotSiteConfigIpRestriction[] | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): WindowsFunctionAppSlotSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: WindowsFunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | WindowsFunctionAppSlotSiteConfigScmIpRestriction[] | undefined;
}
export interface WindowsFunctionAppSlotStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#access_key WindowsFunctionAppSlot#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#account_name WindowsFunctionAppSlot#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#mount_path WindowsFunctionAppSlot#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#name WindowsFunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#share_name WindowsFunctionAppSlot#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#type WindowsFunctionAppSlot#type}
    */
    readonly type: string;
}
export declare function windowsFunctionAppSlotStorageAccountToTerraform(struct?: WindowsFunctionAppSlotStorageAccount | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotStorageAccountToHclTerraform(struct?: WindowsFunctionAppSlotStorageAccount | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsFunctionAppSlotStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotStorageAccount | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class WindowsFunctionAppSlotStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsFunctionAppSlotStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsFunctionAppSlotStorageAccountOutputReference;
}
export interface WindowsFunctionAppSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#create WindowsFunctionAppSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#delete WindowsFunctionAppSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#read WindowsFunctionAppSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#update WindowsFunctionAppSlot#update}
    */
    readonly update?: string;
}
export declare function windowsFunctionAppSlotTimeoutsToTerraform(struct?: WindowsFunctionAppSlotTimeouts | cdktf.IResolvable): any;
export declare function windowsFunctionAppSlotTimeoutsToHclTerraform(struct?: WindowsFunctionAppSlotTimeouts | cdktf.IResolvable): any;
export declare class WindowsFunctionAppSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsFunctionAppSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsFunctionAppSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot azurerm_windows_function_app_slot}
*/
export declare class WindowsFunctionAppSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_windows_function_app_slot";
    /**
    * Generates CDKTF code for importing a WindowsFunctionAppSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WindowsFunctionAppSlot to import
    * @param importFromId The id of the existing WindowsFunctionAppSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WindowsFunctionAppSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.115.0/docs/resources/windows_function_app_slot azurerm_windows_function_app_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WindowsFunctionAppSlotConfig
    */
    constructor(scope: Construct, id: string, config: WindowsFunctionAppSlotConfig);
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _builtinLoggingEnabled?;
    get builtinLoggingEnabled(): boolean | cdktf.IResolvable;
    set builtinLoggingEnabled(value: boolean | cdktf.IResolvable);
    resetBuiltinLoggingEnabled(): void;
    get builtinLoggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateEnabled?;
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    resetClientCertificateEnabled(): void;
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateExclusionPaths?;
    get clientCertificateExclusionPaths(): string;
    set clientCertificateExclusionPaths(value: string);
    resetClientCertificateExclusionPaths(): void;
    get clientCertificateExclusionPathsInput(): string | undefined;
    private _clientCertificateMode?;
    get clientCertificateMode(): string;
    set clientCertificateMode(value: string);
    resetClientCertificateMode(): void;
    get clientCertificateModeInput(): string | undefined;
    private _contentShareForceDisabled?;
    get contentShareForceDisabled(): boolean | cdktf.IResolvable;
    set contentShareForceDisabled(value: boolean | cdktf.IResolvable);
    resetContentShareForceDisabled(): void;
    get contentShareForceDisabledInput(): boolean | cdktf.IResolvable | undefined;
    get customDomainVerificationId(): string;
    private _dailyMemoryTimeQuota?;
    get dailyMemoryTimeQuota(): number;
    set dailyMemoryTimeQuota(value: number);
    resetDailyMemoryTimeQuota(): void;
    get dailyMemoryTimeQuotaInput(): number | undefined;
    get defaultHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ftpPublishBasicAuthenticationEnabled?;
    get ftpPublishBasicAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set ftpPublishBasicAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetFtpPublishBasicAuthenticationEnabled(): void;
    get ftpPublishBasicAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _functionAppId?;
    get functionAppId(): string;
    set functionAppId(value: string);
    get functionAppIdInput(): string | undefined;
    private _functionsExtensionVersion?;
    get functionsExtensionVersion(): string;
    set functionsExtensionVersion(value: string);
    resetFunctionsExtensionVersion(): void;
    get functionsExtensionVersionInput(): string | undefined;
    get hostingEnvironmentId(): string;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReferenceIdentityId?;
    get keyVaultReferenceIdentityId(): string;
    set keyVaultReferenceIdentityId(value: string);
    resetKeyVaultReferenceIdentityId(): void;
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    get kind(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _servicePlanId?;
    get servicePlanId(): string;
    set servicePlanId(value: string);
    resetServicePlanId(): void;
    get servicePlanIdInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): WindowsFunctionAppSlotSiteCredentialList;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _storageKeyVaultSecretId?;
    get storageKeyVaultSecretId(): string;
    set storageKeyVaultSecretId(value: string);
    resetStorageKeyVaultSecretId(): void;
    get storageKeyVaultSecretIdInput(): string | undefined;
    private _storageUsesManagedIdentity?;
    get storageUsesManagedIdentity(): boolean | cdktf.IResolvable;
    set storageUsesManagedIdentity(value: boolean | cdktf.IResolvable);
    resetStorageUsesManagedIdentity(): void;
    get storageUsesManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
    private _webdeployPublishBasicAuthenticationEnabled?;
    get webdeployPublishBasicAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set webdeployPublishBasicAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetWebdeployPublishBasicAuthenticationEnabled(): void;
    get webdeployPublishBasicAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _authSettings;
    get authSettings(): WindowsFunctionAppSlotAuthSettingsOutputReference;
    putAuthSettings(value: WindowsFunctionAppSlotAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): WindowsFunctionAppSlotAuthSettings | undefined;
    private _authSettingsV2;
    get authSettingsV2(): WindowsFunctionAppSlotAuthSettingsV2OutputReference;
    putAuthSettingsV2(value: WindowsFunctionAppSlotAuthSettingsV2): void;
    resetAuthSettingsV2(): void;
    get authSettingsV2Input(): WindowsFunctionAppSlotAuthSettingsV2 | undefined;
    private _backup;
    get backup(): WindowsFunctionAppSlotBackupOutputReference;
    putBackup(value: WindowsFunctionAppSlotBackup): void;
    resetBackup(): void;
    get backupInput(): WindowsFunctionAppSlotBackup | undefined;
    private _connectionString;
    get connectionString(): WindowsFunctionAppSlotConnectionStringList;
    putConnectionString(value: WindowsFunctionAppSlotConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | WindowsFunctionAppSlotConnectionString[] | undefined;
    private _identity;
    get identity(): WindowsFunctionAppSlotIdentityOutputReference;
    putIdentity(value: WindowsFunctionAppSlotIdentity): void;
    resetIdentity(): void;
    get identityInput(): WindowsFunctionAppSlotIdentity | undefined;
    private _siteConfig;
    get siteConfig(): WindowsFunctionAppSlotSiteConfigOutputReference;
    putSiteConfig(value: WindowsFunctionAppSlotSiteConfig): void;
    get siteConfigInput(): WindowsFunctionAppSlotSiteConfig | undefined;
    private _storageAccount;
    get storageAccount(): WindowsFunctionAppSlotStorageAccountList;
    putStorageAccount(value: WindowsFunctionAppSlotStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | WindowsFunctionAppSlotStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): WindowsFunctionAppSlotTimeoutsOutputReference;
    putTimeouts(value: WindowsFunctionAppSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WindowsFunctionAppSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
