# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBootVolumeBackupsResult',
    'AwaitableGetBootVolumeBackupsResult',
    'get_boot_volume_backups',
    'get_boot_volume_backups_output',
]

@pulumi.output_type
class GetBootVolumeBackupsResult:
    """
    A collection of values returned by getBootVolumeBackups.
    """
    def __init__(__self__, boot_volume_backups=None, boot_volume_id=None, compartment_id=None, display_name=None, filters=None, id=None, source_boot_volume_backup_id=None, state=None):
        if boot_volume_backups and not isinstance(boot_volume_backups, list):
            raise TypeError("Expected argument 'boot_volume_backups' to be a list")
        pulumi.set(__self__, "boot_volume_backups", boot_volume_backups)
        if boot_volume_id and not isinstance(boot_volume_id, str):
            raise TypeError("Expected argument 'boot_volume_id' to be a str")
        pulumi.set(__self__, "boot_volume_id", boot_volume_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if source_boot_volume_backup_id and not isinstance(source_boot_volume_backup_id, str):
            raise TypeError("Expected argument 'source_boot_volume_backup_id' to be a str")
        pulumi.set(__self__, "source_boot_volume_backup_id", source_boot_volume_backup_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bootVolumeBackups")
    def boot_volume_backups(self) -> Sequence['outputs.GetBootVolumeBackupsBootVolumeBackupResult']:
        """
        The list of boot_volume_backups.
        """
        return pulumi.get(self, "boot_volume_backups")

    @property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> Optional[str]:
        """
        The OCID of the boot volume.
        """
        return pulumi.get(self, "boot_volume_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the boot volume backup.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBootVolumeBackupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sourceBootVolumeBackupId")
    def source_boot_volume_backup_id(self) -> Optional[str]:
        """
        The OCID of the source boot volume backup.
        """
        return pulumi.get(self, "source_boot_volume_backup_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of a boot volume backup.
        """
        return pulumi.get(self, "state")


class AwaitableGetBootVolumeBackupsResult(GetBootVolumeBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBootVolumeBackupsResult(
            boot_volume_backups=self.boot_volume_backups,
            boot_volume_id=self.boot_volume_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            source_boot_volume_backup_id=self.source_boot_volume_backup_id,
            state=self.state)


def get_boot_volume_backups(boot_volume_id: Optional[str] = None,
                            compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetBootVolumeBackupsFilterArgs', 'GetBootVolumeBackupsFilterArgsDict']]] = None,
                            source_boot_volume_backup_id: Optional[str] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBootVolumeBackupsResult:
    """
    This data source provides the list of Boot Volume Backups in Oracle Cloud Infrastructure Core service.

    Lists the boot volume backups in the specified compartment. You can filter the results by boot volume.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volume_backups = oci.Core.get_boot_volume_backups(compartment_id=compartment_id,
        boot_volume_id=test_boot_volume["id"],
        display_name=boot_volume_backup_display_name,
        source_boot_volume_backup_id=test_boot_volume_backup["id"],
        state=boot_volume_backup_state)
    ```


    :param str boot_volume_id: The OCID of the boot volume.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str source_boot_volume_backup_id: A filter to return only resources that originated from the given source boot volume backup.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['bootVolumeId'] = boot_volume_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sourceBootVolumeBackupId'] = source_boot_volume_backup_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getBootVolumeBackups:getBootVolumeBackups', __args__, opts=opts, typ=GetBootVolumeBackupsResult).value

    return AwaitableGetBootVolumeBackupsResult(
        boot_volume_backups=pulumi.get(__ret__, 'boot_volume_backups'),
        boot_volume_id=pulumi.get(__ret__, 'boot_volume_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        source_boot_volume_backup_id=pulumi.get(__ret__, 'source_boot_volume_backup_id'),
        state=pulumi.get(__ret__, 'state'))
def get_boot_volume_backups_output(boot_volume_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   compartment_id: Optional[pulumi.Input[str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBootVolumeBackupsFilterArgs', 'GetBootVolumeBackupsFilterArgsDict']]]]] = None,
                                   source_boot_volume_backup_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBootVolumeBackupsResult]:
    """
    This data source provides the list of Boot Volume Backups in Oracle Cloud Infrastructure Core service.

    Lists the boot volume backups in the specified compartment. You can filter the results by boot volume.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_boot_volume_backups = oci.Core.get_boot_volume_backups(compartment_id=compartment_id,
        boot_volume_id=test_boot_volume["id"],
        display_name=boot_volume_backup_display_name,
        source_boot_volume_backup_id=test_boot_volume_backup["id"],
        state=boot_volume_backup_state)
    ```


    :param str boot_volume_id: The OCID of the boot volume.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str source_boot_volume_backup_id: A filter to return only resources that originated from the given source boot volume backup.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['bootVolumeId'] = boot_volume_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sourceBootVolumeBackupId'] = source_boot_volume_backup_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getBootVolumeBackups:getBootVolumeBackups', __args__, opts=opts, typ=GetBootVolumeBackupsResult)
    return __ret__.apply(lambda __response__: GetBootVolumeBackupsResult(
        boot_volume_backups=pulumi.get(__response__, 'boot_volume_backups'),
        boot_volume_id=pulumi.get(__response__, 'boot_volume_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        source_boot_volume_backup_id=pulumi.get(__response__, 'source_boot_volume_backup_id'),
        state=pulumi.get(__response__, 'state')))
