# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExadataInfrastructureConfigureExascaleManagementArgs', 'ExadataInfrastructureConfigureExascaleManagement']

@pulumi.input_type
class ExadataInfrastructureConfigureExascaleManagementArgs:
    def __init__(__self__, *,
                 exadata_infrastructure_id: pulumi.Input[str],
                 total_storage_in_gbs: pulumi.Input[int]):
        """
        The set of arguments for constructing a ExadataInfrastructureConfigureExascaleManagement resource.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        pulumi.set(__self__, "total_storage_in_gbs", total_storage_in_gbs)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Input[str]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="totalStorageInGbs")
    def total_storage_in_gbs(self) -> pulumi.Input[int]:
        """
        Storage size needed for Exascale in GBs.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_storage_in_gbs")

    @total_storage_in_gbs.setter
    def total_storage_in_gbs(self, value: pulumi.Input[int]):
        pulumi.set(self, "total_storage_in_gbs", value)


@pulumi.input_type
class _ExadataInfrastructureConfigureExascaleManagementState:
    def __init__(__self__, *,
                 activated_storage_count: Optional[pulumi.Input[int]] = None,
                 additional_compute_count: Optional[pulumi.Input[int]] = None,
                 additional_compute_system_model: Optional[pulumi.Input[str]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementContactArgs']]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 cpus_enabled: Optional[pulumi.Input[int]] = None,
                 csi_number: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_server_version: Optional[pulumi.Input[str]] = None,
                 defined_file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 exascale_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
                 is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
                 is_scheduling_policy_associated: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_slo_status: Optional[pulumi.Input[str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]]] = None,
                 max_cpu_count: Optional[pulumi.Input[int]] = None,
                 max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
                 max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
                 max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 monthly_db_server_version: Optional[pulumi.Input[str]] = None,
                 multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 network_bonding_mode_details: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgs']]]] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rack_serial_number: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 storage_server_version: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 total_storage_in_gbs: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ExadataInfrastructureConfigureExascaleManagement resources.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[int] additional_compute_count: The requested number of additional compute servers for the Exadata infrastructure.
        :param pulumi.Input[str] additional_compute_system_model: Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] admin_network_cidr: The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the Exadata infrastructure is located in.
        :param pulumi.Input[str] cloud_control_plane_server1: The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementContactArgs']]] contacts: The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: The corporate network proxy for access to the control plane network.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[str] csi_number: The CSI Number of the Exadata infrastructure.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]] defined_file_system_configurations: Details of the file system configuration of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]] exascale_configs: The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway: The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[bool] is_cps_offline_report_enabled: Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[bool] is_multi_rack_deployment: Indicates if deployment is Multi-Rack or not.
        :param pulumi.Input[bool] is_scheduling_policy_associated: If true, the infrastructure is using granular maintenance scheduling preference.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_slo_status: A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[str] multi_rack_configuration_file: The base64 encoded Multi-Rack configuration json file.
        :param pulumi.Input[str] netmask: The netmask for the control plane network.
        :param pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgs']]] network_bonding_mode_details: Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] rack_serial_number: The serial number for the Exadata infrastructure.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[str] state: The current lifecycle state of the Exadata infrastructure.
        :param pulumi.Input[int] storage_count: The number of Exadata storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the Exadata infrastructure.
        :param pulumi.Input[str] time_created: The date and time the Exadata infrastructure was created.
        :param pulumi.Input[str] time_zone: The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if activated_storage_count is not None:
            pulumi.set(__self__, "activated_storage_count", activated_storage_count)
        if additional_compute_count is not None:
            pulumi.set(__self__, "additional_compute_count", additional_compute_count)
        if additional_compute_system_model is not None:
            pulumi.set(__self__, "additional_compute_system_model", additional_compute_system_model)
        if additional_storage_count is not None:
            pulumi.set(__self__, "additional_storage_count", additional_storage_count)
        if admin_network_cidr is not None:
            pulumi.set(__self__, "admin_network_cidr", admin_network_cidr)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if cloud_control_plane_server1 is not None:
            pulumi.set(__self__, "cloud_control_plane_server1", cloud_control_plane_server1)
        if cloud_control_plane_server2 is not None:
            pulumi.set(__self__, "cloud_control_plane_server2", cloud_control_plane_server2)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if corporate_proxy is not None:
            pulumi.set(__self__, "corporate_proxy", corporate_proxy)
        if cpus_enabled is not None:
            pulumi.set(__self__, "cpus_enabled", cpus_enabled)
        if csi_number is not None:
            pulumi.set(__self__, "csi_number", csi_number)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version is not None:
            pulumi.set(__self__, "db_server_version", db_server_version)
        if defined_file_system_configurations is not None:
            pulumi.set(__self__, "defined_file_system_configurations", defined_file_system_configurations)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if exascale_configs is not None:
            pulumi.set(__self__, "exascale_configs", exascale_configs)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if infini_band_network_cidr is not None:
            pulumi.set(__self__, "infini_band_network_cidr", infini_band_network_cidr)
        if is_cps_offline_report_enabled is not None:
            pulumi.set(__self__, "is_cps_offline_report_enabled", is_cps_offline_report_enabled)
        if is_multi_rack_deployment is not None:
            pulumi.set(__self__, "is_multi_rack_deployment", is_multi_rack_deployment)
        if is_scheduling_policy_associated is not None:
            pulumi.set(__self__, "is_scheduling_policy_associated", is_scheduling_policy_associated)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_slo_status is not None:
            pulumi.set(__self__, "maintenance_slo_status", maintenance_slo_status)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if max_cpu_count is not None:
            pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs is not None:
            pulumi.set(__self__, "max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_in_gbs is not None:
            pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs is not None:
            pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version is not None:
            pulumi.set(__self__, "monthly_db_server_version", monthly_db_server_version)
        if multi_rack_configuration_file is not None:
            pulumi.set(__self__, "multi_rack_configuration_file", multi_rack_configuration_file)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if network_bonding_mode_details is not None:
            pulumi.set(__self__, "network_bonding_mode_details", network_bonding_mode_details)
        if ntp_servers is not None:
            pulumi.set(__self__, "ntp_servers", ntp_servers)
        if rack_serial_number is not None:
            pulumi.set(__self__, "rack_serial_number", rack_serial_number)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)
        if storage_server_version is not None:
            pulumi.set(__self__, "storage_server_version", storage_server_version)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if total_storage_in_gbs is not None:
            pulumi.set(__self__, "total_storage_in_gbs", total_storage_in_gbs)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @activated_storage_count.setter
    def activated_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "activated_storage_count", value)

    @property
    @pulumi.getter(name="additionalComputeCount")
    def additional_compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_compute_count")

    @additional_compute_count.setter
    def additional_compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_compute_count", value)

    @property
    @pulumi.getter(name="additionalComputeSystemModel")
    def additional_compute_system_model(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        """
        return pulumi.get(self, "additional_compute_system_model")

    @additional_compute_system_model.setter
    def additional_compute_system_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_compute_system_model", value)

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_storage_count", value)

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the Exadata administration network.
        """
        return pulumi.get(self, "admin_network_cidr")

    @admin_network_cidr.setter
    def admin_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_network_cidr", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the availability domain that the Exadata infrastructure is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address for the first control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server1")

    @cloud_control_plane_server1.setter
    def cloud_control_plane_server1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server1", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address for the second control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server2")

    @cloud_control_plane_server2.setter
    def cloud_control_plane_server2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server2", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementContactArgs']]]]:
        """
        The list of contacts for the Exadata infrastructure.
        """
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        The corporate network proxy for access to the control plane network.
        """
        return pulumi.get(self, "corporate_proxy")

    @corporate_proxy.setter
    def corporate_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corporate_proxy", value)

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> Optional[pulumi.Input[int]]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @cpus_enabled.setter
    def cpus_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpus_enabled", value)

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> Optional[pulumi.Input[str]]:
        """
        The CSI Number of the Exadata infrastructure.
        """
        return pulumi.get(self, "csi_number")

    @csi_number.setter
    def csi_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csi_number", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @db_server_version.setter
    def db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_server_version", value)

    @property
    @pulumi.getter(name="definedFileSystemConfigurations")
    def defined_file_system_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]]]:
        """
        Details of the file system configuration of the Exadata infrastructure.
        """
        return pulumi.get(self, "defined_file_system_configurations")

    @defined_file_system_configurations.setter
    def defined_file_system_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs']]]]):
        pulumi.set(self, "defined_file_system_configurations", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="exascaleConfigs")
    def exascale_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]]]:
        """
        The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        """
        return pulumi.get(self, "exascale_configs")

    @exascale_configs.setter
    def exascale_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs']]]]):
        pulumi.set(self, "exascale_configs", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway for the control plane network.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the Exadata InfiniBand interconnect.
        """
        return pulumi.get(self, "infini_band_network_cidr")

    @infini_band_network_cidr.setter
    def infini_band_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infini_band_network_cidr", value)

    @property
    @pulumi.getter(name="isCpsOfflineReportEnabled")
    def is_cps_offline_report_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        """
        return pulumi.get(self, "is_cps_offline_report_enabled")

    @is_cps_offline_report_enabled.setter
    def is_cps_offline_report_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cps_offline_report_enabled", value)

    @property
    @pulumi.getter(name="isMultiRackDeployment")
    def is_multi_rack_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if deployment is Multi-Rack or not.
        """
        return pulumi.get(self, "is_multi_rack_deployment")

    @is_multi_rack_deployment.setter
    def is_multi_rack_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multi_rack_deployment", value)

    @property
    @pulumi.getter(name="isSchedulingPolicyAssociated")
    def is_scheduling_policy_associated(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the infrastructure is using granular maintenance scheduling preference.
        """
        return pulumi.get(self, "is_scheduling_policy_associated")

    @is_scheduling_policy_associated.setter
    def is_scheduling_policy_associated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduling_policy_associated", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> Optional[pulumi.Input[str]]:
        """
        A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        """
        return pulumi.get(self, "maintenance_slo_status")

    @maintenance_slo_status.setter
    def maintenance_slo_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_slo_status", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @max_cpu_count.setter
    def max_cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cpu_count", value)

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @max_data_storage_in_tbs.setter
    def max_data_storage_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_data_storage_in_tbs", value)

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @max_db_node_storage_in_gbs.setter
    def max_db_node_storage_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_db_node_storage_in_gbs", value)

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @max_memory_in_gbs.setter
    def max_memory_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_memory_in_gbs", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @monthly_db_server_version.setter
    def monthly_db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monthly_db_server_version", value)

    @property
    @pulumi.getter(name="multiRackConfigurationFile")
    def multi_rack_configuration_file(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 encoded Multi-Rack configuration json file.
        """
        return pulumi.get(self, "multi_rack_configuration_file")

    @multi_rack_configuration_file.setter
    def multi_rack_configuration_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_rack_configuration_file", value)

    @property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[str]]:
        """
        The netmask for the control plane network.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="networkBondingModeDetails")
    def network_bonding_mode_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgs']]]]:
        """
        Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        """
        return pulumi.get(self, "network_bonding_mode_details")

    @network_bonding_mode_details.setter
    def network_bonding_mode_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgs']]]]):
        pulumi.set(self, "network_bonding_mode_details", value)

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntp_servers")

    @ntp_servers.setter
    def ntp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ntp_servers", value)

    @property
    @pulumi.getter(name="rackSerialNumber")
    def rack_serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        The serial number for the Exadata infrastructure.
        """
        return pulumi.get(self, "rack_serial_number")

    @rack_serial_number.setter
    def rack_serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rack_serial_number", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the Exadata infrastructure.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Exadata storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the storage servers (cells) in the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @storage_server_version.setter
    def storage_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_server_version", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Exadata infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="totalStorageInGbs")
    def total_storage_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        Storage size needed for Exascale in GBs.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_storage_in_gbs")

    @total_storage_in_gbs.setter
    def total_storage_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_storage_in_gbs", value)


class ExadataInfrastructureConfigureExascaleManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 total_storage_in_gbs: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Exadata Infrastructure Configure Exascale Management resource in Oracle Cloud Infrastructure Database service.

        Configures Exascale on Exadata infrastructure resource. Applies to Exadata Cloud@Customer instances only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_infrastructure_configure_exascale_management = oci.database.ExadataInfrastructureConfigureExascaleManagement("test_exadata_infrastructure_configure_exascale_management",
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            total_storage_in_gbs=exadata_infrastructure_configure_exascale_management_total_storage_in_gbs)
        ```

        ## Import

        ExadataInfrastructureConfigureExascaleManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/exadataInfrastructureConfigureExascaleManagement:ExadataInfrastructureConfigureExascaleManagement test_exadata_infrastructure_configure_exascale_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExadataInfrastructureConfigureExascaleManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Exadata Infrastructure Configure Exascale Management resource in Oracle Cloud Infrastructure Database service.

        Configures Exascale on Exadata infrastructure resource. Applies to Exadata Cloud@Customer instances only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_infrastructure_configure_exascale_management = oci.database.ExadataInfrastructureConfigureExascaleManagement("test_exadata_infrastructure_configure_exascale_management",
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            total_storage_in_gbs=exadata_infrastructure_configure_exascale_management_total_storage_in_gbs)
        ```

        ## Import

        ExadataInfrastructureConfigureExascaleManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/exadataInfrastructureConfigureExascaleManagement:ExadataInfrastructureConfigureExascaleManagement test_exadata_infrastructure_configure_exascale_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExadataInfrastructureConfigureExascaleManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExadataInfrastructureConfigureExascaleManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 total_storage_in_gbs: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExadataInfrastructureConfigureExascaleManagementArgs.__new__(ExadataInfrastructureConfigureExascaleManagementArgs)

            if exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'exadata_infrastructure_id'")
            __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
            if total_storage_in_gbs is None and not opts.urn:
                raise TypeError("Missing required property 'total_storage_in_gbs'")
            __props__.__dict__["total_storage_in_gbs"] = total_storage_in_gbs
            __props__.__dict__["activated_storage_count"] = None
            __props__.__dict__["additional_compute_count"] = None
            __props__.__dict__["additional_compute_system_model"] = None
            __props__.__dict__["additional_storage_count"] = None
            __props__.__dict__["admin_network_cidr"] = None
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["cloud_control_plane_server1"] = None
            __props__.__dict__["cloud_control_plane_server2"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compute_count"] = None
            __props__.__dict__["contacts"] = None
            __props__.__dict__["corporate_proxy"] = None
            __props__.__dict__["cpus_enabled"] = None
            __props__.__dict__["csi_number"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["db_server_version"] = None
            __props__.__dict__["defined_file_system_configurations"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["dns_servers"] = None
            __props__.__dict__["exascale_configs"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["gateway"] = None
            __props__.__dict__["infini_band_network_cidr"] = None
            __props__.__dict__["is_cps_offline_report_enabled"] = None
            __props__.__dict__["is_multi_rack_deployment"] = None
            __props__.__dict__["is_scheduling_policy_associated"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_slo_status"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["max_cpu_count"] = None
            __props__.__dict__["max_data_storage_in_tbs"] = None
            __props__.__dict__["max_db_node_storage_in_gbs"] = None
            __props__.__dict__["max_memory_in_gbs"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["monthly_db_server_version"] = None
            __props__.__dict__["multi_rack_configuration_file"] = None
            __props__.__dict__["netmask"] = None
            __props__.__dict__["network_bonding_mode_details"] = None
            __props__.__dict__["ntp_servers"] = None
            __props__.__dict__["rack_serial_number"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_count"] = None
            __props__.__dict__["storage_server_version"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_zone"] = None
        super(ExadataInfrastructureConfigureExascaleManagement, __self__).__init__(
            'oci:Database/exadataInfrastructureConfigureExascaleManagement:ExadataInfrastructureConfigureExascaleManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated_storage_count: Optional[pulumi.Input[int]] = None,
            additional_compute_count: Optional[pulumi.Input[int]] = None,
            additional_compute_system_model: Optional[pulumi.Input[str]] = None,
            additional_storage_count: Optional[pulumi.Input[int]] = None,
            admin_network_cidr: Optional[pulumi.Input[str]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_count: Optional[pulumi.Input[int]] = None,
            contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementContactArgs', 'ExadataInfrastructureConfigureExascaleManagementContactArgsDict']]]]] = None,
            corporate_proxy: Optional[pulumi.Input[str]] = None,
            cpus_enabled: Optional[pulumi.Input[int]] = None,
            csi_number: Optional[pulumi.Input[str]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            db_server_version: Optional[pulumi.Input[str]] = None,
            defined_file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs', 'ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
            exascale_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs', 'ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgsDict']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            gateway: Optional[pulumi.Input[str]] = None,
            infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
            is_cps_offline_report_enabled: Optional[pulumi.Input[bool]] = None,
            is_multi_rack_deployment: Optional[pulumi.Input[bool]] = None,
            is_scheduling_policy_associated: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_slo_status: Optional[pulumi.Input[str]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs', 'ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgsDict']]]]] = None,
            max_cpu_count: Optional[pulumi.Input[int]] = None,
            max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
            max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
            max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            monthly_db_server_version: Optional[pulumi.Input[str]] = None,
            multi_rack_configuration_file: Optional[pulumi.Input[str]] = None,
            netmask: Optional[pulumi.Input[str]] = None,
            network_bonding_mode_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgs', 'ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgsDict']]]]] = None,
            ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rack_serial_number: Optional[pulumi.Input[str]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_count: Optional[pulumi.Input[int]] = None,
            storage_server_version: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            total_storage_in_gbs: Optional[pulumi.Input[int]] = None) -> 'ExadataInfrastructureConfigureExascaleManagement':
        """
        Get an existing ExadataInfrastructureConfigureExascaleManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[int] additional_compute_count: The requested number of additional compute servers for the Exadata infrastructure.
        :param pulumi.Input[str] additional_compute_system_model: Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] admin_network_cidr: The CIDR block for the Exadata administration network.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the Exadata infrastructure is located in.
        :param pulumi.Input[str] cloud_control_plane_server1: The IP address for the first control plane server.
        :param pulumi.Input[str] cloud_control_plane_server2: The IP address for the second control plane server.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: The number of compute servers for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementContactArgs', 'ExadataInfrastructureConfigureExascaleManagementContactArgsDict']]]] contacts: The list of contacts for the Exadata infrastructure.
        :param pulumi.Input[str] corporate_proxy: The corporate network proxy for access to the control plane network.
        :param pulumi.Input[int] cpus_enabled: The number of enabled CPU cores.
        :param pulumi.Input[str] csi_number: The CSI Number of the Exadata infrastructure.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgs', 'ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfigurationArgsDict']]]] defined_file_system_configurations: Details of the file system configuration of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: The list of DNS server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgs', 'ExadataInfrastructureConfigureExascaleManagementExascaleConfigArgsDict']]]] exascale_configs: The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] gateway: The gateway for the control plane network.
        :param pulumi.Input[str] infini_band_network_cidr: The CIDR block for the Exadata InfiniBand interconnect.
        :param pulumi.Input[bool] is_cps_offline_report_enabled: Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        :param pulumi.Input[bool] is_multi_rack_deployment: Indicates if deployment is Multi-Rack or not.
        :param pulumi.Input[bool] is_scheduling_policy_associated: If true, the infrastructure is using granular maintenance scheduling preference.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] maintenance_slo_status: A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgs', 'ExadataInfrastructureConfigureExascaleManagementMaintenanceWindowArgsDict']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[str] multi_rack_configuration_file: The base64 encoded Multi-Rack configuration json file.
        :param pulumi.Input[str] netmask: The netmask for the control plane network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgs', 'ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetailArgsDict']]]] network_bonding_mode_details: Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ntp_servers: The list of NTP server IP addresses. Maximum of 3 allowed.
        :param pulumi.Input[str] rack_serial_number: The serial number for the Exadata infrastructure.
        :param pulumi.Input[str] shape: The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        :param pulumi.Input[str] state: The current lifecycle state of the Exadata infrastructure.
        :param pulumi.Input[int] storage_count: The number of Exadata storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the Exadata infrastructure.
        :param pulumi.Input[str] time_created: The date and time the Exadata infrastructure was created.
        :param pulumi.Input[str] time_zone: The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[int] total_storage_in_gbs: Storage size needed for Exascale in GBs.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExadataInfrastructureConfigureExascaleManagementState.__new__(_ExadataInfrastructureConfigureExascaleManagementState)

        __props__.__dict__["activated_storage_count"] = activated_storage_count
        __props__.__dict__["additional_compute_count"] = additional_compute_count
        __props__.__dict__["additional_compute_system_model"] = additional_compute_system_model
        __props__.__dict__["additional_storage_count"] = additional_storage_count
        __props__.__dict__["admin_network_cidr"] = admin_network_cidr
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["cloud_control_plane_server1"] = cloud_control_plane_server1
        __props__.__dict__["cloud_control_plane_server2"] = cloud_control_plane_server2
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["contacts"] = contacts
        __props__.__dict__["corporate_proxy"] = corporate_proxy
        __props__.__dict__["cpus_enabled"] = cpus_enabled
        __props__.__dict__["csi_number"] = csi_number
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_server_version"] = db_server_version
        __props__.__dict__["defined_file_system_configurations"] = defined_file_system_configurations
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["exascale_configs"] = exascale_configs
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["infini_band_network_cidr"] = infini_band_network_cidr
        __props__.__dict__["is_cps_offline_report_enabled"] = is_cps_offline_report_enabled
        __props__.__dict__["is_multi_rack_deployment"] = is_multi_rack_deployment
        __props__.__dict__["is_scheduling_policy_associated"] = is_scheduling_policy_associated
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_slo_status"] = maintenance_slo_status
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["max_cpu_count"] = max_cpu_count
        __props__.__dict__["max_data_storage_in_tbs"] = max_data_storage_in_tbs
        __props__.__dict__["max_db_node_storage_in_gbs"] = max_db_node_storage_in_gbs
        __props__.__dict__["max_memory_in_gbs"] = max_memory_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["monthly_db_server_version"] = monthly_db_server_version
        __props__.__dict__["multi_rack_configuration_file"] = multi_rack_configuration_file
        __props__.__dict__["netmask"] = netmask
        __props__.__dict__["network_bonding_mode_details"] = network_bonding_mode_details
        __props__.__dict__["ntp_servers"] = ntp_servers
        __props__.__dict__["rack_serial_number"] = rack_serial_number
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_count"] = storage_count
        __props__.__dict__["storage_server_version"] = storage_server_version
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["total_storage_in_gbs"] = total_storage_in_gbs
        return ExadataInfrastructureConfigureExascaleManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @property
    @pulumi.getter(name="additionalComputeCount")
    def additional_compute_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_compute_count")

    @property
    @pulumi.getter(name="additionalComputeSystemModel")
    def additional_compute_system_model(self) -> pulumi.Output[str]:
        """
        Oracle Exadata System Model specification. The system model determines the amount of compute or storage server resources available for use. For more information, please see [System and Shape Configuration Options] (https://docs.oracle.com/en/engineered-systems/exadata-cloud-at-customer/ecccm/ecc-system-config-options.html#GUID-9E090174-5C57-4EB1-9243-B470F9F10D6B)
        """
        return pulumi.get(self, "additional_compute_system_model")

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> pulumi.Output[str]:
        """
        The CIDR block for the Exadata administration network.
        """
        return pulumi.get(self, "admin_network_cidr")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The name of the availability domain that the Exadata infrastructure is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> pulumi.Output[str]:
        """
        The IP address for the first control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server1")

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> pulumi.Output[str]:
        """
        The IP address for the second control plane server.
        """
        return pulumi.get(self, "cloud_control_plane_server2")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[int]:
        """
        The number of compute servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter
    def contacts(self) -> pulumi.Output[Sequence['outputs.ExadataInfrastructureConfigureExascaleManagementContact']]:
        """
        The list of contacts for the Exadata infrastructure.
        """
        return pulumi.get(self, "contacts")

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> pulumi.Output[str]:
        """
        The corporate network proxy for access to the control plane network.
        """
        return pulumi.get(self, "corporate_proxy")

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> pulumi.Output[int]:
        """
        The number of enabled CPU cores.
        """
        return pulumi.get(self, "cpus_enabled")

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> pulumi.Output[str]:
        """
        The CSI Number of the Exadata infrastructure.
        """
        return pulumi.get(self, "csi_number")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @property
    @pulumi.getter(name="definedFileSystemConfigurations")
    def defined_file_system_configurations(self) -> pulumi.Output[Sequence['outputs.ExadataInfrastructureConfigureExascaleManagementDefinedFileSystemConfiguration']]:
        """
        Details of the file system configuration of the Exadata infrastructure.
        """
        return pulumi.get(self, "defined_file_system_configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the Exadata Cloud@Customer infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[str]:
        """
        The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="exascaleConfigs")
    def exascale_configs(self) -> pulumi.Output[Sequence['outputs.ExadataInfrastructureConfigureExascaleManagementExascaleConfig']]:
        """
        The exascale config response details for the Exadata Cloud@Customer infrastructure or cloud Exadata infrastructure . Applies to both Exadata Cloud@Customer instances and Exadata Cloud Service instances.
        """
        return pulumi.get(self, "exascale_configs")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[str]:
        """
        The gateway for the control plane network.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> pulumi.Output[str]:
        """
        The CIDR block for the Exadata InfiniBand interconnect.
        """
        return pulumi.get(self, "infini_band_network_cidr")

    @property
    @pulumi.getter(name="isCpsOfflineReportEnabled")
    def is_cps_offline_report_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether cps offline diagnostic report is enabled for this Exadata infrastructure. This will allow a customer to quickly check status themselves and fix problems on their end, saving time and frustration for both Oracle and the customer when they find the CPS in a disconnected state.You can enable offline diagnostic report during Exadata infrastructure provisioning. You can also disable or enable it at any time using the UpdateExadatainfrastructure API.
        """
        return pulumi.get(self, "is_cps_offline_report_enabled")

    @property
    @pulumi.getter(name="isMultiRackDeployment")
    def is_multi_rack_deployment(self) -> pulumi.Output[bool]:
        """
        Indicates if deployment is Multi-Rack or not.
        """
        return pulumi.get(self, "is_multi_rack_deployment")

    @property
    @pulumi.getter(name="isSchedulingPolicyAssociated")
    def is_scheduling_policy_associated(self) -> pulumi.Output[bool]:
        """
        If true, the infrastructure is using granular maintenance scheduling preference.
        """
        return pulumi.get(self, "is_scheduling_policy_associated")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> pulumi.Output[str]:
        """
        A field to capture ‘Maintenance SLO Status’ for the Exadata infrastructure with values ‘OK’, ‘DEGRADED’. Default is ‘OK’ when the infrastructure is provisioned.
        """
        return pulumi.get(self, "maintenance_slo_status")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.ExadataInfrastructureConfigureExascaleManagementMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> pulumi.Output[int]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> pulumi.Output[float]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> pulumi.Output[int]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> pulumi.Output[int]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> pulumi.Output[str]:
        """
        The monthly software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @property
    @pulumi.getter(name="multiRackConfigurationFile")
    def multi_rack_configuration_file(self) -> pulumi.Output[str]:
        """
        The base64 encoded Multi-Rack configuration json file.
        """
        return pulumi.get(self, "multi_rack_configuration_file")

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Output[str]:
        """
        The netmask for the control plane network.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="networkBondingModeDetails")
    def network_bonding_mode_details(self) -> pulumi.Output[Sequence['outputs.ExadataInfrastructureConfigureExascaleManagementNetworkBondingModeDetail']]:
        """
        Details of bonding mode for Client and Backup and DR networks of an Exadata infrastructure.
        """
        return pulumi.get(self, "network_bonding_mode_details")

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntp_servers")

    @property
    @pulumi.getter(name="rackSerialNumber")
    def rack_serial_number(self) -> pulumi.Output[str]:
        """
        The serial number for the Exadata infrastructure.
        """
        return pulumi.get(self, "rack_serial_number")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the Exadata infrastructure.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> pulumi.Output[int]:
        """
        The number of Exadata storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the storage servers (cells) in the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Exadata infrastructure was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone of the Exadata infrastructure. For details, see [Exadata Infrastructure Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="totalStorageInGbs")
    def total_storage_in_gbs(self) -> pulumi.Output[int]:
        """
        Storage size needed for Exascale in GBs.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_storage_in_gbs")

