# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApplicationVipResult',
    'AwaitableGetApplicationVipResult',
    'get_application_vip',
    'get_application_vip_output',
]

@pulumi.output_type
class GetApplicationVipResult:
    """
    A collection of values returned by getApplicationVip.
    """
    def __init__(__self__, application_vip_id=None, cloud_vm_cluster_id=None, compartment_id=None, db_node_id=None, defined_tags=None, freeform_tags=None, hostname_label=None, id=None, ip_address=None, ipv6address=None, lifecycle_details=None, state=None, subnet_id=None, time_assigned=None):
        if application_vip_id and not isinstance(application_vip_id, str):
            raise TypeError("Expected argument 'application_vip_id' to be a str")
        pulumi.set(__self__, "application_vip_id", application_vip_id)
        if cloud_vm_cluster_id and not isinstance(cloud_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_node_id and not isinstance(db_node_id, str):
            raise TypeError("Expected argument 'db_node_id' to be a str")
        pulumi.set(__self__, "db_node_id", db_node_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label and not isinstance(hostname_label, str):
            raise TypeError("Expected argument 'hostname_label' to be a str")
        pulumi.set(__self__, "hostname_label", hostname_label)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if ipv6address and not isinstance(ipv6address, str):
            raise TypeError("Expected argument 'ipv6address' to be a str")
        pulumi.set(__self__, "ipv6address", ipv6address)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_assigned and not isinstance(time_assigned, str):
            raise TypeError("Expected argument 'time_assigned' to be a str")
        pulumi.set(__self__, "time_assigned", time_assigned)

    @property
    @pulumi.getter(name="applicationVipId")
    def application_vip_id(self) -> str:
        return pulumi.get(self, "application_vip_id")

    @property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> str:
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> str:
        """
        The hostname of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The application virtual IP (VIP) IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def ipv6address(self) -> str:
        """
        The application virtual IP (VIP) IPv6 address.
        """
        return pulumi.get(self, "ipv6address")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeAssigned")
    def time_assigned(self) -> str:
        """
        The date and time when the create operation for the application virtual IP (VIP) address completed.
        """
        return pulumi.get(self, "time_assigned")


class AwaitableGetApplicationVipResult(GetApplicationVipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationVipResult(
            application_vip_id=self.application_vip_id,
            cloud_vm_cluster_id=self.cloud_vm_cluster_id,
            compartment_id=self.compartment_id,
            db_node_id=self.db_node_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            hostname_label=self.hostname_label,
            id=self.id,
            ip_address=self.ip_address,
            ipv6address=self.ipv6address,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            subnet_id=self.subnet_id,
            time_assigned=self.time_assigned)


def get_application_vip(application_vip_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationVipResult:
    """
    This data source provides details about a specific Application Vip resource in Oracle Cloud Infrastructure Database service.

    Gets information about a specified application virtual IP (VIP) address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_application_vip = oci.Database.get_application_vip(application_vip_id=test_application_vip_oci_database_application_vip["id"])
    ```


    :param str application_vip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the application virtual IP (VIP) address.
    """
    __args__ = dict()
    __args__['applicationVipId'] = application_vip_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getApplicationVip:getApplicationVip', __args__, opts=opts, typ=GetApplicationVipResult).value

    return AwaitableGetApplicationVipResult(
        application_vip_id=pulumi.get(__ret__, 'application_vip_id'),
        cloud_vm_cluster_id=pulumi.get(__ret__, 'cloud_vm_cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_node_id=pulumi.get(__ret__, 'db_node_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hostname_label=pulumi.get(__ret__, 'hostname_label'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        ipv6address=pulumi.get(__ret__, 'ipv6address'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        time_assigned=pulumi.get(__ret__, 'time_assigned'))
def get_application_vip_output(application_vip_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationVipResult]:
    """
    This data source provides details about a specific Application Vip resource in Oracle Cloud Infrastructure Database service.

    Gets information about a specified application virtual IP (VIP) address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_application_vip = oci.Database.get_application_vip(application_vip_id=test_application_vip_oci_database_application_vip["id"])
    ```


    :param str application_vip_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the application virtual IP (VIP) address.
    """
    __args__ = dict()
    __args__['applicationVipId'] = application_vip_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getApplicationVip:getApplicationVip', __args__, opts=opts, typ=GetApplicationVipResult)
    return __ret__.apply(lambda __response__: GetApplicationVipResult(
        application_vip_id=pulumi.get(__response__, 'application_vip_id'),
        cloud_vm_cluster_id=pulumi.get(__response__, 'cloud_vm_cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_node_id=pulumi.get(__response__, 'db_node_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        hostname_label=pulumi.get(__response__, 'hostname_label'),
        id=pulumi.get(__response__, 'id'),
        ip_address=pulumi.get(__response__, 'ip_address'),
        ipv6address=pulumi.get(__response__, 'ipv6address'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        time_assigned=pulumi.get(__response__, 'time_assigned')))
