# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVulnerabilityVulnerabilitiesResult',
    'AwaitableGetVulnerabilityVulnerabilitiesResult',
    'get_vulnerability_vulnerabilities',
    'get_vulnerability_vulnerabilities_output',
]

@pulumi.output_type
class GetVulnerabilityVulnerabilitiesResult:
    """
    A collection of values returned by getVulnerabilityVulnerabilities.
    """
    def __init__(__self__, compartment_id=None, database_release=None, display_name=None, filters=None, id=None, resource_id=None, search_by=None, severity_types=None, state=None, vulnerability_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_release and not isinstance(database_release, str):
            raise TypeError("Expected argument 'database_release' to be a str")
        pulumi.set(__self__, "database_release", database_release)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if search_by and not isinstance(search_by, str):
            raise TypeError("Expected argument 'search_by' to be a str")
        pulumi.set(__self__, "search_by", search_by)
        if severity_types and not isinstance(severity_types, list):
            raise TypeError("Expected argument 'severity_types' to be a list")
        pulumi.set(__self__, "severity_types", severity_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vulnerability_collections and not isinstance(vulnerability_collections, list):
            raise TypeError("Expected argument 'vulnerability_collections' to be a list")
        pulumi.set(__self__, "vulnerability_collections", vulnerability_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseRelease")
    def database_release(self) -> Optional[str]:
        return pulumi.get(self, "database_release")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVulnerabilityVulnerabilitiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="searchBy")
    def search_by(self) -> Optional[str]:
        return pulumi.get(self, "search_by")

    @property
    @pulumi.getter(name="severityTypes")
    def severity_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "severity_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vulnerabilityCollections")
    def vulnerability_collections(self) -> Sequence['outputs.GetVulnerabilityVulnerabilitiesVulnerabilityCollectionResult']:
        """
        The list of vulnerability_collection.
        """
        return pulumi.get(self, "vulnerability_collections")


class AwaitableGetVulnerabilityVulnerabilitiesResult(GetVulnerabilityVulnerabilitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVulnerabilityVulnerabilitiesResult(
            compartment_id=self.compartment_id,
            database_release=self.database_release,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            resource_id=self.resource_id,
            search_by=self.search_by,
            severity_types=self.severity_types,
            state=self.state,
            vulnerability_collections=self.vulnerability_collections)


def get_vulnerability_vulnerabilities(compartment_id: Optional[str] = None,
                                      database_release: Optional[str] = None,
                                      display_name: Optional[str] = None,
                                      filters: Optional[Sequence[Union['GetVulnerabilityVulnerabilitiesFilterArgs', 'GetVulnerabilityVulnerabilitiesFilterArgsDict']]] = None,
                                      resource_id: Optional[str] = None,
                                      search_by: Optional[str] = None,
                                      severity_types: Optional[Sequence[str]] = None,
                                      state: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVulnerabilityVulnerabilitiesResult:
    """
    This data source provides the list of Vulnerability Vulnerabilities in Oracle Cloud Infrastructure Dblm service.

    Gets the vulnerabilities summary list

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_vulnerabilities = oci.Dblm.get_vulnerability_vulnerabilities(compartment_id=compartment_id,
        database_release=vulnerability_vulnerability_database_release,
        display_name=vulnerability_vulnerability_display_name,
        resource_id=test_resource["id"],
        search_by=vulnerability_vulnerability_search_by,
        severity_types=vulnerability_vulnerability_severity_type,
        state=vulnerability_vulnerability_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str database_release: A filter to return only database that match the given release version.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str resource_id: A filter to return only resources that match the given resource id.
    :param str search_by: The search input for filter cve id and cve description.
    :param Sequence[str] severity_types: Filter by one or more severity types. Possible values are critical, high, medium, low, info.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['searchBy'] = search_by
    __args__['severityTypes'] = severity_types
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dblm/getVulnerabilityVulnerabilities:getVulnerabilityVulnerabilities', __args__, opts=opts, typ=GetVulnerabilityVulnerabilitiesResult).value

    return AwaitableGetVulnerabilityVulnerabilitiesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_release=pulumi.get(__ret__, 'database_release'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        search_by=pulumi.get(__ret__, 'search_by'),
        severity_types=pulumi.get(__ret__, 'severity_types'),
        state=pulumi.get(__ret__, 'state'),
        vulnerability_collections=pulumi.get(__ret__, 'vulnerability_collections'))
def get_vulnerability_vulnerabilities_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                             database_release: Optional[pulumi.Input[Optional[str]]] = None,
                                             display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVulnerabilityVulnerabilitiesFilterArgs', 'GetVulnerabilityVulnerabilitiesFilterArgsDict']]]]] = None,
                                             resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                                             search_by: Optional[pulumi.Input[Optional[str]]] = None,
                                             severity_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             state: Optional[pulumi.Input[Optional[str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVulnerabilityVulnerabilitiesResult]:
    """
    This data source provides the list of Vulnerability Vulnerabilities in Oracle Cloud Infrastructure Dblm service.

    Gets the vulnerabilities summary list

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vulnerability_vulnerabilities = oci.Dblm.get_vulnerability_vulnerabilities(compartment_id=compartment_id,
        database_release=vulnerability_vulnerability_database_release,
        display_name=vulnerability_vulnerability_display_name,
        resource_id=test_resource["id"],
        search_by=vulnerability_vulnerability_search_by,
        severity_types=vulnerability_vulnerability_severity_type,
        state=vulnerability_vulnerability_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str database_release: A filter to return only database that match the given release version.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str resource_id: A filter to return only resources that match the given resource id.
    :param str search_by: The search input for filter cve id and cve description.
    :param Sequence[str] severity_types: Filter by one or more severity types. Possible values are critical, high, medium, low, info.
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['databaseRelease'] = database_release
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['searchBy'] = search_by
    __args__['severityTypes'] = severity_types
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dblm/getVulnerabilityVulnerabilities:getVulnerabilityVulnerabilities', __args__, opts=opts, typ=GetVulnerabilityVulnerabilitiesResult)
    return __ret__.apply(lambda __response__: GetVulnerabilityVulnerabilitiesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_release=pulumi.get(__response__, 'database_release'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        search_by=pulumi.get(__response__, 'search_by'),
        severity_types=pulumi.get(__response__, 'severity_types'),
        state=pulumi.get(__response__, 'state'),
        vulnerability_collections=pulumi.get(__response__, 'vulnerability_collections')))
