# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPingMonitorsResult',
    'AwaitableGetPingMonitorsResult',
    'get_ping_monitors',
    'get_ping_monitors_output',
]

@pulumi.output_type
class GetPingMonitorsResult:
    """
    A collection of values returned by getPingMonitors.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, home_region=None, id=None, ping_monitors=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if home_region and not isinstance(home_region, str):
            raise TypeError("Expected argument 'home_region' to be a str")
        pulumi.set(__self__, "home_region", home_region)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ping_monitors and not isinstance(ping_monitors, list):
            raise TypeError("Expected argument 'ping_monitors' to be a list")
        pulumi.set(__self__, "ping_monitors", ping_monitors)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly and mutable name suitable for display in a user interface.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPingMonitorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="homeRegion")
    def home_region(self) -> Optional[str]:
        """
        The region where updates must be made and where results must be fetched from.
        """
        return pulumi.get(self, "home_region")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="pingMonitors")
    def ping_monitors(self) -> Sequence['outputs.GetPingMonitorsPingMonitorResult']:
        """
        The list of ping_monitors.
        """
        return pulumi.get(self, "ping_monitors")


class AwaitableGetPingMonitorsResult(GetPingMonitorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPingMonitorsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            home_region=self.home_region,
            id=self.id,
            ping_monitors=self.ping_monitors)


def get_ping_monitors(compartment_id: Optional[str] = None,
                      display_name: Optional[str] = None,
                      filters: Optional[Sequence[Union['GetPingMonitorsFilterArgs', 'GetPingMonitorsFilterArgsDict']]] = None,
                      home_region: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPingMonitorsResult:
    """
    This data source provides the list of Ping Monitors in Oracle Cloud Infrastructure Health Checks service.

    Gets a list of configured ping monitors.

    Results are paginated based on `page` and `limit`.  The `opc-next-page` header provides
    a URL for fetching the next page.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ping_monitors = oci.HealthChecks.get_ping_monitors(compartment_id=compartment_id,
        display_name=ping_monitor_display_name,
        home_region=ping_monitor_home_region)
    ```


    :param str compartment_id: Filters results by compartment.
    :param str display_name: Filters results that exactly match the `displayName` field.
    :param str home_region: Filters results that match the `homeRegion`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['homeRegion'] = home_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:HealthChecks/getPingMonitors:getPingMonitors', __args__, opts=opts, typ=GetPingMonitorsResult).value

    return AwaitableGetPingMonitorsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        home_region=pulumi.get(__ret__, 'home_region'),
        id=pulumi.get(__ret__, 'id'),
        ping_monitors=pulumi.get(__ret__, 'ping_monitors'))
def get_ping_monitors_output(compartment_id: Optional[pulumi.Input[str]] = None,
                             display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPingMonitorsFilterArgs', 'GetPingMonitorsFilterArgsDict']]]]] = None,
                             home_region: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPingMonitorsResult]:
    """
    This data source provides the list of Ping Monitors in Oracle Cloud Infrastructure Health Checks service.

    Gets a list of configured ping monitors.

    Results are paginated based on `page` and `limit`.  The `opc-next-page` header provides
    a URL for fetching the next page.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ping_monitors = oci.HealthChecks.get_ping_monitors(compartment_id=compartment_id,
        display_name=ping_monitor_display_name,
        home_region=ping_monitor_home_region)
    ```


    :param str compartment_id: Filters results by compartment.
    :param str display_name: Filters results that exactly match the `displayName` field.
    :param str home_region: Filters results that match the `homeRegion`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['homeRegion'] = home_region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:HealthChecks/getPingMonitors:getPingMonitors', __args__, opts=opts, typ=GetPingMonitorsResult)
    return __ret__.apply(lambda __response__: GetPingMonitorsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        home_region=pulumi.get(__response__, 'home_region'),
        id=pulumi.get(__response__, 'id'),
        ping_monitors=pulumi.get(__response__, 'ping_monitors')))
