# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLimitDefinitionsResult',
    'AwaitableGetLimitDefinitionsResult',
    'get_limit_definitions',
    'get_limit_definitions_output',
]

@pulumi.output_type
class GetLimitDefinitionsResult:
    """
    A collection of values returned by getLimitDefinitions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, limit_definitions=None, name=None, service_name=None, subscription_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit_definitions and not isinstance(limit_definitions, list):
            raise TypeError("Expected argument 'limit_definitions' to be a list")
        pulumi.set(__self__, "limit_definitions", limit_definitions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLimitDefinitionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="limitDefinitions")
    def limit_definitions(self) -> Sequence['outputs.GetLimitDefinitionsLimitDefinitionResult']:
        """
        The list of limit_definitions.
        """
        return pulumi.get(self, "limit_definitions")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The resource limit name. To be used for writing policies (in case of quotas) or other programmatic calls.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The service name of the limit.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        return pulumi.get(self, "subscription_id")


class AwaitableGetLimitDefinitionsResult(GetLimitDefinitionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLimitDefinitionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            limit_definitions=self.limit_definitions,
            name=self.name,
            service_name=self.service_name,
            subscription_id=self.subscription_id)


def get_limit_definitions(compartment_id: Optional[str] = None,
                          filters: Optional[Sequence[Union['GetLimitDefinitionsFilterArgs', 'GetLimitDefinitionsFilterArgsDict']]] = None,
                          name: Optional[str] = None,
                          service_name: Optional[str] = None,
                          subscription_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLimitDefinitionsResult:
    """
    This data source provides the list of Limit Definitions in Oracle Cloud Infrastructure Limits service.

    Includes a list of resource limits that are currently supported. If subscription Id is provided, then only resource limits supported by subscription will be returned
    If the 'areQuotasSupported' property is true, you can create quota policies on top of this limit at the
    compartment level.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_limit_definitions = oci.Limits.get_limit_definitions(compartment_id=tenancy_ocid,
        name=limit_definition_name,
        service_name=test_service["name"],
        subscription_id=subscription_ocid)
    ```


    :param str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
    :param str name: Optional field, filter for a specific resource limit.
    :param str service_name: The target service name.
    :param str subscription_id: The OCID of the subscription assigned to tenant
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['serviceName'] = service_name
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Limits/getLimitDefinitions:getLimitDefinitions', __args__, opts=opts, typ=GetLimitDefinitionsResult).value

    return AwaitableGetLimitDefinitionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        limit_definitions=pulumi.get(__ret__, 'limit_definitions'),
        name=pulumi.get(__ret__, 'name'),
        service_name=pulumi.get(__ret__, 'service_name'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'))
def get_limit_definitions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLimitDefinitionsFilterArgs', 'GetLimitDefinitionsFilterArgsDict']]]]] = None,
                                 name: Optional[pulumi.Input[Optional[str]]] = None,
                                 service_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 subscription_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLimitDefinitionsResult]:
    """
    This data source provides the list of Limit Definitions in Oracle Cloud Infrastructure Limits service.

    Includes a list of resource limits that are currently supported. If subscription Id is provided, then only resource limits supported by subscription will be returned
    If the 'areQuotasSupported' property is true, you can create quota policies on top of this limit at the
    compartment level.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_limit_definitions = oci.Limits.get_limit_definitions(compartment_id=tenancy_ocid,
        name=limit_definition_name,
        service_name=test_service["name"],
        subscription_id=subscription_ocid)
    ```


    :param str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
    :param str name: Optional field, filter for a specific resource limit.
    :param str service_name: The target service name.
    :param str subscription_id: The OCID of the subscription assigned to tenant
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['serviceName'] = service_name
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Limits/getLimitDefinitions:getLimitDefinitions', __args__, opts=opts, typ=GetLimitDefinitionsResult)
    return __ret__.apply(lambda __response__: GetLimitDefinitionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        limit_definitions=pulumi.get(__response__, 'limit_definitions'),
        name=pulumi.get(__response__, 'name'),
        service_name=pulumi.get(__response__, 'service_name'),
        subscription_id=pulumi.get(__response__, 'subscription_id')))
