# function that maps common verbs to templates
def get_function_description(func_name):
    verb_templates = {
        "calculate": f"Calculates the {func_name.split('_', 1)[-1]}.",
        "get": f"Retrieves the {func_name.split('_', 1)[-1]} from a given source.",
        "create": f"Creates a new {func_name.split('_', 1)[-1]}.",
        "fetch": f"Fetches the {func_name.split('_', 1)[-1]}.",
        "process": f"Processes the input to produce a {func_name.split('_', 1)[-1]}.",
        "update": f"Updates the {func_name.split('_', 1)[-1]}.",
        "delete": f"Deletes the {func_name.split('_', 1)[-1]}.",
        "remove": f"Removes the {func_name.split('_', 1)[-1]}.",
        "add": f"Adds a new {func_name.split('_', 1)[-1]}.",
        "set": f"Sets the {func_name.split('_', 1)[-1]}.",
        "initialize": f"Initializes the {func_name.split('_', 1)[-1]}.",
        "load": f"Loads the {func_name.split('_', 1)[-1]}.",
        "save": f"Saves the {func_name.split('_', 1)[-1]}.",
        "validate": f"Validates the {func_name.split('_', 1)[-1]}.",
        "send": f"Sends the {func_name.split('_', 1)[-1]}.",
        "receive": f"Receives the {func_name.split('_', 1)[-1]}.",
        "compute": f"Computes the {func_name.split('_', 1)[-1]}.",
        "generate": f"Generates the {func_name.split('_', 1)[-1]}.",
        "convert": f"Converts the {func_name.split('_', 1)[-1]}.",
        "transform": f"Transforms the {func_name.split('_', 1)[-1]}.",
        "merge": f"Merges the {func_name.split('_', 1)[-1]}.",
        "split": f"Splits the {func_name.split('_', 1)[-1]}.",
        "extract": f"Extracts the {func_name.split('_', 1)[-1]}.",
        "compare": f"Compares the {func_name.split('_', 1)[-1]}.",
        "sort": f"Sorts the {func_name.split('_', 1)[-1]}.",
        "filter": f"Filters the {func_name.split('_', 1)[-1]}.",
        "aggregate": f"Aggregates the {func_name.split('_', 1)[-1]}.",
        "map": f"Maps the {func_name.split('_', 1)[-1]}.",
        "reduce": f"Reduces the {func_name.split('_', 1)[-1]}.",
        "clean": f"Cleans the {func_name.split('_', 1)[-1]}.",
        "normalize": f"Normalizes the {func_name.split('_', 1)[-1]}.",
        "format": f"Formats the {func_name.split('_', 1)[-1]}.",
        "parse": f"Parses the {func_name.split('_', 1)[-1]}.",
        "serialize": f"Serializes the {func_name.split('_', 1)[-1]}.",
        "deserialize": f"Deserializes the {func_name.split('_', 1)[-1]}.",
        "encrypt": f"Encrypts the {func_name.split('_', 1)[-1]}.",
        "decrypt": f"Decrypts the {func_name.split('_', 1)[-1]}.",
        "compress": f"Compresses the {func_name.split('_', 1)[-1]}.",
        "decompress": f"Decompresses the {func_name.split('_', 1)[-1]}.",
        "archive": f"Archives the {func_name.split('_', 1)[-1]}.",
        "unarchive": f"Unarchives the {func_name.split('_', 1)[-1]}.",
        "backup": f"Backs up the {func_name.split('_', 1)[-1]}.",
        "restore": f"Restores the {func_name.split('_', 1)[-1]}.",
        "log": f"Logs the {func_name.split('_', 1)[-1]}.",
        "monitor": f"Monitors the {func_name.split('_', 1)[-1]}.",
        "track": f"Tracks the {func_name.split('_', 1)[-1]}.",
        "report": f"Reports the {func_name.split('_', 1)[-1]}.",
        "notify": f"Notifies about the {func_name.split('_', 1)[-1]}.",
        "alert": f"Alerts about the {func_name.split('_', 1)[-1]}.",
        "schedule": f"Schedules the {func_name.split('_', 1)[-1]}.",
        "execute": f"Executes the {func_name.split('_', 1)[-1]}.",
        "run": f"Runs the {func_name.split('_', 1)[-1]}.",
        "test": f"Tests the {func_name.split('_', 1)[-1]}.",
        "debug": f"Debugs the {func_name.split('_', 1)[-1]}.",
        "build": f"Builds the {func_name.split('_', 1)[-1]}.",
        "deploy": f"Deploys the {func_name.split('_', 1)[-1]}.",
        "install": f"Installs the {func_name.split('_', 1)[-1]}.",
        "uninstall": f"Uninstalls the {func_name.split('_', 1)[-1]}.",
        "upgrade": f"Upgrades the {func_name.split('_', 1)[-1]}.",
        "downgrade": f"Downgrades the {func_name.split('_', 1)[-1]}.",
        "configure": f"Configures the {func_name.split('_', 1)[-1]}.",
        "initialize": f"Initializes the {func_name.split('_', 1)[-1]}.",
        "shutdown": f"Shuts down the {func_name.split('_', 1)[-1]}.",
        "restart": f"Restarts the {func_name.split('_', 1)[-1]}.",
        "start": f"Starts the {func_name.split('_', 1)[-1]}.",
        "stop": f"Stops the {func_name.split('_', 1)[-1]}.",
        "pause": f"Pauses the {func_name.split('_', 1)[-1]}.",
        "resume": f"Resumes the {func_name.split('_', 1)[-1]}.",
        "lock": f"Locks the {func_name.split('_', 1)[-1]}.",
        "unlock": f"Unlocks the {func_name.split('_', 1)[-1]}.",
        "authenticate": f"Authenticates the {func_name.split('_', 1)[-1]}.",
        "authorize": f"Authorizes the {func_name.split('_', 1)[-1]}.",
        "log_in": f"Logs in the {func_name.split('_', 1)[-1]}.",
        "log_out": f"Logs out the {func_name.split('_', 1)[-1]}.",
        "register": f"Registers the {func_name.split('_', 1)[-1]}.",
        "deregister": f"Deregisters the {func_name.split('_', 1)[-1]}.",
        "subscribe": f"Subscribes to the {func_name.split('_', 1)[-1]}.",
        "unsubscribe": f"Unsubscribes from the {func_name.split('_', 1)[-1]}.",
        "publish": f"Publishes the {func_name.split('_', 1)[-1]}.",
    }

    action = func_name.split('_')[0]  # First part is the action (verb)
    return verb_templates.get(action, f"Executes the function {func_name}.")
