# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetBudgetResult',
    'AwaitableGetBudgetResult',
    'get_budget',
    'get_budget_output',
]

@pulumi.output_type
class GetBudgetResult:
    """
    A collection of values returned by getBudget.
    """
    def __init__(__self__, actual_spend=None, alert_rule_count=None, amount=None, budget_id=None, budget_processing_period_start_offset=None, compartment_id=None, defined_tags=None, description=None, display_name=None, end_date=None, forecasted_spend=None, freeform_tags=None, id=None, processing_period_type=None, reset_period=None, start_date=None, state=None, target_compartment_id=None, target_type=None, targets=None, time_created=None, time_spend_computed=None, time_updated=None, version=None):
        if actual_spend and not isinstance(actual_spend, float):
            raise TypeError("Expected argument 'actual_spend' to be a float")
        pulumi.set(__self__, "actual_spend", actual_spend)
        if alert_rule_count and not isinstance(alert_rule_count, int):
            raise TypeError("Expected argument 'alert_rule_count' to be a int")
        pulumi.set(__self__, "alert_rule_count", alert_rule_count)
        if amount and not isinstance(amount, int):
            raise TypeError("Expected argument 'amount' to be a int")
        pulumi.set(__self__, "amount", amount)
        if budget_id and not isinstance(budget_id, str):
            raise TypeError("Expected argument 'budget_id' to be a str")
        pulumi.set(__self__, "budget_id", budget_id)
        if budget_processing_period_start_offset and not isinstance(budget_processing_period_start_offset, int):
            raise TypeError("Expected argument 'budget_processing_period_start_offset' to be a int")
        pulumi.set(__self__, "budget_processing_period_start_offset", budget_processing_period_start_offset)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if end_date and not isinstance(end_date, str):
            raise TypeError("Expected argument 'end_date' to be a str")
        pulumi.set(__self__, "end_date", end_date)
        if forecasted_spend and not isinstance(forecasted_spend, float):
            raise TypeError("Expected argument 'forecasted_spend' to be a float")
        pulumi.set(__self__, "forecasted_spend", forecasted_spend)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if processing_period_type and not isinstance(processing_period_type, str):
            raise TypeError("Expected argument 'processing_period_type' to be a str")
        pulumi.set(__self__, "processing_period_type", processing_period_type)
        if reset_period and not isinstance(reset_period, str):
            raise TypeError("Expected argument 'reset_period' to be a str")
        pulumi.set(__self__, "reset_period", reset_period)
        if start_date and not isinstance(start_date, str):
            raise TypeError("Expected argument 'start_date' to be a str")
        pulumi.set(__self__, "start_date", start_date)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_compartment_id and not isinstance(target_compartment_id, str):
            raise TypeError("Expected argument 'target_compartment_id' to be a str")
        pulumi.set(__self__, "target_compartment_id", target_compartment_id)
        if target_type and not isinstance(target_type, str):
            raise TypeError("Expected argument 'target_type' to be a str")
        pulumi.set(__self__, "target_type", target_type)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_spend_computed and not isinstance(time_spend_computed, str):
            raise TypeError("Expected argument 'time_spend_computed' to be a str")
        pulumi.set(__self__, "time_spend_computed", time_spend_computed)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="actualSpend")
    def actual_spend(self) -> float:
        """
        The actual spend in currency for the current budget cycle.
        """
        return pulumi.get(self, "actual_spend")

    @property
    @pulumi.getter(name="alertRuleCount")
    def alert_rule_count(self) -> int:
        """
        The total number of alert rules in the budget.
        """
        return pulumi.get(self, "alert_rule_count")

    @property
    @pulumi.getter
    def amount(self) -> int:
        """
        The amount of the budget, expressed in the currency of the customer's rate card.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> str:
        return pulumi.get(self, "budget_id")

    @property
    @pulumi.getter(name="budgetProcessingPeriodStartOffset")
    def budget_processing_period_start_offset(self) -> int:
        """
        The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        """
        return pulumi.get(self, "budget_processing_period_start_offset")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the budget.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the budget. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        The time when the one-time budget concludes. For example, - `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="forecastedSpend")
    def forecasted_spend(self) -> float:
        """
        The forecasted spend in currency by the end of the current budget cycle.
        """
        return pulumi.get(self, "forecasted_spend")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the budget.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="processingPeriodType")
    def processing_period_type(self) -> str:
        """
        The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        """
        return pulumi.get(self, "processing_period_type")

    @property
    @pulumi.getter(name="resetPeriod")
    def reset_period(self) -> str:
        """
        The reset period for the budget.
        """
        return pulumi.get(self, "reset_period")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the budget.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> str:
        """
        This is DEPRECATED. For backwards compatability, the property is populated when the targetType is "COMPARTMENT", and targets contain the specific target compartment OCID. For all other scenarios, this property will be left empty.
        """
        warnings.warn("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""", DeprecationWarning)
        pulumi.log.warn("""target_compartment_id is deprecated: The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")

        return pulumi.get(self, "target_compartment_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        """
        The type of target on which the budget is applied.
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[str]:
        """
        The list of targets on which the budget is applied. If the targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If the targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}".
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time that the budget was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSpendComputed")
    def time_spend_computed(self) -> str:
        """
        The time that the budget spend was last computed.
        """
        return pulumi.get(self, "time_spend_computed")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time that the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the budget. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


class AwaitableGetBudgetResult(GetBudgetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBudgetResult(
            actual_spend=self.actual_spend,
            alert_rule_count=self.alert_rule_count,
            amount=self.amount,
            budget_id=self.budget_id,
            budget_processing_period_start_offset=self.budget_processing_period_start_offset,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            end_date=self.end_date,
            forecasted_spend=self.forecasted_spend,
            freeform_tags=self.freeform_tags,
            id=self.id,
            processing_period_type=self.processing_period_type,
            reset_period=self.reset_period,
            start_date=self.start_date,
            state=self.state,
            target_compartment_id=self.target_compartment_id,
            target_type=self.target_type,
            targets=self.targets,
            time_created=self.time_created,
            time_spend_computed=self.time_spend_computed,
            time_updated=self.time_updated,
            version=self.version)


def get_budget(budget_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBudgetResult:
    """
    This data source provides details about a specific Budget resource in Oracle Cloud Infrastructure Budget service.

    Gets a budget by the identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_budget = oci.Budget.get_budget(budget_id=oci_budget_budget["test_budget"]["id"])
    ```


    :param str budget_id: The unique budget OCID.
    """
    __args__ = dict()
    __args__['budgetId'] = budget_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Budget/getBudget:getBudget', __args__, opts=opts, typ=GetBudgetResult).value

    return AwaitableGetBudgetResult(
        actual_spend=pulumi.get(__ret__, 'actual_spend'),
        alert_rule_count=pulumi.get(__ret__, 'alert_rule_count'),
        amount=pulumi.get(__ret__, 'amount'),
        budget_id=pulumi.get(__ret__, 'budget_id'),
        budget_processing_period_start_offset=pulumi.get(__ret__, 'budget_processing_period_start_offset'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        end_date=pulumi.get(__ret__, 'end_date'),
        forecasted_spend=pulumi.get(__ret__, 'forecasted_spend'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        processing_period_type=pulumi.get(__ret__, 'processing_period_type'),
        reset_period=pulumi.get(__ret__, 'reset_period'),
        start_date=pulumi.get(__ret__, 'start_date'),
        state=pulumi.get(__ret__, 'state'),
        target_compartment_id=pulumi.get(__ret__, 'target_compartment_id'),
        target_type=pulumi.get(__ret__, 'target_type'),
        targets=pulumi.get(__ret__, 'targets'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_spend_computed=pulumi.get(__ret__, 'time_spend_computed'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_budget)
def get_budget_output(budget_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBudgetResult]:
    """
    This data source provides details about a specific Budget resource in Oracle Cloud Infrastructure Budget service.

    Gets a budget by the identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_budget = oci.Budget.get_budget(budget_id=oci_budget_budget["test_budget"]["id"])
    ```


    :param str budget_id: The unique budget OCID.
    """
    ...
