# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourceUsageResult',
    'AwaitableGetResourceUsageResult',
    'get_resource_usage',
    'get_resource_usage_output',
]

@pulumi.output_type
class GetResourceUsageResult:
    """
    A collection of values returned by getResourceUsage.
    """
    def __init__(__self__, em_instance_count=None, em_instances=None, em_warehouse_id=None, id=None, operations_insights_warehouse_id=None, schema_name=None, targets_count=None):
        if em_instance_count and not isinstance(em_instance_count, int):
            raise TypeError("Expected argument 'em_instance_count' to be a int")
        pulumi.set(__self__, "em_instance_count", em_instance_count)
        if em_instances and not isinstance(em_instances, list):
            raise TypeError("Expected argument 'em_instances' to be a list")
        pulumi.set(__self__, "em_instances", em_instances)
        if em_warehouse_id and not isinstance(em_warehouse_id, str):
            raise TypeError("Expected argument 'em_warehouse_id' to be a str")
        pulumi.set(__self__, "em_warehouse_id", em_warehouse_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if operations_insights_warehouse_id and not isinstance(operations_insights_warehouse_id, str):
            raise TypeError("Expected argument 'operations_insights_warehouse_id' to be a str")
        pulumi.set(__self__, "operations_insights_warehouse_id", operations_insights_warehouse_id)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)
        if targets_count and not isinstance(targets_count, int):
            raise TypeError("Expected argument 'targets_count' to be a int")
        pulumi.set(__self__, "targets_count", targets_count)

    @property
    @pulumi.getter(name="emInstanceCount")
    def em_instance_count(self) -> int:
        """
        EmInstanceCount
        """
        return pulumi.get(self, "em_instance_count")

    @property
    @pulumi.getter(name="emInstances")
    def em_instances(self) -> Sequence['outputs.GetResourceUsageEmInstanceResult']:
        """
        List of emInstances
        """
        return pulumi.get(self, "em_instances")

    @property
    @pulumi.getter(name="emWarehouseId")
    def em_warehouse_id(self) -> str:
        return pulumi.get(self, "em_warehouse_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="operationsInsightsWarehouseId")
    def operations_insights_warehouse_id(self) -> str:
        """
        operations Insights Warehouse Identifier
        """
        return pulumi.get(self, "operations_insights_warehouse_id")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        """
        schema name
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="targetsCount")
    def targets_count(self) -> int:
        """
        EmInstance Target count
        """
        return pulumi.get(self, "targets_count")


class AwaitableGetResourceUsageResult(GetResourceUsageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceUsageResult(
            em_instance_count=self.em_instance_count,
            em_instances=self.em_instances,
            em_warehouse_id=self.em_warehouse_id,
            id=self.id,
            operations_insights_warehouse_id=self.operations_insights_warehouse_id,
            schema_name=self.schema_name,
            targets_count=self.targets_count)


def get_resource_usage(em_warehouse_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceUsageResult:
    """
    This data source provides details about a specific Em Warehouse Resource Usage resource in Oracle Cloud Infrastructure Em Warehouse service.

    Gets a EmWarehouseResourceUsage by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_em_warehouse_resource_usage = oci.EmWarehouse.get_resource_usage(em_warehouse_id=oci_em_warehouse_em_warehouse["test_em_warehouse"]["id"])
    ```


    :param str em_warehouse_id: unique EmWarehouse identifier
    """
    __args__ = dict()
    __args__['emWarehouseId'] = em_warehouse_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:EmWarehouse/getResourceUsage:getResourceUsage', __args__, opts=opts, typ=GetResourceUsageResult).value

    return AwaitableGetResourceUsageResult(
        em_instance_count=pulumi.get(__ret__, 'em_instance_count'),
        em_instances=pulumi.get(__ret__, 'em_instances'),
        em_warehouse_id=pulumi.get(__ret__, 'em_warehouse_id'),
        id=pulumi.get(__ret__, 'id'),
        operations_insights_warehouse_id=pulumi.get(__ret__, 'operations_insights_warehouse_id'),
        schema_name=pulumi.get(__ret__, 'schema_name'),
        targets_count=pulumi.get(__ret__, 'targets_count'))


@_utilities.lift_output_func(get_resource_usage)
def get_resource_usage_output(em_warehouse_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResourceUsageResult]:
    """
    This data source provides details about a specific Em Warehouse Resource Usage resource in Oracle Cloud Infrastructure Em Warehouse service.

    Gets a EmWarehouseResourceUsage by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_em_warehouse_resource_usage = oci.EmWarehouse.get_resource_usage(em_warehouse_id=oci_em_warehouse_em_warehouse["test_em_warehouse"]["id"])
    ```


    :param str em_warehouse_id: unique EmWarehouse identifier
    """
    ...
