# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRetrievePasswordResult',
    'AwaitableGetRetrievePasswordResult',
    'get_retrieve_password',
    'get_retrieve_password_output',
]

@pulumi.output_type
class GetRetrievePasswordResult:
    """
    A collection of values returned by getRetrievePassword.
    """
    def __init__(__self__, id=None, sddc_id=None, sddc_password=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sddc_id and not isinstance(sddc_id, str):
            raise TypeError("Expected argument 'sddc_id' to be a str")
        pulumi.set(__self__, "sddc_id", sddc_id)
        if sddc_password and not isinstance(sddc_password, dict):
            raise TypeError("Expected argument 'sddc_password' to be a dict")
        pulumi.set(__self__, "sddc_password", sddc_password)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> str:
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter(name="sddcPassword")
    def sddc_password(self) -> Mapping[str, Any]:
        """
        SDDC vCenter/NSX/HCX password.
        """
        return pulumi.get(self, "sddc_password")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetRetrievePasswordResult(GetRetrievePasswordResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRetrievePasswordResult(
            id=self.id,
            sddc_id=self.sddc_id,
            sddc_password=self.sddc_password,
            type=self.type)


def get_retrieve_password(sddc_id: Optional[str] = None,
                          type: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRetrievePasswordResult:
    """
    This data source retrieves the SDDC password in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_password = oci.Ocvp.get_retrieve_password(sddc_id=var["compartment_id"],
        type=var["password_type"])
    ```


    :param str sddc_id: The [OCID](https://www.terraform.io/Content/General/Concepts/identifiers.htm) of the SDDC.
    :param str type: The SDDC password type.
    """
    __args__ = dict()
    __args__['sddcId'] = sddc_id
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getRetrievePassword:getRetrievePassword', __args__, opts=opts, typ=GetRetrievePasswordResult).value

    return AwaitableGetRetrievePasswordResult(
        id=pulumi.get(__ret__, 'id'),
        sddc_id=pulumi.get(__ret__, 'sddc_id'),
        sddc_password=pulumi.get(__ret__, 'sddc_password'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_retrieve_password)
def get_retrieve_password_output(sddc_id: Optional[pulumi.Input[str]] = None,
                                 type: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRetrievePasswordResult]:
    """
    This data source retrieves the SDDC password in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_password = oci.Ocvp.get_retrieve_password(sddc_id=var["compartment_id"],
        type=var["password_type"])
    ```


    :param str sddc_id: The [OCID](https://www.terraform.io/Content/General/Concepts/identifiers.htm) of the SDDC.
    :param str type: The SDDC password type.
    """
    ...
