# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RedisClusterNodeCollection',
    'RedisClusterNodeCollectionItem',
    'GetRedisClusterNodeCollectionResult',
    'GetRedisClusterNodeCollectionItemResult',
    'GetRedisClustersFilterResult',
    'GetRedisClustersRedisClusterCollectionResult',
    'GetRedisClustersRedisClusterCollectionItemResult',
    'GetRedisClustersRedisClusterCollectionItemNodeCollectionResult',
    'GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult',
]

@pulumi.output_type
class RedisClusterNodeCollection(dict):
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.RedisClusterNodeCollectionItem']] = None):
        """
        :param Sequence['RedisClusterNodeCollectionItemArgs'] items: Collection of node objects.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.RedisClusterNodeCollectionItem']]:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class RedisClusterNodeCollectionItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "privateEndpointFqdn":
            suggest = "private_endpoint_fqdn"
        elif key == "privateEndpointIpAddress":
            suggest = "private_endpoint_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisClusterNodeCollectionItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisClusterNodeCollectionItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisClusterNodeCollectionItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 private_endpoint_fqdn: Optional[str] = None,
                 private_endpoint_ip_address: Optional[str] = None):
        """
        :param str display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param str private_endpoint_fqdn: The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        :param str private_endpoint_ip_address: The private IP address of the API endpoint to access a specific node.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if private_endpoint_fqdn is not None:
            pulumi.set(__self__, "private_endpoint_fqdn", private_endpoint_fqdn)
        if private_endpoint_ip_address is not None:
            pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateEndpointFqdn")
    def private_endpoint_fqdn(self) -> Optional[str]:
        """
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_fqdn")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> Optional[str]:
        """
        The private IP address of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_ip_address")


@pulumi.output_type
class GetRedisClusterNodeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRedisClusterNodeCollectionItemResult']):
        """
        :param Sequence['GetRedisClusterNodeCollectionItemArgs'] items: Collection of node objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRedisClusterNodeCollectionItemResult']:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRedisClusterNodeCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 private_endpoint_fqdn: str,
                 private_endpoint_ip_address: str):
        """
        :param str display_name: A user-friendly name of a Redis cluster node.
        :param str private_endpoint_fqdn: The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        :param str private_endpoint_ip_address: The private IP address of the API endpoint to access a specific node.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_endpoint_fqdn", private_endpoint_fqdn)
        pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name of a Redis cluster node.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateEndpointFqdn")
    def private_endpoint_fqdn(self) -> str:
        """
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_fqdn")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> str:
        """
        The private IP address of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_ip_address")


@pulumi.output_type
class GetRedisClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRedisClustersRedisClusterCollectionItemResult']):
        """
        :param Sequence['GetRedisClustersRedisClusterCollectionItemArgs'] items: Collection of node objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRedisClustersRedisClusterCollectionItemResult']:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 node_collections: Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionResult'],
                 node_count: int,
                 node_memory_in_gbs: float,
                 primary_endpoint_ip_address: str,
                 primary_fqdn: str,
                 replicas_endpoint_ip_address: str,
                 replicas_fqdn: str,
                 software_version: str,
                 state: str,
                 subnet_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the Redis cluster.
        :param str lifecycle_details: A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        :param Sequence['GetRedisClustersRedisClusterCollectionItemNodeCollectionArgs'] node_collections: The collection of Redis cluster nodes.
        :param int node_count: The number of nodes in the Redis cluster.
        :param float node_memory_in_gbs: The amount of memory allocated to the Redis cluster's nodes, in gigabytes.
        :param str primary_endpoint_ip_address: The private IP address of the API endpoint for the Redis cluster's primary node.
        :param str primary_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the Redis cluster's primary node.
        :param str replicas_endpoint_ip_address: The private IP address of the API endpoint for the Redis cluster's replica nodes.
        :param str replicas_fqdn: The fully qualified domain name (FQDN) of the API endpoint for the Redis cluster's replica nodes.
        :param str software_version: The Redis version that the cluster is running.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the Redis cluster's subnet.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The date and time the Redis cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param str time_updated: The date and time the Redis cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "node_collections", node_collections)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_memory_in_gbs", node_memory_in_gbs)
        pulumi.set(__self__, "primary_endpoint_ip_address", primary_endpoint_ip_address)
        pulumi.set(__self__, "primary_fqdn", primary_fqdn)
        pulumi.set(__self__, "replicas_endpoint_ip_address", replicas_endpoint_ip_address)
        pulumi.set(__self__, "replicas_fqdn", replicas_fqdn)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the Redis cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nodeCollections")
    def node_collections(self) -> Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionResult']:
        """
        The collection of Redis cluster nodes.
        """
        return pulumi.get(self, "node_collections")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes in the Redis cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeMemoryInGbs")
    def node_memory_in_gbs(self) -> float:
        """
        The amount of memory allocated to the Redis cluster's nodes, in gigabytes.
        """
        return pulumi.get(self, "node_memory_in_gbs")

    @property
    @pulumi.getter(name="primaryEndpointIpAddress")
    def primary_endpoint_ip_address(self) -> str:
        """
        The private IP address of the API endpoint for the Redis cluster's primary node.
        """
        return pulumi.get(self, "primary_endpoint_ip_address")

    @property
    @pulumi.getter(name="primaryFqdn")
    def primary_fqdn(self) -> str:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the Redis cluster's primary node.
        """
        return pulumi.get(self, "primary_fqdn")

    @property
    @pulumi.getter(name="replicasEndpointIpAddress")
    def replicas_endpoint_ip_address(self) -> str:
        """
        The private IP address of the API endpoint for the Redis cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_endpoint_ip_address")

    @property
    @pulumi.getter(name="replicasFqdn")
    def replicas_fqdn(self) -> str:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the Redis cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_fqdn")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> str:
        """
        The Redis version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the Redis cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Redis cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the Redis cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionItemNodeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult']):
        """
        :param Sequence['GetRedisClustersRedisClusterCollectionItemNodeCollectionItemArgs'] items: Collection of node objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult']:
        """
        Collection of node objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRedisClustersRedisClusterCollectionItemNodeCollectionItemResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 private_endpoint_fqdn: str,
                 private_endpoint_ip_address: str):
        """
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param str private_endpoint_fqdn: The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        :param str private_endpoint_ip_address: The private IP address of the API endpoint to access a specific node.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "private_endpoint_fqdn", private_endpoint_fqdn)
        pulumi.set(__self__, "private_endpoint_ip_address", private_endpoint_ip_address)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="privateEndpointFqdn")
    def private_endpoint_fqdn(self) -> str:
        """
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_fqdn")

    @property
    @pulumi.getter(name="privateEndpointIpAddress")
    def private_endpoint_ip_address(self) -> str:
        """
        The private IP address of the API endpoint to access a specific node.
        """
        return pulumi.get(self, "private_endpoint_ip_address")


