from . import pure
from . import avx2
from . import avx512
from cpufeature.extension import CPUFeature


def test(rvs, use_avx=3, **kwargs):
    method = pure
    if use_avx == 1 and not CPUFeature['AVX512vl']:
        print("!!! Warning: AVX512vl instruction set is not supported by your CPU, backing up to pure implementation")
        use_avx = 0
    elif use_avx in (1, 3) and CPUFeature['AVX512vl']:
        method = avx512
        use_avx = 1
    elif use_avx == 2 and not CPUFeature['AVX2']:
        print("!!! Warning: AVX2 instruction set is not supported by your CPU, backing up to pure implementation")
        use_avx = 0
    elif use_avx in (2, 3) and CPUFeature['AVX2']:
        method = avx2
        use_avx = 2
    else:  # use pure implementation
        use_avx = 0

    return method.test(rvs, use_avx=use_avx, **kwargs)
