Format Specification Votes
==========================

Acceptable file formats are files which are generated by hand, by the "Wabsti Elections and Referenda (VRSG)" election program or the web application itself.

"Municipality" might refer to a district, ward, etc.

## Content

1. [Standard format](#1-standard-format)
2. [OneGov](#2-onegov)
3. [Wabsti](#3-wabsti)
4. [WabstiCExport](#4-wabsticexport)


1 Standard format
-----------------

There is generally one CSV/Excel file per referendum proposal. However, should the referendum include a counter-proposal and a tie-breaker, then three files need to be delivered: One file with the results of the referendum, one file with the results of the counter-proposal and one file with the results of the tie-breaker.

### Columns

Each line contains the result of a single municipality, provided that this has been counted in full. The following columns are expected in the order listed here:

Name|Description
---|---
`Bezirk`|The district in which the municipality is located. If the municipality is not located in a district, this field can be left empty.
`ID`|The municipality number (BFS number) at the time of the vote. A value of `0` can be used for expats.
`Name`|The name of the municipality.
`Ja Stimmen`|The number of “yes” votes. If the word `unbekannt` is entered, the line will be ignored (not yet counted).
`Nein Stimmen`|The number of “no” votes. If the word `unbekannt` is entered, the line will be ignored (not yet counted).
`Stimmberechtigte`|The number of persons eligible to vote. If the word `unbekannt` is entered, the line will be ignored (not yet counted).
`Leere Stimmzettel`|The number of blank ballot papers. If the word `unbekannt` is entered, the line will be ignored (not yet counted).
`Ungültige Stimmzettel`|The number of spoilt ballot papers. If the word `unbekannt` is entered, the line will be ignored (not yet counted).

### Temporary results

Municipalities are deemed not to have been counted yet if the municipality is not included in the results.

### Template

- [vote_standard.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/vote_standard.csv)


2 OneGov
--------

The format used by the web application for the export consists of one single file per vote. There is a line for every municipality and type of referendum (proposal, counter-proposal, tie-breaker).

### Columns

The following columns will be evaluated and should exist at the least:

Name|Description
---|---
`status`|`unknown`, `interim` or `final`.
`type`|`proposal`, `counter-proposal` or `tie-breaker`.
`group`|Where the result comes from. This can be the region and municipality (separated by a forward slash), the name of the city and name of the district (likewise separated by a forward slash) or a simple municipality name. This all depends on the respective canton.
`entity_id`|The municipality number (BFS number). A value of `0` can be used for expats.
`counted`|`true` if the municipality has been counted.
`yeas`|The number of “yes” votes.
`nays`|The number of “no” votes.
`invalid`|The number of spoilt votes.
`empty`|The number of blank votes.
`elegible_voters`|The number of persons eligible to vote.

### Temporary results

Municipalities are deemed not to have been counted yet if one of the following two conditions apply:
- `counted = false`
- the municipality is not included in the results

If the status is
- `interim`, the whole vote is considered not yet completed
- `final`, the whole vote is considered completed
- `unknown`, the whole vote is considered completed, if all (expected) municipalities are counted

### Template

- [vote_onegov.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/vote_onegov.csv)


3 Wabsti
--------

The format of the "Wabsti Elections and Referenda (VRSG)" election program consists of a single file which contains all the data for many referenda. There is a line for every referendum and municipality.

### Columns

The following columns will be evaluated and should exist at the least:

Name|Description
---|---
`Vorlage-Nr.`|A sequential number for each proposal/referendum. Must be specified at the upload dialog.
`Name`|The name of the municipality
`BfS-Nr.`|The municipality number (BFS number). If `name = Auslandschweizer`, any value can be used for exapts.
`Stimmberechtigte`|The number of persons eligible to vote.
`leere SZ`|The number of blank ballot papers.
`ungültige SZ`|The number of spoilt ballot papers.
`Ja`|The number of “yes” votes.
`Nein`|The number of “no” votes.
`GegenvJa`|The number who voted “yes” to the counter-proposal.
`GegenvNein`|The number who voted “no” to the counter-proposal.
`StichfrJa`|The number who voted “yes” to the tie-breaker.
`StichfrNein`|The number who voted “no” to the tie-breaker.
`StimmBet`|The turnout as a percentage. Is used to decide whether the municipality has already been counted. If the turnout is `0`, the line is ignored (not yet counted).

### Temporary results

Municipalities are deemed not to have been counted yet if one of the following two conditions apply:
- `StimmBet = 0`
- the municipality is not included in the results

### Template

- [vote_wabsti.csv](https://raw.githubusercontent.com/OneGov/onegov.election_day/master/docs/templates/vote_wabsti.csv)


4 WabstiCExport
---------------

Version `2.2` is supported, please refer to the documentation provided by the exporter program for more information about the columns of the different files.
