<a id="mypy-boto3-snowball"></a>

# mypy-boto3-snowball

[![PyPI - mypy-boto3-snowball](https://img.shields.io/pypi/v/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-snowball.svg?color=blue)](https://pypi.org/project/mypy-boto3-snowball)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-snowball?color=blue)](https://pypistats.org/packages/mypy-boto3-snowball)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Snowball 1.18.49](https://boto3.amazonaws.com/v1/documentation/api/1.18.49/reference/services/snowball.html#Snowball)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-snowball docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_snowball/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-snowball](#mypy-boto3-snowball)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Snowball` service.

```bash
python -m pip install boto3-stubs[snowball]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[snowball]` in your environment:
  `python -m pip install 'boto3-stubs[snowball]'`

Both type checking and auto-complete should work for `Snowball` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[snowball]` in your environment:
  `python -m pip install 'boto3-stubs[snowball]'`

Both type checking and auto-complete should work for `Snowball` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[snowball]` in your environment:
  `python -m pip install 'boto3-stubs[snowball]'`
- Run `mypy` as usual

Type checking should work for `Snowball` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[snowball]` in your environment:
  `python -m pip install 'boto3-stubs[snowball]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Snowball` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SnowballClient` provides annotations for `boto3.client("snowball")`.

```python
import boto3

from mypy_boto3_snowball import SnowballClient

client: SnowballClient = boto3.client("snowball")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SnowballClient = session.client("snowball")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_snowball.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_snowball import SnowballClient
from mypy_boto3_snowball.paginator import (
    DescribeAddressesPaginator,
    ListClusterJobsPaginator,
    ListClustersPaginator,
    ListCompatibleImagesPaginator,
    ListJobsPaginator,
)

client: SnowballClient = boto3.client("snowball")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_addresses_paginator: DescribeAddressesPaginator = client.get_paginator("describe_addresses")
list_cluster_jobs_paginator: ListClusterJobsPaginator = client.get_paginator("list_cluster_jobs")
list_clusters_paginator: ListClustersPaginator = client.get_paginator("list_clusters")
list_compatible_images_paginator: ListCompatibleImagesPaginator = client.get_paginator("list_compatible_images")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
```

<a id="literals"></a>

### Literals

`mypy_boto3_snowball.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_snowball.literals import (
    ClusterStateType,
    DescribeAddressesPaginatorName,
    DeviceServiceNameType,
    JobStateType,
    JobTypeType,
    ListClusterJobsPaginatorName,
    ListClustersPaginatorName,
    ListCompatibleImagesPaginatorName,
    ListJobsPaginatorName,
    LongTermPricingTypeType,
    RemoteManagementType,
    ShipmentStateType,
    ShippingLabelStatusType,
    ShippingOptionType,
    SnowballCapacityType,
    SnowballTypeType,
    StorageUnitType,
    TransferOptionType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ClusterStateType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_snowball.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_snowball.type_defs import (
    AddressTypeDef,
    CancelClusterRequestRequestTypeDef,
    CancelJobRequestRequestTypeDef,
    ClusterListEntryTypeDef,
    ClusterMetadataTypeDef,
    CompatibleImageTypeDef,
    CreateAddressRequestRequestTypeDef,
    CreateAddressResultTypeDef,
    CreateClusterRequestRequestTypeDef,
    CreateClusterResultTypeDef,
    CreateJobRequestRequestTypeDef,
    CreateJobResultTypeDef,
    CreateLongTermPricingRequestRequestTypeDef,
    CreateLongTermPricingResultTypeDef,
    CreateReturnShippingLabelRequestRequestTypeDef,
    CreateReturnShippingLabelResultTypeDef,
    DataTransferTypeDef,
    DescribeAddressRequestRequestTypeDef,
    DescribeAddressResultTypeDef,
    DescribeAddressesRequestRequestTypeDef,
    DescribeAddressesResultTypeDef,
    DescribeClusterRequestRequestTypeDef,
    DescribeClusterResultTypeDef,
    DescribeJobRequestRequestTypeDef,
    DescribeJobResultTypeDef,
    DescribeReturnShippingLabelRequestRequestTypeDef,
    DescribeReturnShippingLabelResultTypeDef,
    DeviceConfigurationTypeDef,
    Ec2AmiResourceTypeDef,
    EventTriggerDefinitionTypeDef,
    GetJobManifestRequestRequestTypeDef,
    GetJobManifestResultTypeDef,
    GetJobUnlockCodeRequestRequestTypeDef,
    GetJobUnlockCodeResultTypeDef,
    GetSnowballUsageResultTypeDef,
    GetSoftwareUpdatesRequestRequestTypeDef,
    GetSoftwareUpdatesResultTypeDef,
    INDTaxDocumentsTypeDef,
    JobListEntryTypeDef,
    JobLogsTypeDef,
    JobMetadataTypeDef,
    JobResourceTypeDef,
    KeyRangeTypeDef,
    LambdaResourceTypeDef,
    ListClusterJobsRequestRequestTypeDef,
    ListClusterJobsResultTypeDef,
    ListClustersRequestRequestTypeDef,
    ListClustersResultTypeDef,
    ListCompatibleImagesRequestRequestTypeDef,
    ListCompatibleImagesResultTypeDef,
    ListJobsRequestRequestTypeDef,
    ListJobsResultTypeDef,
    ListLongTermPricingRequestRequestTypeDef,
    ListLongTermPricingResultTypeDef,
    LongTermPricingListEntryTypeDef,
    NFSOnDeviceServiceConfigurationTypeDef,
    NotificationTypeDef,
    OnDeviceServiceConfigurationTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadataTypeDef,
    S3ResourceTypeDef,
    ShipmentTypeDef,
    ShippingDetailsTypeDef,
    SnowconeDeviceConfigurationTypeDef,
    TargetOnDeviceServiceTypeDef,
    TaxDocumentsTypeDef,
    UpdateClusterRequestRequestTypeDef,
    UpdateJobRequestRequestTypeDef,
    UpdateJobShipmentStateRequestRequestTypeDef,
    UpdateLongTermPricingRequestRequestTypeDef,
    WirelessConnectionTypeDef,
)

def get_structure() -> AddressTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-snowball` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-snowball docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_snowball/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
