# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['redditwarp',
 'redditwarp._cli',
 'redditwarp.auth',
 'redditwarp.core',
 'redditwarp.dark',
 'redditwarp.dark.auth',
 'redditwarp.dark.core',
 'redditwarp.dark.siteprocs',
 'redditwarp.dark.siteprocs.login',
 'redditwarp.dark.util',
 'redditwarp.dtos',
 'redditwarp.dtos.widget',
 'redditwarp.http',
 'redditwarp.http.misc',
 'redditwarp.http.transport',
 'redditwarp.http.transport.connectors',
 'redditwarp.http.util',
 'redditwarp.iterators',
 'redditwarp.model_loaders',
 'redditwarp.models',
 'redditwarp.models.widget',
 'redditwarp.pagination',
 'redditwarp.pagination.paginators',
 'redditwarp.pagination.paginators.listing',
 'redditwarp.pagination.paginators.listing.mixins',
 'redditwarp.pagination.paginators.moderation',
 'redditwarp.pagination.paginators.user',
 'redditwarp.pushshift',
 'redditwarp.pushshift.core',
 'redditwarp.pushshift.models',
 'redditwarp.pushshift.paginators',
 'redditwarp.pushshift.siteprocs',
 'redditwarp.siteprocs',
 'redditwarp.siteprocs.account',
 'redditwarp.siteprocs.collection',
 'redditwarp.siteprocs.comment',
 'redditwarp.siteprocs.comment_tree',
 'redditwarp.siteprocs.custom_feed',
 'redditwarp.siteprocs.draft',
 'redditwarp.siteprocs.flair',
 'redditwarp.siteprocs.flair_emoji',
 'redditwarp.siteprocs.front',
 'redditwarp.siteprocs.live_thread',
 'redditwarp.siteprocs.message',
 'redditwarp.siteprocs.misc',
 'redditwarp.siteprocs.moderation',
 'redditwarp.siteprocs.modmail',
 'redditwarp.siteprocs.submission',
 'redditwarp.siteprocs.subreddit',
 'redditwarp.siteprocs.subreddit_style_new',
 'redditwarp.siteprocs.subreddit_style_old',
 'redditwarp.siteprocs.user',
 'redditwarp.siteprocs.widget',
 'redditwarp.siteprocs.wiki',
 'redditwarp.streaming',
 'redditwarp.streaming.makers',
 'redditwarp.util',
 'redditwarp.websocket',
 'redditwarp.websocket.transport',
 'redditwarp.websocket.transport.carriers']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'redditwarp',
    'version': '0.11.1',
    'description': 'A library for interacting with the Reddit API.',
    'long_description': '\n# RedditWarp\n\nA comprehensive, type-complete, easy-to-learn Python Reddit API wrapper.\n\nRedditWarp is a Python library designed to handle the complexities\nof the Reddit API in a package that is comprehensive, highly discoverable, static-type\nconscious, and provides a large set of useful abstractions that allow for better code\norganisation and maintainability.\n\nThis library can be used to build robust statically-typed Reddit bots and programs.\n\nLook how easy it is to use:\n\n```python\nimport redditwarp.SYNC\n\nclient = redditwarp.SYNC.Client()\n\nit = client.p.front.pull.hot(5)\nl = list(it)\nfor subm in l:\n    print("r/{0.subreddit.name} | {0.id36}+ ^{0.score} | {0.title!r:.80}".format(subm))\n```\n\n## Features\n\n* A consistent and easy-to-learn programming interface.\n* Modern type-complete codebase.\n* Sync and asynchronous IO support.\n* Automatic rate limit handling.\n* A comprehensive and discoverable index of API procedures.\n* Model classes that sensibly wrap API structures.\n* Formal data structures to facilitate comment tree traversals and pagination.\n* HTTP transport library agnosticism.\n* OAuth2 tooling and CLI utilities to help manage auth tokens.\n* A simple event-based listing endpoint streaming framework.\n\n## Installation\n\n**Requires Python 3.8+.**\nType annotations may use 3.9 features.\nCode examples will assume 3.10.\n\nInstall/update:\n\n    pip install -U redditwarp\n\n## Demonstration\n\n<details open>\n  <summary>Examples</summary>\n\n```python\nimport redditwarp.SYNC\n\nclient = redditwarp.SYNC.Client()\n\n# Display the first 5 submissions on the Reddit frontpage.\nit = client.p.front.pull.hot(5)\nl = list(it)\nfor subm in l:\n    print("r/{0.subreddit.name} | {0.id36}+ ^{0.score} | {0.title!r:.80}".format(subm))\n\n# How many subscribers does r/Python have?\nsubr = client.p.subreddit.fetch_by_name(\'Python\')\nprint(subr.subscriber_count)\n\n# Display the top submission of the week in the r/YouShouldKnow subreddit.\nit1 = client.p.subreddit.pull.top(\'YouShouldKnow\', amount=1, time=\'week\')\nm = next(it1)\nprint(f\'\'\'\\\n{m.permalink}\n{m.id36}+ ^{m.score} | {m.title}\nSubmitted {m.created_at.astimezone().ctime()}{\' *\' if m.is_edited else \'\'} \\\nby u/{m.author_display_name} to r/{m.subreddit.name}\n\'\'\')\n\n# Get the first comment of a submission.\ntree_node = client.p.comment_tree.fetch(int(\'uc8i1g\', 36), sort=\'top\', limit=1)\nc = tree_node.children[0].value\nprint(f\'\'\'\\\n{c.submission.id36}+{c.id36} ^{c.score}\nu/{c.author_display_name} says:\n{c.body}\n\'\'\')\n\n# List the moderators of r/redditdev.\nit2 = client.p.moderation.pull_users.moderators(\'redditdev\')\nfor mod in it2:\n    print(mod.name)\n```\n\n</details>\n\n<details>\n  <summary>More examples</summary>\n\n```python\n# ...\n\n# Need credentials for these next few API calls.\nCLIENT_ID = \'...\'\nCLIENT_SECRET = \'...\'\nREFRESH_TOKEN = \'...\'\nclient1 = redditwarp.SYNC.Client(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN)\n\n# Who am I?\nme = client1.p.account.fetch()\nprint(f"Hello u/{me.name}!")\n\n# Show my last 5 comments.\nit3 = client.p.user.pull.comments(me.name, 5)\nfor comm in it3:\n    print(\'###\')\n    print(comm.body)\n\n# Show my last 10 saved items.\nfrom redditwarp.models.submission_SYNC import Submission\nfrom redditwarp.models.comment_SYNC import Comment\nit4 = client1.p.user.pull.saved(me.name, 10)\nl = list(it4)\nfor obj in l:\n    print(\'###\')\n    match obj:\n        case Submission() as m:\n            print(f\'\'\'\\\n{m.permalink}\n{m.id36}+ ^{m.score} | {m.title}\nSubmitted {m.created_at.astimezone().ctime()}{\' *\' if m.is_edited else \'\'} \\\nby u/{m.author_display_name} to r/{m.subreddit.name}\n\'\'\')\n        case Comment() as c:\n            print(f\'\'\'\\\n{c.permalink}\n{c.submission.id36}+{c.id36} ^{c.score}\nu/{c.author_display_name} says:\n{c.body}\n\'\'\')\n\n# Submit a link post to r/test.\nsubm_id = client1.p.submission.create_link_post(\'test\',\n        "Check out this cool website", "https://www.reddit.com")\n\n# Reply to a submission.\nfrom redditwarp.util.extract_id_from_url import extract_submission_id_from_url\nidn = extract_submission_id_from_url("https://www.reddit.com/comments/5e1az9")\ncomm1 = client1.p.submission.reply(idn, "Pretty cool stuff!")\n\n# Delete the post and the comment reply.\nclient1.p.submission.delete(subm_id)\nclient1.p.comment.delete(comm1.id)\n```\n\n</details>\n\n<details>\n  <summary>Streaming example</summary>\n\n```python\n#!/usr/bin/env python\nfrom __future__ import annotations\nfrom typing import TYPE_CHECKING\nif TYPE_CHECKING:\n    from redditwarp.models.submission_ASYNC import Submission\n\nimport asyncio\n\nimport redditwarp.ASYNC\nfrom redditwarp.streaming.makers.subreddit_ASYNC import create_submission_stream\nfrom redditwarp.streaming.ASYNC import flow\n\nasync def main() -> None:\n    client = redditwarp.ASYNC.Client()\n    async with client:\n        submission_stream = create_submission_stream(client, \'AskReddit\')\n\n        @submission_stream.output.attach\n        async def _(subm: Submission) -> None:\n            print(subm.id36, \'~\', subm.title)\n\n        @submission_stream.error.attach\n        async def _(exc: Exception) -> None:\n            print(\'ERROR:\', repr(exc))\n\n        await flow(submission_stream)\n\nasyncio.run(main())\n```\n\n</details>\n\n## Support\n\nPost any questions you have to [r/redditdev].\n\n[r/redditdev]: https://www.reddit.com/r/redditdev/\n\nJoin the conversation in the RedditWarp [Discord guild].\n\n[Discord guild]: https://discord.gg/wcXTQcJ6Fc\n\n## Links\n\n* [Repository](https://github.com/Pyprohly/redditwarp)\n* [Documentation](https://redditwarp.readthedocs.io/)\n* [Discord guild]\n* [r/redditdev]\n',
    'author': 'Pyprohly',
    'author_email': 'pyprohly@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
