"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
from dataclasses_json import Undefined, dataclass_json
from enum import Enum
from shippo import utils
from typing import Optional


class Type(str, Enum):
    r"""Party to be billed. (Leave blank for DHL Germany.)"""
    SENDER = 'SENDER'
    RECIPIENT = 'RECIPIENT'
    THIRD_PARTY = 'THIRD_PARTY'
    THIRD_PARTY_CONSIGNEE = 'THIRD_PARTY_CONSIGNEE'
    COLLECT = 'COLLECT'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class Billing:
    r"""Specify billing details (UPS, FedEx, and DHL Germany only)."""
    account: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('account'), 'exclude': lambda f: f is None }})
    r"""Account number to be billed. (For DHL Germany, leave this field blank.)"""
    country: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('country'), 'exclude': lambda f: f is None }})
    r"""Country iso2 code of account number to be billed (required for UPS third party billing only)."""
    participation_code: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('participation_code'), 'exclude': lambda f: f is None }})
    r"""2 digit code used to override your default participation code associated with your DHL Germany account."""
    type: Optional[Type] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('type'), 'exclude': lambda f: f is None }})
    r"""Party to be billed. (Leave blank for DHL Germany.)"""
    zip: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('zip'), 'exclude': lambda f: f is None }})
    r"""ZIP code of account number to be billed (required for UPS if there is a zip on the billing account)."""
    

