"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
from .carrieraccountservicelevel import CarrierAccountServiceLevel
from .fedexconnectexistingownaccountparameters import FedExConnectExistingOwnAccountParameters
from .upsconnectexistingownaccountparameters import UPSConnectExistingOwnAccountParameters
from dataclasses_json import Undefined, dataclass_json
from enum import Enum
from shippo import utils
from typing import Any, Dict, List, Optional, Union


class CarrierAccountWithExtraInfoType(str, Enum):
    r"""Authentication method used by this account."""
    DEFAULT = 'default'
    OAUTH = 'oauth'


class CarrierAccountWithExtraInfoStatus(str, Enum):
    r"""Current authentication status. Possible values: 'disconnected' (authorization lost, reconnect needed), 'connected' (authorized and active), 'authorization_pending' (awaiting initial authorization flow)."""
    DISCONNECTED = 'disconnected'
    CONNECTED = 'connected'
    AUTHORIZATION_PENDING = 'authorization_pending'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class Authentication:
    type: Optional[CarrierAccountWithExtraInfoType] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('type'), 'exclude': lambda f: f is None }})
    r"""Authentication method used by this account."""
    status: Optional[CarrierAccountWithExtraInfoStatus] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('status'), 'exclude': lambda f: f is None }})
    r"""Current authentication status. Possible values: 'disconnected' (authorization lost, reconnect needed), 'connected' (authorized and active), 'authorization_pending' (awaiting initial authorization flow)."""
    



@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class ObjectInfo:
    r"""Holds internal state relevant to users."""
    authentication: Optional[Authentication] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('authentication'), 'exclude': lambda f: f is None }})
    



@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class CarrierAccountWithExtraInfo:
    account_id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('account_id') }})
    r"""Unique identifier of the account. Please check the <a href=\\"https://docs.goshippo.com/docs/carriers/carrieraccounts/\\">carrier accounts tutorial</a>
    page for the `account_id` per carrier.<br> 
    To protect account information, this field will be masked in any API response.
    """
    carrier: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('carrier') }})
    r"""Carrier token, see <a href=\\"#tag/Carriers\\">Carriers</a><br>
    Please check the <a href=\"https://docs.goshippo.com/docs/carriers/carrieraccounts/\">carrier accounts tutorial</a> page for all supported carriers.
    """
    active: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('active'), 'exclude': lambda f: f is None }})
    r"""Determines whether the account is active. When creating a shipment, if no `carrier_accounts` are explicitly
    passed Shippo will query all carrier accounts that have this field set. By default, this is set to True.
    """
    parameters: Optional[Parameters] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('parameters'), 'exclude': lambda f: f is None }})
    carrier_name: Optional[Any] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('carrier_name'), 'exclude': lambda f: f is None }})
    r"""Carrier name, see <a href=\\"#tag/Carriers\\">Carriers</a><br>"""
    is_shippo_account: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('is_shippo_account'), 'exclude': lambda f: f is None }})
    metadata: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('metadata'), 'exclude': lambda f: f is None }})
    object_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_id'), 'exclude': lambda f: f is None }})
    r"""Unique identifier of the carrier account object."""
    object_owner: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_owner'), 'exclude': lambda f: f is None }})
    r"""Username of the user who created the carrier account object."""
    service_levels: Optional[List[CarrierAccountServiceLevel]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('service_levels'), 'exclude': lambda f: f is None }})
    test: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('test'), 'exclude': lambda f: f is None }})
    r"""Indicates whether the object has been created in test mode."""
    object_info: Optional[ObjectInfo] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_info'), 'exclude': lambda f: f is None }})
    r"""Holds internal state relevant to users."""
    


Parameters = Union[Dict[str, Any], FedExConnectExistingOwnAccountParameters, UPSConnectExistingOwnAccountParameters]
