"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from .weightunitenum import WeightUnitEnum
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from shippo import utils
from typing import Optional


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class LineItemBase:
    currency: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('currency'), 'exclude': lambda f: f is None }})
    r"""Currency of the <code>total_price</code> amount."""
    manufacture_country: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('manufacture_country'), 'exclude': lambda f: f is None }})
    r"""Country the item was manufactured in. In the Shippo dashboard, this value will be used ot pre-fill the customs declaration when creating a label for this order."""
    max_delivery_time: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('max_delivery_time'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""The date and time this item needs to be delivered by, i.e. by when the carrier delivers it to the buyer.
    This value is used by some platforms such as eBay to measure a seller's shipping time and performance. 
    It will be displayed in the Shippo dashboard.
    """
    max_ship_time: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('max_ship_time'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""The date and time this item needs to be fulfilled by, i.e. by when the shipping label needs to be
    created and handed over to the carrier. This value is used by some platforms such as eBay to measure 
    a seller's handling time and performance. It will be displayed in the Shippo dashboard.
    """
    quantity: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('quantity'), 'exclude': lambda f: f is None }})
    r"""The quantity of this item in this order."""
    sku: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('sku'), 'exclude': lambda f: f is None }})
    r"""The stock keeping unit value of this item."""
    title: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('title'), 'exclude': lambda f: f is None }})
    r"""Title of the line item."""
    total_price: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('total_price'), 'exclude': lambda f: f is None }})
    r"""Total price paid by the buyer for this item (or these items, if quantity > 1)."""
    variant_title: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('variant_title'), 'exclude': lambda f: f is None }})
    r"""A variant is a specific variation of an item (e.g. `size M` or `color blue`).
    Variants might be exposed as a separate resource in the future too. 
    Currently the variant title is a free text field describing the variant.
    """
    weight: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('weight'), 'exclude': lambda f: f is None }})
    r"""Total weight of this/these item(s). Instead of specifying the weight of all items,
    you can also set the <code>total_weight</code> value of the order object.
    """
    weight_unit: Optional[WeightUnitEnum] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('weight_unit'), 'exclude': lambda f: f is None }})
    r"""The unit used for weight."""
    

