"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from .location import Location
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from enum import Enum
from shippo import utils
from typing import List, Optional


class PickupStatus(str, Enum):
    r"""Indicates the status of the pickup."""
    PENDING = 'PENDING'
    CONFIRMED = 'CONFIRMED'
    ERROR = 'ERROR'
    CANCELLED = 'CANCELLED'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class Pickup:
    carrier_account: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('carrier_account') }})
    r"""The object ID of your USPS or DHL Express carrier account.
    You can retrieve this from your Rate requests or our <a href=\"#tag/Carrier-Accounts/\">Carrier Accounts</a> endpoint.
    """
    location: Location = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('location') }})
    r"""Location where the parcel(s) will be picked up."""
    requested_end_time: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('requested_end_time'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The latest that you requested your parcels to be available for pickup.
    Expressed in the timezone specified in the response.
    """
    requested_start_time: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('requested_start_time'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""The earliest that you requested your parcels to be ready for pickup.
    Expressed in the timezone specified in the response.
    """
    transactions: List[str] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('transactions') }})
    r"""The transaction(s) object ID(s) for the parcel(s) that need to be picked up."""
    metadata: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('metadata'), 'exclude': lambda f: f is None }})
    r"""A string of up to 100 characters that can be filled with any additional information you
    want to attach to the object.
    """
    object_created: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_created'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""Date and time of Pickup creation."""
    object_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_id'), 'exclude': lambda f: f is None }})
    r"""Unique identifier of the given Pickup object."""
    object_updated: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_updated'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""Date and time of last Pickup update."""
    confirmed_start_time: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('confirmed_start_time'), 'exclude': lambda f: f is None }})
    r"""The earliest that your parcels will be ready for pickup, confirmed by the carrier.
    Expressed in the timezone specified in the response.
    """
    confirmed_end_time: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('confirmed_end_time'), 'exclude': lambda f: f is None }})
    r"""The latest that your parcels will be available for pickup, confirmed by the carrier.
    Expressed in the timezone specified in the response.
    """
    cancel_by_time: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('cancel_by_time'), 'exclude': lambda f: f is None }})
    r"""The latest time to cancel a pickup. Expressed in the timezone specified in the response.
    To cancel a pickup, you will need to contact the carrier directly. 
    The ability to cancel a pickup through Shippo may be released in future iterations.
    """
    status: Optional[PickupStatus] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('status'), 'exclude': lambda f: f is None }})
    r"""Indicates the status of the pickup."""
    confirmation_code: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('confirmation_code'), 'exclude': lambda f: f is None }})
    r"""Pickup's confirmation code returned by the carrier.
    To edit or cancel a pickup, you will need to contact USPS or DHL Express directly and provide your `confirmation_code`.
    """
    timezone: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('timezone'), 'exclude': lambda f: f is None }})
    r"""The pickup time windows will be in the time zone specified here, not UTC."""
    messages: Optional[List[str]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('messages'), 'exclude': lambda f: f is None }})
    r"""An array containing strings of any messages generated during validation."""
    is_test: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('is_test'), 'exclude': lambda f: f is None }})
    r"""Indicates whether the object has been created in test mode."""
    

