# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2258
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.box_compatibilities import BoxCompatibilities
from vrt_lss_studio.models.box_limits import BoxLimits
from vrt_lss_studio.models.capacity import Capacity
from typing import Optional, Set
from typing_extensions import Self

class Box(BaseModel):
    """
    A transport box capable to hold a cargo. 
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Unique compartment key used to identify the cargo placement in compartments.")
    capacity: Optional[Capacity] = None
    compatibilities: Optional[BoxCompatibilities] = None
    limits: Optional[BoxLimits] = None
    __properties: ClassVar[List[str]] = ["key", "capacity", "compatibilities", "limits"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Box from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of capacity
        if self.capacity:
            _dict['capacity'] = self.capacity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of limits
        if self.limits:
            _dict['limits'] = self.limits.to_dict()
        # set to None if capacity (nullable) is None
        # and model_fields_set contains the field
        if self.capacity is None and "capacity" in self.model_fields_set:
            _dict['capacity'] = None

        # set to None if compatibilities (nullable) is None
        # and model_fields_set contains the field
        if self.compatibilities is None and "compatibilities" in self.model_fields_set:
            _dict['compatibilities'] = None

        # set to None if limits (nullable) is None
        # and model_fields_set contains the field
        if self.limits is None and "limits" in self.model_fields_set:
            _dict['limits'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Box from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "capacity": Capacity.from_dict(obj["capacity"]) if obj.get("capacity") is not None else None,
            "compatibilities": BoxCompatibilities.from_dict(obj["compatibilities"]) if obj.get("compatibilities") is not None else None,
            "limits": BoxLimits.from_dict(obj["limits"]) if obj.get("limits") is not None else None
        })
        return _obj


