# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2258
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CalculationSettings(BaseModel):
    """
    Calculation settings.
    """ # noqa: E501
    max_calculation_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT20M', description="Max calculation time. The countdown starts from the time when data is uploaded to the server and calculation starts. ")
    max_waiting_time: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT20M', description="Max calculation time. The countdown starts from the time when data is uploaded to the server. ")
    result_ttl: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT20M', description="Calculation result lifetime. The countdown starts from the time when the calculation is completed. ")
    result_timezone: Optional[Annotated[int, Field(le=12, strict=True, ge=-12)]] = Field(default=0, description="The time zone where the calculation result is returned. ")
    treat_warnings_as_errors: Optional[StrictBool] = Field(default=False, description="Treat warnings as errors. ")
    precision: Optional[Annotated[int, Field(le=6, strict=True, ge=0)]] = Field(default=2, description="Specifies the calculation accuracy in the decimal point sequence number. It equals 2 by default, so the accuracy is 0.01. ")
    __properties: ClassVar[List[str]] = ["max_calculation_time", "max_waiting_time", "result_ttl", "result_timezone", "treat_warnings_as_errors", "precision"]

    @field_validator('max_calculation_time')
    def max_calculation_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('max_waiting_time')
    def max_waiting_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('result_ttl')
    def result_ttl_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CalculationSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CalculationSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "max_calculation_time": obj.get("max_calculation_time") if obj.get("max_calculation_time") is not None else 'PT20M',
            "max_waiting_time": obj.get("max_waiting_time") if obj.get("max_waiting_time") is not None else 'PT20M',
            "result_ttl": obj.get("result_ttl") if obj.get("result_ttl") is not None else 'PT20M',
            "result_timezone": obj.get("result_timezone") if obj.get("result_timezone") is not None else 0,
            "treat_warnings_as_errors": obj.get("treat_warnings_as_errors") if obj.get("treat_warnings_as_errors") is not None else False,
            "precision": obj.get("precision") if obj.get("precision") is not None else 2
        })
        return _obj


