# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2258
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.entity_type import EntityType
from typing import Optional, Set
from typing_extensions import Self

class EntityPath(BaseModel):
    """
    The description of the entity and the path to it. 
    """ # noqa: E501
    entity_key: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(description="Target entity key.")
    entity_type: EntityType
    child_entity: Optional[EntityPath] = None
    __properties: ClassVar[List[str]] = ["entity_key", "entity_type", "child_entity"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EntityPath from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of child_entity
        if self.child_entity:
            _dict['child_entity'] = self.child_entity.to_dict()
        # set to None if entity_key (nullable) is None
        # and model_fields_set contains the field
        if self.entity_key is None and "entity_key" in self.model_fields_set:
            _dict['entity_key'] = None

        # set to None if child_entity (nullable) is None
        # and model_fields_set contains the field
        if self.child_entity is None and "child_entity" in self.model_fields_set:
            _dict['child_entity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EntityPath from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "entity_key": obj.get("entity_key"),
            "entity_type": obj.get("entity_type"),
            "child_entity": EntityPath.from_dict(obj["child_entity"]) if obj.get("child_entity") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
EntityPath.model_rebuild(raise_errors=False)

