# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2258
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.capacity import Capacity
from vrt_lss_studio.models.measurements import Measurements
from vrt_lss_studio.models.quality_statistics import QualityStatistics
from typing import Optional, Set
from typing_extensions import Self

class Statistics(BaseModel):
    """
    General statistics for one or more trips. 
    """ # noqa: E501
    cost: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Total costs calculated based on the performer's and transport tariffs. The total cost is equal to the difference between the total reward (`reward`) and expenses (`cost`). ")
    reward: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="The total reward for orders fulfillment.")
    measurements: Measurements
    trips_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of planned trips.")
    performers_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of performers involved in orders fulfillment.")
    orders_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of planned and assigned orders.")
    plan_orders_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of planned orders.")
    waitlist_orders_count: Annotated[int, Field(le=15001, strict=True, ge=0)] = Field(description="The total number of assigned orders.")
    cargo_capacity_ratio: Optional[Capacity]
    max_transport_load: Optional[Capacity]
    quality: Optional[QualityStatistics] = None
    __properties: ClassVar[List[str]] = ["cost", "reward", "measurements", "trips_count", "performers_count", "orders_count", "plan_orders_count", "waitlist_orders_count", "cargo_capacity_ratio", "max_transport_load", "quality"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Statistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cargo_capacity_ratio
        if self.cargo_capacity_ratio:
            _dict['cargo_capacity_ratio'] = self.cargo_capacity_ratio.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_transport_load
        if self.max_transport_load:
            _dict['max_transport_load'] = self.max_transport_load.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # set to None if cargo_capacity_ratio (nullable) is None
        # and model_fields_set contains the field
        if self.cargo_capacity_ratio is None and "cargo_capacity_ratio" in self.model_fields_set:
            _dict['cargo_capacity_ratio'] = None

        # set to None if max_transport_load (nullable) is None
        # and model_fields_set contains the field
        if self.max_transport_load is None and "max_transport_load" in self.model_fields_set:
            _dict['max_transport_load'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Statistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cost": obj.get("cost"),
            "reward": obj.get("reward"),
            "measurements": Measurements.from_dict(obj["measurements"]) if obj.get("measurements") is not None else None,
            "trips_count": obj.get("trips_count"),
            "performers_count": obj.get("performers_count"),
            "orders_count": obj.get("orders_count"),
            "plan_orders_count": obj.get("plan_orders_count"),
            "waitlist_orders_count": obj.get("waitlist_orders_count"),
            "cargo_capacity_ratio": Capacity.from_dict(obj["cargo_capacity_ratio"]) if obj.get("cargo_capacity_ratio") is not None else None,
            "max_transport_load": Capacity.from_dict(obj["max_transport_load"]) if obj.get("max_transport_load") is not None else None,
            "quality": QualityStatistics.from_dict(obj["quality"]) if obj.get("quality") is not None else None
        })
        return _obj


