# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2258
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.actualize_settings import ActualizeSettings
from vrt_lss_studio.models.facts import Facts
from vrt_lss_studio.models.hardlink import Hardlink
from vrt_lss_studio.models.location import Location
from vrt_lss_studio.models.order import Order
from vrt_lss_studio.models.performer import Performer
from vrt_lss_studio.models.plan_settings import PlanSettings
from vrt_lss_studio.models.plan_statistics import PlanStatistics
from vrt_lss_studio.models.replan_settings import ReplanSettings
from vrt_lss_studio.models.routing_transport_matrix import RoutingTransportMatrix
from vrt_lss_studio.models.transport import Transport
from vrt_lss_studio.models.trip import Trip
from typing import Optional, Set
from typing_extensions import Self

class UniversalData(BaseModel):
    """
    VRt.Universal JSON format. A general list of data and settings that combines all data for planning, replaning and actualization. 
    """ # noqa: E501
    locations: Optional[Annotated[List[Location], Field(min_length=0, max_length=15001)]] = Field(default=None, description="List of locations used for orders and shifts.")
    orders: Optional[Annotated[List[Order], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Orders list.")
    performers: Optional[Annotated[List[Performer], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Available performers list.")
    transports: Optional[Annotated[List[Transport], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Available transports list.")
    hardlinks: Optional[Annotated[List[Hardlink], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Assignments list.")
    trips: Optional[Annotated[List[Trip], Field(min_length=0, max_length=15001)]] = Field(default=None, description="Existing routes.")
    facts: Optional[Facts] = None
    statistics: Optional[PlanStatistics] = None
    external_routing: Optional[Annotated[List[RoutingTransportMatrix], Field(min_length=0, max_length=12)]] = Field(default=None, description="Time and distance matrices list for each transport type from dataset. By specifying an external routing matrix `external_routing`, parameters `geo_settings` are not used. ")
    plan_settings: Optional[PlanSettings] = None
    replan_settings: Optional[ReplanSettings] = None
    actualize_settings: Optional[ActualizeSettings] = None
    dataset_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1000)]] = Field(default='', description="The name of the dataset. A technical field that does not affect planning. ")
    __properties: ClassVar[List[str]] = ["locations", "orders", "performers", "transports", "hardlinks", "trips", "facts", "statistics", "external_routing", "plan_settings", "replan_settings", "actualize_settings", "dataset_name"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UniversalData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in locations (list)
        _items = []
        if self.locations:
            for _item in self.locations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item in self.orders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in performers (list)
        _items = []
        if self.performers:
            for _item in self.performers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['performers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transports (list)
        _items = []
        if self.transports:
            for _item in self.transports:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transports'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in hardlinks (list)
        _items = []
        if self.hardlinks:
            for _item in self.hardlinks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['hardlinks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in trips (list)
        _items = []
        if self.trips:
            for _item in self.trips:
                if _item:
                    _items.append(_item.to_dict())
            _dict['trips'] = _items
        # override the default output from pydantic by calling `to_dict()` of facts
        if self.facts:
            _dict['facts'] = self.facts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in external_routing (list)
        _items = []
        if self.external_routing:
            for _item in self.external_routing:
                if _item:
                    _items.append(_item.to_dict())
            _dict['external_routing'] = _items
        # override the default output from pydantic by calling `to_dict()` of plan_settings
        if self.plan_settings:
            _dict['plan_settings'] = self.plan_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of replan_settings
        if self.replan_settings:
            _dict['replan_settings'] = self.replan_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actualize_settings
        if self.actualize_settings:
            _dict['actualize_settings'] = self.actualize_settings.to_dict()
        # set to None if statistics (nullable) is None
        # and model_fields_set contains the field
        if self.statistics is None and "statistics" in self.model_fields_set:
            _dict['statistics'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UniversalData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "locations": [Location.from_dict(_item) for _item in obj["locations"]] if obj.get("locations") is not None else None,
            "orders": [Order.from_dict(_item) for _item in obj["orders"]] if obj.get("orders") is not None else None,
            "performers": [Performer.from_dict(_item) for _item in obj["performers"]] if obj.get("performers") is not None else None,
            "transports": [Transport.from_dict(_item) for _item in obj["transports"]] if obj.get("transports") is not None else None,
            "hardlinks": [Hardlink.from_dict(_item) for _item in obj["hardlinks"]] if obj.get("hardlinks") is not None else None,
            "trips": [Trip.from_dict(_item) for _item in obj["trips"]] if obj.get("trips") is not None else None,
            "facts": Facts.from_dict(obj["facts"]) if obj.get("facts") is not None else None,
            "statistics": PlanStatistics.from_dict(obj["statistics"]) if obj.get("statistics") is not None else None,
            "external_routing": [RoutingTransportMatrix.from_dict(_item) for _item in obj["external_routing"]] if obj.get("external_routing") is not None else None,
            "plan_settings": PlanSettings.from_dict(obj["plan_settings"]) if obj.get("plan_settings") is not None else None,
            "replan_settings": ReplanSettings.from_dict(obj["replan_settings"]) if obj.get("replan_settings") is not None else None,
            "actualize_settings": ActualizeSettings.from_dict(obj["actualize_settings"]) if obj.get("actualize_settings") is not None else None,
            "dataset_name": obj.get("dataset_name") if obj.get("dataset_name") is not None else ''
        })
        return _obj


