/*
 * Decompiled with CFR 0.152.
 */
package kco.forceatlas2;

import kco.forceatlas2.ForceAtlas2LayoutData;
import kco.forceatlas2.Region;
import org.gephi.graph.api.Node;

public class ForceFactory {
    public static ForceFactory builder = new ForceFactory();

    private ForceFactory() {
    }

    public RepulsionForce buildRepulsion(boolean bl, double d) {
        if (bl) {
            return new linRepulsion_antiCollision(d);
        }
        return new linRepulsion(d);
    }

    public RepulsionForce getStrongGravity(double d) {
        return new strongGravity(d);
    }

    public AttractionForce buildAttraction(boolean bl, boolean bl2, boolean bl3, double d) {
        if (bl3) {
            if (bl) {
                if (bl2) {
                    return new logAttraction_degreeDistributed_antiCollision(d);
                }
                return new logAttraction_antiCollision(d);
            }
            if (bl2) {
                return new linAttraction_degreeDistributed_antiCollision(d);
            }
            return new linAttraction_antiCollision(d);
        }
        if (bl) {
            if (bl2) {
                return new logAttraction_degreeDistributed(d);
            }
            return new logAttraction(d);
        }
        if (bl2) {
            return new linAttraction_massDistributed(d);
        }
        return new linAttraction(d);
    }

    private class logAttraction_degreeDistributed_antiCollision
    extends AttractionForce {
        private double coefficient;

        public logAttraction_degreeDistributed_antiCollision(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d4 = node.x() - node2.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)(node.y() - node2.y())) * d3 + (d2 = (double)(node.z() - node2.z())) * d2) - (double)node.size() - (double)node2.size();
            if (d5 > 0.0) {
                double d6 = -this.coefficient * d * Math.log(1.0 + d5) / d5 / forceAtlas2LayoutData.getMass();
                forceAtlas2LayoutData.augmentDx(d4 * d6);
                forceAtlas2LayoutData.augmentDy(d3 * d6);
                forceAtlas2LayoutData.augmentDz(d2 * d6);
                forceAtlas2LayoutData2.augmentDx(-d4 * d6);
                forceAtlas2LayoutData2.augmentDy(-d3 * d6);
                forceAtlas2LayoutData2.augmentDz(-d2 * d6);
            }
        }
    }

    private class logAttraction_antiCollision
    extends AttractionForce {
        private double coefficient;

        public logAttraction_antiCollision(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d4 = node.x() - node2.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)(node.y() - node2.y())) * d3 + (d2 = (double)(node.z() - node2.z())) * d2) - (double)node.size() - (double)node2.size();
            if (d5 > 0.0) {
                double d6 = -this.coefficient * d * Math.log(1.0 + d5) / d5;
                forceAtlas2LayoutData.augmentDx(d4 * d6);
                forceAtlas2LayoutData.augmentDy(d3 * d6);
                forceAtlas2LayoutData.augmentDz(d2 * d6);
                forceAtlas2LayoutData2.augmentDx(-d4 * d6);
                forceAtlas2LayoutData2.augmentDy(-d3 * d6);
                forceAtlas2LayoutData2.augmentDz(-d2 * d6);
            }
        }
    }

    private class linAttraction_degreeDistributed_antiCollision
    extends AttractionForce {
        private double coefficient;

        public linAttraction_degreeDistributed_antiCollision(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d4 = node.x() - node2.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)(node.y() - node2.y())) * d3 + (d2 = (double)(node.z() - node2.z())) * d2) - (double)node.size() - (double)node2.size();
            if (d5 > 0.0) {
                double d6 = -this.coefficient * d / forceAtlas2LayoutData.getMass();
                forceAtlas2LayoutData.augmentDx(d4 * d6);
                forceAtlas2LayoutData.augmentDy(d3 * d6);
                forceAtlas2LayoutData.augmentDz(d2 * d6);
                forceAtlas2LayoutData2.augmentDx(-d4 * d6);
                forceAtlas2LayoutData2.augmentDy(-d3 * d6);
                forceAtlas2LayoutData2.augmentDz(-d2 * d6);
            }
        }
    }

    private class linAttraction_antiCollision
    extends AttractionForce {
        private double coefficient;

        public linAttraction_antiCollision(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d4 = node.x() - node2.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)(node.y() - node2.y())) * d3 + (d2 = (double)(node.z() - node2.z())) * d2) - (double)node.size() - (double)node2.size();
            if (d5 > 0.0) {
                double d6 = -this.coefficient * d;
                forceAtlas2LayoutData.augmentDx(d4 * d6);
                forceAtlas2LayoutData.augmentDy(d3 * d6);
                forceAtlas2LayoutData.augmentDz(d2 * d6);
                forceAtlas2LayoutData2.augmentDx(-d4 * d6);
                forceAtlas2LayoutData2.augmentDy(-d3 * d6);
                forceAtlas2LayoutData2.augmentDz(-d2 * d6);
            }
        }
    }

    private class logAttraction_degreeDistributed
    extends AttractionForce {
        private double coefficient;

        public logAttraction_degreeDistributed(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d4 = node.x() - node2.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)(node.y() - node2.y())) * d3 + (d2 = (double)(node.z() - node2.z())) * d2);
            if (d5 > 0.0) {
                double d6 = -this.coefficient * d * Math.log(1.0 + d5) / d5 / forceAtlas2LayoutData.getMass();
                forceAtlas2LayoutData.augmentDx(d4 * d6);
                forceAtlas2LayoutData.augmentDy(d3 * d6);
                forceAtlas2LayoutData.augmentDz(d2 * d6);
                forceAtlas2LayoutData2.augmentDx(-d4 * d6);
                forceAtlas2LayoutData2.augmentDy(-d3 * d6);
                forceAtlas2LayoutData2.augmentDz(-d2 * d6);
            }
        }
    }

    private class logAttraction
    extends AttractionForce {
        private double coefficient;

        public logAttraction(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d4 = node.x() - node2.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)(node.y() - node2.y())) * d3 + (d2 = (double)(node.z() - node2.z())) * d2);
            if (d5 > 0.0) {
                double d6 = -this.coefficient * d * Math.log(1.0 + d5) / d5;
                forceAtlas2LayoutData.augmentDx(d4 * d6);
                forceAtlas2LayoutData.augmentDy(d3 * d6);
                forceAtlas2LayoutData.augmentDz(d2 * d6);
                forceAtlas2LayoutData2.augmentDx(-d4 * d6);
                forceAtlas2LayoutData2.augmentDy(-d3 * d6);
                forceAtlas2LayoutData2.augmentDz(-d2 * d6);
            }
        }
    }

    private class linAttraction_massDistributed
    extends AttractionForce {
        private double coefficient;

        public linAttraction_massDistributed(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d2 = node.x() - node2.x();
            double d3 = node.y() - node2.y();
            double d4 = node.z() - node2.z();
            double d5 = -this.coefficient * d / forceAtlas2LayoutData.getMass();
            forceAtlas2LayoutData.augmentDx(d2 * d5);
            forceAtlas2LayoutData.augmentDy(d3 * d5);
            forceAtlas2LayoutData.augmentDz(d4 * d5);
            forceAtlas2LayoutData2.augmentDx(-d2 * d5);
            forceAtlas2LayoutData2.augmentDy(-d3 * d5);
            forceAtlas2LayoutData2.augmentDz(-d4 * d5);
        }
    }

    private class linAttraction
    extends AttractionForce {
        private double coefficient;

        public linAttraction(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2, double d) {
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d2 = node.x() - node2.x();
            double d3 = node.y() - node2.y();
            double d4 = node.z() - node2.z();
            double d5 = -this.coefficient * d;
            forceAtlas2LayoutData.augmentDx(d2 * d5);
            forceAtlas2LayoutData.augmentDy(d3 * d5);
            forceAtlas2LayoutData.augmentDz(d4 * d5);
            forceAtlas2LayoutData2.augmentDx(-d2 * d5);
            forceAtlas2LayoutData2.augmentDy(-d3 * d5);
            forceAtlas2LayoutData2.augmentDz(-d4 * d5);
        }
    }

    private class strongGravity
    extends RepulsionForce {
        private double coefficient;

        public strongGravity(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2) {
        }

        @Override
        public void apply(Node node, Region region) {
        }

        @Override
        public void apply(Node node, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            double d4 = node.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)node.y()) * d3 + (d2 = (double)node.z()) * d2);
            if (d5 > 0.0) {
                double d6 = this.coefficient * forceAtlas2LayoutData.getMass() * d;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() - d4 * d6);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() - d3 * d6);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() - d2 * d6);
            }
        }

        @Override
        public void apply_BH(Node node, Node node2) {
        }
    }

    private class linRepulsion_antiCollision
    extends RepulsionForce {
        private double coefficient;

        public linRepulsion_antiCollision(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2) {
            double d;
            double d2;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d3 = node.x() - node2.x();
            double d4 = Math.sqrt(d3 * d3 + (d2 = (double)(node.y() - node2.y())) * d2 + (d = (double)(node.z() - node2.z())) * d) - (double)node.size() - (double)node2.size();
            if (d4 > 0.0) {
                double d5 = this.coefficient * forceAtlas2LayoutData.getMass() * forceAtlas2LayoutData2.getMass() / d4 / d4;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d5);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d5);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d5);
                forceAtlas2LayoutData2.setDx(forceAtlas2LayoutData2.getDx() - d3 * d5);
                forceAtlas2LayoutData2.setDy(forceAtlas2LayoutData2.getDy() - d2 * d5);
                forceAtlas2LayoutData2.setDz(forceAtlas2LayoutData2.getDz() - d * d5);
            } else if (d4 < 0.0) {
                double d6 = 100.0 * this.coefficient * forceAtlas2LayoutData.getMass() * forceAtlas2LayoutData2.getMass();
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d6);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d6);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d6);
                forceAtlas2LayoutData2.setDx(forceAtlas2LayoutData2.getDx() - d3 * d6);
                forceAtlas2LayoutData2.setDy(forceAtlas2LayoutData2.getDy() - d2 * d6);
                forceAtlas2LayoutData2.setDz(forceAtlas2LayoutData2.getDz() - d * d6);
            }
        }

        @Override
        public void apply(Node node, Region region) {
            double d;
            double d2;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            double d3 = (double)node.x() - region.getMassCenterX();
            double d4 = Math.sqrt(d3 * d3 + (d2 = (double)node.y() - region.getMassCenterY()) * d2 + (d = (double)node.z() - region.getMassCenterZ()) * d);
            if (d4 > 0.0) {
                double d5 = this.coefficient * forceAtlas2LayoutData.getMass() * region.getMass() / d4 / d4;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d5);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d5);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d5);
            } else if (d4 < 0.0) {
                double d6 = -this.coefficient * forceAtlas2LayoutData.getMass() * region.getMass() / d4;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d6);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d6);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d6);
            }
        }

        @Override
        public void apply(Node node, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            double d4 = node.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)node.y()) * d3 + (d2 = (double)node.z()) * d2);
            if (d5 > 0.0) {
                double d6 = this.coefficient * forceAtlas2LayoutData.getMass() * d / d5;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() - d4 * d6);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() - d3 * d6);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() - d2 * d6);
            }
        }

        @Override
        public void apply_BH(Node node, Node node2) {
            double d;
            double d2;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d3 = node.x() - node2.x();
            double d4 = Math.sqrt(d3 * d3 + (d2 = (double)(node.y() - node2.y())) * d2 + (d = (double)(node.z() - node2.z())) * d) - (double)node.size() - (double)node2.size();
            if (d4 > 0.0) {
                double d5 = this.coefficient * forceAtlas2LayoutData.getMass() * forceAtlas2LayoutData2.getMass() / d4 / d4;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d5);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d5);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d5);
            }
        }
    }

    private class linRepulsion
    extends RepulsionForce {
        private double coefficient;

        public linRepulsion(double d) {
            this.coefficient = d;
        }

        @Override
        public void apply(Node node, Node node2) {
            double d;
            double d2;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d3 = node.x() - node2.x();
            double d4 = Math.sqrt(d3 * d3 + (d2 = (double)(node.y() - node2.y())) * d2 + (d = (double)(node.z() - node2.z())) * d);
            if (d4 > 0.0) {
                double d5 = this.coefficient * forceAtlas2LayoutData.getMass() * forceAtlas2LayoutData2.getMass() / d4 / d4;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d5);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d5);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d5);
                forceAtlas2LayoutData2.setDx(forceAtlas2LayoutData2.getDx() - d3 * d5);
                forceAtlas2LayoutData2.setDy(forceAtlas2LayoutData2.getDy() - d2 * d5);
                forceAtlas2LayoutData2.setDz(forceAtlas2LayoutData2.getDz() - d * d5);
            }
        }

        @Override
        public void apply(Node node, Region region) {
            double d;
            double d2;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            double d3 = (double)node.x() - region.getMassCenterX();
            double d4 = Math.sqrt(d3 * d3 + (d2 = (double)node.y() - region.getMassCenterY()) * d2 + (d = (double)node.z() - region.getMassCenterZ()) * d);
            if (d4 > 0.0) {
                double d5 = this.coefficient * forceAtlas2LayoutData.getMass() * region.getMass() / d4 / d4;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d5);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d5);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d5);
            }
        }

        @Override
        public void apply(Node node, double d) {
            double d2;
            double d3;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            double d4 = node.x();
            double d5 = Math.sqrt(d4 * d4 + (d3 = (double)node.y()) * d3 + (d2 = (double)node.z()) * d2);
            if (d5 > 0.0) {
                double d6 = this.coefficient * forceAtlas2LayoutData.getMass() * d / d5;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() - d4 * d6);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() - d3 * d6);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() - d2 * d6);
            }
        }

        @Override
        public void apply_BH(Node node, Node node2) {
            double d;
            double d2;
            ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            ForceAtlas2LayoutData forceAtlas2LayoutData2 = (ForceAtlas2LayoutData)node2.getLayoutData();
            double d3 = node.x() - node2.x();
            double d4 = Math.sqrt(d3 * d3 + (d2 = (double)(node.y() - node2.y())) * d2 + (d = (double)(node.z() - node2.z())) * d);
            if (d4 > 0.0) {
                double d5 = this.coefficient * forceAtlas2LayoutData.getMass() * forceAtlas2LayoutData2.getMass() / d4 / d4;
                forceAtlas2LayoutData.setDx(forceAtlas2LayoutData.getDx() + d3 * d5);
                forceAtlas2LayoutData.setDy(forceAtlas2LayoutData.getDy() + d2 * d5);
                forceAtlas2LayoutData.setDz(forceAtlas2LayoutData.getDz() + d * d5);
            }
        }
    }

    public abstract class RepulsionForce {
        public abstract void apply(Node var1, Node var2);

        public abstract void apply(Node var1, Region var2);

        public abstract void apply(Node var1, double var2);

        public abstract void apply_BH(Node var1, Node var2);
    }

    public abstract class AttractionForce {
        public abstract void apply(Node var1, Node var2, double var3);
    }
}

