/*
 * Decompiled with CFR 0.152.
 */
package kco.forceatlas2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kco.forceatlas2.ForceAtlas2;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.io.exporter.api.ExportController;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.ImportController;
import org.gephi.io.processor.plugin.DefaultProcessor;
import org.gephi.io.processor.spi.Processor;
import org.gephi.layout.spi.Layout;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public class Main {
    private static Map<String, Arg> argsMap = new LinkedHashMap<String, Arg>();

    private static void writeOutput(Graph graph, boolean bl, Set<String> set, String string) {
        try {
            ExportController exportController = (ExportController)Lookup.getDefault().lookup(ExportController.class);
            for (String string2 : set) {
                if (string2.equals("txt")) {
                    PrintWriter printWriter = new PrintWriter(new FileWriter(string + (string.toLowerCase().endsWith("." + string2) ? "" : "." + string2)));
                    printWriter.print("id\tx\ty" + (bl ? "\tz" : "") + "\n");
                    for (Node node : graph.getNodes()) {
                        printWriter.print(node.getId());
                        printWriter.print("\t");
                        printWriter.print(node.x());
                        printWriter.print("\t");
                        printWriter.print(node.y());
                        if (bl) {
                            printWriter.print("\t");
                            printWriter.print(node.z());
                        }
                        printWriter.print("\n");
                    }
                    printWriter.close();
                    continue;
                }
                exportController.exportFile(new File(string + (string.toLowerCase().endsWith("." + string2) ? "" : "." + string2)), exportController.getExporter(string2));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private static void addArg(String string, String string2, boolean bl, Object object) {
        argsMap.put("--" + string.toLowerCase(), new Arg(string, string2, bl, "" + object));
    }

    private static void addArg(String string, String string2, boolean bl) {
        argsMap.put("--" + string.toLowerCase(), new Arg(string, string2, bl, null));
    }

    private static String getArg(String string) {
        Arg arg = argsMap.get("--" + string.toLowerCase());
        return arg != null ? arg.value : null;
    }

    public static void main(String[] stringArray) throws IOException {
        PrintWriter printWriter;
        int n;
        Object object;
        Object object22;
        HashSet<String> hashSet;
        Object object32;
        UndirectedGraph undirectedGraph;
        int n2;
        long l = System.currentTimeMillis();
        Main.addArg("input", "Input graph in one of Gephi input file formats https://gephi.org/users/supported-graph-formats/", true);
        Main.addArg("output", "Output file", true);
        Main.addArg("nsteps", "Number of iterations. Mutually exclusive with --targetChangePerNode", true);
        Main.addArg("targetChangePerNode", "Maximum change per node to stop the algorithm. Mutually exclusive with --nsteps", true);
        Main.addArg("targetSteps", "Maximum number of iterations before stopping the algoritm. This option is together with --targetChangePerNode", true, 10000);
        Main.addArg("2d", "Generate a 2d layout", false, false);
        Main.addArg("useAltSpeed", "Use alternative speed calculation, which is documented in the ForceAtlas2 paper.", false, false);
        Main.addArg("directed", "Whether input graph is undirected", false, false);
        Main.addArg("nthreads", "Number of threads to use. If not specified will use all cores", true);
        Main.addArg("format", "Output file format. One of csv, gdf, gexf, gml, graphml, pajek, txt", true);
        Main.addArg("coords", "Tab separated file containing initial coordinates with headers id, x, y, and, z", true);
        Main.addArg("seed", "Seed for random number generation for initial node positions", true);
        Main.addArg("barnesHutSplits", "Rounds of splits to use for Barnes-Hut tree building. Number of regions after splitting is 4^barnesHutSplits for 2D and 8^barnesHutSplits for 3D", true);
        Main.addArg("barnesHutTheta", " Theta of the Barnes Hut optimization", true);
        Main.addArg("barnesHutUpdateIter", "Update Barnes-Hut tree every barnesHutUpdateIter iterations", true);
        Main.addArg("updateCenter", "Update Barnes-Hut region centers when not rebuilding Barnes-Hut tree", false, false);
        Main.addArg("jitterTolerance", "How much swinging you allow. Above 1 discouraged. Lower gives less speed and more precision.", true);
        Main.addArg("linLogMode", "Switch ForceAtlas' model from lin-lin to lin-log (tribute to Andreas Noack). Makes clusters more tight.", true);
        Main.addArg("scalingRatio", "How much repulsion you want. More makes a more sparse graph", true);
        Main.addArg("gravity", "Attracts nodes to the center", true);
        Main.addArg("strongGravityMode", "A stronger gravity law", true);
        Main.addArg("outboundAttractionDistribution", "Distributes attraction along outbound edges. Hubs attract less and thus are pushed to the borders.", true);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string;
            Arg arg = argsMap.get(stringArray[n2].toLowerCase());
            if (arg == null) {
                System.err.println("Unknown argument " + stringArray[n2]);
                System.exit(1);
            }
            arg.value = string = arg.not_boolean ? stringArray[++n2] : "true";
        }
        n2 = 0;
        double d = 0.0;
        int n3 = 0;
        Long l2 = null;
        boolean bl = true;
        boolean bl2 = false;
        int n4 = Runtime.getRuntime().availableProcessors();
        Double d2 = null;
        Double d3 = null;
        Boolean bl3 = null;
        Double d4 = null;
        Boolean bl4 = null;
        Double d5 = null;
        Boolean bl5 = null;
        Integer n5 = null;
        HashSet<String> hashSet2 = new HashSet<String>();
        File file = null;
        Boolean bl6 = false;
        Integer n6 = null;
        File file2 = new File(Main.getArg("input"));
        if (!file2.exists()) {
            System.err.println(file2 + " not found.");
            System.exit(1);
        }
        String string = Main.getArg("output");
        if (Main.getArg("nsteps") != null) {
            n2 = Integer.parseInt(Main.getArg("nsteps"));
        }
        if (Main.getArg("targetChangePerNode") != null) {
            d = Double.parseDouble(Main.getArg("targetChangePerNode"));
            n3 = Integer.parseInt(Main.getArg("targetSteps"));
        }
        if (n2 == 0 && d == 0.0) {
            System.err.println("Either --nsteps or --targetChangePerNode must be set!");
            System.exit(1);
        }
        if (n2 > 0 && d > 0.0) {
            System.err.println("--nsteps and --targetChangePerNode are mutually exclusive!");
            System.exit(1);
        }
        if (Main.getArg("barnesHutSplits") != null) {
            n6 = Integer.parseInt(Main.getArg("barnesHutSplits"));
        }
        if (Main.getArg("nthreads") != null) {
            n4 = Integer.parseInt(Main.getArg("nthreads"));
        }
        if (Main.getArg("barnesHutTheta") != null) {
            d2 = Double.parseDouble(Main.getArg("barnesHutTheta"));
        }
        if (Main.getArg("jitterTolerance") != null) {
            d3 = Double.parseDouble(Main.getArg("jitterTolerance"));
        }
        if (Main.getArg("linLogMode") != null) {
            bl3 = Main.getArg("linLogMode").equalsIgnoreCase("true");
        }
        if (Main.getArg("scalingRatio") != null) {
            d4 = Double.parseDouble(Main.getArg("scalingRatio"));
        }
        if (Main.getArg("gravity") != null) {
            d5 = Double.parseDouble(Main.getArg("gravity"));
        }
        if (Main.getArg("strongGravityMode") != null) {
            bl4 = Main.getArg("strongGravityMode").equalsIgnoreCase("true");
        }
        if (Main.getArg("outboundAttractionDistribution") != null) {
            bl5 = Main.getArg("outboundAttractionDistribution").equalsIgnoreCase("true");
        }
        if (Main.getArg("seed") != null) {
            l2 = Long.parseLong(Main.getArg("seed"));
        }
        if (Main.getArg("format") != null) {
            hashSet2.add(Main.getArg("format"));
        }
        if (Main.getArg("barnesHutUpdateIter") != null) {
            n5 = Integer.parseInt(Main.getArg("barnesHutUpdateIter"));
        }
        bl6 = Main.getArg("updateCenter").equalsIgnoreCase("true");
        bl = !Main.getArg("2d").equalsIgnoreCase("true");
        bl2 = Main.getArg("useAltSpeed").equalsIgnoreCase("true");
        if (Main.getArg("coords") != null && !(file = new File(Main.getArg("coords"))).exists()) {
            System.err.println(file + " not found.");
            System.exit(1);
        }
        if (hashSet2.size() == 0) {
            hashSet2.add("txt");
        }
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        projectController.newProject();
        Workspace workspace = projectController.getCurrentWorkspace();
        ImportController importController = (ImportController)Lookup.getDefault().lookup(ImportController.class);
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        Container container = importController.importFile(file2);
        if (!Main.getArg("directed").equalsIgnoreCase("true")) {
            container.getLoader().setEdgeDefault(EdgeDirectionDefault.UNDIRECTED);
            undirectedGraph = graphModel.getUndirectedGraph();
        } else {
            container.getLoader().setEdgeDefault(EdgeDirectionDefault.DIRECTED);
            undirectedGraph = graphModel.getDirectedGraph();
        }
        importController.process(container, (Processor)new DefaultProcessor(), workspace);
        ForceAtlas2 forceAtlas2 = new ForceAtlas2(null, bl, bl2);
        forceAtlas2.setGraphModel(graphModel);
        Random random = l2 != null ? new Random(l2) : new Random();
        int n7 = 0;
        for (Object object32 : undirectedGraph.getNodes()) {
            ++n7;
            object32.setX((float)((0.01 + random.nextDouble()) * 1000.0) - 500.0f);
            object32.setY((float)((0.01 + random.nextDouble()) * 1000.0) - 500.0f);
            if (bl) {
                object32.setZ((float)((0.01 + random.nextDouble()) * 1000.0) - 500.0f);
                continue;
            }
            object32.setZ(0.0f);
        }
        if (file != null) {
            hashSet = new HashMap();
            for (Object object22 : undirectedGraph.getNodes()) {
                hashSet.put(object22.getId(), object22);
            }
            object32 = new BufferedReader(new FileReader(file));
            object22 = "\t";
            object = ((BufferedReader)object32).readLine();
            for (String string2 : new String[]{"\t", ","}) {
                if (((String)object).indexOf(string2) == -1) continue;
                object22 = string2;
                break;
            }
            List<String> list = Arrays.asList(((String)object).split((String)object22));
            int n8 = list.indexOf("id");
            int n9 = list.indexOf("x");
            n = list.indexOf("y");
            int n10 = list.indexOf("z");
            while ((object = ((BufferedReader)object32).readLine()) != null) {
                String[] stringArray2 = ((String)object).split((String)object22);
                String string3 = stringArray2[n8];
                Node node = (Node)hashSet.get(string3);
                if (node != null) {
                    node.setX(Float.parseFloat(stringArray2[n9]));
                    node.setY(Float.parseFloat(stringArray2[n]));
                    if (!bl) continue;
                    node.setZ(Float.parseFloat(stringArray2[n10]));
                    continue;
                }
                System.err.println(string3 + " not found");
            }
            ((BufferedReader)object32).close();
        }
        if (d2 != null) {
            forceAtlas2.setBarnesHutTheta(d2);
        }
        if (d3 != null) {
            forceAtlas2.setJitterTolerance(d3);
        }
        if (bl3 != null) {
            forceAtlas2.setLinLogMode(bl3);
        }
        if (d4 != null) {
            forceAtlas2.setScalingRatio(d4);
        }
        if (bl4 != null) {
            forceAtlas2.setStrongGravityMode(bl4);
        }
        if (d5 != null) {
            forceAtlas2.setGravity(d5);
        }
        if (bl5 != null) {
            forceAtlas2.setOutboundAttractionDistribution(bl5);
        }
        forceAtlas2.setThreadsCount(n4);
        if (n5 != null) {
            forceAtlas2.setUpdateBarnesHutIter(n5);
        }
        if (bl6 != null) {
            forceAtlas2.setUpdateCenter(bl6);
        }
        if (n6 != null) {
            forceAtlas2.setBarnesHutSplits(n6);
        }
        forceAtlas2.initAlgo();
        hashSet = hashSet2;
        object32 = string;
        object22 = undirectedGraph;
        object = forceAtlas2;
        boolean bl7 = bl;
        PrintWriter printWriter2 = printWriter = n2 > 0 ? new PrintWriter(new FileWriter(string + ".distances.txt")) : null;
        if (n2 > 0) {
            printWriter.print("step\tdistance\n");
        }
        Thread thread = new Thread((Layout)object, (Graph)object22, bl7, hashSet, (String)object32, printWriter){
            final /* synthetic */ Layout val$_layout;
            final /* synthetic */ Graph val$_g;
            final /* synthetic */ boolean val$_is3d;
            final /* synthetic */ Set val$_formats;
            final /* synthetic */ String val$_output;
            final /* synthetic */ PrintWriter val$distanceWriter;
            {
                this.val$_layout = layout;
                this.val$_g = graph;
                this.val$_is3d = bl;
                this.val$_formats = set;
                this.val$_output = string;
                this.val$distanceWriter = printWriter;
            }

            @Override
            public void run() {
                this.val$_layout.endAlgo();
                Main.writeOutput(this.val$_g, this.val$_is3d, this.val$_formats, this.val$_output);
                if (this.val$distanceWriter != null) {
                    this.val$distanceWriter.close();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        if (n2 > 0) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                forceAtlas2.goAlgo();
                double d6 = forceAtlas2.getDistance();
                printWriter.print(i);
                printWriter.print("\t");
                printWriter.print(d6);
                printWriter.print("\n");
                printWriter.flush();
                int n11 = (int)Math.floor(100.0 * ((double)i + 1.0) / (double)n2);
                if (n11 == n) continue;
                System.out.print("*");
                n = n11;
                if (n11 % 25 != 0) continue;
                System.out.println(n11 + "%");
            }
        } else {
            double d7;
            n2 = 0;
            do {
                forceAtlas2.goAlgo();
                d7 = forceAtlas2.getDistance() / (double)n7;
                if (++n2 % 100 != 0) continue;
                System.out.println(n2 + " iterations, change_per_node = " + d7);
            } while (n2 == 1 || d7 > d && n2 < n3);
            System.out.println("Finished in " + n2 + " iterations, change_per_node = " + d7);
        }
        Runtime.getRuntime().removeShutdownHook(thread);
        forceAtlas2.endAlgo();
        Main.writeOutput((Graph)undirectedGraph, bl, hashSet2, string);
        if (printWriter != null) {
            printWriter.close();
        }
        long l3 = System.currentTimeMillis();
        System.out.println("Time = " + (double)(l3 - l) / 1000.0 + "s");
    }

    private static class Arg {
        String flag;
        String description;
        boolean not_boolean;
        String defaultValue;
        String value;

        private Arg(String string, String string2, boolean bl, String string3) {
            this.flag = string;
            this.description = string2;
            this.not_boolean = bl;
            this.defaultValue = string3;
            if (string3 != null) {
                this.value = string3;
            }
        }

        public String toString() {
            return this.flag;
        }
    }
}

