# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictStr
from typing import Optional
from typing_extensions import Annotated
from uuid import UUID
from ..models.account_status import AccountStatus
from ..models.broker_data_account_type_enum import BrokerDataAccountTypeEnum
from ..models.broker_data_asset_type_enum import BrokerDataAssetTypeEnum
from ..models.broker_data_order_side_enum import BrokerDataOrderSideEnum
from ..models.broker_data_order_status_enum import BrokerDataOrderStatusEnum
from ..models.broker_data_position_status_enum import BrokerDataPositionStatusEnum
from ..models.finatic_response_disconnect_action_result import FinaticResponseDisconnectActionResult
from ..models.finatic_response_list_accounts import FinaticResponseListAccounts
from ..models.finatic_response_list_balances import FinaticResponseListBalances
from ..models.finatic_response_list_broker_info import FinaticResponseListBrokerInfo
from ..models.finatic_response_list_order_event_response import FinaticResponseListOrderEventResponse
from ..models.finatic_response_list_order_fill_response import FinaticResponseListOrderFillResponse
from ..models.finatic_response_list_order_group_response import FinaticResponseListOrderGroupResponse
from ..models.finatic_response_list_order_response import FinaticResponseListOrderResponse
from ..models.finatic_response_list_position_lot_fill_response import FinaticResponseListPositionLotFillResponse
from ..models.finatic_response_list_position_lot_response import FinaticResponseListPositionLotResponse
from ..models.finatic_response_list_position_response import FinaticResponseListPositionResponse
from ..models.finatic_response_list_user_broker_connections import FinaticResponseListUserBrokerConnections

from ..api_client import ApiClient, RequestSerialized
from ..api_response import ApiResponse
from ..rest import RESTResponseType


class BrokersApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def disconnect_company_from_broker_api_v1_brokers_disconnect_company_connection_id_delete(
        self,
        connection_id: Annotated[UUID, Field(description="Connection ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseDisconnectActionResult:
        """Disconnect Company From Broker

        Remove a company's access to a broker connection.  If the company is the only one with access, the entire connection is deleted. If other companies have access, only the company's access is removed.

        :param connection_id: Connection ID (required)
        :type connection_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._disconnect_company_from_broker_api_v1_brokers_disconnect_company_connection_id_delete_serialize(
            connection_id=connection_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseDisconnectActionResult",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def disconnect_company_from_broker_api_v1_brokers_disconnect_company_connection_id_delete_with_http_info(
        self,
        connection_id: Annotated[UUID, Field(description="Connection ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseDisconnectActionResult]:
        """Disconnect Company From Broker

        Remove a company's access to a broker connection.  If the company is the only one with access, the entire connection is deleted. If other companies have access, only the company's access is removed.

        :param connection_id: Connection ID (required)
        :type connection_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._disconnect_company_from_broker_api_v1_brokers_disconnect_company_connection_id_delete_serialize(
            connection_id=connection_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseDisconnectActionResult",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def disconnect_company_from_broker_api_v1_brokers_disconnect_company_connection_id_delete_without_preload_content(
        self,
        connection_id: Annotated[UUID, Field(description="Connection ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Disconnect Company From Broker

        Remove a company's access to a broker connection.  If the company is the only one with access, the entire connection is deleted. If other companies have access, only the company's access is removed.

        :param connection_id: Connection ID (required)
        :type connection_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._disconnect_company_from_broker_api_v1_brokers_disconnect_company_connection_id_delete_serialize(
            connection_id=connection_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseDisconnectActionResult",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _disconnect_company_from_broker_api_v1_brokers_disconnect_company_connection_id_delete_serialize(
        self,
        connection_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if connection_id is not None:
            _path_params['connection_id'] = connection_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v1/brokers/disconnect-company/{connection_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_accounts_api_v1_brokers_data_accounts_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_type: Annotated[Optional[BrokerDataAccountTypeEnum], Field(description="Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')")] = None,
        status: Annotated[Optional[AccountStatus], Field(description="Filter by account status (e.g., 'active', 'inactive')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of accounts to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of accounts to skip for pagination")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include connection metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListAccounts:
        """Get Accounts

        Get accounts for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns accounts from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_type: Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')
        :type account_type: BrokerDataAccountTypeEnum
        :param status: Filter by account status (e.g., 'active', 'inactive')
        :type status: AccountStatus
        :param currency: Filter by currency (e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of accounts to return
        :type limit: int
        :param offset: Number of accounts to skip for pagination
        :type offset: int
        :param with_metadata: Include connection metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_api_v1_brokers_data_accounts_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_type=account_type,
            status=status,
            currency=currency,
            limit=limit,
            offset=offset,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListAccounts",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_accounts_api_v1_brokers_data_accounts_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_type: Annotated[Optional[BrokerDataAccountTypeEnum], Field(description="Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')")] = None,
        status: Annotated[Optional[AccountStatus], Field(description="Filter by account status (e.g., 'active', 'inactive')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of accounts to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of accounts to skip for pagination")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include connection metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListAccounts]:
        """Get Accounts

        Get accounts for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns accounts from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_type: Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')
        :type account_type: BrokerDataAccountTypeEnum
        :param status: Filter by account status (e.g., 'active', 'inactive')
        :type status: AccountStatus
        :param currency: Filter by currency (e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of accounts to return
        :type limit: int
        :param offset: Number of accounts to skip for pagination
        :type offset: int
        :param with_metadata: Include connection metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_api_v1_brokers_data_accounts_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_type=account_type,
            status=status,
            currency=currency,
            limit=limit,
            offset=offset,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListAccounts",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_accounts_api_v1_brokers_data_accounts_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_type: Annotated[Optional[BrokerDataAccountTypeEnum], Field(description="Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')")] = None,
        status: Annotated[Optional[AccountStatus], Field(description="Filter by account status (e.g., 'active', 'inactive')")] = None,
        currency: Annotated[Optional[StrictStr], Field(description="Filter by currency (e.g., 'USD', 'EUR')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of accounts to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of accounts to skip for pagination")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include connection metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Accounts

        Get accounts for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns accounts from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_type: Filter by account type (e.g., 'margin', 'cash', 'crypto_wallet', 'live', 'sim')
        :type account_type: BrokerDataAccountTypeEnum
        :param status: Filter by account status (e.g., 'active', 'inactive')
        :type status: AccountStatus
        :param currency: Filter by currency (e.g., 'USD', 'EUR')
        :type currency: str
        :param limit: Maximum number of accounts to return
        :type limit: int
        :param offset: Number of accounts to skip for pagination
        :type offset: int
        :param with_metadata: Include connection metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_accounts_api_v1_brokers_data_accounts_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_type=account_type,
            status=status,
            currency=currency,
            limit=limit,
            offset=offset,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListAccounts",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_accounts_api_v1_brokers_data_accounts_get_serialize(
        self,
        broker_id,
        connection_id,
        account_type,
        status,
        currency,
        limit,
        offset,
        with_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_type is not None:
            
            _query_params.append(('account_type', account_type.value))
            
        if status is not None:
            
            _query_params.append(('status', status.value))
            
        if currency is not None:
            
            _query_params.append(('currency', currency))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if with_metadata is not None:
            
            _query_params.append(('with_metadata', with_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/accounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_balances_api_v1_brokers_data_balances_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        is_end_of_day_snapshot: Annotated[Optional[StrictBool], Field(description="Filter by end-of-day snapshot status (true/false)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of balances to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of balances to skip for pagination")] = None,
        balance_created_after: Annotated[Optional[datetime], Field(description="Filter balances created after this timestamp")] = None,
        balance_created_before: Annotated[Optional[datetime], Field(description="Filter balances created before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include balance metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListBalances:
        """Get Balances

        Get balances for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns balances from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param is_end_of_day_snapshot: Filter by end-of-day snapshot status (true/false)
        :type is_end_of_day_snapshot: bool
        :param limit: Maximum number of balances to return
        :type limit: int
        :param offset: Number of balances to skip for pagination
        :type offset: int
        :param balance_created_after: Filter balances created after this timestamp
        :type balance_created_after: datetime
        :param balance_created_before: Filter balances created before this timestamp
        :type balance_created_before: datetime
        :param with_metadata: Include balance metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_balances_api_v1_brokers_data_balances_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            is_end_of_day_snapshot=is_end_of_day_snapshot,
            limit=limit,
            offset=offset,
            balance_created_after=balance_created_after,
            balance_created_before=balance_created_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBalances",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_balances_api_v1_brokers_data_balances_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        is_end_of_day_snapshot: Annotated[Optional[StrictBool], Field(description="Filter by end-of-day snapshot status (true/false)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of balances to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of balances to skip for pagination")] = None,
        balance_created_after: Annotated[Optional[datetime], Field(description="Filter balances created after this timestamp")] = None,
        balance_created_before: Annotated[Optional[datetime], Field(description="Filter balances created before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include balance metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListBalances]:
        """Get Balances

        Get balances for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns balances from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param is_end_of_day_snapshot: Filter by end-of-day snapshot status (true/false)
        :type is_end_of_day_snapshot: bool
        :param limit: Maximum number of balances to return
        :type limit: int
        :param offset: Number of balances to skip for pagination
        :type offset: int
        :param balance_created_after: Filter balances created after this timestamp
        :type balance_created_after: datetime
        :param balance_created_before: Filter balances created before this timestamp
        :type balance_created_before: datetime
        :param with_metadata: Include balance metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_balances_api_v1_brokers_data_balances_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            is_end_of_day_snapshot=is_end_of_day_snapshot,
            limit=limit,
            offset=offset,
            balance_created_after=balance_created_after,
            balance_created_before=balance_created_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBalances",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_balances_api_v1_brokers_data_balances_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        is_end_of_day_snapshot: Annotated[Optional[StrictBool], Field(description="Filter by end-of-day snapshot status (true/false)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of balances to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of balances to skip for pagination")] = None,
        balance_created_after: Annotated[Optional[datetime], Field(description="Filter balances created after this timestamp")] = None,
        balance_created_before: Annotated[Optional[datetime], Field(description="Filter balances created before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include balance metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Balances

        Get balances for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns balances from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param is_end_of_day_snapshot: Filter by end-of-day snapshot status (true/false)
        :type is_end_of_day_snapshot: bool
        :param limit: Maximum number of balances to return
        :type limit: int
        :param offset: Number of balances to skip for pagination
        :type offset: int
        :param balance_created_after: Filter balances created after this timestamp
        :type balance_created_after: datetime
        :param balance_created_before: Filter balances created before this timestamp
        :type balance_created_before: datetime
        :param with_metadata: Include balance metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_balances_api_v1_brokers_data_balances_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            is_end_of_day_snapshot=is_end_of_day_snapshot,
            limit=limit,
            offset=offset,
            balance_created_after=balance_created_after,
            balance_created_before=balance_created_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBalances",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_balances_api_v1_brokers_data_balances_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        is_end_of_day_snapshot,
        limit,
        offset,
        balance_created_after,
        balance_created_before,
        with_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if is_end_of_day_snapshot is not None:
            
            _query_params.append(('is_end_of_day_snapshot', is_end_of_day_snapshot))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if balance_created_after is not None:
            if isinstance(balance_created_after, datetime):
                _query_params.append(
                    (
                        'balance_created_after',
                        balance_created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('balance_created_after', balance_created_after))
            
        if balance_created_before is not None:
            if isinstance(balance_created_before, datetime):
                _query_params.append(
                    (
                        'balance_created_before',
                        balance_created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('balance_created_before', balance_created_before))
            
        if with_metadata is not None:
            
            _query_params.append(('with_metadata', with_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/balances',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_brokers_api_v1_brokers_get(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListBrokerInfo:
        """Get Brokers

        Get all available brokers.  This is a fast operation that returns a cached list of available brokers. The list is loaded once at startup and never changes during runtime.  Returns ------- FinaticResponse[list[BrokerInfo]]     list of available brokers with their metadata.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brokers_api_v1_brokers_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBrokerInfo",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_brokers_api_v1_brokers_get_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListBrokerInfo]:
        """Get Brokers

        Get all available brokers.  This is a fast operation that returns a cached list of available brokers. The list is loaded once at startup and never changes during runtime.  Returns ------- FinaticResponse[list[BrokerInfo]]     list of available brokers with their metadata.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brokers_api_v1_brokers_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBrokerInfo",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_brokers_api_v1_brokers_get_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Brokers

        Get all available brokers.  This is a fast operation that returns a cached list of available brokers. The list is loaded once at startup and never changes during runtime.  Returns ------- FinaticResponse[list[BrokerInfo]]     list of available brokers with their metadata.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brokers_api_v1_brokers_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListBrokerInfo",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_brokers_api_v1_brokers_get_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_order_events_api_v1_brokers_data_orders_order_id_events_get(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of events to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of events to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListOrderEventResponse:
        """Get Order Events

        Get order events for a specific order.  This endpoint returns all lifecycle events for the specified order.

        :param order_id: Order ID (required)
        :type order_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of events to return
        :type limit: int
        :param offset: Number of events to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_events_api_v1_brokers_data_orders_order_id_events_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderEventResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_order_events_api_v1_brokers_data_orders_order_id_events_get_with_http_info(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of events to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of events to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListOrderEventResponse]:
        """Get Order Events

        Get order events for a specific order.  This endpoint returns all lifecycle events for the specified order.

        :param order_id: Order ID (required)
        :type order_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of events to return
        :type limit: int
        :param offset: Number of events to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_events_api_v1_brokers_data_orders_order_id_events_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderEventResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_order_events_api_v1_brokers_data_orders_order_id_events_get_without_preload_content(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of events to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of events to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Order Events

        Get order events for a specific order.  This endpoint returns all lifecycle events for the specified order.

        :param order_id: Order ID (required)
        :type order_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of events to return
        :type limit: int
        :param offset: Number of events to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_events_api_v1_brokers_data_orders_order_id_events_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderEventResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_order_events_api_v1_brokers_data_orders_order_id_events_get_serialize(
        self,
        order_id,
        connection_id,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['order_id'] = order_id
        # process the query parameters
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/orders/{order_id}/events',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_order_fills_api_v1_brokers_data_orders_order_id_fills_get(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListOrderFillResponse:
        """Get Order Fills

        Get order fills for a specific order.  This endpoint returns all execution fills for the specified order.

        :param order_id: Order ID (required)
        :type order_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_fills_api_v1_brokers_data_orders_order_id_fills_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderFillResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_order_fills_api_v1_brokers_data_orders_order_id_fills_get_with_http_info(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListOrderFillResponse]:
        """Get Order Fills

        Get order fills for a specific order.  This endpoint returns all execution fills for the specified order.

        :param order_id: Order ID (required)
        :type order_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_fills_api_v1_brokers_data_orders_order_id_fills_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderFillResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_order_fills_api_v1_brokers_data_orders_order_id_fills_get_without_preload_content(
        self,
        order_id: Annotated[UUID, Field(description="Order ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Order Fills

        Get order fills for a specific order.  This endpoint returns all execution fills for the specified order.

        :param order_id: Order ID (required)
        :type order_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_fills_api_v1_brokers_data_orders_order_id_fills_get_serialize(
            order_id=order_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderFillResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_order_fills_api_v1_brokers_data_orders_order_id_fills_get_serialize(
        self,
        order_id,
        connection_id,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if order_id is not None:
            _path_params['order_id'] = order_id
        # process the query parameters
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/orders/{order_id}/fills',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_order_groups_api_v1_brokers_data_orders_groups_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of order groups to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of order groups to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter order groups created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter order groups created before this timestamp")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListOrderGroupResponse:
        """Get Order Groups

        Get order groups.  This endpoint returns order groups that contain multiple orders.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of order groups to return
        :type limit: int
        :param offset: Number of order groups to skip for pagination
        :type offset: int
        :param created_after: Filter order groups created after this timestamp
        :type created_after: datetime
        :param created_before: Filter order groups created before this timestamp
        :type created_before: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_groups_api_v1_brokers_data_orders_groups_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderGroupResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_order_groups_api_v1_brokers_data_orders_groups_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of order groups to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of order groups to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter order groups created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter order groups created before this timestamp")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListOrderGroupResponse]:
        """Get Order Groups

        Get order groups.  This endpoint returns order groups that contain multiple orders.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of order groups to return
        :type limit: int
        :param offset: Number of order groups to skip for pagination
        :type offset: int
        :param created_after: Filter order groups created after this timestamp
        :type created_after: datetime
        :param created_before: Filter order groups created before this timestamp
        :type created_before: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_groups_api_v1_brokers_data_orders_groups_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderGroupResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_order_groups_api_v1_brokers_data_orders_groups_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of order groups to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of order groups to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter order groups created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter order groups created before this timestamp")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Order Groups

        Get order groups.  This endpoint returns order groups that contain multiple orders.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of order groups to return
        :type limit: int
        :param offset: Number of order groups to skip for pagination
        :type offset: int
        :param created_after: Filter order groups created after this timestamp
        :type created_after: datetime
        :param created_before: Filter order groups created before this timestamp
        :type created_before: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_order_groups_api_v1_brokers_data_orders_groups_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderGroupResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_order_groups_api_v1_brokers_data_orders_groups_get_serialize(
        self,
        broker_id,
        connection_id,
        limit,
        offset,
        created_after,
        created_before,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'created_after',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_after', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'created_before',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_before', created_before))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/orders/groups',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_orders_api_v1_brokers_data_orders_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        order_status: Annotated[Optional[BrokerDataOrderStatusEnum], Field(description="Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')")] = None,
        side: Annotated[Optional[BrokerDataOrderSideEnum], Field(description="Filter by order side (e.g., 'buy', 'sell')")] = None,
        asset_type: Annotated[Optional[BrokerDataAssetTypeEnum], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of orders to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of orders to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter orders created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter orders created before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include order metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListOrderResponse:
        """Get Orders

        Get orders for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns orders from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param order_status: Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')
        :type order_status: BrokerDataOrderStatusEnum
        :param side: Filter by order side (e.g., 'buy', 'sell')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param limit: Maximum number of orders to return
        :type limit: int
        :param offset: Number of orders to skip for pagination
        :type offset: int
        :param created_after: Filter orders created after this timestamp
        :type created_after: datetime
        :param created_before: Filter orders created before this timestamp
        :type created_before: datetime
        :param with_metadata: Include order metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_orders_api_v1_brokers_data_orders_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            order_status=order_status,
            side=side,
            asset_type=asset_type,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_orders_api_v1_brokers_data_orders_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        order_status: Annotated[Optional[BrokerDataOrderStatusEnum], Field(description="Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')")] = None,
        side: Annotated[Optional[BrokerDataOrderSideEnum], Field(description="Filter by order side (e.g., 'buy', 'sell')")] = None,
        asset_type: Annotated[Optional[BrokerDataAssetTypeEnum], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of orders to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of orders to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter orders created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter orders created before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include order metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListOrderResponse]:
        """Get Orders

        Get orders for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns orders from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param order_status: Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')
        :type order_status: BrokerDataOrderStatusEnum
        :param side: Filter by order side (e.g., 'buy', 'sell')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param limit: Maximum number of orders to return
        :type limit: int
        :param offset: Number of orders to skip for pagination
        :type offset: int
        :param created_after: Filter orders created after this timestamp
        :type created_after: datetime
        :param created_before: Filter orders created before this timestamp
        :type created_before: datetime
        :param with_metadata: Include order metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_orders_api_v1_brokers_data_orders_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            order_status=order_status,
            side=side,
            asset_type=asset_type,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_orders_api_v1_brokers_data_orders_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        order_status: Annotated[Optional[BrokerDataOrderStatusEnum], Field(description="Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')")] = None,
        side: Annotated[Optional[BrokerDataOrderSideEnum], Field(description="Filter by order side (e.g., 'buy', 'sell')")] = None,
        asset_type: Annotated[Optional[BrokerDataAssetTypeEnum], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of orders to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of orders to skip for pagination")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter orders created after this timestamp")] = None,
        created_before: Annotated[Optional[datetime], Field(description="Filter orders created before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include order metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Orders

        Get orders for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns orders from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param order_status: Filter by order status (e.g., 'filled', 'pending_new', 'cancelled')
        :type order_status: BrokerDataOrderStatusEnum
        :param side: Filter by order side (e.g., 'buy', 'sell')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param limit: Maximum number of orders to return
        :type limit: int
        :param offset: Number of orders to skip for pagination
        :type offset: int
        :param created_after: Filter orders created after this timestamp
        :type created_after: datetime
        :param created_before: Filter orders created before this timestamp
        :type created_before: datetime
        :param with_metadata: Include order metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_orders_api_v1_brokers_data_orders_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            order_status=order_status,
            side=side,
            asset_type=asset_type,
            limit=limit,
            offset=offset,
            created_after=created_after,
            created_before=created_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListOrderResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_orders_api_v1_brokers_data_orders_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        symbol,
        order_status,
        side,
        asset_type,
        limit,
        offset,
        created_after,
        created_before,
        with_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if symbol is not None:
            
            _query_params.append(('symbol', symbol))
            
        if order_status is not None:
            
            _query_params.append(('order_status', order_status.value))
            
        if side is not None:
            
            _query_params.append(('side', side.value))
            
        if asset_type is not None:
            
            _query_params.append(('asset_type', asset_type.value))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'created_after',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_after', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'created_before',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('created_before', created_before))
            
        if with_metadata is not None:
            
            _query_params.append(('with_metadata', with_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/orders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_position_lot_fills_api_v1_brokers_data_positions_lots_lot_id_fills_get(
        self,
        lot_id: Annotated[UUID, Field(description="Position lot ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListPositionLotFillResponse:
        """Get Position Lot Fills

        Get position lot fills for a specific lot.  This endpoint returns all fills associated with a specific position lot.

        :param lot_id: Position lot ID (required)
        :type lot_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lot_fills_api_v1_brokers_data_positions_lots_lot_id_fills_get_serialize(
            lot_id=lot_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionLotFillResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_position_lot_fills_api_v1_brokers_data_positions_lots_lot_id_fills_get_with_http_info(
        self,
        lot_id: Annotated[UUID, Field(description="Position lot ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListPositionLotFillResponse]:
        """Get Position Lot Fills

        Get position lot fills for a specific lot.  This endpoint returns all fills associated with a specific position lot.

        :param lot_id: Position lot ID (required)
        :type lot_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lot_fills_api_v1_brokers_data_positions_lots_lot_id_fills_get_serialize(
            lot_id=lot_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionLotFillResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_position_lot_fills_api_v1_brokers_data_positions_lots_lot_id_fills_get_without_preload_content(
        self,
        lot_id: Annotated[UUID, Field(description="Position lot ID")],
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of fills to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of fills to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Position Lot Fills

        Get position lot fills for a specific lot.  This endpoint returns all fills associated with a specific position lot.

        :param lot_id: Position lot ID (required)
        :type lot_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param limit: Maximum number of fills to return
        :type limit: int
        :param offset: Number of fills to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lot_fills_api_v1_brokers_data_positions_lots_lot_id_fills_get_serialize(
            lot_id=lot_id,
            connection_id=connection_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionLotFillResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_position_lot_fills_api_v1_brokers_data_positions_lots_lot_id_fills_get_serialize(
        self,
        lot_id,
        connection_id,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if lot_id is not None:
            _path_params['lot_id'] = lot_id
        # process the query parameters
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/positions/lots/{lot_id}/fills',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_position_lots_api_v1_brokers_data_positions_lots_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        position_id: Annotated[Optional[UUID], Field(description="Filter by position ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of position lots to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of position lots to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListPositionLotResponse:
        """Get Position Lots

        Get position lots (tax lots for positions).  This endpoint returns tax lots for positions, which are used for tax reporting. Each lot tracks when a position was opened/closed and at what prices.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param position_id: Filter by position ID
        :type position_id: str
        :param limit: Maximum number of position lots to return
        :type limit: int
        :param offset: Number of position lots to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lots_api_v1_brokers_data_positions_lots_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            position_id=position_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionLotResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_position_lots_api_v1_brokers_data_positions_lots_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        position_id: Annotated[Optional[UUID], Field(description="Filter by position ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of position lots to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of position lots to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListPositionLotResponse]:
        """Get Position Lots

        Get position lots (tax lots for positions).  This endpoint returns tax lots for positions, which are used for tax reporting. Each lot tracks when a position was opened/closed and at what prices.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param position_id: Filter by position ID
        :type position_id: str
        :param limit: Maximum number of position lots to return
        :type limit: int
        :param offset: Number of position lots to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lots_api_v1_brokers_data_positions_lots_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            position_id=position_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionLotResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_position_lots_api_v1_brokers_data_positions_lots_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        position_id: Annotated[Optional[UUID], Field(description="Filter by position ID")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of position lots to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of position lots to skip for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Position Lots

        Get position lots (tax lots for positions).  This endpoint returns tax lots for positions, which are used for tax reporting. Each lot tracks when a position was opened/closed and at what prices.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param position_id: Filter by position ID
        :type position_id: str
        :param limit: Maximum number of position lots to return
        :type limit: int
        :param offset: Number of position lots to skip for pagination
        :type offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_position_lots_api_v1_brokers_data_positions_lots_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            position_id=position_id,
            limit=limit,
            offset=offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionLotResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_position_lots_api_v1_brokers_data_positions_lots_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        symbol,
        position_id,
        limit,
        offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if symbol is not None:
            
            _query_params.append(('symbol', symbol))
            
        if position_id is not None:
            
            _query_params.append(('position_id', position_id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/positions/lots',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_positions_api_v1_brokers_data_positions_get(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        side: Annotated[Optional[BrokerDataOrderSideEnum], Field(description="Filter by position side (e.g., 'long', 'short')")] = None,
        asset_type: Annotated[Optional[BrokerDataAssetTypeEnum], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        position_status: Annotated[Optional[BrokerDataPositionStatusEnum], Field(description="Filter by position status: 'open' (quantity > 0) or 'closed' (quantity = 0)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of positions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of positions to skip for pagination")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Filter positions updated after this timestamp")] = None,
        updated_before: Annotated[Optional[datetime], Field(description="Filter positions updated before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include position metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListPositionResponse:
        """Get Positions

        Get positions for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns positions from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param side: Filter by position side (e.g., 'long', 'short')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param position_status: Filter by position status: 'open' (quantity > 0) or 'closed' (quantity = 0)
        :type position_status: BrokerDataPositionStatusEnum
        :param limit: Maximum number of positions to return
        :type limit: int
        :param offset: Number of positions to skip for pagination
        :type offset: int
        :param updated_after: Filter positions updated after this timestamp
        :type updated_after: datetime
        :param updated_before: Filter positions updated before this timestamp
        :type updated_before: datetime
        :param with_metadata: Include position metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_positions_api_v1_brokers_data_positions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            side=side,
            asset_type=asset_type,
            position_status=position_status,
            limit=limit,
            offset=offset,
            updated_after=updated_after,
            updated_before=updated_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_positions_api_v1_brokers_data_positions_get_with_http_info(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        side: Annotated[Optional[BrokerDataOrderSideEnum], Field(description="Filter by position side (e.g., 'long', 'short')")] = None,
        asset_type: Annotated[Optional[BrokerDataAssetTypeEnum], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        position_status: Annotated[Optional[BrokerDataPositionStatusEnum], Field(description="Filter by position status: 'open' (quantity > 0) or 'closed' (quantity = 0)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of positions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of positions to skip for pagination")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Filter positions updated after this timestamp")] = None,
        updated_before: Annotated[Optional[datetime], Field(description="Filter positions updated before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include position metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListPositionResponse]:
        """Get Positions

        Get positions for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns positions from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param side: Filter by position side (e.g., 'long', 'short')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param position_status: Filter by position status: 'open' (quantity > 0) or 'closed' (quantity = 0)
        :type position_status: BrokerDataPositionStatusEnum
        :param limit: Maximum number of positions to return
        :type limit: int
        :param offset: Number of positions to skip for pagination
        :type offset: int
        :param updated_after: Filter positions updated after this timestamp
        :type updated_after: datetime
        :param updated_before: Filter positions updated before this timestamp
        :type updated_before: datetime
        :param with_metadata: Include position metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_positions_api_v1_brokers_data_positions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            side=side,
            asset_type=asset_type,
            position_status=position_status,
            limit=limit,
            offset=offset,
            updated_after=updated_after,
            updated_before=updated_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_positions_api_v1_brokers_data_positions_get_without_preload_content(
        self,
        broker_id: Annotated[Optional[StrictStr], Field(description="Filter by broker ID")] = None,
        connection_id: Annotated[Optional[UUID], Field(description="Filter by connection ID")] = None,
        account_id: Annotated[Optional[StrictStr], Field(description="Filter by broker provided account ID")] = None,
        symbol: Annotated[Optional[StrictStr], Field(description="Filter by symbol")] = None,
        side: Annotated[Optional[BrokerDataOrderSideEnum], Field(description="Filter by position side (e.g., 'long', 'short')")] = None,
        asset_type: Annotated[Optional[BrokerDataAssetTypeEnum], Field(description="Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')")] = None,
        position_status: Annotated[Optional[BrokerDataPositionStatusEnum], Field(description="Filter by position status: 'open' (quantity > 0) or 'closed' (quantity = 0)")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="Maximum number of positions to return")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of positions to skip for pagination")] = None,
        updated_after: Annotated[Optional[datetime], Field(description="Filter positions updated after this timestamp")] = None,
        updated_before: Annotated[Optional[datetime], Field(description="Filter positions updated before this timestamp")] = None,
        with_metadata: Annotated[Optional[StrictBool], Field(description="Include position metadata in response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Positions

        Get positions for all authorized broker connections.  This endpoint is accessible from the portal and uses session-only authentication. Returns positions from connections the company has read access to.

        :param broker_id: Filter by broker ID
        :type broker_id: str
        :param connection_id: Filter by connection ID
        :type connection_id: str
        :param account_id: Filter by broker provided account ID
        :type account_id: str
        :param symbol: Filter by symbol
        :type symbol: str
        :param side: Filter by position side (e.g., 'long', 'short')
        :type side: BrokerDataOrderSideEnum
        :param asset_type: Filter by asset type (e.g., 'stock', 'option', 'crypto', 'future')
        :type asset_type: BrokerDataAssetTypeEnum
        :param position_status: Filter by position status: 'open' (quantity > 0) or 'closed' (quantity = 0)
        :type position_status: BrokerDataPositionStatusEnum
        :param limit: Maximum number of positions to return
        :type limit: int
        :param offset: Number of positions to skip for pagination
        :type offset: int
        :param updated_after: Filter positions updated after this timestamp
        :type updated_after: datetime
        :param updated_before: Filter positions updated before this timestamp
        :type updated_before: datetime
        :param with_metadata: Include position metadata in response
        :type with_metadata: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_positions_api_v1_brokers_data_positions_get_serialize(
            broker_id=broker_id,
            connection_id=connection_id,
            account_id=account_id,
            symbol=symbol,
            side=side,
            asset_type=asset_type,
            position_status=position_status,
            limit=limit,
            offset=offset,
            updated_after=updated_after,
            updated_before=updated_before,
            with_metadata=with_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListPositionResponse",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_positions_api_v1_brokers_data_positions_get_serialize(
        self,
        broker_id,
        connection_id,
        account_id,
        symbol,
        side,
        asset_type,
        position_status,
        limit,
        offset,
        updated_after,
        updated_before,
        with_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if broker_id is not None:
            
            _query_params.append(('broker_id', broker_id))
            
        if connection_id is not None:
            
            _query_params.append(('connection_id', connection_id))
            
        if account_id is not None:
            
            _query_params.append(('account_id', account_id))
            
        if symbol is not None:
            
            _query_params.append(('symbol', symbol))
            
        if side is not None:
            
            _query_params.append(('side', side.value))
            
        if asset_type is not None:
            
            _query_params.append(('asset_type', asset_type.value))
            
        if position_status is not None:
            
            _query_params.append(('position_status', position_status.value))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if updated_after is not None:
            if isinstance(updated_after, datetime):
                _query_params.append(
                    (
                        'updated_after',
                        updated_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_after', updated_after))
            
        if updated_before is not None:
            if isinstance(updated_before, datetime):
                _query_params.append(
                    (
                        'updated_before',
                        updated_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_before', updated_before))
            
        if with_metadata is not None:
            
            _query_params.append(('with_metadata', with_metadata))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/data/positions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_broker_connections_api_v1_brokers_connections_get(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FinaticResponseListUserBrokerConnections:
        """List Broker Connections

        List all broker connections for the current user.  This endpoint is accessible from the portal and uses session-only authentication. Returns connections that the user has any permissions for.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_broker_connections_api_v1_brokers_connections_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListUserBrokerConnections",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_broker_connections_api_v1_brokers_connections_get_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FinaticResponseListUserBrokerConnections]:
        """List Broker Connections

        List all broker connections for the current user.  This endpoint is accessible from the portal and uses session-only authentication. Returns connections that the user has any permissions for.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_broker_connections_api_v1_brokers_connections_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListUserBrokerConnections",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_broker_connections_api_v1_brokers_connections_get_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Broker Connections

        List all broker connections for the current user.  This endpoint is accessible from the portal and uses session-only authentication. Returns connections that the user has any permissions for.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_broker_connections_api_v1_brokers_connections_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FinaticResponseListUserBrokerConnections",
            '400': "FinaticError",
            '401': "FinaticError",
            '403': "FinaticError",
            '404': "FinaticError",
            '409': "FinaticError",
            '422': "FinaticError",
            '429': "FinaticError",
            '500': "FinaticError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_broker_connections_api_v1_brokers_connections_get_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/brokers/connections',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


