# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class Balances(BaseModel):
    """
    Balances
    """ # noqa: E501
    id: Optional[UUID] = None
    account_id: UUID
    available_to_withdraw: Optional[Union[StrictFloat, StrictInt]] = None
    balance_created_at: Optional[datetime] = None
    balance_updated_at: Optional[datetime] = None
    created_at: Optional[datetime]
    initial_margin: Optional[Union[StrictFloat, StrictInt]] = None
    is_end_of_day_snapshot: Optional[StrictBool] = None
    maintenance_margin: Optional[Union[StrictFloat, StrictInt]] = None
    net_liquidation_value: Optional[Union[StrictFloat, StrictInt]] = None
    raw_payload: Optional[Dict[str, Any]] = None
    total_cash_value: Optional[Union[StrictFloat, StrictInt]] = None
    total_realized_pnl: Optional[Union[StrictFloat, StrictInt]] = None
    updated_at: Optional[datetime]
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "account_id", "available_to_withdraw", "balance_created_at", "balance_updated_at", "created_at", "initial_margin", "is_end_of_day_snapshot", "maintenance_margin", "net_liquidation_value", "raw_payload", "total_cash_value", "total_realized_pnl", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Balances from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if available_to_withdraw (nullable) is None
        # and model_fields_set contains the field
        if self.available_to_withdraw is None and "available_to_withdraw" in self.model_fields_set:
            _dict['available_to_withdraw'] = None

        # set to None if balance_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.balance_created_at is None and "balance_created_at" in self.model_fields_set:
            _dict['balance_created_at'] = None

        # set to None if balance_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.balance_updated_at is None and "balance_updated_at" in self.model_fields_set:
            _dict['balance_updated_at'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if initial_margin (nullable) is None
        # and model_fields_set contains the field
        if self.initial_margin is None and "initial_margin" in self.model_fields_set:
            _dict['initial_margin'] = None

        # set to None if is_end_of_day_snapshot (nullable) is None
        # and model_fields_set contains the field
        if self.is_end_of_day_snapshot is None and "is_end_of_day_snapshot" in self.model_fields_set:
            _dict['is_end_of_day_snapshot'] = None

        # set to None if maintenance_margin (nullable) is None
        # and model_fields_set contains the field
        if self.maintenance_margin is None and "maintenance_margin" in self.model_fields_set:
            _dict['maintenance_margin'] = None

        # set to None if net_liquidation_value (nullable) is None
        # and model_fields_set contains the field
        if self.net_liquidation_value is None and "net_liquidation_value" in self.model_fields_set:
            _dict['net_liquidation_value'] = None

        # set to None if raw_payload (nullable) is None
        # and model_fields_set contains the field
        if self.raw_payload is None and "raw_payload" in self.model_fields_set:
            _dict['raw_payload'] = None

        # set to None if total_cash_value (nullable) is None
        # and model_fields_set contains the field
        if self.total_cash_value is None and "total_cash_value" in self.model_fields_set:
            _dict['total_cash_value'] = None

        # set to None if total_realized_pnl (nullable) is None
        # and model_fields_set contains the field
        if self.total_realized_pnl is None and "total_realized_pnl" in self.model_fields_set:
            _dict['total_realized_pnl'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Balances from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account_id": obj.get("account_id"),
            "available_to_withdraw": obj.get("available_to_withdraw"),
            "balance_created_at": obj.get("balance_created_at"),
            "balance_updated_at": obj.get("balance_updated_at"),
            "created_at": obj.get("created_at"),
            "initial_margin": obj.get("initial_margin"),
            "is_end_of_day_snapshot": obj.get("is_end_of_day_snapshot"),
            "maintenance_margin": obj.get("maintenance_margin"),
            "net_liquidation_value": obj.get("net_liquidation_value"),
            "raw_payload": obj.get("raw_payload"),
            "total_cash_value": obj.get("total_cash_value"),
            "total_realized_pnl": obj.get("total_realized_pnl"),
            "updated_at": obj.get("updated_at")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


