# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from .public_subscription_status_enum import PublicSubscriptionStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class CompanyResponse(BaseModel):
    """
    Schema for company response data.
    """ # noqa: E501
    name: StrictStr
    email: Optional[StrictStr] = None
    use_case_features: Optional[List[StrictStr]] = None
    referral_source: Optional[StrictStr] = None
    is_active: Optional[StrictBool] = None
    id: UUID
    subscription_status: Optional[PublicSubscriptionStatusEnum] = None
    total_connections: Optional[StrictInt] = None
    total_users: Optional[StrictInt] = None
    billing_status: Optional[StrictStr] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    trading_enabled: Optional[StrictBool] = None
    onboarding_step: Optional[StrictInt] = None
    onboarding_completed: Optional[StrictBool] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "email", "use_case_features", "referral_source", "is_active", "id", "subscription_status", "total_connections", "total_users", "billing_status", "created_at", "updated_at", "trading_enabled", "onboarding_step", "onboarding_completed"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompanyResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if use_case_features (nullable) is None
        # and model_fields_set contains the field
        if self.use_case_features is None and "use_case_features" in self.model_fields_set:
            _dict['use_case_features'] = None

        # set to None if referral_source (nullable) is None
        # and model_fields_set contains the field
        if self.referral_source is None and "referral_source" in self.model_fields_set:
            _dict['referral_source'] = None

        # set to None if is_active (nullable) is None
        # and model_fields_set contains the field
        if self.is_active is None and "is_active" in self.model_fields_set:
            _dict['is_active'] = None

        # set to None if subscription_status (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_status is None and "subscription_status" in self.model_fields_set:
            _dict['subscription_status'] = None

        # set to None if total_connections (nullable) is None
        # and model_fields_set contains the field
        if self.total_connections is None and "total_connections" in self.model_fields_set:
            _dict['total_connections'] = None

        # set to None if total_users (nullable) is None
        # and model_fields_set contains the field
        if self.total_users is None and "total_users" in self.model_fields_set:
            _dict['total_users'] = None

        # set to None if billing_status (nullable) is None
        # and model_fields_set contains the field
        if self.billing_status is None and "billing_status" in self.model_fields_set:
            _dict['billing_status'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updated_at'] = None

        # set to None if trading_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.trading_enabled is None and "trading_enabled" in self.model_fields_set:
            _dict['trading_enabled'] = None

        # set to None if onboarding_step (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_step is None and "onboarding_step" in self.model_fields_set:
            _dict['onboarding_step'] = None

        # set to None if onboarding_completed (nullable) is None
        # and model_fields_set contains the field
        if self.onboarding_completed is None and "onboarding_completed" in self.model_fields_set:
            _dict['onboarding_completed'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompanyResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "email": obj.get("email"),
            "use_case_features": obj.get("use_case_features"),
            "referral_source": obj.get("referral_source"),
            "is_active": obj.get("is_active"),
            "id": obj.get("id"),
            "subscription_status": obj.get("subscription_status"),
            "total_connections": obj.get("total_connections"),
            "total_users": obj.get("total_users"),
            "billing_status": obj.get("billing_status"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "trading_enabled": obj.get("trading_enabled"),
            "onboarding_step": obj.get("onboarding_step"),
            "onboarding_completed": obj.get("onboarding_completed")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


