# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class PositionResponse(BaseModel):
    """
    Unified position response model combining open and closed positions.  This model includes all possible fields from both Positions and PositionsHistoricalSnapshots tables. Fields that are not applicable for a specific position type will be None.  Attributes ---------- id : UUID     Position identifier user_broker_connection_id : UUID     Connection reference broker_provided_account_id : str     Account identifier symbol : str     Instrument symbol asset_type : str | None     Asset type (equity, crypto, option, etc.) avg_buy_price : float | None     Average buy price avg_sell_price : float | None     Average sell price (None for closed positions) cost_basis : float | None     Total cost basis cost_basis_w_commission : float | None     Cost basis with commissions realized_pl : float | None     Realized profit/loss realized_pl_w_commission : float | None     Realized PL with commissions realized_pl_percent : float | None     Realized PL percentage (None for closed positions) quantity : float | None     Position quantity side : str | None     Position side (long/short) status : str | None     Position status (active/inactive/closed) current_price : float | None     Current market price (None for closed positions) market_value : float | None     Current market value (None for closed positions) unrealized_pl : float | None     Unrealized profit/loss (None for closed positions) unrealized_pl_percent : float | None     Unrealized PL percentage (None for closed positions) position_created_at : datetime | None     When position was opened position_updated_at : datetime | None     Last position update (None for closed positions) position_closed_at : datetime | None     When position was closed (None for open positions) position_group_id : UUID | None     Position group identifier instrument_key : str | None     Normalized instrument key (None for open positions) snapshot_date : date | None     Snapshot date (None for open positions) created_at : datetime     Record creation time updated_at : datetime     Last update time
    """ # noqa: E501
    id: StrictStr = Field(description="Position identifier")
    user_broker_connection_id: StrictStr = Field(description="Connection reference")
    broker_provided_account_id: StrictStr = Field(description="Account identifier")
    symbol: StrictStr = Field(description="Instrument symbol")
    asset_type: Optional[StrictStr] = None
    avg_buy_price: Optional[Union[StrictFloat, StrictInt]] = None
    avg_sell_price: Optional[Union[StrictFloat, StrictInt]] = None
    cost_basis: Optional[Union[StrictFloat, StrictInt]] = None
    cost_basis_w_commission: Optional[Union[StrictFloat, StrictInt]] = None
    realized_pl: Optional[Union[StrictFloat, StrictInt]] = None
    realized_pl_w_commission: Optional[Union[StrictFloat, StrictInt]] = None
    realized_pl_percent: Optional[Union[StrictFloat, StrictInt]] = None
    quantity: Optional[Union[StrictFloat, StrictInt]] = None
    side: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    current_price: Optional[Union[StrictFloat, StrictInt]] = None
    market_value: Optional[Union[StrictFloat, StrictInt]] = None
    unrealized_pl: Optional[Union[StrictFloat, StrictInt]] = None
    unrealized_pl_percent: Optional[Union[StrictFloat, StrictInt]] = None
    position_created_at: Optional[datetime] = None
    position_updated_at: Optional[datetime] = None
    position_group_id: Optional[StrictStr] = None
    position_closed_at: Optional[datetime] = None
    instrument_key: Optional[StrictStr] = None
    snapshot_date: Optional[date] = None
    created_at: datetime = Field(description="Record creation time")
    updated_at: datetime = Field(description="Last update time")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "user_broker_connection_id", "broker_provided_account_id", "symbol", "asset_type", "avg_buy_price", "avg_sell_price", "cost_basis", "cost_basis_w_commission", "realized_pl", "realized_pl_w_commission", "realized_pl_percent", "quantity", "side", "status", "current_price", "market_value", "unrealized_pl", "unrealized_pl_percent", "position_created_at", "position_updated_at", "position_group_id", "position_closed_at", "instrument_key", "snapshot_date", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PositionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if asset_type (nullable) is None
        # and model_fields_set contains the field
        if self.asset_type is None and "asset_type" in self.model_fields_set:
            _dict['asset_type'] = None

        # set to None if avg_buy_price (nullable) is None
        # and model_fields_set contains the field
        if self.avg_buy_price is None and "avg_buy_price" in self.model_fields_set:
            _dict['avg_buy_price'] = None

        # set to None if avg_sell_price (nullable) is None
        # and model_fields_set contains the field
        if self.avg_sell_price is None and "avg_sell_price" in self.model_fields_set:
            _dict['avg_sell_price'] = None

        # set to None if cost_basis (nullable) is None
        # and model_fields_set contains the field
        if self.cost_basis is None and "cost_basis" in self.model_fields_set:
            _dict['cost_basis'] = None

        # set to None if cost_basis_w_commission (nullable) is None
        # and model_fields_set contains the field
        if self.cost_basis_w_commission is None and "cost_basis_w_commission" in self.model_fields_set:
            _dict['cost_basis_w_commission'] = None

        # set to None if realized_pl (nullable) is None
        # and model_fields_set contains the field
        if self.realized_pl is None and "realized_pl" in self.model_fields_set:
            _dict['realized_pl'] = None

        # set to None if realized_pl_w_commission (nullable) is None
        # and model_fields_set contains the field
        if self.realized_pl_w_commission is None and "realized_pl_w_commission" in self.model_fields_set:
            _dict['realized_pl_w_commission'] = None

        # set to None if realized_pl_percent (nullable) is None
        # and model_fields_set contains the field
        if self.realized_pl_percent is None and "realized_pl_percent" in self.model_fields_set:
            _dict['realized_pl_percent'] = None

        # set to None if quantity (nullable) is None
        # and model_fields_set contains the field
        if self.quantity is None and "quantity" in self.model_fields_set:
            _dict['quantity'] = None

        # set to None if side (nullable) is None
        # and model_fields_set contains the field
        if self.side is None and "side" in self.model_fields_set:
            _dict['side'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if current_price (nullable) is None
        # and model_fields_set contains the field
        if self.current_price is None and "current_price" in self.model_fields_set:
            _dict['current_price'] = None

        # set to None if market_value (nullable) is None
        # and model_fields_set contains the field
        if self.market_value is None and "market_value" in self.model_fields_set:
            _dict['market_value'] = None

        # set to None if unrealized_pl (nullable) is None
        # and model_fields_set contains the field
        if self.unrealized_pl is None and "unrealized_pl" in self.model_fields_set:
            _dict['unrealized_pl'] = None

        # set to None if unrealized_pl_percent (nullable) is None
        # and model_fields_set contains the field
        if self.unrealized_pl_percent is None and "unrealized_pl_percent" in self.model_fields_set:
            _dict['unrealized_pl_percent'] = None

        # set to None if position_created_at (nullable) is None
        # and model_fields_set contains the field
        if self.position_created_at is None and "position_created_at" in self.model_fields_set:
            _dict['position_created_at'] = None

        # set to None if position_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.position_updated_at is None and "position_updated_at" in self.model_fields_set:
            _dict['position_updated_at'] = None

        # set to None if position_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.position_group_id is None and "position_group_id" in self.model_fields_set:
            _dict['position_group_id'] = None

        # set to None if position_closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.position_closed_at is None and "position_closed_at" in self.model_fields_set:
            _dict['position_closed_at'] = None

        # set to None if instrument_key (nullable) is None
        # and model_fields_set contains the field
        if self.instrument_key is None and "instrument_key" in self.model_fields_set:
            _dict['instrument_key'] = None

        # set to None if snapshot_date (nullable) is None
        # and model_fields_set contains the field
        if self.snapshot_date is None and "snapshot_date" in self.model_fields_set:
            _dict['snapshot_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PositionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_broker_connection_id": obj.get("user_broker_connection_id"),
            "broker_provided_account_id": obj.get("broker_provided_account_id"),
            "symbol": obj.get("symbol"),
            "asset_type": obj.get("asset_type"),
            "avg_buy_price": obj.get("avg_buy_price"),
            "avg_sell_price": obj.get("avg_sell_price"),
            "cost_basis": obj.get("cost_basis"),
            "cost_basis_w_commission": obj.get("cost_basis_w_commission"),
            "realized_pl": obj.get("realized_pl"),
            "realized_pl_w_commission": obj.get("realized_pl_w_commission"),
            "realized_pl_percent": obj.get("realized_pl_percent"),
            "quantity": obj.get("quantity"),
            "side": obj.get("side"),
            "status": obj.get("status"),
            "current_price": obj.get("current_price"),
            "market_value": obj.get("market_value"),
            "unrealized_pl": obj.get("unrealized_pl"),
            "unrealized_pl_percent": obj.get("unrealized_pl_percent"),
            "position_created_at": obj.get("position_created_at"),
            "position_updated_at": obj.get("position_updated_at"),
            "position_group_id": obj.get("position_group_id"),
            "position_closed_at": obj.get("position_closed_at"),
            "instrument_key": obj.get("instrument_key"),
            "snapshot_date": obj.get("snapshot_date"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


